/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.intellij.util.io.URLUtil;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyReferringObjectsValue;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.PyVariableLocator;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.RunCustomOperationCommand;
import java.util.List;

public class GetReferrersCommand
extends RunCustomOperationCommand<List<PyDebugValue>> {
    public GetReferrersCommand(RemoteDebugger target, String threadId, String frameId, PyReferringObjectsValue value) {
        super(target, GetReferrersCommand.createVariableLocator(threadId, frameId, value), "from _pydevd_bundle.pydevd_referrers import get_referrer_info", "get_referrer_info");
    }

    @Override
    protected AbstractCommand.ResponseProcessor<List<PyDebugValue>> createResponseProcessor() {
        return new AbstractCommand.ResponseProcessor<List<PyDebugValue>>(){

            @Override
            protected List<PyDebugValue> parseResponse(ProtocolFrame response) throws PyDebuggerException {
                return ProtocolParser.parseReferrers(URLUtil.decode((String)response.getPayload()), GetReferrersCommand.this.getDebugger().getDebugProcess());
            }
        };
    }

    private static PyVariableLocator createVariableLocator(final String threadId, final String frameId, final PyReferringObjectsValue var) {
        return new PyVariableLocator(){

            @Override
            public String getThreadId() {
                return threadId;
            }

            @Override
            public String getPyDBLocation() {
                if (var.getId() == null) {
                    return threadId + "\t" + frameId + "\tFRAME\t" + var.getName();
                }
                return this.getThreadId() + "\t" + var.getId() + "\tBY_ID";
            }
        };
    }
}

