/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fastutil.ints;

import com.intellij.util.fastutil.Hash;
import com.intellij.util.fastutil.HashCommon;
import com.intellij.util.fastutil.ints.Int2IntEntry;
import com.intellij.util.fastutil.ints.Int2IntMap;
import com.intellij.util.fastutil.ints.IntArrayList;
import com.intellij.util.fastutil.ints.IntIterator;
import com.intellij.util.fastutil.ints.MutableInt2IntMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="This API is temporary multiplatform shim. Please make sure you are not using it by accident", replaceWith=@ReplaceWith(expression="it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap", imports={}), level=DeprecationLevel.WARNING)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0018\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0004NOPQB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\nB\u001b\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\rB#\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\u0011J\u0006\u0010*\u001a\u00020\u0016J\b\u0010+\u001a\u00020\u0004H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0004H\u0002J\u0010\u0010/\u001a\u00020-2\u0006\u0010.\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u0004H\u0002J\b\u00103\u001a\u00020\u0004H\u0002J\u000e\u00104\u001a\u00020-2\u0006\u00105\u001a\u00020\fJ\u0010\u00106\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J \u00107\u001a\u00020-2\u0006\u00102\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0018\u00108\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0010\u00109\u001a\u00020-2\u0006\u00102\u001a\u00020\u0004H\u0002J\u0010\u0010:\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0011\u0010;\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0096\u0002J\u000e\u0010<\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010=\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010>\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u0016\u0010:\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u0006\u0010?\u001a\u00020\u0004J\u000e\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u00020\u0004J\u001e\u0010A\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010A\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u0006\u0010C\u001a\u00020-J\u0010\u0010D\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0004J\u0010\u0010E\u001a\u00020-2\u0006\u0010F\u001a\u00020\u0004H\u0002J\u0013\u0010G\u001a\u00020\u00162\b\u0010H\u001a\u0004\u0018\u00010IH\u0096\u0002J\b\u0010J\u001a\u00020\u0004H\u0016J\"\u0010K\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0012\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040MR\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010'\u00a8\u0006R"}, d2={"Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap;", "Lcom/intellij/util/fastutil/Hash;", "Lcom/intellij/util/fastutil/ints/MutableInt2IntMap;", "expected", "", "f", "", "<init>", "(IF)V", "()V", "(I)V", "m", "Lcom/intellij/util/fastutil/ints/Int2IntMap;", "(Lcom/intellij/util/fastutil/ints/Int2IntMap;F)V", "k", "", "v", "([I[IF)V", "key", "value", "mask", "containsNullKey", "", "n", "maxFill", "minN", "size", "getSize", "()I", "setSize", "defaultValue", "entries", "", "Lcom/intellij/util/fastutil/ints/Int2IntEntry;", "getEntries", "()Ljava/util/Iterator;", "keys", "Lcom/intellij/util/fastutil/ints/IntIterator;", "getKeys", "()Lcom/intellij/util/fastutil/ints/IntIterator;", "values", "getValues", "isEmpty", "realSize", "ensureCapacity", "", "capacity", "tryCapacity", "", "removeEntry", "pos", "removeNullEntry", "putAll", "from", "find", "insert", "put", "shiftKeys", "remove", "get", "containsKey", "containsValue", "getOrDefault", "defaultReturnValue", "rv", "replace", "oldValue", "clear", "trim", "rehash", "newN", "equals", "o", "", "hashCode", "computeIfAbsent", "mappingFunction", "Lkotlin/Function1;", "MapIterator", "EntryIterator", "KeyIterator", "ValueIterator", "intellij.platform.util.multiplatform"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInt2IntOpenHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Int2IntOpenHashMap.kt\ncom/intellij/util/fastutil/ints/Int2IntOpenHashMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,541:1\n1#2:542\n*E\n"})
public final class Int2IntOpenHashMap
implements Hash,
MutableInt2IntMap {
    @NotNull
    private int[] key;
    @NotNull
    private int[] value;
    private int mask;
    private boolean containsNullKey;
    private int n;
    private int maxFill;
    private int minN;
    private int size;
    private float f;
    private int defaultValue;
    @NotNull
    private final Iterator<Int2IntEntry> entries;
    @NotNull
    private final IntIterator keys;
    @NotNull
    private final IntIterator values;

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @Override
    @NotNull
    public Iterator<Int2IntEntry> getEntries() {
        return this.entries;
    }

    @Override
    @NotNull
    public IntIterator getKeys() {
        return this.keys;
    }

    @Override
    @NotNull
    public IntIterator getValues() {
        return this.values;
    }

    public Int2IntOpenHashMap(int expected, float f) {
        this.entries = new EntryIterator();
        this.keys = new KeyIterator();
        this.values = new ValueIterator();
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.INSTANCE.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, f);
        this.key = new int[this.n + 1];
        this.value = new int[this.n + 1];
    }

    public Int2IntOpenHashMap() {
        this(16, 0.75f);
    }

    public Int2IntOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Int2IntOpenHashMap(@NotNull Int2IntMap m, float f) {
        Intrinsics.checkNotNullParameter(m, "m");
        this(m.getSize(), f);
        this.putAll(m);
    }

    public /* synthetic */ Int2IntOpenHashMap(Int2IntMap int2IntMap, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.75f;
        }
        this(int2IntMap, f);
    }

    public Int2IntOpenHashMap(@NotNull int[] k, @NotNull int[] v, float f) {
        Intrinsics.checkNotNullParameter(k, "k");
        Intrinsics.checkNotNullParameter(v, "v");
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ')');
        }
        int n = k.length;
        for (int i = 0; i < n; ++i) {
            this.set(k[i], v[i]);
        }
    }

    public /* synthetic */ Int2IntOpenHashMap(int[] nArray, int[] nArray2, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f = 0.75f;
        }
        this(nArray, nArray2, f);
    }

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    private final int realSize() {
        return this.containsNullKey ? this.getSize() - 1 : this.getSize();
    }

    private final void ensureCapacity(int capacity) {
        int needed = HashCommon.INSTANCE.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private final void tryCapacity(long capacity) {
        int needed = Math.min(0x40000000, Math.max(2, HashCommon.INSTANCE.nextPowerOfTwo((int)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private final int removeEntry(int pos) {
        int oldValue = this.value[pos];
        int n = this.getSize();
        this.setSize(n + -1);
        this.shiftKeys(pos);
        if (this.n > this.minN && this.getSize() < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private final int removeNullEntry() {
        this.containsNullKey = false;
        int oldValue = this.value[this.n];
        int n = this.getSize();
        this.setSize(n + -1);
        if (this.n > this.minN && this.getSize() < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    public final void putAll(@NotNull Int2IntMap from) {
        Intrinsics.checkNotNullParameter(from, "from");
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(from.getSize());
        } else {
            this.tryCapacity(this.getSize() + from.getSize());
        }
        int n = from.getSize();
        Iterator<Int2IntEntry> i = from.getEntries();
        while (n-- != 0) {
            Int2IntEntry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    private final int find(int k) {
        int it;
        int n;
        if (k == 0) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int n2 = n = HashCommon.INSTANCE.mix(k) & this.mask;
        int[] nArray = key;
        boolean bl = false;
        pos = it;
        it = n = nArray[n];
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return -(pos + 1);
        }
        if (k == curr) {
            return pos;
        }
        do {
            it = n = pos + 1 & this.mask;
            nArray = key;
            boolean bl3 = false;
            pos = it;
            it = n = nArray[n];
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return -(pos + 1);
        } while (k != curr);
        return pos;
    }

    private final void insert(int pos, int k, int v) {
        if (pos == this.n) {
            this.containsNullKey = true;
        }
        this.key[pos] = k;
        this.value[pos] = v;
        int n = this.getSize();
        this.setSize(n + 1);
        if (n >= this.maxFill) {
            this.rehash(HashCommon.INSTANCE.arraySize(this.getSize() + 1, this.f));
        }
    }

    @Override
    public int put(int key, int value) {
        int pos = this.find(key);
        if (pos < 0) {
            this.insert(-pos - 1, key, value);
            return this.defaultReturnValue();
        }
        int oldValue = this.value[pos];
        this.value[pos] = value;
        this.key[pos] = key;
        return oldValue;
    }

    private final void shiftKeys(int pos) {
        int pos2 = pos;
        int last2 = 0;
        int slot = 0;
        int curr = 0;
        int[] key = this.key;
        int[] value = this.value;
        while (true) {
            int n;
            int it = n = pos2;
            boolean bl = false;
            last2 = it;
            pos2 = n + 1 & this.mask;
            while (true) {
                it = n = key[pos2];
                boolean bl2 = false;
                curr = it;
                if (n == 0) {
                    key[last2] = 0;
                    return;
                }
                slot = HashCommon.INSTANCE.mix(curr) & this.mask;
                if (last2 <= pos2 ? last2 >= slot || slot > pos2 : (pos2 + 1 <= slot ? slot <= last2 : false)) break;
                pos2 = pos2 + 1 & this.mask;
            }
            key[last2] = curr;
            value[last2] = value[pos2];
        }
    }

    @Override
    public int remove(int k) {
        int it;
        int n;
        if (k == 0) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defaultReturnValue();
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int n2 = n = HashCommon.INSTANCE.mix(k) & this.mask;
        int[] nArray = key;
        boolean bl = false;
        pos = it;
        it = n = nArray[n];
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return this.defaultReturnValue();
        }
        if (k == curr) {
            return this.removeEntry(pos);
        }
        do {
            it = n = pos + 1 & this.mask;
            nArray = key;
            boolean bl3 = false;
            pos = it;
            it = n = nArray[n];
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return this.defaultReturnValue();
        } while (k != curr);
        return this.removeEntry(pos);
    }

    @Override
    public int get(int k) {
        int it;
        int n;
        if (k == 0) {
            return this.containsNullKey ? this.value[this.n] : this.defaultReturnValue();
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int n2 = n = HashCommon.INSTANCE.mix(k) & this.mask;
        int[] nArray = key;
        boolean bl = false;
        pos = it;
        it = n = nArray[n];
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return this.defaultReturnValue();
        }
        if (k == curr) {
            return this.value[pos];
        }
        do {
            it = n = pos + 1 & this.mask;
            nArray = key;
            boolean bl3 = false;
            pos = it;
            it = n = nArray[n];
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return this.defaultReturnValue();
        } while (k != curr);
        return this.value[pos];
    }

    public final boolean containsKey(int k) {
        int it;
        int n;
        if (k == 0) {
            return this.containsNullKey;
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int n2 = n = HashCommon.INSTANCE.mix(k) & this.mask;
        int[] nArray = key;
        boolean bl = false;
        pos = it;
        it = n = nArray[n];
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return false;
        }
        if (k == curr) {
            return true;
        }
        do {
            it = n = pos + 1 & this.mask;
            nArray = key;
            boolean bl3 = false;
            pos = it;
            it = n = nArray[n];
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return false;
        } while (k != curr);
        return true;
    }

    public final boolean containsValue(int v) {
        if (this.containsNullKey && this.value[this.n] == v) {
            return true;
        }
        int i = this.n;
        while (i-- != 0) {
            if (this.key[i] == 0 || this.value[i] != v) continue;
            return true;
        }
        return false;
    }

    public final int getOrDefault(int k, int defaultValue) {
        int n;
        if (k == 0) {
            return this.containsNullKey ? this.value[this.n] : defaultValue;
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int it = n = key[HashCommon.INSTANCE.mix(k) & this.mask];
        boolean bl = false;
        pos = it;
        it = n;
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return defaultValue;
        }
        if (k == curr) {
            return this.value[pos];
        }
        do {
            it = n = key[pos + 1 & this.mask];
            boolean bl3 = false;
            pos = it;
            it = n;
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return defaultValue;
        } while (k != curr);
        return this.value[pos];
    }

    public final boolean remove(int k, int v) {
        int n;
        if (k == 0) {
            if (this.containsNullKey && v == this.value[this.n]) {
                this.removeNullEntry();
                return true;
            }
            return false;
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int it = n = key[HashCommon.INSTANCE.mix(k) & this.mask];
        boolean bl = false;
        pos = it;
        it = n;
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return false;
        }
        if (k == curr && v == this.value[pos]) {
            this.removeEntry(pos);
            return true;
        }
        do {
            it = n = key[pos + 1 & this.mask];
            boolean bl3 = false;
            pos = it;
            it = n;
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return false;
        } while (k != curr || v != this.value[pos]);
        this.removeEntry(pos);
        return true;
    }

    public final int defaultReturnValue() {
        return this.defaultValue;
    }

    public final void defaultReturnValue(int rv) {
        this.defaultValue = rv;
    }

    public final boolean replace(int k, int oldValue, int v) {
        int pos = this.find(k);
        if (pos < 0 || oldValue != this.value[pos]) {
            return false;
        }
        this.value[pos] = v;
        return true;
    }

    public final int replace(int k, int v) {
        int pos = this.find(k);
        if (pos < 0) {
            return this.defaultReturnValue();
        }
        int oldValue = this.value[pos];
        this.value[pos] = v;
        return oldValue;
    }

    public final void clear() {
        if (this.getSize() == 0) {
            return;
        }
        this.setSize(0);
        this.containsNullKey = false;
        ArraysKt.fill$default(this.key, 0, 0, 0, 6, null);
    }

    public final boolean trim(int n) {
        int l = HashCommon.INSTANCE.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (l >= this.n || this.getSize() > HashCommon.INSTANCE.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (Exception cantDoIt) {
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean trim$default(Int2IntOpenHashMap int2IntOpenHashMap, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = int2IntOpenHashMap.getSize();
        }
        return int2IntOpenHashMap.trim(n);
    }

    private final void rehash(int newN) {
        int[] key = this.key;
        int[] value = this.value;
        int mask = newN - 1;
        int[] newKey = new int[newN + 1];
        int[] newValue = new int[newN + 1];
        int i = this.n;
        int pos = 0;
        int j = this.realSize();
        while (j-- != 0) {
            int it;
            int n;
            while (key[--i] == 0) {
            }
            int n2 = n = HashCommon.INSTANCE.mix(key[i]) & mask;
            int[] nArray = newKey;
            boolean bl = false;
            pos = it;
            if (nArray[n] != 0) {
                do {
                    it = n = pos + 1 & mask;
                    nArray = newKey;
                    boolean bl2 = false;
                    pos = it;
                } while (nArray[n] != 0);
            }
            newKey[pos] = key[i];
            newValue[pos] = value[i];
        }
        newValue[newN] = value[this.n];
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Int2IntMap)) {
            return false;
        }
        if (this.getSize() != ((Int2IntMap)o).getSize()) {
            return false;
        }
        Iterator<Int2IntEntry> iterator2 = this.getEntries();
        while (iterator2.hasNext()) {
            Int2IntEntry int2IntEntry = iterator2.next();
            int key = int2IntEntry.component1();
            int value = int2IntEntry.component2();
            if (((Int2IntMap)o).get(key) == value) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        int[] key = this.key;
        int[] value = this.value;
        int j = this.realSize();
        int i = 0;
        while (j-- != 0) {
            while (key[i] == 0) {
                ++i;
            }
            int t = key[i];
            h += (t ^= value[i]);
            ++i;
        }
        if (this.containsNullKey) {
            h += value[this.n];
        }
        return h;
    }

    public final int computeIfAbsent(int k, @NotNull Function1<? super Integer, Integer> mappingFunction) {
        Intrinsics.checkNotNullParameter(mappingFunction, "mappingFunction");
        int pos = this.find(k);
        if (pos >= 0) {
            return this.value[pos];
        }
        int newValue = ((Number)mappingFunction.invoke((Integer)k)).intValue();
        this.insert(-pos - 1, k, newValue);
        return newValue;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap$EntryIterator;", "Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap$MapIterator;", "Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap;", "", "Lcom/intellij/util/fastutil/ints/Int2IntEntry;", "<init>", "(Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap;)V", "next", "intellij.platform.util.multiplatform"})
    private final class EntryIterator
    extends MapIterator
    implements Iterator<Int2IntEntry>,
    KMappedMarker {
        @Override
        @NotNull
        public Int2IntEntry next() {
            int nextIndex = this.nextEntry();
            return new Int2IntEntry(Int2IntOpenHashMap.this.key[nextIndex], Int2IntOpenHashMap.this.value[nextIndex]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0006\u001a\u00020\u0007H\u0096\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap$KeyIterator;", "Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap$MapIterator;", "Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap;", "Lcom/intellij/util/fastutil/ints/IntIterator;", "<init>", "(Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap;)V", "next", "", "intellij.platform.util.multiplatform"})
    private final class KeyIterator
    extends MapIterator
    implements IntIterator {
        @Override
        public int next() {
            return Int2IntOpenHashMap.this.key[this.nextEntry()];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001c\u001a\u00020\u0011J\u0006\u0010\u001d\u001a\u00020\u0005J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap$MapIterator;", "", "<init>", "(Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap;)V", "pos", "", "getPos", "()I", "setPos", "(I)V", "last", "getLast", "setLast", "c", "getC", "setC", "mustReturnNullKey", "", "getMustReturnNullKey", "()Z", "setMustReturnNullKey", "(Z)V", "wrapped", "Lcom/intellij/util/fastutil/ints/IntArrayList;", "getWrapped", "()Lcom/intellij/util/fastutil/ints/IntArrayList;", "setWrapped", "(Lcom/intellij/util/fastutil/ints/IntArrayList;)V", "hasNext", "nextEntry", "shiftKeys", "", "intellij.platform.util.multiplatform"})
    @SourceDebugExtension(value={"SMAP\nInt2IntOpenHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Int2IntOpenHashMap.kt\ncom/intellij/util/fastutil/ints/Int2IntOpenHashMap$MapIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,541:1\n1#2:542\n*E\n"})
    private abstract class MapIterator {
        private int pos;
        private int last;
        private int c;
        private boolean mustReturnNullKey;
        @Nullable
        private IntArrayList wrapped;

        public MapIterator() {
            this.pos = Int2IntOpenHashMap.this.n;
            this.last = -1;
            this.c = Int2IntOpenHashMap.this.getSize();
            this.mustReturnNullKey = Int2IntOpenHashMap.this.containsNullKey;
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n) {
            this.pos = n;
        }

        public final int getLast() {
            return this.last;
        }

        public final void setLast(int n) {
            this.last = n;
        }

        public final int getC() {
            return this.c;
        }

        public final void setC(int n) {
            this.c = n;
        }

        public final boolean getMustReturnNullKey() {
            return this.mustReturnNullKey;
        }

        public final void setMustReturnNullKey(boolean bl) {
            this.mustReturnNullKey = bl;
        }

        @Nullable
        public final IntArrayList getWrapped() {
            return this.wrapped;
        }

        public final void setWrapped(@Nullable IntArrayList intArrayList) {
            this.wrapped = intArrayList;
        }

        public final boolean hasNext() {
            return this.c != 0;
        }

        public final int nextEntry() {
            int n;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n2 = this.c;
            this.c = n2 + -1;
            if (this.mustReturnNullKey) {
                this.mustReturnNullKey = false;
                int it = n2 = Int2IntOpenHashMap.this.n;
                boolean bl = false;
                this.last = it;
                return n2;
            }
            int[] key = Int2IntOpenHashMap.this.key;
            do {
                this.pos += -1;
                if (this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                if (this.wrapped == null) {
                    throw new IllegalStateException();
                }
                IntArrayList intArrayList = this.wrapped;
                Intrinsics.checkNotNull(intArrayList);
                int k = intArrayList.get(-this.pos - 1);
                int p = HashCommon.INSTANCE.mix(k) & Int2IntOpenHashMap.this.mask;
                while (k != key[p]) {
                    p = p + 1 & Int2IntOpenHashMap.this.mask;
                }
                return p;
            } while (key[this.pos] == 0);
            int it = n = this.pos;
            boolean bl = false;
            this.last = it;
            return n;
        }

        /*
         * WARNING - void declaration
         */
        private final void shiftKeys(int pos) {
            int pos2 = 0;
            pos2 = pos;
            int last2 = 0;
            int slot = 0;
            int curr = 0;
            int[] key = Int2IntOpenHashMap.this.key;
            int[] value = Int2IntOpenHashMap.this.value;
            while (true) {
                int n;
                int it = n = pos2;
                boolean bl = false;
                last2 = it;
                pos2 = n + 1 & Int2IntOpenHashMap.this.mask;
                while (true) {
                    it = n = key[pos2];
                    boolean bl2 = false;
                    curr = it;
                    if (n == 0) {
                        key[last2] = 0;
                        value[last2] = 0;
                        return;
                    }
                    slot = HashCommon.INSTANCE.mix(curr) & Int2IntOpenHashMap.this.mask;
                    if (last2 <= pos2 ? last2 >= slot || slot > pos2 : (pos2 + 1 <= slot ? slot <= last2 : false)) break;
                    pos2 = pos2 + 1 & Int2IntOpenHashMap.this.mask;
                }
                if (pos2 < last2 && this.wrapped == null) {
                    void $this$shiftKeys_u24lambda_u242;
                    IntArrayList intArrayList;
                    IntArrayList it2 = intArrayList = new IntArrayList(2);
                    MapIterator mapIterator = this;
                    boolean bl3 = false;
                    $this$shiftKeys_u24lambda_u242.add(key[pos2]);
                    mapIterator.wrapped = intArrayList;
                }
                key[last2] = curr;
                value[last2] = value[pos2];
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0006\u001a\u00020\u0007H\u0096\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap$ValueIterator;", "Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap$MapIterator;", "Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap;", "Lcom/intellij/util/fastutil/ints/IntIterator;", "<init>", "(Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap;)V", "next", "", "intellij.platform.util.multiplatform"})
    private final class ValueIterator
    extends MapIterator
    implements IntIterator {
        @Override
        public int next() {
            return Int2IntOpenHashMap.this.value[this.nextEntry()];
        }
    }
}

