/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessOutputType
extends Key<Object> {
    public static final ProcessOutputType SYSTEM = new ProcessOutputType("system");
    public static final ProcessOutputType STDOUT = new ProcessOutputType("stdout");
    public static final ProcessOutputType STDERR = new ProcessOutputType("stderr");
    @Nullable
    private final String myEscapeSequence;
    @NotNull
    private final ProcessOutputType myStreamType;

    public ProcessOutputType(@NotNull String name, @NotNull ProcessOutputType streamType) {
        if (name == null) {
            ProcessOutputType.$$$reportNull$$$0(0);
        }
        if (streamType == null) {
            ProcessOutputType.$$$reportNull$$$0(1);
        }
        super(name);
        this.myEscapeSequence = name;
        this.myStreamType = streamType.getBaseOutputType();
    }

    private ProcessOutputType(@NotNull String name) {
        if (name == null) {
            ProcessOutputType.$$$reportNull$$$0(2);
        }
        super(name);
        this.myEscapeSequence = null;
        this.myStreamType = this;
    }

    @NotNull
    public ProcessOutputType getBaseOutputType() {
        ProcessOutputType processOutputType = this.myStreamType;
        if (processOutputType == null) {
            ProcessOutputType.$$$reportNull$$$0(3);
        }
        return processOutputType;
    }

    public boolean isStdout() {
        return this.getBaseOutputType() == STDOUT;
    }

    public boolean isStderr() {
        return this.getBaseOutputType() == STDERR;
    }

    public static boolean isStderr(@NotNull Key<?> key) {
        if (key == null) {
            ProcessOutputType.$$$reportNull$$$0(4);
        }
        return key instanceof ProcessOutputType && ((ProcessOutputType)key).isStderr();
    }

    public static boolean isStdout(@NotNull Key<?> key) {
        if (key == null) {
            ProcessOutputType.$$$reportNull$$$0(5);
        }
        return key instanceof ProcessOutputType && ((ProcessOutputType)key).isStdout();
    }

    @Nullable
    public String getEscapeSequence() {
        return this.myEscapeSequence;
    }

    @Override
    public String toString() {
        if (this.myEscapeSequence != null) {
            return "[" + this.getBaseOutputType() + "] " + ProcessOutputType.toHumanReadableEscapeSequence(this.myEscapeSequence);
        }
        return super.toString();
    }

    @NotNull
    private static String toHumanReadableEscapeSequence(@NotNull String escapeSequence) {
        if (escapeSequence == null) {
            ProcessOutputType.$$$reportNull$$$0(6);
        }
        String string = escapeSequence.replace("\u001b", "ESC").replace("\u0007", "BEL").replace("\n", "\\n").replace("\r", "\\r").replace("\b", "\\b");
        if (string == null) {
            ProcessOutputType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static ProcessOutputType fromKey(@NotNull Key<?> key) {
        if (key == null) {
            ProcessOutputType.$$$reportNull$$$0(8);
        }
        if (key instanceof ProcessOutputType) {
            ProcessOutputType processOutputType = (ProcessOutputType)key;
            if (processOutputType == null) {
                ProcessOutputType.$$$reportNull$$$0(9);
            }
            return processOutputType;
        }
        throw new IllegalArgumentException("Unexpected key " + key + ". Should be one of ProcessOutputTypes");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamType";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/ProcessOutputType";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapeSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/ProcessOutputType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseOutputType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toHumanReadableEscapeSequence";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fromKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isStderr";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isStdout";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toHumanReadableEscapeSequence";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fromKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

