/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.history;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.history.CommandHistoryUtil;
import org.jetbrains.plugins.terminal.block.history.CommandSearchListener;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/terminal/block/history/CommandSearchPresenter;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;)V", "showCommandSearch", "", "history", "", "", "Companion", "intellij.terminal"})
public final class CommandSearchPresenter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final TerminalPromptModel promptModel;
    @NotNull
    private static final Key<Boolean> IS_COMMAND_SEARCH_LOOKUP_KEY;

    public CommandSearchPresenter(@NotNull Project project, @NotNull Editor editor, @NotNull TerminalPromptModel promptModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)promptModel, (String)"promptModel");
        this.project = project;
        this.editor = editor;
        this.promptModel = promptModel;
    }

    public final void showCommandSearch(@NotNull List<String> history) {
        Intrinsics.checkNotNullParameter(history, (String)"history");
        String command2 = this.promptModel.getCommandText();
        LookupImpl lookup = CommandHistoryUtil.INSTANCE.createLookup(this.project, this.editor, command2, CollectionsKt.asReversed(history));
        lookup.putUserData(IS_COMMAND_SEARCH_LOOKUP_KEY, (Object)true);
        lookup.addLookupListener(new LookupListener(this){
            final /* synthetic */ CommandSearchPresenter this$0;
            {
                this.this$0 = $receiver;
            }

            public void lookupCanceled(LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ((CommandSearchListener)CommandSearchPresenter.access$getProject$p(this.this$0).getMessageBus().syncPublisher(CommandSearchListener.Companion.getTOPIC())).commandSearchAborted(CommandSearchPresenter.access$getPromptModel$p(this.this$0));
            }
        });
        if (lookup.showLookup()) {
            lookup.ensureSelectionVisible(false);
            ((CommandSearchListener)this.project.getMessageBus().syncPublisher(CommandSearchListener.Companion.getTOPIC())).commandSearchShown(this.promptModel);
        }
    }

    public static final /* synthetic */ Project access$getProject$p(CommandSearchPresenter $this) {
        return $this.project;
    }

    public static final /* synthetic */ TerminalPromptModel access$getPromptModel$p(CommandSearchPresenter $this) {
        return $this.promptModel;
    }

    static {
        Key key = Key.create((String)"isCommandSearchLookup");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        IS_COMMAND_SEARCH_LOOKUP_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00020\u0006*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/block/history/CommandSearchPresenter$Companion;", "", "<init>", "()V", "IS_COMMAND_SEARCH_LOOKUP_KEY", "Lcom/intellij/openapi/util/Key;", "", "isTerminalCommandSearch", "Lcom/intellij/codeInsight/lookup/Lookup;", "(Lcom/intellij/codeInsight/lookup/Lookup;)Z", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isTerminalCommandSearch(@NotNull Lookup $this$isTerminalCommandSearch) {
            Intrinsics.checkNotNullParameter((Object)$this$isTerminalCommandSearch, (String)"<this>");
            UserDataHolder userDataHolder = $this$isTerminalCommandSearch instanceof UserDataHolder ? (UserDataHolder)$this$isTerminalCommandSearch : null;
            return userDataHolder != null ? Intrinsics.areEqual((Object)userDataHolder.getUserData(IS_COMMAND_SEARCH_LOOKUP_KEY), (Object)true) : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

