/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgDiffProvider
implements DiffProvider {
    private final Project project;

    public HgDiffProvider(Project project) {
        this.project = project;
    }

    public VcsRevisionNumber getCurrentRevision(VirtualFile file) {
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.project, (VirtualFile)file);
        if (vcsRoot == null) {
            return null;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        return (VcsRevisionNumber)new HgWorkingCopyRevisionsCommand((Project)this.project).parents((VirtualFile)vcsRoot, (FilePath)filePath).first;
    }

    public ItemLatestState getLastRevision(VirtualFile file) {
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.project, (VirtualFile)file);
        if (vcsRoot == null) {
            return null;
        }
        HgRevisionNumber revision = (HgRevisionNumber)this.getCurrentRevision(file);
        if (revision == null) {
            return null;
        }
        return new ItemLatestState((VcsRevisionNumber)revision, file.exists(), true);
    }

    public ItemLatestState getLastRevision(FilePath filePath) {
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.project, (FilePath)filePath);
        if (vcsRoot == null) {
            return null;
        }
        HgWorkingCopyRevisionsCommand command = new HgWorkingCopyRevisionsCommand(this.project);
        HgRevisionNumber currentRevision = (HgRevisionNumber)command.identify(vcsRoot).getFirst();
        if (currentRevision == null) {
            return null;
        }
        boolean fileExists = filePath.getIOFile().exists();
        if (currentRevision.isWorkingVersion()) {
            return new ItemLatestState((VcsRevisionNumber)command.firstParent(vcsRoot), fileExists, true);
        }
        return new ItemLatestState((VcsRevisionNumber)currentRevision, fileExists, true);
    }

    public VcsRevisionNumber getLatestCommittedRevision(VirtualFile vcsRoot) {
        return new HgWorkingCopyRevisionsCommand(this.project).tip(vcsRoot);
    }

    public ContentRevision createFileContent(VcsRevisionNumber revisionNumber, VirtualFile file) {
        if (file == null) {
            return null;
        }
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.project, (VirtualFile)file);
        if (vcsRoot == null) {
            return null;
        }
        HgRevisionNumber hgRevisionNumber = (HgRevisionNumber)revisionNumber;
        if (hgRevisionNumber.isWorkingVersion()) {
            throw new IllegalStateException("Should not compare against working copy");
        }
        HgFile hgFile = new HgFile(vcsRoot, HgUtil.getOriginalFileName(VcsUtil.getFilePath((VirtualFile)file), ChangeListManager.getInstance((Project)this.project)));
        return HgContentRevision.create(this.project, hgFile, hgRevisionNumber);
    }

    public boolean canCompareWithWorkingDir() {
        return true;
    }

    @NotNull
    public Collection<Change> compareWithWorkingDir(@NotNull VirtualFile fileOrDir, @NotNull VcsRevisionNumber revNum) throws VcsException {
        HgRepository repo;
        if (fileOrDir == null) {
            HgDiffProvider.$$$reportNull$$$0(0);
        }
        if (revNum == null) {
            HgDiffProvider.$$$reportNull$$$0(1);
        }
        if ((repo = (HgRepository)HgUtil.getRepositoryManager(this.project).getRepositoryForFile(fileOrDir)) == null) {
            throw new VcsException(HgBundle.message("error.cannot.find.repository.for.file", fileOrDir.getName()));
        }
        assert (revNum instanceof HgRevisionNumber) : "Expected " + HgRevisionNumber.class.getSimpleName() + ", got " + revNum.getClass().getSimpleName();
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)fileOrDir);
        List<Change> changes = HgUtil.getDiff(this.project, repo.getRoot(), filePath, (HgRevisionNumber)revNum, null);
        if (changes.isEmpty() && !filePath.isDirectory()) {
            HgFile hgFile = new HgFile(repo.getRoot(), filePath);
            List list = VcsDiffUtil.createChangesWithCurrentContentForFile((FilePath)filePath, (ContentRevision)HgContentRevision.create(this.project, hgFile, (HgRevisionNumber)revNum));
            if (list == null) {
                HgDiffProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<Change> list = changes;
        if (list == null) {
            HgDiffProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revNum";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/provider/HgDiffProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/provider/HgDiffProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compareWithWorkingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compareWithWorkingDir";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

