/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationListRequestCopier;
import software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceCreditSpecificationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyInstanceCreditSpecificationRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyInstanceCreditSpecificationRequest.getter(ModifyInstanceCreditSpecificationRequest::dryRun)).setter(ModifyInstanceCreditSpecificationRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ModifyInstanceCreditSpecificationRequest.getter(ModifyInstanceCreditSpecificationRequest::clientToken)).setter(ModifyInstanceCreditSpecificationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build()}).build();
    private static final SdkField<List<InstanceCreditSpecificationRequest>> INSTANCE_CREDIT_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceCreditSpecifications").getter(ModifyInstanceCreditSpecificationRequest.getter(ModifyInstanceCreditSpecificationRequest::instanceCreditSpecifications)).setter(ModifyInstanceCreditSpecificationRequest.setter(Builder::instanceCreditSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreditSpecification").unmarshallLocationName("InstanceCreditSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceCreditSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, CLIENT_TOKEN_FIELD, INSTANCE_CREDIT_SPECIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyInstanceCreditSpecificationRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String clientToken;
    private final List<InstanceCreditSpecificationRequest> instanceCreditSpecifications;

    private ModifyInstanceCreditSpecificationRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
        this.instanceCreditSpecifications = builder.instanceCreditSpecifications;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasInstanceCreditSpecifications() {
        return this.instanceCreditSpecifications != null && !(this.instanceCreditSpecifications instanceof SdkAutoConstructList);
    }

    public final List<InstanceCreditSpecificationRequest> instanceCreditSpecifications() {
        return this.instanceCreditSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceCreditSpecifications() ? this.instanceCreditSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceCreditSpecificationRequest)) {
            return false;
        }
        ModifyInstanceCreditSpecificationRequest other = (ModifyInstanceCreditSpecificationRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasInstanceCreditSpecifications() == other.hasInstanceCreditSpecifications() && Objects.equals(this.instanceCreditSpecifications(), other.instanceCreditSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyInstanceCreditSpecificationRequest").add("DryRun", (Object)this.dryRun()).add("ClientToken", (Object)this.clientToken()).add("InstanceCreditSpecifications", this.hasInstanceCreditSpecifications() ? this.instanceCreditSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "InstanceCreditSpecifications": {
                return Optional.ofNullable(clazz.cast(this.instanceCreditSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("InstanceCreditSpecification", INSTANCE_CREDIT_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceCreditSpecificationRequest, T> g) {
        return obj -> g.apply((ModifyInstanceCreditSpecificationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String clientToken;
        private List<InstanceCreditSpecificationRequest> instanceCreditSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceCreditSpecificationRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.clientToken(model.clientToken);
            this.instanceCreditSpecifications(model.instanceCreditSpecifications);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<InstanceCreditSpecificationRequest.Builder> getInstanceCreditSpecifications() {
            List<InstanceCreditSpecificationRequest.Builder> result = InstanceCreditSpecificationListRequestCopier.copyToBuilder(this.instanceCreditSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceCreditSpecifications(Collection<InstanceCreditSpecificationRequest.BuilderImpl> instanceCreditSpecifications) {
            this.instanceCreditSpecifications = InstanceCreditSpecificationListRequestCopier.copyFromBuilder(instanceCreditSpecifications);
        }

        @Override
        public final Builder instanceCreditSpecifications(Collection<InstanceCreditSpecificationRequest> instanceCreditSpecifications) {
            this.instanceCreditSpecifications = InstanceCreditSpecificationListRequestCopier.copy(instanceCreditSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCreditSpecifications(InstanceCreditSpecificationRequest ... instanceCreditSpecifications) {
            this.instanceCreditSpecifications(Arrays.asList(instanceCreditSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCreditSpecifications(Consumer<InstanceCreditSpecificationRequest.Builder> ... instanceCreditSpecifications) {
            this.instanceCreditSpecifications(Stream.of(instanceCreditSpecifications).map(c -> (InstanceCreditSpecificationRequest)((InstanceCreditSpecificationRequest.Builder)InstanceCreditSpecificationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceCreditSpecificationRequest build() {
            return new ModifyInstanceCreditSpecificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyInstanceCreditSpecificationRequest> {
        public Builder dryRun(Boolean var1);

        public Builder clientToken(String var1);

        public Builder instanceCreditSpecifications(Collection<InstanceCreditSpecificationRequest> var1);

        public Builder instanceCreditSpecifications(InstanceCreditSpecificationRequest ... var1);

        public Builder instanceCreditSpecifications(Consumer<InstanceCreditSpecificationRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

