/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.trackers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import org.opensearch.common.util.Streak;
import org.opensearch.common.util.TimeBasedExpiryTracker;
import org.opensearch.wlm.ResourceType;

public class NodeDuressTrackers {
    private final Map<ResourceType, NodeDuressTracker> duressTrackers;
    private final Map<ResourceType, Boolean> resourceDuressCache = new ConcurrentHashMap<ResourceType, Boolean>();
    private final BooleanSupplier nodeDuressCacheExpiryChecker;

    public NodeDuressTrackers(Map<ResourceType, NodeDuressTracker> duressTrackers) {
        this(duressTrackers, new TimeBasedExpiryTracker(System::nanoTime));
    }

    public NodeDuressTrackers(Map<ResourceType, NodeDuressTracker> duressTrackers, BooleanSupplier nodeDuressCacheExpiryChecker) {
        this.duressTrackers = duressTrackers;
        for (ResourceType resourceType : ResourceType.values()) {
            this.resourceDuressCache.put(resourceType, false);
        }
        this.nodeDuressCacheExpiryChecker = nodeDuressCacheExpiryChecker;
    }

    public boolean isResourceInDuress(ResourceType resourceType) {
        this.updateCache();
        return this.resourceDuressCache.get((Object)resourceType);
    }

    public boolean isNodeInDuress() {
        for (ResourceType resourceType : ResourceType.values()) {
            if (!this.isResourceInDuress(resourceType)) continue;
            return true;
        }
        return false;
    }

    private void updateCache() {
        if (this.nodeDuressCacheExpiryChecker.getAsBoolean()) {
            for (ResourceType resourceType : ResourceType.values()) {
                this.resourceDuressCache.put(resourceType, this.duressTrackers.get((Object)resourceType).test());
            }
        }
    }

    public static class NodeDuressTracker {
        private final Streak breaches = new Streak();
        private final BooleanSupplier isNodeInDuress;
        private final IntSupplier maxBreachAllowedSupplier;

        public NodeDuressTracker(BooleanSupplier isNodeInDuress, IntSupplier maxBreachAllowedSupplier) {
            this.isNodeInDuress = isNodeInDuress;
            this.maxBreachAllowedSupplier = maxBreachAllowedSupplier;
        }

        public boolean test() {
            return this.breaches.record(this.isNodeInDuress.getAsBoolean()) >= this.maxBreachAllowedSupplier.getAsInt();
        }
    }
}

