/*
 * SPDX-FileCopyrightText: Copyright (c) 1993-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/***************************** HW State Routines ***************************\
*                                                                           *
* Module: hals_all.c                                                          *
*       Hal interface init routines for files generated by rmconfig         *
*                                                                           *
\***************************************************************************/

#include "nvoc/object.h"
#include "core/core.h"
#include "gpu/gpu.h"
#include "gpu/eng_desc.h"

#include "vgpu/rpc.h"

//
// These defines affect what we see in halgen generated headers.
//
// If RMCFG_ENGINE_SETUP is not already defined, then setup for
// a monolithic hal.
//
// The per-gpu-family hal setups #include this file with the RMCFG
// setup defines already defined to pull in just the interfaces
// needed for that gpu family.
//

#if ! defined(RMCFG_ENGINE_SETUP)

#  define RMCFG_ENGINE_SETUP      1   // pull in per-gpu engine interface's

#  define RMCFG_HAL_SETUP_ALL     1   // monolithic - ALL configured gpus' support in this file
#  define RMCFG_HAL_SUPPORT_ALL   1   // not required, but keeps us honest

#endif  // ! defined RMCFG_ENGINE_SETUP

// Pull in generated code to setup each engine's hal interfaces for each gpu
#include "g_hal_register.h"
#include "g_hal_private.h"

