/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.sandbox.search.AggregatedQueryLeafProfilerResult;

public class QueryProfilerResult {
    private final String type;
    private final String description;
    private final long startTime;
    private final long totalTime;
    private final Map<String, Long> queryBreakdowns;
    private final List<AggregatedQueryLeafProfilerResult> aggregatedQueryLeafBreakdowns;
    private final List<QueryProfilerResult> childrenProfileResults;

    public QueryProfilerResult(String type, String description, Map<String, Long> queryBreakdowns, List<AggregatedQueryLeafProfilerResult> aggregatedQueryLeafBreakdowns, List<QueryProfilerResult> childrenProfileResults, long startTime, long totalTime) {
        this.type = type;
        this.description = description;
        this.queryBreakdowns = Objects.requireNonNull(queryBreakdowns, "required breakdown argument missing");
        this.aggregatedQueryLeafBreakdowns = Objects.requireNonNull(aggregatedQueryLeafBreakdowns, "required slice breakdowns argument missing");
        this.childrenProfileResults = childrenProfileResults == null ? Collections.emptyList() : childrenProfileResults;
        this.startTime = startTime;
        this.totalTime = totalTime;
    }

    public String getQueryName() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Long> getTimeBreakdown() {
        return Collections.unmodifiableMap(this.queryBreakdowns);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public List<AggregatedQueryLeafProfilerResult> getAggregatedQueryLeafBreakdowns() {
        return Collections.unmodifiableList(this.aggregatedQueryLeafBreakdowns);
    }

    public List<QueryProfilerResult> getProfiledChildren() {
        return Collections.unmodifiableList(this.childrenProfileResults);
    }
}

