/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.ffmpeg.FFmpegProgress;
import com.github.kokorin.jaffree.ffmpeg.ProgressListener;
import com.github.kokorin.jaffree.net.TcpNegotiator;
import com.github.kokorin.jaffree.util.ParseUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpegProgressReader
implements TcpNegotiator {
    private final ProgressListener progressListener;
    private static final Logger LOGGER = LoggerFactory.getLogger(FFmpegProgressReader.class);

    public FFmpegProgressReader(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    @Override
    public void negotiate(Socket socket) throws IOException {
        try (InputStream inputStream = socket.getInputStream();){
            this.readProgress(inputStream);
        }
    }

    protected void readProgress(InputStream inputStream) throws IOException {
        BufferedReader lineReader = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        Long frame = null;
        Double fps = null;
        Double quality = null;
        Double bitrate = null;
        Long totalSize = null;
        Long outTimeMicros = null;
        Long dupFrames = null;
        Long dropFrames = null;
        Double speed = null;
        LOGGER.debug("Reading encoding progress");
        block25: while ((line = lineReader.readLine()) != null) {
            LOGGER.trace("Line read: {}", (Object)line);
            String[] keyValue = line.split("=", 2);
            if (keyValue.length != 2) continue;
            String key = keyValue[0];
            String value = keyValue[1];
            switch (key) {
                case "frame": {
                    frame = ParseUtil.parseLong(value);
                    continue block25;
                }
                case "fps": {
                    fps = ParseUtil.parseDouble(value);
                    continue block25;
                }
                case "bitrate": {
                    bitrate = ParseUtil.parseBitrateInKBits(value);
                    continue block25;
                }
                case "total_size": {
                    totalSize = ParseUtil.parseLong(value);
                    continue block25;
                }
                case "out_time_us": 
                case "out_time_ms": {
                    outTimeMicros = ParseUtil.parseLong(value);
                    continue block25;
                }
                case "out_time": {
                    continue block25;
                }
                case "dup_frames": {
                    dupFrames = ParseUtil.parseLong(value);
                    continue block25;
                }
                case "drop_frames": {
                    dropFrames = ParseUtil.parseLong(value);
                    continue block25;
                }
                case "speed": {
                    speed = ParseUtil.parseSpeed(value);
                    continue block25;
                }
                case "progress": {
                    FFmpegProgress progress = new FFmpegProgress(frame, fps, quality, totalSize, outTimeMicros, dupFrames, dropFrames, bitrate, speed);
                    frame = null;
                    fps = null;
                    quality = null;
                    bitrate = null;
                    totalSize = null;
                    outTimeMicros = null;
                    dupFrames = null;
                    dropFrames = null;
                    speed = null;
                    this.progressListener.onProgress(progress);
                    continue block25;
                }
            }
            if (key.startsWith("stream_")) {
                quality = ParseUtil.parseDouble(value);
                continue;
            }
            LOGGER.info("Unknown property: {}", (Object)key);
        }
    }
}

