/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class RemoteIPAttribute
implements ExchangeAttribute {
    public static final String REMOTE_IP_SHORT = "%a";
    public static final String REMOTE_IP = "%{REMOTE_IP}";
    public static final ExchangeAttribute INSTANCE = new RemoteIPAttribute();

    private RemoteIPAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        InetSocketAddress sourceAddress = exchange.getSourceAddress();
        InetAddress address = sourceAddress.getAddress();
        if (address == null) {
            address = exchange.getSourceAddress().getAddress();
        }
        if (address == null) {
            return null;
        }
        return address.getHostAddress();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Remote IP", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Remote IP";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RemoteIPAttribute.REMOTE_IP) || token.equals(RemoteIPAttribute.REMOTE_IP_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

