/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism.scram;

import org.wildfly.security.mechanism.scram.ScramInitialClientMessage;
import org.wildfly.security.mechanism.scram.ScramInitialServerMessage;
import org.wildfly.security.mechanism.scram.ScramMechanism;
import org.wildfly.security.password.interfaces.ScramDigestPassword;

public final class ScramFinalClientMessage {
    private final ScramInitialClientMessage initialResponse;
    private final ScramInitialServerMessage initialChallenge;
    private final ScramDigestPassword password;
    private final byte[] clientProof;
    private final byte[] messageBytes;
    private final int proofOffset;

    ScramFinalClientMessage(ScramInitialClientMessage initialResponse, ScramInitialServerMessage initialChallenge, ScramDigestPassword password, byte[] clientProof, byte[] messageBytes, int proofOffset) {
        this.initialResponse = initialResponse;
        this.initialChallenge = initialChallenge;
        this.password = password;
        this.clientProof = clientProof;
        this.messageBytes = messageBytes;
        this.proofOffset = proofOffset;
    }

    public ScramInitialClientMessage getInitialResponse() {
        return this.initialResponse;
    }

    public ScramInitialServerMessage getInitialChallenge() {
        return this.initialChallenge;
    }

    public ScramDigestPassword getPassword() {
        return this.password;
    }

    byte[] getRawClientProof() {
        return this.clientProof;
    }

    byte[] getRawMessageBytes() {
        return this.messageBytes;
    }

    public byte[] getClientProof() {
        return (byte[])this.clientProof.clone();
    }

    public byte[] getMessageBytes() {
        return (byte[])this.messageBytes.clone();
    }

    public ScramMechanism getMechanism() {
        return this.initialResponse.getMechanism();
    }

    int getProofOffset() {
        return this.proofOffset;
    }
}

