/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import org.hibernate.annotations.OptimisticLockType;

public enum OptimisticLockStyle {
    NONE,
    VERSION,
    DIRTY,
    ALL;


    public static OptimisticLockStyle fromLockType(OptimisticLockType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case OptimisticLockType.VERSION -> VERSION;
            case OptimisticLockType.NONE -> NONE;
            case OptimisticLockType.DIRTY -> DIRTY;
            case OptimisticLockType.ALL -> ALL;
        };
    }

    public boolean isAllOrDirty() {
        return this.isAll() || this.isDirty();
    }

    public boolean isAll() {
        return this == ALL;
    }

    public boolean isDirty() {
        return this == DIRTY;
    }

    public boolean isVersion() {
        return this == VERSION;
    }

    public boolean isNone() {
        return this == NONE;
    }
}

