/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.json.OracleJsonValueFunction;
import org.hibernate.dialect.function.xml.XmlTableFunction;
import org.hibernate.dialect.function.xml.XmlTableSetReturningFunctionTypeResolver;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleXmlTableFunction
extends XmlTableFunction {
    public OracleXmlTableFunction(TypeConfiguration typeConfiguration) {
        super(false, new OracleXmlTableSetReturningFunctionTypeResolver(), typeConfiguration);
    }

    @Override
    protected String determineColumnType(CastTarget castTarget, SqlAstTranslator<?> walker) {
        String typeName;
        return switch (typeName = super.determineColumnType(castTarget, walker)) {
            case "clob" -> "varchar2(" + walker.getSessionFactory().getJdbcServices().getDialect().getMaxVarcharLength() + ")";
            case "number(1,0)" -> {
                if (OracleJsonValueFunction.isEncodedBoolean(castTarget.getJdbcMapping())) {
                    yield "varchar2(5)";
                }
                yield typeName;
            }
            default -> typeName;
        };
    }

    private static class OracleXmlTableSetReturningFunctionTypeResolver
    extends XmlTableSetReturningFunctionTypeResolver {
        private OracleXmlTableSetReturningFunctionTypeResolver() {
        }

        @Override
        protected void addSelectableMapping(List<SelectableMapping> selectableMappings, String name, JdbcMapping type, SqmToSqlAstConverter converter) {
            if (OracleJsonValueFunction.isEncodedBoolean(type)) {
                JdbcLiteralFormatter jdbcLiteralFormatter = type.getJdbcLiteralFormatter();
                Dialect dialect = converter.getCreationContext().getDialect();
                WrapperOptions wrapperOptions = converter.getCreationContext().getWrapperOptions();
                Object trueValue = type.convertToRelationalValue(true);
                Object falseValue = type.convertToRelationalValue(false);
                String trueFragment = jdbcLiteralFormatter.toJdbcLiteral(trueValue, dialect, wrapperOptions);
                String falseFragment = jdbcLiteralFormatter.toJdbcLiteral(falseValue, dialect, wrapperOptions);
                selectableMappings.add(new SelectableMappingImpl("", name, new SelectablePath(name), "decode({@}." + name + ",'true'," + trueFragment + ",'false'," + falseFragment + ")", null, "varchar2(5)", null, null, null, null, false, false, false, false, false, false, type));
            } else {
                super.addSelectableMapping(selectableMappings, name, type, converter);
            }
        }
    }
}

