/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.store.syncronization;

import java.util.EnumMap;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.store.syncronization.Synchronizer;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderFactory;

public class UserSynchronizer
implements Synchronizer<UserModel.UserRemovedEvent> {
    @Override
    public void synchronize(UserModel.UserRemovedEvent event, KeycloakSessionFactory factory) {
        ProviderFactory providerFactory = factory.getProviderFactory(AuthorizationProvider.class);
        AuthorizationProvider authorizationProvider = (AuthorizationProvider)providerFactory.create(event.getKeycloakSession());
        AdminPermissionsSchema.SCHEMA.removeResourceObject(authorizationProvider, (ProviderEvent)event);
        this.removeFromUserPermissionTickets(event, authorizationProvider);
        this.removeUserResources(event, authorizationProvider);
    }

    private void removeUserResources(UserModel.UserRemovedEvent event, AuthorizationProvider authorizationProvider) {
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        UserModel userModel = event.getUser();
        resourceStore.findByOwner(null, userModel.getId(), resource -> {
            String resourceId = resource.getId();
            policyStore.findByResource(resource.getResourceServer(), (Resource)resource).forEach(policy -> {
                if (policy.getResources().size() == 1) {
                    policyStore.delete(policy.getId());
                } else {
                    policy.removeResource((Resource)resource);
                }
            });
            resourceStore.delete(resourceId);
        });
    }

    private void removeFromUserPermissionTickets(UserModel.UserRemovedEvent event, AuthorizationProvider authorizationProvider) {
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        PermissionTicketStore ticketStore = storeFactory.getPermissionTicketStore();
        UserModel userModel = event.getUser();
        EnumMap<PermissionTicket.FilterOption, String> attributes = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
        attributes.put(PermissionTicket.FilterOption.OWNER, userModel.getId());
        for (PermissionTicket ticket : ticketStore.find(null, attributes, null, null)) {
            ticketStore.delete(ticket.getId());
        }
        attributes.clear();
        attributes.put(PermissionTicket.FilterOption.REQUESTER, userModel.getId());
        for (PermissionTicket ticket : ticketStore.find(null, attributes, null, null)) {
            ticketStore.delete(ticket.getId());
        }
    }
}

