/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithName;
import java.util.Optional;

public class SslProcessor {
    private static final String JAVA_11_PLUS_SSL_LOGGER = "sun.security.ssl.SSLLogger";
    SslConfig ssl;

    @BuildStep
    SslNativeConfigBuildItem setupNativeSsl() {
        return new SslNativeConfigBuildItem(this.ssl.native_());
    }

    @BuildStep
    void runtime(BuildProducer<RuntimeReinitializedClassBuildItem> reinitialized) {
        reinitialized.produce(new RuntimeReinitializedClassBuildItem(JAVA_11_PLUS_SSL_LOGGER));
    }

    @ConfigMapping(prefix="quarkus.ssl")
    @ConfigRoot(phase=ConfigPhase.BUILD_TIME)
    static interface SslConfig {
        @WithName(value="native")
        public Optional<Boolean> native_();
    }
}

