/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.cache;

import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;
import org.python.google.common.annotations.GwtIncompatible;
import org.python.google.common.cache.AbstractCache;
import org.python.google.common.cache.ElementTypesAreNonnullByDefault;
import org.python.google.common.cache.LoadingCache;
import org.python.google.common.collect.ImmutableMap;
import org.python.google.common.collect.Maps;
import org.python.google.common.util.concurrent.UncheckedExecutionException;
import org.python.google.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class AbstractLoadingCache<K, V>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    @Override
    @CanIgnoreReturnValue
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (K key : keys) {
            if (result.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return ImmutableMap.copyOf(result);
    }

    @Override
    public final V apply(K key) {
        return this.getUnchecked(key);
    }

    @Override
    public void refresh(K key) {
        throw new UnsupportedOperationException();
    }
}

