/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Generate an n-dimensional image of a grid.


GridImageSource generates an image of a grid. From the abstract... "Certain classes
of images find disparate use amongst members of the ITK community for
such purposes as visualization, simulation, testing, etc. Currently
there exists two derived classes from the ImageSource class used for generating specific images for various applications,
viz. RandomImageSource and GaussianImageSource. We propose to add to this set with the class GridImageSource which, obviously enough, produces a grid image. Such images are
useful for visualizing deformation when used in conjunction with the WarpImageFilter, simulating magnetic resonance tagging images, or creating optical
illusions with which to amaze your friends."

The output image may be of any dimension.


Tustison N., Avants B., Gee J. University of Pennsylvania
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/ze1ssz
See:
 itk::simple::GridSource for the procedural interface

 itk::GridImageSource for the Doxygen on the original ITK class.


C++ includes: sitkGridImageSource.h
*/
public class GridImageSource extends ImageFilter {
  private transient long swigCPtr;

  protected GridImageSource(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GridImageSource_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GridImageSource obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GridImageSource obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GridImageSource::~GridImageSource()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GridImageSource(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GridImageSource::GridImageSource()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GridImageSource() {
    this(SimpleITKJNI.new_GridImageSource(), true);
  }

  /**
Self&amp; itk::simple::GridImageSource::SetOutputPixelType(PixelIDValueEnum OutputPixelType)
*/
public  void setOutputPixelType(PixelIDValueEnum OutputPixelType) {
    SimpleITKJNI.GridImageSource_setOutputPixelType(swigCPtr, this, OutputPixelType.swigValue());
  }

  /**
PixelIDValueEnum itk::simple::GridImageSource::GetOutputPixelType() const
*/
public  PixelIDValueEnum getOutputPixelType() {
    return PixelIDValueEnum.swigToEnum(SimpleITKJNI.GridImageSource_getOutputPixelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::GridImageSource::SetSize(std::vector&lt; unsigned int &gt; Size)
*/
public  void setSize(VectorUInt32 Size) {
    SimpleITKJNI.GridImageSource_setSize(swigCPtr, this, VectorUInt32.getCPtr(Size), Size);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::GridImageSource::GetSize() const
*/
public  VectorUInt32 getSize() {
    return new VectorUInt32(SimpleITKJNI.GridImageSource_getSize(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GridImageSource::SetSigma(std::vector&lt; double &gt; Sigma)

Set/Get the standard deviation of the Gaussians or width of the box
functions.

*/
public  void setSigma(VectorDouble Sigma) {
    SimpleITKJNI.GridImageSource_setSigma__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(Sigma), Sigma);
  }

  /**
Self&amp; itk::simple::GridImageSource::SetSigma(std::vector&lt; double &gt; Sigma)

Set/Get the standard deviation of the Gaussians or width of the box
functions.

*/
public  void setSigma(double value) {
    SimpleITKJNI.GridImageSource_setSigma__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::GridImageSource::GetSigma() const

Set/Get the standard deviation of the Gaussians or width of the box
functions.

*/
public  VectorDouble getSigma() {
    return new VectorDouble(SimpleITKJNI.GridImageSource_getSigma(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GridImageSource::SetGridSpacing(std::vector&lt; double &gt; GridSpacing)

Set/Get the grid spacing of the peaks.

*/
public  void setGridSpacing(VectorDouble GridSpacing) {
    SimpleITKJNI.GridImageSource_setGridSpacing(swigCPtr, this, VectorDouble.getCPtr(GridSpacing), GridSpacing);
  }

  /**
std::vector&lt;double&gt; itk::simple::GridImageSource::GetGridSpacing() const

Set/Get the grid spacing of the peaks.

*/
public  VectorDouble getGridSpacing() {
    return new VectorDouble(SimpleITKJNI.GridImageSource_getGridSpacing(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GridImageSource::SetGridOffset(std::vector&lt; double &gt; GridOffset)

Set/Get the grid offset.

*/
public  void setGridOffset(VectorDouble GridOffset) {
    SimpleITKJNI.GridImageSource_setGridOffset(swigCPtr, this, VectorDouble.getCPtr(GridOffset), GridOffset);
  }

  /**
std::vector&lt;double&gt; itk::simple::GridImageSource::GetGridOffset() const

Set/Get the grid offset.

*/
public  VectorDouble getGridOffset() {
    return new VectorDouble(SimpleITKJNI.GridImageSource_getGridOffset(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GridImageSource::SetScale(double Scale)

Set/Get the scale factor to multiply the true value of the grid.

*/
public  void setScale(double Scale) {
    SimpleITKJNI.GridImageSource_setScale(swigCPtr, this, Scale);
  }

  /**
double itk::simple::GridImageSource::GetScale() const

Set/Get the scale factor to multiply the true value of the grid.

*/
public  double getScale() {
    return SimpleITKJNI.GridImageSource_getScale(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GridImageSource::SetOrigin(std::vector&lt; double &gt; Origin)
*/
public  void setOrigin(VectorDouble Origin) {
    SimpleITKJNI.GridImageSource_setOrigin(swigCPtr, this, VectorDouble.getCPtr(Origin), Origin);
  }

  /**
std::vector&lt;double&gt; itk::simple::GridImageSource::GetOrigin() const
*/
public  VectorDouble getOrigin() {
    return new VectorDouble(SimpleITKJNI.GridImageSource_getOrigin(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GridImageSource::SetSpacing(std::vector&lt; double &gt; Spacing)
*/
public  void setSpacing(VectorDouble Spacing) {
    SimpleITKJNI.GridImageSource_setSpacing(swigCPtr, this, VectorDouble.getCPtr(Spacing), Spacing);
  }

  /**
std::vector&lt;double&gt; itk::simple::GridImageSource::GetSpacing() const
*/
public  VectorDouble getSpacing() {
    return new VectorDouble(SimpleITKJNI.GridImageSource_getSpacing(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GridImageSource::SetDirection(std::vector&lt; double &gt; Direction)
*/
public  void setDirection(VectorDouble Direction) {
    SimpleITKJNI.GridImageSource_setDirection(swigCPtr, this, VectorDouble.getCPtr(Direction), Direction);
  }

  /**
std::vector&lt;double&gt; itk::simple::GridImageSource::GetDirection() const
*/
public  VectorDouble getDirection() {
    return new VectorDouble(SimpleITKJNI.GridImageSource_getDirection(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GridImageSource::SetWhichDimensions(std::vector&lt; bool &gt; WhichDimensions)

Set/Get the dimensions which are gridded.

*/
public  void setWhichDimensions(VectorBool WhichDimensions) {
    SimpleITKJNI.GridImageSource_setWhichDimensions(swigCPtr, this, VectorBool.getCPtr(WhichDimensions), WhichDimensions);
  }

  /**
std::vector&lt;bool&gt; itk::simple::GridImageSource::GetWhichDimensions() const

Set/Get the dimensions which are gridded.

*/
public  VectorBool getWhichDimensions() {
    return new VectorBool(SimpleITKJNI.GridImageSource_getWhichDimensions(swigCPtr, this), true);
  }

  /**
std::string itk::simple::GridImageSource::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GridImageSource_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GridImageSource::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GridImageSource_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GridImageSource::Execute()

Execute the filter on the input image

*/
public  Image execute() {
    return new Image(SimpleITKJNI.GridImageSource_execute(swigCPtr, this), true);
  }

}
