/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageFilter;
import org.itk.simple.SimpleITKJNI;

public class FFTConvolutionImageFilter
extends ImageFilter {
    private transient long swigCPtr;

    protected FFTConvolutionImageFilter(long l, boolean bl) {
        super(SimpleITKJNI.FFTConvolutionImageFilter_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(FFTConvolutionImageFilter fFTConvolutionImageFilter) {
        return fFTConvolutionImageFilter == null ? 0L : fFTConvolutionImageFilter.swigCPtr;
    }

    protected static long swigRelease(FFTConvolutionImageFilter fFTConvolutionImageFilter) {
        long l = 0L;
        if (fFTConvolutionImageFilter != null) {
            if (!fFTConvolutionImageFilter.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = fFTConvolutionImageFilter.swigCPtr;
            fFTConvolutionImageFilter.swigCMemOwn = false;
            fFTConvolutionImageFilter.delete();
        }
        return l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_FFTConvolutionImageFilter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public FFTConvolutionImageFilter() {
        this(SimpleITKJNI.new_FFTConvolutionImageFilter(), true);
    }

    public void setNormalize(boolean bl) {
        SimpleITKJNI.FFTConvolutionImageFilter_setNormalize(this.swigCPtr, this, bl);
    }

    public void normalizeOn() {
        SimpleITKJNI.FFTConvolutionImageFilter_normalizeOn(this.swigCPtr, this);
    }

    public void normalizeOff() {
        SimpleITKJNI.FFTConvolutionImageFilter_normalizeOff(this.swigCPtr, this);
    }

    public boolean getNormalize() {
        return SimpleITKJNI.FFTConvolutionImageFilter_getNormalize(this.swigCPtr, this);
    }

    public void setBoundaryCondition(BoundaryConditionType boundaryConditionType) {
        SimpleITKJNI.FFTConvolutionImageFilter_setBoundaryCondition(this.swigCPtr, this, boundaryConditionType.swigValue());
    }

    public BoundaryConditionType getBoundaryCondition() {
        return BoundaryConditionType.swigToEnum(SimpleITKJNI.FFTConvolutionImageFilter_getBoundaryCondition(this.swigCPtr, this));
    }

    public void setOutputRegionMode(OutputRegionModeType outputRegionModeType) {
        SimpleITKJNI.FFTConvolutionImageFilter_setOutputRegionMode(this.swigCPtr, this, outputRegionModeType.swigValue());
    }

    public OutputRegionModeType getOutputRegionMode() {
        return OutputRegionModeType.swigToEnum(SimpleITKJNI.FFTConvolutionImageFilter_getOutputRegionMode(this.swigCPtr, this));
    }

    @Override
    public String getName() {
        return SimpleITKJNI.FFTConvolutionImageFilter_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.FFTConvolutionImageFilter_toString(this.swigCPtr, this);
    }

    public Image execute(Image image, Image image2) {
        return new Image(SimpleITKJNI.FFTConvolutionImageFilter_execute(this.swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(image2), image2), true);
    }

    public static final class BoundaryConditionType {
        public static final BoundaryConditionType ZERO_PAD = new BoundaryConditionType("ZERO_PAD");
        public static final BoundaryConditionType ZERO_FLUX_NEUMANN_PAD = new BoundaryConditionType("ZERO_FLUX_NEUMANN_PAD");
        public static final BoundaryConditionType PERIODIC_PAD = new BoundaryConditionType("PERIODIC_PAD");
        private static BoundaryConditionType[] swigValues = new BoundaryConditionType[]{ZERO_PAD, ZERO_FLUX_NEUMANN_PAD, PERIODIC_PAD};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static BoundaryConditionType swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && BoundaryConditionType.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (BoundaryConditionType.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(BoundaryConditionType.class) + " with value " + n);
        }

        private BoundaryConditionType(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private BoundaryConditionType(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private BoundaryConditionType(String string, BoundaryConditionType boundaryConditionType) {
            this.swigName = string;
            this.swigValue = boundaryConditionType.swigValue;
            swigNext = this.swigValue + 1;
        }
    }

    public static final class OutputRegionModeType {
        public static final OutputRegionModeType SAME = new OutputRegionModeType("SAME");
        public static final OutputRegionModeType VALID = new OutputRegionModeType("VALID");
        private static OutputRegionModeType[] swigValues = new OutputRegionModeType[]{SAME, VALID};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static OutputRegionModeType swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && OutputRegionModeType.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (OutputRegionModeType.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(OutputRegionModeType.class) + " with value " + n);
        }

        private OutputRegionModeType(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private OutputRegionModeType(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private OutputRegionModeType(String string, OutputRegionModeType outputRegionModeType) {
            this.swigName = string;
            this.swigValue = outputRegionModeType.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

