/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.util.Locale;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.plugins.PluginAwareInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.Build.class, Scope.Settings.class, Scope.Project.class})
public abstract class ConfigurationTargetIdentifier {
    private ConfigurationTargetIdentifier() {
    }

    public abstract Type getTargetType();

    public abstract @Nullable String getTargetPath();

    public abstract String getBuildPath();

    public static @Nullable ConfigurationTargetIdentifier of(Object any) {
        if (any instanceof PluginAwareInternal) {
            return ((PluginAwareInternal)any).getConfigurationTargetIdentifier();
        }
        return null;
    }

    public static ConfigurationTargetIdentifier of(final ProjectInternal project) {
        return new ConfigurationTargetIdentifier(){

            @Override
            public Type getTargetType() {
                return Type.PROJECT;
            }

            @Override
            public @Nullable String getTargetPath() {
                return project.getProjectPath().asString();
            }

            @Override
            public String getBuildPath() {
                return project.getGradle().getIdentityPath().asString();
            }
        };
    }

    public static ConfigurationTargetIdentifier of(final SettingsInternal settings) {
        return new ConfigurationTargetIdentifier(){

            @Override
            public Type getTargetType() {
                return Type.SETTINGS;
            }

            @Override
            public @Nullable String getTargetPath() {
                return null;
            }

            @Override
            public String getBuildPath() {
                return settings.getGradle().getIdentityPath().asString();
            }
        };
    }

    public static ConfigurationTargetIdentifier of(final GradleInternal gradle) {
        return new ConfigurationTargetIdentifier(){

            @Override
            public Type getTargetType() {
                return Type.GRADLE;
            }

            @Override
            public @Nullable String getTargetPath() {
                return null;
            }

            @Override
            public String getBuildPath() {
                return gradle.getIdentityPath().asString();
            }
        };
    }

    public static enum Type {
        GRADLE,
        SETTINGS,
        PROJECT;

        public final String label = this.name().toLowerCase(Locale.ROOT);
    }
}

