/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation.managed;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.instantiation.managed.ManagedObjectCreator;
import org.gradle.internal.instantiation.managed.ManagedObjectProvider;
import org.gradle.internal.instantiation.managed.ManagedObjectRegistry;
import org.gradle.internal.service.AnnotatedServiceLifecycleHandler;
import org.jspecify.annotations.Nullable;

public class DefaultManagedObjectRegistry
implements ManagedObjectRegistry {
    private final @Nullable ManagedObjectRegistry parent;
    private final ReflectionCache reflectionCache;
    private final ConcurrentMap<Class<?>, MethodHandle> factoryByPublicType = new ConcurrentHashMap();

    public DefaultManagedObjectRegistry() {
        this(null, new ReflectionCache());
    }

    private DefaultManagedObjectRegistry(@Nullable ManagedObjectRegistry parent, ReflectionCache reflectionCache) {
        this.parent = parent;
        this.reflectionCache = reflectionCache;
    }

    @Override
    public ManagedObjectRegistry createChild() {
        return new DefaultManagedObjectRegistry(this, this.reflectionCache);
    }

    public List<Class<? extends Annotation>> getAnnotations() {
        return Collections.singletonList(ManagedObjectProvider.class);
    }

    public @Nullable Class<? extends Annotation> getImplicitAnnotation() {
        return null;
    }

    public void whenRegistered(Class<? extends Annotation> annotation, AnnotatedServiceLifecycleHandler.Registration registration) {
        assert (annotation == ManagedObjectProvider.class);
        Object instance = registration.getInstance();
        for (Class declaredType : registration.getDeclaredTypes()) {
            if (!declaredType.isAnnotationPresent(ManagedObjectProvider.class)) continue;
            boolean registeredCreator = false;
            for (Method declaredMethod : declaredType.getMethods()) {
                Class<?> publicType = DefaultManagedObjectRegistry.findCreatorAnnotation(declaredMethod);
                if (publicType == null) continue;
                MethodHandle handle = this.getHandleForInstance(declaredMethod, instance);
                this.registerFactory(publicType, handle);
                registeredCreator = true;
            }
            if (registeredCreator) continue;
            throw new IllegalArgumentException("Service " + declaredType + " annotated with @ManagedObjectProvider must have at least one method annotated with @ManagedObjectCreator.");
        }
    }

    private static @Nullable Class<?> findCreatorAnnotation(Method declaredMethod) {
        ManagedObjectCreator creatorAnnotation = declaredMethod.getAnnotation(ManagedObjectCreator.class);
        if (creatorAnnotation == null) {
            return null;
        }
        if (creatorAnnotation.publicType() != Void.TYPE) {
            return creatorAnnotation.publicType();
        }
        return declaredMethod.getReturnType();
    }

    private MethodHandle getHandleForInstance(Method declaredMethod, Object instance) {
        Method instanceMethod = this.reflectionCache.getMethod(instance.getClass(), declaredMethod.getName(), declaredMethod.getParameterTypes());
        if (Modifier.isStatic(instanceMethod.getModifiers())) {
            throw new IllegalArgumentException("Method " + instanceMethod + " annotated with @ManagedObjectCreator must not be static.");
        }
        Class<?> returnType = declaredMethod.getReturnType();
        if (returnType == Void.TYPE) {
            throw new IllegalArgumentException("Method " + declaredMethod + " annotated with @ManagedObjectCreator must return a value.");
        }
        MethodHandle handle = this.reflectionCache.unreflect(instanceMethod).bindTo(instance);
        DefaultManagedObjectRegistry.validateFactoryMethod(instanceMethod, handle);
        return handle;
    }

    private static void validateFactoryMethod(Method method, MethodHandle handle) {
        MethodType type = handle.type();
        if (type.parameterCount() > 2) {
            throw new IllegalArgumentException("Method " + method + " annotated with @ManagedObjectCreator has too many parameters.");
        }
        for (Class<?> parameterType : type.parameterArray()) {
            if (parameterType == Class.class) continue;
            throw new IllegalArgumentException("Method " + method + " annotated with @ManagedObjectCreator must have parameters of type Class, but has parameter of type " + parameterType + ".");
        }
    }

    private void registerFactory(Class<?> publicType, MethodHandle handle) {
        MethodHandle existing = this.factoryByPublicType.put(publicType, handle);
        if (existing != null) {
            List sortedMethods = Stream.of(existing, handle).map(MethodHandle::toString).sorted().collect(Collectors.toList());
            throw new IllegalArgumentException("Method " + (String)sortedMethods.get(0) + " for type " + publicType + "conflicts with existing factory method " + (String)sortedMethods.get(1) + ".");
        }
    }

    @Override
    public <T> @Nullable T newInstance(Class<T> type) {
        MethodHandle factory = (MethodHandle)this.factoryByPublicType.get(type);
        if (factory != null) {
            try {
                Object result = factory.invokeExact();
                return type.cast(result);
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not create managed object.", e);
            }
        }
        if (this.parent != null) {
            return this.parent.newInstance(type);
        }
        return null;
    }

    @Override
    public <T> @Nullable T newInstance(Class<T> type, Class<?> arg1) {
        MethodHandle factory = (MethodHandle)this.factoryByPublicType.get(type);
        if (factory != null) {
            try {
                Object result = factory.invokeExact(arg1);
                return type.cast(result);
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not create managed object.", e);
            }
        }
        if (this.parent != null) {
            return this.parent.newInstance(type, arg1);
        }
        return null;
    }

    @Override
    public <T> @Nullable T newInstance(Class<T> type, Class<?> arg1, Class<?> arg2) {
        MethodHandle factory = (MethodHandle)this.factoryByPublicType.get(type);
        if (factory != null) {
            try {
                Object result = factory.invokeExact(arg1, arg2);
                return type.cast(result);
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not create managed object.", e);
            }
        }
        if (this.parent != null) {
            return this.parent.newInstance(type, arg1, arg2);
        }
        return null;
    }

    private static class ReflectionCache {
        private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
        private final ConcurrentMap<Method, MethodHandle> unreflectionCache = new ConcurrentHashMap<Method, MethodHandle>();
        private final ConcurrentMap<GetMethodKey, Method> findMethodCache = new ConcurrentHashMap<GetMethodKey, Method>();

        private ReflectionCache() {
        }

        public MethodHandle unreflect(Method method) {
            MethodHandle cached = (MethodHandle)this.unreflectionCache.get(method);
            if (cached != null) {
                return cached;
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new IllegalArgumentException("Method " + method + " is not public.");
            }
            if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                throw new IllegalArgumentException("Declaring class '" + method.getDeclaringClass().getName() + "' of method " + method + " is not public.");
            }
            return this.unreflectionCache.computeIfAbsent(method, m -> {
                try {
                    MethodHandle handle = LOOKUP.unreflect((Method)m);
                    return handle.asType(MethodType.methodType(Object.class, handle.type().parameterArray()));
                }
                catch (IllegalAccessException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            });
        }

        public Method getMethod(Class<?> targetClass, String methodName, Class<?>[] parameterTypes) {
            GetMethodKey key = new GetMethodKey(targetClass, methodName, parameterTypes);
            Method method = (Method)this.findMethodCache.get(key);
            if (method != null) {
                return method;
            }
            return this.findMethodCache.computeIfAbsent(key, k -> {
                try {
                    return targetClass.getMethod(((GetMethodKey)k).methodName, ((GetMethodKey)k).parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            });
        }

        private static final class GetMethodKey {
            private final Class<?> targetClass;
            private final String methodName;
            private final Class<?>[] parameterTypes;
            private final int hashCode;

            public GetMethodKey(Class<?> targetClass, String methodName, Class<?>[] parameterTypes) {
                this.targetClass = targetClass;
                this.methodName = methodName;
                this.parameterTypes = parameterTypes;
                this.hashCode = GetMethodKey.computeHashCode(targetClass, methodName, parameterTypes);
            }

            public boolean equals(Object o) {
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                GetMethodKey that = (GetMethodKey)o;
                return this.targetClass.equals(that.targetClass) && this.methodName.equals(that.methodName) && Arrays.equals(this.parameterTypes, that.parameterTypes);
            }

            public int hashCode() {
                return this.hashCode;
            }

            private static int computeHashCode(Class<?> declaringClass, String methodName, Class<?>[] parameterTypes) {
                int result = declaringClass.hashCode();
                result = 31 * result + methodName.hashCode();
                result = 31 * result + Arrays.hashCode(parameterTypes);
                return result;
            }
        }
    }
}

