/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.problems;

import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.cc.impl.problems.HtmlReportTemplate;
import org.gradle.internal.cc.impl.problems.JsonModelWriter;
import org.gradle.internal.cc.impl.problems.JsonSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\rH\u0002J\b\u0010\u0012\u001a\u00020\rH\u0002J\u0006\u0010\u0013\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/gradle/internal/cc/impl/problems/HtmlReportWriter;", "", "writer", "Ljava/io/Writer;", "htmlTemplate", "Lorg/gradle/internal/cc/impl/problems/HtmlReportTemplate;", "jsonModelWriter", "Lorg/gradle/internal/cc/impl/problems/JsonModelWriter;", "<init>", "(Ljava/io/Writer;Lorg/gradle/internal/cc/impl/problems/HtmlReportTemplate;Lorg/gradle/internal/cc/impl/problems/JsonModelWriter;)V", "getJsonModelWriter", "()Lorg/gradle/internal/cc/impl/problems/JsonModelWriter;", "beginHtmlReport", "", "endHtmlReport", "details", "Lorg/gradle/internal/cc/impl/problems/JsonSource;", "beginReportData", "endReportData", "close", "configuration-problems-base"})
public final class HtmlReportWriter {
    @NotNull
    private final Writer writer;
    @NotNull
    private final HtmlReportTemplate htmlTemplate;
    @NotNull
    private final JsonModelWriter jsonModelWriter;

    public HtmlReportWriter(@NotNull Writer writer, @NotNull HtmlReportTemplate htmlTemplate, @NotNull JsonModelWriter jsonModelWriter) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)htmlTemplate, (String)"htmlTemplate");
        Intrinsics.checkNotNullParameter((Object)jsonModelWriter, (String)"jsonModelWriter");
        this.writer = writer;
        this.htmlTemplate = htmlTemplate;
        this.jsonModelWriter = jsonModelWriter;
    }

    @NotNull
    public final JsonModelWriter getJsonModelWriter() {
        return this.jsonModelWriter;
    }

    public final void beginHtmlReport() {
        this.writer.append(this.htmlTemplate.getHeader());
        this.beginReportData();
        this.jsonModelWriter.beginModel();
    }

    public final void endHtmlReport(@NotNull JsonSource details) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.jsonModelWriter.endModel(details);
        this.endReportData();
        this.writer.append(this.htmlTemplate.getFooter());
    }

    private final void beginReportData() {
        Writer $this$beginReportData_u24lambda_u240 = this.writer;
        boolean bl = false;
        ((Appendable)$this$beginReportData_u24lambda_u240).append("<script type=\"text/javascript\">").append('\n');
        ((Appendable)$this$beginReportData_u24lambda_u240).append("function configurationCacheProblems() { return (").append('\n');
        ((Appendable)$this$beginReportData_u24lambda_u240).append("// begin-report-data").append('\n');
    }

    private final void endReportData() {
        Writer $this$endReportData_u24lambda_u240 = this.writer;
        boolean bl = false;
        ((Appendable)$this$endReportData_u24lambda_u240).append('\n');
        ((Appendable)$this$endReportData_u24lambda_u240).append("// end-report-data").append('\n');
        ((Appendable)$this$endReportData_u24lambda_u240).append(");}").append('\n');
        ((Appendable)$this$endReportData_u24lambda_u240).append("</script>").append('\n');
    }

    public final void close() {
        this.writer.close();
    }
}

