/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save.xml;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FieldGpx;
import tim.prune.data.FieldXml;
import tim.prune.data.FileInfo;
import tim.prune.data.FileType;
import tim.prune.data.MediaObject;
import tim.prune.gui.ProgressDialog;
import tim.prune.save.SettingsForExport;
import tim.prune.save.xml.ExtensionTree;
import tim.prune.save.xml.GpxVersion;
import tim.prune.save.xml.GpxWriter;
import tim.prune.save.xml.HeaderCombiner;

public class GpxWriter11
extends GpxWriter {
    public GpxWriter11(ProgressDialog progressDialog, SettingsForExport settingsForExport) {
        super(progressDialog, settingsForExport);
    }

    @Override
    protected String getDefaultGpxHeader() {
        return "<gpx version=\"1.1\" creator=\"GpsPrune v26.1 activityworkshop.net\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns=\"http://www.topografix.com/GPX/1/1\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd\">";
    }

    private String getDefaultSchemaLocation() {
        return "http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd";
    }

    @Override
    protected String getGpxHeader(FileInfo fileInfo) {
        HeaderCombiner headerCombiner = new HeaderCombiner(GpxVersion.GPX_1_1);
        int n = 0;
        while (n < fileInfo.getNumFiles()) {
            headerCombiner.addSourceInfo(fileInfo.getSource(n));
            ++n;
        }
        return "<gpx version=\"1.1\" creator=\"GpsPrune v26.1 activityworkshop.net\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns=\"http://www.topografix.com/GPX/1/1\"\n xsi:schemaLocation=\"" + headerCombiner.getAllLocations(this.getDefaultSchemaLocation()) + "\"\n" + headerCombiner.getNamespaces() + ">";
    }

    @Override
    protected void writeMetadata(OutputStreamWriter outputStreamWriter, String string, String string2) throws IOException {
        outputStreamWriter.write("\t<metadata>\n");
        GpxWriter11.writeNameAndDescription(outputStreamWriter, string, string2, "\t\t");
        outputStreamWriter.write("\t</metadata>\n");
    }

    @Override
    protected boolean versionSupportsPointLinks() {
        return true;
    }

    @Override
    protected boolean versionSupportsTag(FieldGpx fieldGpx) {
        return !fieldGpx.getName().equals("speed") && !fieldGpx.getName().equals("course");
    }

    @Override
    protected String makeMediaLink(MediaObject mediaObject) {
        if (mediaObject.getFile() != null) {
            return "<link href=\"" + mediaObject.getFile().getAbsolutePath() + "\"><text>" + mediaObject.getName() + "</text></link>";
        }
        if (mediaObject.getUrl() != null) {
            return "<link href=\"" + mediaObject.getUrl() + "\"><text>" + mediaObject.getName() + "</text></link>";
        }
        return "";
    }

    @Override
    protected void exportWaypointExtensions(DataPoint dataPoint, Writer writer) throws IOException {
        List<Field> list = dataPoint.getFieldList().getFields(FileType.GPX);
        if (list == null || list.isEmpty()) {
            return;
        }
        ExtensionTree extensionTree = new ExtensionTree();
        for (Field field : list) {
            String string = dataPoint.getFieldValue(field);
            if (GpxWriter11.isEmpty(string) || !(field instanceof FieldXml)) continue;
            FieldXml fieldXml = (FieldXml)field;
            extensionTree.addTag(fieldXml.getCategories(), fieldXml.getTag(string));
        }
        boolean bl = true;
        boolean bl2 = false;
        for (String string : extensionTree.getAllTags(5)) {
            if (bl) {
                writer.write("\t\t\t\t<extensions>\n");
                bl = false;
                bl2 = true;
            }
            writer.write(string);
            writer.write(10);
        }
        if (bl2) {
            writer.write("\t\t\t\t</extensions>\n");
        }
    }

    @Override
    protected void exportTrackpointExtensions(DataPoint dataPoint, Writer writer) throws IOException {
        this.exportWaypointExtensions(dataPoint, writer);
    }
}

