/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.RangeStats;
import tim.prune.data.Track;

public class Selection {
    private final Track _track;
    private int _currentPoint = -1;
    private int _prevNumPoints = 0;
    private int _startIndex = -1;
    private int _endIndex = -1;
    private int _currentPhotoIndex = -1;
    private int _currentAudioIndex = -1;

    public Selection(Track track) {
        this._track = track;
    }

    public int getCurrentPointIndex() {
        return this._currentPoint;
    }

    public boolean hasRangeSelected() {
        return this._startIndex >= 0 && this._endIndex > this._startIndex;
    }

    private void recalculate() {
        int n = this._track.getNumPoints();
        if (n != this._prevNumPoints) {
            this._prevNumPoints = n;
            this.check();
        }
    }

    public RangeStats getRangeStats(Config config) {
        int n = config.getConfigInt("prune.altitudetolerance") / 100;
        if (this._track.getNumPoints() > 0 && this.hasRangeSelected()) {
            return new RangeStats(this._track, this._startIndex, this._endIndex, n);
        }
        return new RangeStats(n);
    }

    public int getStart() {
        this.recalculate();
        return this._startIndex;
    }

    public int getEnd() {
        this.recalculate();
        return this._endIndex;
    }

    public void clearAll() {
        this._currentPoint = -1;
        this.selectRange(-1, -1);
        this._currentPhotoIndex = -1;
        this._currentAudioIndex = -1;
        this.check();
    }

    public void selectRange(int n, int n2) {
        this._startIndex = n;
        this._endIndex = n2;
        this.check();
    }

    public void selectRangeStart() {
        this.selectRangeStart(this._currentPoint);
    }

    private void selectRangeStart(int n) {
        if (n < 0) {
            this._endIndex = -1;
            this._startIndex = -1;
        } else {
            this._startIndex = n;
            if (this._endIndex <= this._startIndex) {
                this._endIndex = this._track.getNumPoints() - 1;
            }
        }
        UpdateMessageBroker.informSubscribers();
    }

    public void selectRangeEnd() {
        this.selectRangeEnd(this._currentPoint);
    }

    public void selectRangeEnd(int n) {
        if (n < 0) {
            this._endIndex = -1;
            this._startIndex = -1;
        } else {
            this._endIndex = n;
            if (this._startIndex > this._endIndex || this._startIndex < 0) {
                this._startIndex = 0;
            }
        }
        UpdateMessageBroker.informSubscribers();
    }

    public void modifyPointDeleted(int n) {
        if (this.hasRangeSelected() && n <= this._endIndex) {
            --this._endIndex;
            if (n < this._startIndex) {
                --this._startIndex;
            }
        }
        this.check();
    }

    public void modifyPointInserted(int n) {
        if (this.hasRangeSelected() && n <= this._endIndex) {
            ++this._endIndex;
            if (n <= this._startIndex) {
                ++this._startIndex;
            }
            this.check();
        }
    }

    public void selectPointPhotoAudio(int n, int n2, int n3) {
        this._currentPoint = n;
        this._currentPhotoIndex = n2;
        this._currentAudioIndex = n3;
        this.check();
    }

    public int getCurrentPhotoIndex() {
        return this._currentPhotoIndex;
    }

    public int getCurrentAudioIndex() {
        return this._currentAudioIndex;
    }

    private void check() {
        if (this._track != null && this._track.getNumPoints() > 0) {
            int n = this._track.getNumPoints() - 1;
            if (this._currentPoint > n) {
                this._currentPoint = n;
            }
            if (this._endIndex > n) {
                this._endIndex = n;
            }
            if (this._startIndex > n) {
                this._startIndex = n;
            }
        } else {
            this._endIndex = -1;
            this._startIndex = -1;
            this._currentPoint = -1;
        }
        UpdateMessageBroker.informSubscribers(4);
    }
}

