/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.io.File;

public class RecentFile {
    private final boolean _regularLoad;
    private final File _file;

    public RecentFile(File file, boolean bl) {
        this._file = file;
        this._regularLoad = bl;
    }

    public RecentFile(String string) {
        if (string != null && string.length() > 3) {
            this._regularLoad = string.charAt(0) != 'g';
            this._file = new File(string.substring(1));
        } else {
            this._file = null;
            this._regularLoad = true;
        }
    }

    public File getFile() {
        return this._file;
    }

    public boolean isRegularLoad() {
        return this._regularLoad;
    }

    public boolean isValid() {
        return this._file != null && this._file.exists() && this._file.isFile();
    }

    public String getConfigString() {
        if (!this.isValid()) {
            return "";
        }
        return String.valueOf(this._regularLoad ? "r" : "g") + this._file.getAbsolutePath();
    }

    public boolean isSameFile(RecentFile recentFile) {
        return recentFile != null && this.isValid() && recentFile.isValid() && (this._file.equals(recentFile._file) || this._file.getAbsolutePath().equals(recentFile._file.getAbsolutePath()));
    }
}

