/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import tim.prune.config.ColourScheme;
import tim.prune.data.RecentFileList;
import tim.prune.data.UnitSet;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.colour.ColourerFactory;
import tim.prune.gui.colour.PointColourer;

public class Config {
    private File _configFile = null;
    private Properties _configValues = null;
    private final ColourScheme _colourScheme = new ColourScheme();
    private PointColourer _pointColourer = null;
    private RecentFileList _recentFiles = new RecentFileList();
    private UnitSet _unitSet = UnitSetLibrary.getUnitSet(null);
    public static final String KEY_TRACK_DIR = "prune.trackdirectory";
    public static final String KEY_PHOTO_DIR = "prune.photodirectory";
    public static final String KEY_LANGUAGE_CODE = "prune.languagecode";
    public static final String KEY_LANGUAGE_FILE = "prune.languagefile";
    public static final String KEY_GPS_DEVICE = "prune.gpsdevice";
    public static final String KEY_GPS_FORMAT = "prune.gpsformat";
    public static final String KEY_GPSBABEL_FILTER = "prune.gpsbabelfilter";
    public static final String KEY_IMPORT_FILE_FORMAT = "prune.lastimportfileformat";
    public static final String KEY_POVRAY_FONT = "prune.povrayfont";
    public static final String KEY_UNITSET_KEY = "prune.unitsetkey";
    public static final String KEY_COORD_DISPLAY_FORMAT = "prune.coorddisplay";
    public static final String KEY_MAPSOURCE_INDEX = "prune.mapsource";
    public static final String KEY_NUM_FIXED_MAPS = "prune.numfixedmapsources";
    public static final String KEY_MAPSOURCE_LIST = "prune.mapsourcelist";
    public static final String KEY_SHOW_MAP = "prune.showmap";
    public static final String KEY_WINDOW_BOUNDS = "prune.windowbounds";
    public static final String KEY_DISK_CACHE = "prune.diskcache";
    public static final String KEY_ONLINE_MODE = "prune.onlinemode";
    public static final String KEY_KMZ_IMAGE_SIZE = "prune.kmzimagewidth";
    public static final String KEY_GPSBABEL_PATH = "prune.gpsbabelpath";
    public static final String KEY_GNUPLOT_PATH = "prune.gnuplotpath";
    public static final String KEY_EXIFTOOL_PATH = "prune.exiftoolpath";
    public static final String KEY_COLOUR_SCHEME = "prune.colourscheme";
    public static final String KEY_POINT_COLOURER = "prune.pointcolourer";
    public static final String KEY_LINE_WIDTH = "prune.linewidth";
    public static final String KEY_ANTIALIAS = "prune.antialias";
    public static final String KEY_OSSCALING = "prune.osscaling";
    public static final String KEY_KML_TRACK_COLOUR = "prune.kmltrackcolour";
    public static final String KEY_WINDOW_STYLE = "prune.windowstyle";
    public static final String KEY_AUTOSAVE_SETTINGS = "prune.autosavesettings";
    public static final String KEY_RECENT_FILES = "prune.recentfiles";
    public static final String KEY_ESTIMATION_PARAMS = "prune.estimationparams";
    public static final String KEY_HEIGHT_EXAGGERATION = "prune.heightexaggeration";
    public static final String KEY_TERRAIN_GRID_SIZE = "prune.terraingridsize";
    public static final String KEY_ALTITUDE_TOLERANCE = "prune.altitudetolerance";
    public static final String KEY_WAYPOINT_ICONS = "prune.waypointicons";
    public static final String KEY_WAYPOINT_ICON_SIZE = "prune.waypointiconsize";
    public static final String KEY_WAYPOINT_ICON_CUSTOM = "prune.waypointiconusecustom";
    public static final String KEY_WAYPOINT_ICON_PATH = "prune.waypointiconpath";
    public static final String KEY_WPICON_SALT = "prune.waypointsalt";
    public static final String KEY_TIMEZONE_ID = "prune.timezoneid";
    public static final String KEY_LATLON_RANGE = "prune.latlonrange";
    public static final String KEY_EARTHDATA_AUTH = "prune.earthdataauth";
    public static final String KEY_COMPRESSION_SETTINGS = "prune.compression";
    public static final String KEY_COMPRESSION_METHODS = "prune.compressionmethods";
    public static final String KEY_ICONS_DOUBLE_SIZE = "prune.iconsdoublesize";
    public static final String KEY_ASKED_ABOUT_CONFIG_MIGRATION = "prune.configmigrationasked";
    public static final String KEY_SHOW_ZOOMLEVEL = "prune.showzoomlevel";

    public Config() {
        this._configValues = Config.getDefaultProperties();
    }

    public boolean loadFile(File file) {
        Properties properties = Config.getDefaultProperties();
        boolean bl = false;
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                properties.load(fileInputStream);
                bl = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        this._configValues.putAll((Map<?, ?>)properties);
        this._colourScheme.loadFromHex(this._configValues.getProperty(KEY_COLOUR_SCHEME));
        this._pointColourer = ColourerFactory.createColourer(this._configValues.getProperty(KEY_POINT_COLOURER));
        this._recentFiles = new RecentFileList(this._configValues.getProperty(KEY_RECENT_FILES));
        this._unitSet = UnitSetLibrary.getUnitSet(this._configValues.getProperty(KEY_UNITSET_KEY));
        this.setConfigString(KEY_COORD_DISPLAY_FORMAT, "NONE");
        if (bl) {
            this._configFile = file;
        }
        return bl;
    }

    private static Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.put(KEY_GPS_DEVICE, "usb:");
        properties.put(KEY_GPS_FORMAT, "garmin");
        properties.put(KEY_POVRAY_FONT, "crystal.ttf");
        properties.put(KEY_SHOW_MAP, "1");
        properties.put(KEY_EXIFTOOL_PATH, "exiftool");
        properties.put(KEY_GNUPLOT_PATH, "gnuplot");
        properties.put(KEY_GPSBABEL_PATH, "gpsbabel");
        properties.put(KEY_IMPORT_FILE_FORMAT, "-1");
        properties.put(KEY_KMZ_IMAGE_SIZE, "240");
        properties.put(KEY_ANTIALIAS, "1");
        properties.put(KEY_OSSCALING, "0");
        properties.put(KEY_AUTOSAVE_SETTINGS, "1");
        properties.put(KEY_UNITSET_KEY, "unitset.kilometres");
        properties.put(KEY_COORD_DISPLAY_FORMAT, "NONE");
        properties.put(KEY_HEIGHT_EXAGGERATION, "100");
        properties.put(KEY_TERRAIN_GRID_SIZE, "50");
        properties.put(KEY_ALTITUDE_TOLERANCE, "0");
        properties.put(KEY_WAYPOINT_ICON_SIZE, "1");
        properties.put(KEY_WPICON_SALT, "-1");
        properties.put(KEY_ICONS_DOUBLE_SIZE, "0");
        properties.put(KEY_SHOW_ZOOMLEVEL, "0");
        properties.put(KEY_ASKED_ABOUT_CONFIG_MIGRATION, "0");
        return properties;
    }

    private static int parseInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {}
        return n;
    }

    public File getConfigFile() {
        return this._configFile;
    }

    public void setConfigFile(File file) {
        this._configFile = file;
    }

    public Properties getAllConfig() {
        this._configValues.setProperty(KEY_RECENT_FILES, this._recentFiles.getConfigString());
        return this._configValues;
    }

    public ColourScheme getColourScheme() {
        return this._colourScheme;
    }

    public PointColourer getPointColourer() {
        return this._pointColourer;
    }

    public RecentFileList getRecentFileList() {
        return this._recentFiles;
    }

    public void setConfigString(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            this._configValues.remove(string);
        } else {
            this._configValues.put(string, string2);
        }
    }

    public void setConfigBoolean(String string, boolean bl) {
        if (string != null && !string.isEmpty()) {
            this._configValues.put(string, bl ? "1" : "0");
        }
    }

    public void setConfigInt(String string, int n) {
        if (string != null && !string.isEmpty()) {
            this._configValues.put(string, "" + n);
        }
    }

    public String getConfigString(String string) {
        return this._configValues.getProperty(string);
    }

    public boolean getConfigBoolean(String string) {
        String string2 = this._configValues.getProperty(string);
        return string2 == null || string2.equals("1");
    }

    public int getConfigInt(String string) {
        return Config.parseInt(this._configValues.getProperty(string));
    }

    public void updateColourScheme() {
        this.setConfigString(KEY_COLOUR_SCHEME, this._colourScheme.toString());
    }

    public void updatePointColourer(PointColourer pointColourer) {
        this._pointColourer = pointColourer;
        this.setConfigString(KEY_POINT_COLOURER, ColourerFactory.pointColourerToString(this._pointColourer));
    }

    public UnitSet getUnitSet() {
        return this._unitSet;
    }

    public void selectUnitSet(int n) {
        this._unitSet = UnitSetLibrary.getUnitSet(n);
        this.setConfigString(KEY_UNITSET_KEY, this._unitSet.getNameKey());
    }

    private boolean hasString(String string) {
        String string2 = this.getConfigString(string);
        return string2 != null && !string2.isEmpty();
    }

    public boolean hasUnsavedChanges() {
        return this._configFile == null && this.getConfigBoolean(KEY_AUTOSAVE_SETTINGS) && (this.getConfigInt(KEY_MAPSOURCE_INDEX) > 0 || this.hasString(KEY_MAPSOURCE_LIST) || this.hasString(KEY_DISK_CACHE) || this.hasString(KEY_EARTHDATA_AUTH) || this.getConfigInt(KEY_POINT_COLOURER) > 0 || this.getConfigInt(KEY_WAYPOINT_ICONS) > 0);
    }
}

