/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class BaselineShiftManager
extends LengthManager {
    protected static final StringMap<Value> values = new StringMap(4);

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 40;
    }

    @Override
    public String getPropertyName() {
        return "baseline-shift";
    }

    @Override
    public Value getDefaultValue() {
        return SVGValueConstants.BASELINE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case IDENT: {
                return this.createIdentValue(lu.getStringValue(), engine);
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
        }
        return super.createValue(lu, engine);
    }

    protected Value createIdentValue(String value, CSSEngine engine) throws DOMException {
        Value v = values.get(value.toLowerCase(Locale.ROOT).intern());
        if (v == null) {
            throw this.createInvalidIdentifierDOMException(value);
        }
        return v;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value.getUnitType() == 2) {
            sm.putLineHeightRelative(idx, true);
            int lhi = engine.getLineHeightIndex();
            CSSStylableElement parent = (CSSStylableElement)elt.getParentNode();
            if (parent == null) {
                parent = elt;
            }
            Value lh = engine.getComputedStyle(parent, null, lhi);
            float flh = this.lineHeightValue(parent, null, engine, lh);
            float v = value.getFloatValue();
            return new FloatValue(3, flh * v / 100.0f);
        }
        return super.computeValue(elt, pseudo, engine, idx, sm, value);
    }

    @Override
    protected int getOrientation() {
        return 2;
    }

    static {
        values.put("baseline", SVGValueConstants.BASELINE_VALUE);
        values.put("sub", SVGValueConstants.SUB_VALUE);
        values.put("super", SVGValueConstants.SUPER_VALUE);
    }
}

