/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import jogamp.graph.font.typecast.ot.table.NameRecord;
import jogamp.graph.font.typecast.ot.table.Table;

public class NameTable
implements Table {
    private final short _formatSelector;
    private final short _numberOfNameRecords;
    private final short _stringStorageOffset;
    private final NameRecord[] _records;

    public NameTable(DataInput dataInput, int n) throws IOException {
        this._formatSelector = dataInput.readShort();
        this._numberOfNameRecords = dataInput.readShort();
        this._stringStorageOffset = dataInput.readShort();
        this._records = new NameRecord[this._numberOfNameRecords];
        for (int i = 0; i < this._numberOfNameRecords; ++i) {
            this._records[i] = new NameRecord(dataInput);
        }
        byte[] byArray = new byte[n - this._stringStorageOffset];
        dataInput.readFully(byArray);
        for (int i = 0; i < this._numberOfNameRecords; ++i) {
            this._records[i].loadString(new DataInputStream(new ByteArrayInputStream(byArray)));
        }
    }

    @Override
    public int getType() {
        return 1851878757;
    }

    public short getFormat() {
        return this._formatSelector;
    }

    public short getNumberOfNameRecords() {
        return this._numberOfNameRecords;
    }

    public short getStringStorageOffset() {
        return this._stringStorageOffset;
    }

    public NameRecord getRecord(int n) {
        if (this._numberOfNameRecords > n) {
            return this._records[n];
        }
        return null;
    }

    public String getRecordsRecordString(int n) {
        if (this._numberOfNameRecords > n) {
            return this._records[n].getRecordString();
        }
        return "";
    }

    public String getRecordString(short s) {
        for (int i = 0; i < this._numberOfNameRecords; ++i) {
            if (this._records[i].getNameId() != s) continue;
            return this._records[i].getRecordString();
        }
        return "";
    }

    public String toString() {
        return "'name' Table - Naming Table\n--------------------------------\n        'name' format:       " + this._formatSelector + "\n        count:               " + this._numberOfNameRecords + "\n        stringOffset:        " + this._stringStorageOffset + "\n        records:" + Arrays.asList(this._records).stream().map(nameRecord -> "\n" + nameRecord.toString()).collect(Collectors.joining("\n"));
    }
}

