/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database.load;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;

public class TreeNodeLazyExpander
extends TreeNodeSpecial {
    private static Image IMG_MORE = DBeaverIcons.getImage((DBPImage)UIIcon.REFRESH);
    private DBNNode[] allChildren;
    private int visibleChildren;

    public TreeNodeLazyExpander(DBNNode parent, DBNNode[] allChildren, int visibleChildren) {
        super(parent);
        this.allChildren = allChildren;
        this.visibleChildren = visibleChildren;
    }

    public int getVisibleChildren() {
        return this.visibleChildren;
    }

    public String getText(Object element) {
        return "More ... (" + this.visibleChildren + "/" + this.allChildren.length + ")";
    }

    public Image getImage(Object element) {
        return IMG_MORE;
    }

    @Override
    public boolean handleDefaultAction(@NotNull DatabaseNavigatorTree tree) {
        int longListFetchSize = Math.max(100, DBWorkbench.getPlatform().getPreferenceStore().getInt("navigator.long.list.fetch.size"));
        boolean lastSegment = this.visibleChildren + longListFetchSize > this.allChildren.length;
        int nextSegmentSize = lastSegment ? this.allChildren.length - this.visibleChildren : longListFetchSize;
        Object[] nodes = new Object[lastSegment ? nextSegmentSize : nextSegmentSize + 1];
        System.arraycopy(this.allChildren, this.visibleChildren, nodes, 0, nextSegmentSize);
        if (!lastSegment) {
            nodes[nextSegmentSize] = new TreeNodeLazyExpander(this.getParent(), this.allChildren, this.visibleChildren + nextSegmentSize);
        }
        Tree treeControl = tree.getViewer().getTree();
        treeControl.setRedraw(false);
        try {
            tree.getViewer().remove((Object)this);
            tree.getViewer().add((Object)this.getParent(), nodes);
        }
        finally {
            treeControl.setRedraw(true);
        }
        return true;
    }
}

