/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.contentassist;

import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class StyledTextContentAdapter
implements IControlContentAdapter,
IControlContentAdapter2 {
    public String getControlContents(Control control) {
        return ((StyledText)control).getText();
    }

    public void setControlContents(Control control, String text, int cursorPosition) {
        ((StyledText)control).setText(text);
        ((StyledText)control).setSelection(cursorPosition, cursorPosition);
    }

    public void insertControlContents(Control control, String text, int cursorPosition) {
        StyledText styledText = (StyledText)control;
        Point selection = styledText.getSelection();
        styledText.insert(text);
        if (cursorPosition <= text.length()) {
            styledText.setSelection(selection.x + cursorPosition, selection.x + cursorPosition);
        }
    }

    public int getCursorPosition(Control control) {
        return ((StyledText)control).getCaretOffset();
    }

    public Rectangle getInsertionBounds(Control control) {
        StyledText styledText = (StyledText)control;
        Point caretOrigin = styledText.getLocationAtOffset(styledText.getCaretOffset());
        return new Rectangle(caretOrigin.x + styledText.getClientArea().x, caretOrigin.y + styledText.getClientArea().y + 3, 1, styledText.getLineHeight());
    }

    public void setCursorPosition(Control control, int position) {
        ((StyledText)control).setSelection(new Point(position, position));
    }

    public Point getSelection(Control control) {
        return ((StyledText)control).getSelection();
    }

    public void setSelection(Control control, Point range) {
        ((StyledText)control).setSelection(range);
    }
}

