/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.binary;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ui.editors.binary.internal.BinaryEditorMessages;

public class HexStatusLine
extends Composite {
    private static final String TEXT_INSERT = BinaryEditorMessages.editor_binary_hex_status_line_text_insert;
    private static final String TEXT_OVERWRITE = BinaryEditorMessages.editor_binary_hex_status_line_text_ovewrite;
    private Label position = null;
    private Label value = null;
    private Label insertMode = null;

    public HexStatusLine(Composite parent, int style, boolean withLeftSeparator) {
        super(parent, style);
        this.initialize(withLeftSeparator);
    }

    private void initialize(boolean withSeparator) {
        GridLayout statusLayout = new GridLayout();
        statusLayout.numColumns = withSeparator ? 6 : 5;
        statusLayout.marginHeight = 0;
        this.setLayout((Layout)statusLayout);
        if (withSeparator) {
            GridData separator1GridData = new GridData();
            separator1GridData.grabExcessVerticalSpace = true;
            separator1GridData.verticalAlignment = 4;
            Label separator1 = new Label((Composite)this, 2);
            separator1.setLayoutData((Object)separator1GridData);
        }
        GC gc = new GC((Drawable)this);
        FontMetrics fontMetrics = gc.getFontMetrics();
        this.position = new Label((Composite)this, 32);
        GridData gridData1 = new GridData(58 * fontMetrics.getAverageCharWidth(), -1);
        this.position.setLayoutData((Object)gridData1);
        GridData separator23GridData = new GridData();
        separator23GridData.grabExcessVerticalSpace = true;
        separator23GridData.verticalAlignment = 4;
        Label separator2 = new Label((Composite)this, 2);
        separator2.setLayoutData((Object)separator23GridData);
        this.value = new Label((Composite)this, 32);
        GridData gridData2 = new GridData(44 * fontMetrics.getAverageCharWidth(), -1);
        this.value.setLayoutData((Object)gridData2);
        GridData separator3GridData = new GridData();
        separator3GridData.grabExcessVerticalSpace = true;
        separator3GridData.verticalAlignment = 4;
        Label separator3 = new Label((Composite)this, 2);
        separator3.setLayoutData((Object)separator3GridData);
        this.insertMode = new Label((Composite)this, 32);
        GridData gridData3 = new GridData((TEXT_OVERWRITE.length() + 2) * fontMetrics.getAverageCharWidth(), -1);
        this.insertMode.setLayoutData((Object)gridData3);
        gc.dispose();
    }

    public void updateInsertModeText(boolean insert) {
        if (this.isDisposed() || this.insertMode.isDisposed()) {
            return;
        }
        this.insertMode.setText(insert ? TEXT_INSERT : TEXT_OVERWRITE);
    }

    public void updatePositionValueText(long pos, byte val) {
        this.updatePositionText(pos);
        this.updateValueText(val);
    }

    public void updateSelectionValueText(long[] sel, byte val) {
        this.updateSelectionText(sel);
        this.updateValueText(val);
    }

    public void updatePositionText(long pos) {
        if (this.isDisposed() || this.position.isDisposed()) {
            return;
        }
        String posText = BinaryEditorMessages.editor_binary_hex_status_line_offset + pos + " (dec) = " + Long.toHexString(pos) + " (binary)";
        this.position.setText(posText);
    }

    public void updateValueText(byte val) {
        if (this.isDisposed() || this.position.isDisposed()) {
            return;
        }
        String valBinText = "0000000" + Long.toBinaryString(val);
        String valText = BinaryEditorMessages.editor_binary_hex_status_line_value + val + " (dec) = " + Integer.toHexString(0xFF & val) + " (binary) = " + valBinText.substring(valBinText.length() - 8) + " (bin)";
        this.value.setText(valText);
    }

    public void updateSelectionText(long[] sel) {
        if (this.isDisposed() || this.position.isDisposed()) {
            return;
        }
        String selText = BinaryEditorMessages.editor_binary_hex_status_line_selection + sel[0] + " (0x" + Long.toHexString(sel[0]) + ") - " + sel[1] + " (0x" + Long.toHexString(sel[1]) + ")";
        this.position.setText(selText);
    }
}

