/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.NavigatorResources;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ProgramInfo;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.NodeEditorInput;
import org.jkiss.dbeaver.ui.editors.entity.FolderEditor;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractResourceHandler
implements DBPResourceHandler {
    public int getFeatures(IResource resource) {
        if (resource instanceof IFolder) {
            if (resource.getParent() instanceof IFolder) {
                return 30;
            }
            return 20;
        }
        return 0;
    }

    @NotNull
    public DBNResource makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) throws CoreException, DBException {
        return new DBNResource(parentNode, resource, (DBPResourceHandler)this);
    }

    public void openResource(@NotNull IResource resource) throws CoreException, DBException {
        DBNResource node;
        if (resource instanceof IFolder && (node = NavigatorResources.getNodeByResource((DBNModel)DBWorkbench.getPlatform().getNavigatorModel(), (IResource)resource)) != null) {
            NodeEditorInput nodeInput = new NodeEditorInput((DBNNode)node);
            UIUtils.getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)nodeInput, FolderEditor.class.getName());
        }
    }

    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        return "resource";
    }

    @Nullable
    public String getResourceDescription(@NotNull IResource resource) {
        return resource.getName();
    }

    @Nullable
    public List<DBPDataSourceContainer> getAssociatedDataSources(DBNResource resource) {
        return null;
    }

    @NotNull
    public String getResourceNodeName(@NotNull IResource resource) {
        return resource.getName();
    }

    public DBPImage getResourceIcon(@NotNull IResource resource) {
        ProgramInfo program;
        if (resource instanceof IContainer) {
            return null;
        }
        String fileExtension = resource.getFileExtension();
        if (!CommonUtils.isEmpty((String)fileExtension) && (program = ProgramInfo.getProgram((String)fileExtension)) != null && program.getImage() != null) {
            return program.getImage();
        }
        return null;
    }
}

