/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;

public class UnsupportedStatement
implements Statement {
    private List<String> declarations;

    public UnsupportedStatement(List<String> declarations) {
        this.declarations = Objects.requireNonNull(declarations, "The List of Tokens must not be null.");
    }

    public UnsupportedStatement(String upfront, List<String> declarations) {
        this.declarations = new ArrayList<String>();
        this.declarations.add(upfront);
        this.declarations.addAll((Collection<String>)Objects.requireNonNull(declarations, "The List of Tokens must not be null."));
    }

    @Override
    public <T, S> T accept(StatementVisitor<T> statementVisitor, S context) {
        return statementVisitor.visit(this, context);
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int i = 0;
        for (String s : this.declarations) {
            if (i > 0) {
                builder.append(" ");
            }
            builder.append(s);
            ++i;
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public boolean isEmpty() {
        return this.declarations.isEmpty();
    }
}

