/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class ParallelAllClassVisitor
implements ClassPoolVisitor {
    private static final int THREAD_COUNT;
    private final ClassVisitorFactory classVisitorFactory;

    public ParallelAllClassVisitor(ClassVisitorFactory classVisitorFactory) {
        this.classVisitorFactory = classVisitorFactory;
    }

    @Override
    public void visitClassPool(ClassPool classPool) {
        if (THREAD_COUNT <= 1) {
            classPool.classesAccept(this.classVisitorFactory.createClassVisitor());
        } else {
            ExecutorService executor = Executors.newFixedThreadPool(THREAD_COUNT, new MyThreadFactory());
            MyThreadedClassVisitor classVisitor = new MyThreadedClassVisitor(executor);
            classPool.classesAccept(classVisitor);
            try {
                executor.shutdown();
                classVisitor.awaitTermination();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Parallel execution is taking too long", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    static {
        Integer threads = null;
        try {
            String threadCountString = System.getProperty("parallel.threads");
            if (threadCountString != null) {
                threads = Integer.parseInt(threadCountString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        threads = threads == null ? Runtime.getRuntime().availableProcessors() - 1 : Math.min(threads, Runtime.getRuntime().availableProcessors());
        THREAD_COUNT = threads;
    }

    private static class MyThreadedClassVisitor
    implements ClassVisitor {
        private final ExecutorService executorService;
        private final List<Future> futures = new ArrayList<Future>();

        public MyThreadedClassVisitor(ExecutorService executorService) {
            this.executorService = executorService;
        }

        public void awaitTermination() throws ExecutionException, InterruptedException {
            for (Future future : this.futures) {
                future.get();
            }
        }

        @Override
        public void visitLibraryClass(LibraryClass libraryClass) {
            this.submitClassToExecutorService(libraryClass);
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            this.submitClassToExecutorService(programClass);
        }

        private void submitClassToExecutorService(final Clazz clazz) {
            this.futures.add(this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    MyClassVisitorThread thread = (MyClassVisitorThread)Thread.currentThread();
                    clazz.accept(thread.classVisitor);
                }
            }));
        }
    }

    private class MyClassVisitorThread
    extends Thread {
        private final ClassVisitor classVisitor;

        public MyClassVisitorThread(int counter, Runnable runnable) {
            super(runnable, "Parallel Class Visitor " + counter);
            this.classVisitor = ParallelAllClassVisitor.this.classVisitorFactory.createClassVisitor();
        }
    }

    private class MyThreadFactory
    implements ThreadFactory {
        private int threadCounter = 0;

        private MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new MyClassVisitorThread(++this.threadCounter, runnable);
        }
    }

    public static interface ClassVisitorFactory {
        public ClassVisitor createClassVisitor();
    }
}

