# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class AccessReviewContactedReviewer(_serialization.Model):
    """Access Review Contacted Reviewer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The access review reviewer id.
    :vartype id: str
    :ivar name: The access review reviewer id.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar user_display_name: The display name of the reviewer.
    :vartype user_display_name: str
    :ivar user_principal_name: The user principal name of the reviewer.
    :vartype user_principal_name: str
    :ivar created_date_time: Date Time when the reviewer was contacted.
    :vartype created_date_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "user_display_name": {"readonly": True},
        "user_principal_name": {"readonly": True},
        "created_date_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_display_name": {"key": "properties.userDisplayName", "type": "str"},
        "user_principal_name": {"key": "properties.userPrincipalName", "type": "str"},
        "created_date_time": {"key": "properties.createdDateTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.user_display_name: Optional[str] = None
        self.user_principal_name: Optional[str] = None
        self.created_date_time: Optional[datetime.datetime] = None


class AccessReviewContactedReviewerListResult(_serialization.Model):
    """List of access review contacted reviewers.

    :ivar value: Access Review Contacted Reviewer.
    :vartype value: list[~azure.mgmt.authorization.models.AccessReviewContactedReviewer]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AccessReviewContactedReviewer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AccessReviewContactedReviewer"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Access Review Contacted Reviewer.
        :paramtype value: list[~azure.mgmt.authorization.models.AccessReviewContactedReviewer]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AccessReviewDecision(_serialization.Model):
    """Access Review.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The access review decision id.
    :vartype id: str
    :ivar name: The access review decision name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar recommendation: The feature- generated recommendation shown to the reviewer. Known values
     are: "Approve", "Deny", and "NoInfoAvailable".
    :vartype recommendation: str or ~azure.mgmt.authorization.models.AccessRecommendationType
    :ivar decision: The decision on the approval step. This value is initially set to NotReviewed.
     Approvers can take action of Approve/Deny. Known values are: "Approve", "Deny", "NotReviewed",
     "DontKnow", and "NotNotified".
    :vartype decision: str or ~azure.mgmt.authorization.models.AccessReviewResult
    :ivar justification: Justification provided by approvers for their action.
    :vartype justification: str
    :ivar reviewed_date_time: Date Time when a decision was taken.
    :vartype reviewed_date_time: ~datetime.datetime
    :ivar apply_result: The outcome of applying the decision. Known values are: "New", "Applying",
     "AppliedSuccessfully", "AppliedWithUnknownFailure", "AppliedSuccessfullyButObjectNotFound", and
     "ApplyNotSupported".
    :vartype apply_result: str or ~azure.mgmt.authorization.models.AccessReviewApplyResult
    :ivar applied_date_time: The date and time when the review decision was applied.
    :vartype applied_date_time: ~datetime.datetime
    :ivar insights: This is the collection of insights for this decision item.
    :vartype insights: list[~azure.mgmt.authorization.models.AccessReviewDecisionInsight]
    :ivar membership_types: Every decision item in an access review represents a principal's
     membership to a resource. This property represents details of the membership. Examples of this
     detail might be whether the principal has direct access or indirect access.
    :vartype membership_types: list[str or
     ~azure.mgmt.authorization.models.AccessReviewDecisionPrincipalResourceMembershipType]
    :ivar principal_id_properties_applied_by_principal_id: The identity id.
    :vartype principal_id_properties_applied_by_principal_id: str
    :ivar principal_type_properties_applied_by_principal_type: The identity type :
     user/servicePrincipal. Known values are: "user" and "servicePrincipal".
    :vartype principal_type_properties_applied_by_principal_type: str or
     ~azure.mgmt.authorization.models.AccessReviewActorIdentityType
    :ivar principal_name_properties_applied_by_principal_name: The identity display name.
    :vartype principal_name_properties_applied_by_principal_name: str
    :ivar user_principal_name_properties_applied_by_user_principal_name: The user principal name(if
     valid).
    :vartype user_principal_name_properties_applied_by_user_principal_name: str
    :ivar principal_id_properties_reviewed_by_principal_id: The identity id.
    :vartype principal_id_properties_reviewed_by_principal_id: str
    :ivar principal_type_properties_reviewed_by_principal_type: The identity type :
     user/servicePrincipal. Known values are: "user" and "servicePrincipal".
    :vartype principal_type_properties_reviewed_by_principal_type: str or
     ~azure.mgmt.authorization.models.AccessReviewActorIdentityType
    :ivar principal_name_properties_reviewed_by_principal_name: The identity display name.
    :vartype principal_name_properties_reviewed_by_principal_name: str
    :ivar user_principal_name_properties_reviewed_by_user_principal_name: The user principal
     name(if valid).
    :vartype user_principal_name_properties_reviewed_by_user_principal_name: str
    :ivar type_properties_resource_type: The type of resource. "azureRole"
    :vartype type_properties_resource_type: str or
     ~azure.mgmt.authorization.models.DecisionResourceType
    :ivar id_properties_resource_id: The id of resource associated with a decision record.
    :vartype id_properties_resource_id: str
    :ivar display_name_properties_resource_display_name: The display name of resource associated
     with a decision record.
    :vartype display_name_properties_resource_display_name: str
    :ivar type_properties_principal_type: The type of decision target : User/ServicePrincipal.
     Known values are: "user" and "servicePrincipal".
    :vartype type_properties_principal_type: str or
     ~azure.mgmt.authorization.models.DecisionTargetType
    :ivar id_properties_principal_id: The id of principal whose access was reviewed.
    :vartype id_properties_principal_id: str
    :ivar display_name_properties_principal_display_name: The display name of the user whose access
     was reviewed.
    :vartype display_name_properties_principal_display_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "recommendation": {"readonly": True},
        "reviewed_date_time": {"readonly": True},
        "apply_result": {"readonly": True},
        "applied_date_time": {"readonly": True},
        "principal_id_properties_applied_by_principal_id": {"readonly": True},
        "principal_type_properties_applied_by_principal_type": {"readonly": True},
        "principal_name_properties_applied_by_principal_name": {"readonly": True},
        "user_principal_name_properties_applied_by_user_principal_name": {"readonly": True},
        "principal_id_properties_reviewed_by_principal_id": {"readonly": True},
        "principal_type_properties_reviewed_by_principal_type": {"readonly": True},
        "principal_name_properties_reviewed_by_principal_name": {"readonly": True},
        "user_principal_name_properties_reviewed_by_user_principal_name": {"readonly": True},
        "id_properties_resource_id": {"readonly": True},
        "display_name_properties_resource_display_name": {"readonly": True},
        "id_properties_principal_id": {"readonly": True},
        "display_name_properties_principal_display_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "recommendation": {"key": "properties.recommendation", "type": "str"},
        "decision": {"key": "properties.decision", "type": "str"},
        "justification": {"key": "properties.justification", "type": "str"},
        "reviewed_date_time": {"key": "properties.reviewedDateTime", "type": "iso-8601"},
        "apply_result": {"key": "properties.applyResult", "type": "str"},
        "applied_date_time": {"key": "properties.appliedDateTime", "type": "iso-8601"},
        "insights": {"key": "properties.insights", "type": "[AccessReviewDecisionInsight]"},
        "membership_types": {"key": "properties.principalResourceMembership.membershipTypes", "type": "[str]"},
        "principal_id_properties_applied_by_principal_id": {"key": "properties.appliedBy.principalId", "type": "str"},
        "principal_type_properties_applied_by_principal_type": {
            "key": "properties.appliedBy.principalType",
            "type": "str",
        },
        "principal_name_properties_applied_by_principal_name": {
            "key": "properties.appliedBy.principalName",
            "type": "str",
        },
        "user_principal_name_properties_applied_by_user_principal_name": {
            "key": "properties.appliedBy.userPrincipalName",
            "type": "str",
        },
        "principal_id_properties_reviewed_by_principal_id": {"key": "properties.reviewedBy.principalId", "type": "str"},
        "principal_type_properties_reviewed_by_principal_type": {
            "key": "properties.reviewedBy.principalType",
            "type": "str",
        },
        "principal_name_properties_reviewed_by_principal_name": {
            "key": "properties.reviewedBy.principalName",
            "type": "str",
        },
        "user_principal_name_properties_reviewed_by_user_principal_name": {
            "key": "properties.reviewedBy.userPrincipalName",
            "type": "str",
        },
        "type_properties_resource_type": {"key": "properties.resource.type", "type": "str"},
        "id_properties_resource_id": {"key": "properties.resource.id", "type": "str"},
        "display_name_properties_resource_display_name": {"key": "properties.resource.displayName", "type": "str"},
        "type_properties_principal_type": {"key": "properties.principal.type", "type": "str"},
        "id_properties_principal_id": {"key": "properties.principal.id", "type": "str"},
        "display_name_properties_principal_display_name": {"key": "properties.principal.displayName", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        decision: Optional[Union[str, "_models.AccessReviewResult"]] = None,
        justification: Optional[str] = None,
        insights: Optional[List["_models.AccessReviewDecisionInsight"]] = None,
        membership_types: Optional[
            List[Union[str, "_models.AccessReviewDecisionPrincipalResourceMembershipType"]]
        ] = None,
        type_properties_resource_type: Optional[Union[str, "_models.DecisionResourceType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword decision: The decision on the approval step. This value is initially set to
         NotReviewed. Approvers can take action of Approve/Deny. Known values are: "Approve", "Deny",
         "NotReviewed", "DontKnow", and "NotNotified".
        :paramtype decision: str or ~azure.mgmt.authorization.models.AccessReviewResult
        :keyword justification: Justification provided by approvers for their action.
        :paramtype justification: str
        :keyword insights: This is the collection of insights for this decision item.
        :paramtype insights: list[~azure.mgmt.authorization.models.AccessReviewDecisionInsight]
        :keyword membership_types: Every decision item in an access review represents a principal's
         membership to a resource. This property represents details of the membership. Examples of this
         detail might be whether the principal has direct access or indirect access.
        :paramtype membership_types: list[str or
         ~azure.mgmt.authorization.models.AccessReviewDecisionPrincipalResourceMembershipType]
        :keyword type_properties_resource_type: The type of resource. "azureRole"
        :paramtype type_properties_resource_type: str or
         ~azure.mgmt.authorization.models.DecisionResourceType
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.recommendation: Optional[Union[str, "_models.AccessRecommendationType"]] = None
        self.decision = decision
        self.justification = justification
        self.reviewed_date_time: Optional[datetime.datetime] = None
        self.apply_result: Optional[Union[str, "_models.AccessReviewApplyResult"]] = None
        self.applied_date_time: Optional[datetime.datetime] = None
        self.insights = insights
        self.membership_types = membership_types
        self.principal_id_properties_applied_by_principal_id: Optional[str] = None
        self.principal_type_properties_applied_by_principal_type: Optional[
            Union[str, "_models.AccessReviewActorIdentityType"]
        ] = None
        self.principal_name_properties_applied_by_principal_name: Optional[str] = None
        self.user_principal_name_properties_applied_by_user_principal_name: Optional[str] = None
        self.principal_id_properties_reviewed_by_principal_id: Optional[str] = None
        self.principal_type_properties_reviewed_by_principal_type: Optional[
            Union[str, "_models.AccessReviewActorIdentityType"]
        ] = None
        self.principal_name_properties_reviewed_by_principal_name: Optional[str] = None
        self.user_principal_name_properties_reviewed_by_user_principal_name: Optional[str] = None
        self.type_properties_resource_type = type_properties_resource_type
        self.id_properties_resource_id: Optional[str] = None
        self.display_name_properties_resource_display_name: Optional[str] = None
        self.type_properties_principal_type: Optional[str] = None
        self.id_properties_principal_id: Optional[str] = None
        self.display_name_properties_principal_display_name: Optional[str] = None


class AccessReviewDecisionIdentity(_serialization.Model):
    """Target of the decision.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AccessReviewDecisionServicePrincipalIdentity, AccessReviewDecisionUserIdentity

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of decision target : User/ServicePrincipal. Required. Known values are:
     "user" and "servicePrincipal".
    :vartype type: str or ~azure.mgmt.authorization.models.DecisionTargetType
    :ivar id: The id of principal whose access was reviewed.
    :vartype id: str
    :ivar display_name: The display name of the user whose access was reviewed.
    :vartype display_name: str
    """

    _validation = {
        "type": {"required": True},
        "id": {"readonly": True},
        "display_name": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "servicePrincipal": "AccessReviewDecisionServicePrincipalIdentity",
            "user": "AccessReviewDecisionUserIdentity",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.id: Optional[str] = None
        self.display_name: Optional[str] = None


class AccessReviewDecisionInsight(_serialization.Model):
    """Access Review Decision Insight.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The access review insight id.
    :vartype id: str
    :ivar name: The access review insight name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar type_properties_type: The type of insight. "userSignInInsight"
    :vartype type_properties_type: str or
     ~azure.mgmt.authorization.models.AccessReviewDecisionInsightType
    :ivar insight_created_date_time: Date Time when the insight was created.
    :vartype insight_created_date_time: any
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "insight_created_date_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "insight_created_date_time": {"key": "properties.insightCreatedDateTime", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.type_properties_type: Optional[str] = None
        self.insight_created_date_time: Optional[Any] = None


class AccessReviewDecisionInsightProperties(_serialization.Model):
    """Details of the Insight.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AccessReviewDecisionUserSignInInsightProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of insight. Required. "userSignInInsight"
    :vartype type: str or ~azure.mgmt.authorization.models.AccessReviewDecisionInsightType
    :ivar insight_created_date_time: Date Time when the insight was created.
    :vartype insight_created_date_time: any
    """

    _validation = {
        "type": {"required": True},
        "insight_created_date_time": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "insight_created_date_time": {"key": "insightCreatedDateTime", "type": "object"},
    }

    _subtype_map = {"type": {"userSignInInsight": "AccessReviewDecisionUserSignInInsightProperties"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.insight_created_date_time: Optional[Any] = None


class AccessReviewDecisionListResult(_serialization.Model):
    """List of access review decisions.

    :ivar value: Access Review Decision list.
    :vartype value: list[~azure.mgmt.authorization.models.AccessReviewDecision]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AccessReviewDecision]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AccessReviewDecision"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Access Review Decision list.
        :paramtype value: list[~azure.mgmt.authorization.models.AccessReviewDecision]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AccessReviewDecisionProperties(_serialization.Model):
    """Approval Step.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar recommendation: The feature- generated recommendation shown to the reviewer. Known values
     are: "Approve", "Deny", and "NoInfoAvailable".
    :vartype recommendation: str or ~azure.mgmt.authorization.models.AccessRecommendationType
    :ivar decision: The decision on the approval step. This value is initially set to NotReviewed.
     Approvers can take action of Approve/Deny. Known values are: "Approve", "Deny", "NotReviewed",
     "DontKnow", and "NotNotified".
    :vartype decision: str or ~azure.mgmt.authorization.models.AccessReviewResult
    :ivar justification: Justification provided by approvers for their action.
    :vartype justification: str
    :ivar reviewed_date_time: Date Time when a decision was taken.
    :vartype reviewed_date_time: ~datetime.datetime
    :ivar apply_result: The outcome of applying the decision. Known values are: "New", "Applying",
     "AppliedSuccessfully", "AppliedWithUnknownFailure", "AppliedSuccessfullyButObjectNotFound", and
     "ApplyNotSupported".
    :vartype apply_result: str or ~azure.mgmt.authorization.models.AccessReviewApplyResult
    :ivar applied_date_time: The date and time when the review decision was applied.
    :vartype applied_date_time: ~datetime.datetime
    :ivar insights: This is the collection of insights for this decision item.
    :vartype insights: list[~azure.mgmt.authorization.models.AccessReviewDecisionInsight]
    :ivar membership_types: Every decision item in an access review represents a principal's
     membership to a resource. This property represents details of the membership. Examples of this
     detail might be whether the principal has direct access or indirect access.
    :vartype membership_types: list[str or
     ~azure.mgmt.authorization.models.AccessReviewDecisionPrincipalResourceMembershipType]
    :ivar principal_id_applied_by_principal_id: The identity id.
    :vartype principal_id_applied_by_principal_id: str
    :ivar principal_type_applied_by_principal_type: The identity type : user/servicePrincipal.
     Known values are: "user" and "servicePrincipal".
    :vartype principal_type_applied_by_principal_type: str or
     ~azure.mgmt.authorization.models.AccessReviewActorIdentityType
    :ivar principal_name_applied_by_principal_name: The identity display name.
    :vartype principal_name_applied_by_principal_name: str
    :ivar user_principal_name_applied_by_user_principal_name: The user principal name(if valid).
    :vartype user_principal_name_applied_by_user_principal_name: str
    :ivar principal_id_reviewed_by_principal_id: The identity id.
    :vartype principal_id_reviewed_by_principal_id: str
    :ivar principal_type_reviewed_by_principal_type: The identity type : user/servicePrincipal.
     Known values are: "user" and "servicePrincipal".
    :vartype principal_type_reviewed_by_principal_type: str or
     ~azure.mgmt.authorization.models.AccessReviewActorIdentityType
    :ivar principal_name_reviewed_by_principal_name: The identity display name.
    :vartype principal_name_reviewed_by_principal_name: str
    :ivar user_principal_name_reviewed_by_user_principal_name: The user principal name(if valid).
    :vartype user_principal_name_reviewed_by_user_principal_name: str
    :ivar type_resource_type: The type of resource. "azureRole"
    :vartype type_resource_type: str or ~azure.mgmt.authorization.models.DecisionResourceType
    :ivar id_resource_id: The id of resource associated with a decision record.
    :vartype id_resource_id: str
    :ivar display_name_resource_display_name: The display name of resource associated with a
     decision record.
    :vartype display_name_resource_display_name: str
    :ivar type_principal_type: The type of decision target : User/ServicePrincipal. Known values
     are: "user" and "servicePrincipal".
    :vartype type_principal_type: str or ~azure.mgmt.authorization.models.DecisionTargetType
    :ivar id_principal_id: The id of principal whose access was reviewed.
    :vartype id_principal_id: str
    :ivar display_name_principal_display_name: The display name of the user whose access was
     reviewed.
    :vartype display_name_principal_display_name: str
    """

    _validation = {
        "recommendation": {"readonly": True},
        "reviewed_date_time": {"readonly": True},
        "apply_result": {"readonly": True},
        "applied_date_time": {"readonly": True},
        "principal_id_applied_by_principal_id": {"readonly": True},
        "principal_type_applied_by_principal_type": {"readonly": True},
        "principal_name_applied_by_principal_name": {"readonly": True},
        "user_principal_name_applied_by_user_principal_name": {"readonly": True},
        "principal_id_reviewed_by_principal_id": {"readonly": True},
        "principal_type_reviewed_by_principal_type": {"readonly": True},
        "principal_name_reviewed_by_principal_name": {"readonly": True},
        "user_principal_name_reviewed_by_user_principal_name": {"readonly": True},
        "id_resource_id": {"readonly": True},
        "display_name_resource_display_name": {"readonly": True},
        "id_principal_id": {"readonly": True},
        "display_name_principal_display_name": {"readonly": True},
    }

    _attribute_map = {
        "recommendation": {"key": "recommendation", "type": "str"},
        "decision": {"key": "decision", "type": "str"},
        "justification": {"key": "justification", "type": "str"},
        "reviewed_date_time": {"key": "reviewedDateTime", "type": "iso-8601"},
        "apply_result": {"key": "applyResult", "type": "str"},
        "applied_date_time": {"key": "appliedDateTime", "type": "iso-8601"},
        "insights": {"key": "insights", "type": "[AccessReviewDecisionInsight]"},
        "membership_types": {"key": "principalResourceMembership.membershipTypes", "type": "[str]"},
        "principal_id_applied_by_principal_id": {"key": "appliedBy.principalId", "type": "str"},
        "principal_type_applied_by_principal_type": {"key": "appliedBy.principalType", "type": "str"},
        "principal_name_applied_by_principal_name": {"key": "appliedBy.principalName", "type": "str"},
        "user_principal_name_applied_by_user_principal_name": {"key": "appliedBy.userPrincipalName", "type": "str"},
        "principal_id_reviewed_by_principal_id": {"key": "reviewedBy.principalId", "type": "str"},
        "principal_type_reviewed_by_principal_type": {"key": "reviewedBy.principalType", "type": "str"},
        "principal_name_reviewed_by_principal_name": {"key": "reviewedBy.principalName", "type": "str"},
        "user_principal_name_reviewed_by_user_principal_name": {"key": "reviewedBy.userPrincipalName", "type": "str"},
        "type_resource_type": {"key": "resource.type", "type": "str"},
        "id_resource_id": {"key": "resource.id", "type": "str"},
        "display_name_resource_display_name": {"key": "resource.displayName", "type": "str"},
        "type_principal_type": {"key": "principal.type", "type": "str"},
        "id_principal_id": {"key": "principal.id", "type": "str"},
        "display_name_principal_display_name": {"key": "principal.displayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        decision: Optional[Union[str, "_models.AccessReviewResult"]] = None,
        justification: Optional[str] = None,
        insights: Optional[List["_models.AccessReviewDecisionInsight"]] = None,
        membership_types: Optional[
            List[Union[str, "_models.AccessReviewDecisionPrincipalResourceMembershipType"]]
        ] = None,
        type_resource_type: Optional[Union[str, "_models.DecisionResourceType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword decision: The decision on the approval step. This value is initially set to
         NotReviewed. Approvers can take action of Approve/Deny. Known values are: "Approve", "Deny",
         "NotReviewed", "DontKnow", and "NotNotified".
        :paramtype decision: str or ~azure.mgmt.authorization.models.AccessReviewResult
        :keyword justification: Justification provided by approvers for their action.
        :paramtype justification: str
        :keyword insights: This is the collection of insights for this decision item.
        :paramtype insights: list[~azure.mgmt.authorization.models.AccessReviewDecisionInsight]
        :keyword membership_types: Every decision item in an access review represents a principal's
         membership to a resource. This property represents details of the membership. Examples of this
         detail might be whether the principal has direct access or indirect access.
        :paramtype membership_types: list[str or
         ~azure.mgmt.authorization.models.AccessReviewDecisionPrincipalResourceMembershipType]
        :keyword type_resource_type: The type of resource. "azureRole"
        :paramtype type_resource_type: str or ~azure.mgmt.authorization.models.DecisionResourceType
        """
        super().__init__(**kwargs)
        self.recommendation: Optional[Union[str, "_models.AccessRecommendationType"]] = None
        self.decision = decision
        self.justification = justification
        self.reviewed_date_time: Optional[datetime.datetime] = None
        self.apply_result: Optional[Union[str, "_models.AccessReviewApplyResult"]] = None
        self.applied_date_time: Optional[datetime.datetime] = None
        self.insights = insights
        self.membership_types = membership_types
        self.principal_id_applied_by_principal_id: Optional[str] = None
        self.principal_type_applied_by_principal_type: Optional[Union[str, "_models.AccessReviewActorIdentityType"]] = (
            None
        )
        self.principal_name_applied_by_principal_name: Optional[str] = None
        self.user_principal_name_applied_by_user_principal_name: Optional[str] = None
        self.principal_id_reviewed_by_principal_id: Optional[str] = None
        self.principal_type_reviewed_by_principal_type: Optional[
            Union[str, "_models.AccessReviewActorIdentityType"]
        ] = None
        self.principal_name_reviewed_by_principal_name: Optional[str] = None
        self.user_principal_name_reviewed_by_user_principal_name: Optional[str] = None
        self.type_resource_type = type_resource_type
        self.id_resource_id: Optional[str] = None
        self.display_name_resource_display_name: Optional[str] = None
        self.type_principal_type: Optional[str] = None
        self.id_principal_id: Optional[str] = None
        self.display_name_principal_display_name: Optional[str] = None


class AccessReviewDecisionServicePrincipalIdentity(AccessReviewDecisionIdentity):  # pylint: disable=name-too-long
    """Service Principal Decision Target.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of decision target : User/ServicePrincipal. Required. Known values are:
     "user" and "servicePrincipal".
    :vartype type: str or ~azure.mgmt.authorization.models.DecisionTargetType
    :ivar id: The id of principal whose access was reviewed.
    :vartype id: str
    :ivar display_name: The display name of the user whose access was reviewed.
    :vartype display_name: str
    :ivar app_id: The appId for the service principal entity being reviewed.
    :vartype app_id: str
    """

    _validation = {
        "type": {"required": True},
        "id": {"readonly": True},
        "display_name": {"readonly": True},
        "app_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "app_id": {"key": "appId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: str = "servicePrincipal"
        self.app_id: Optional[str] = None


class AccessReviewDecisionUserIdentity(AccessReviewDecisionIdentity):
    """User Decision Target.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of decision target : User/ServicePrincipal. Required. Known values are:
     "user" and "servicePrincipal".
    :vartype type: str or ~azure.mgmt.authorization.models.DecisionTargetType
    :ivar id: The id of principal whose access was reviewed.
    :vartype id: str
    :ivar display_name: The display name of the user whose access was reviewed.
    :vartype display_name: str
    :ivar user_principal_name: The user principal name of the user whose access was reviewed.
    :vartype user_principal_name: str
    """

    _validation = {
        "type": {"required": True},
        "id": {"readonly": True},
        "display_name": {"readonly": True},
        "user_principal_name": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "user_principal_name": {"key": "userPrincipalName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: str = "user"
        self.user_principal_name: Optional[str] = None


class AccessReviewDecisionUserSignInInsightProperties(
    AccessReviewDecisionInsightProperties
):  # pylint: disable=name-too-long
    """User Decision Target.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of insight. Required. "userSignInInsight"
    :vartype type: str or ~azure.mgmt.authorization.models.AccessReviewDecisionInsightType
    :ivar insight_created_date_time: Date Time when the insight was created.
    :vartype insight_created_date_time: any
    :ivar last_sign_in_date_time: Date Time when the user signed into the tenant.
    :vartype last_sign_in_date_time: any
    """

    _validation = {
        "type": {"required": True},
        "insight_created_date_time": {"readonly": True},
        "last_sign_in_date_time": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "insight_created_date_time": {"key": "insightCreatedDateTime", "type": "object"},
        "last_sign_in_date_time": {"key": "lastSignInDateTime", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: str = "userSignInInsight"
        self.last_sign_in_date_time: Optional[Any] = None


class AccessReviewDefaultSettings(_serialization.Model):
    """Access Review Default Settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The access review default settings id. This is only going to be default.
    :vartype id: str
    :ivar name: The access review default settings name. This is always going to be Access Review
     Default Settings.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar mail_notifications_enabled: Flag to indicate whether sending mails to reviewers and the
     review creator is enabled.
    :vartype mail_notifications_enabled: bool
    :ivar reminder_notifications_enabled: Flag to indicate whether sending reminder emails to
     reviewers are enabled.
    :vartype reminder_notifications_enabled: bool
    :ivar default_decision_enabled: Flag to indicate whether reviewers are required to provide a
     justification when reviewing access.
    :vartype default_decision_enabled: bool
    :ivar justification_required_on_approval: Flag to indicate whether the reviewer is required to
     pass justification when recording a decision.
    :vartype justification_required_on_approval: bool
    :ivar default_decision: This specifies the behavior for the autoReview feature when an access
     review completes. Known values are: "Approve", "Deny", and "Recommendation".
    :vartype default_decision: str or ~azure.mgmt.authorization.models.DefaultDecisionType
    :ivar auto_apply_decisions_enabled: Flag to indicate whether auto-apply capability, to
     automatically change the target object access resource, is enabled. If not enabled, a user
     must, after the review completes, apply the access review.
    :vartype auto_apply_decisions_enabled: bool
    :ivar recommendations_enabled: Flag to indicate whether showing recommendations to reviewers is
     enabled.
    :vartype recommendations_enabled: bool
    :ivar recommendation_look_back_duration: Recommendations for access reviews are calculated by
     looking back at 30 days of data(w.r.t the start date of the review) by default. However, in
     some scenarios, customers want to change how far back to look at and want to configure 60 days,
     90 days, etc. instead. This setting allows customers to configure this duration. The value
     should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can
     be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours,
     minutes, seconds)).
    :vartype recommendation_look_back_duration: ~datetime.timedelta
    :ivar instance_duration_in_days: The duration in days for an instance.
    :vartype instance_duration_in_days: int
    :ivar type_properties_recurrence_range_type: The recurrence range type. The possible values
     are: endDate, noEnd, numbered. Known values are: "endDate", "noEnd", and "numbered".
    :vartype type_properties_recurrence_range_type: str or
     ~azure.mgmt.authorization.models.AccessReviewRecurrenceRangeType
    :ivar number_of_occurrences: The number of times to repeat the access review. Required and must
     be positive if type is numbered.
    :vartype number_of_occurrences: int
    :ivar start_date: The DateTime when the review is scheduled to be start. This could be a date
     in the future. Required on create.
    :vartype start_date: ~datetime.datetime
    :ivar end_date: The DateTime when the review is scheduled to end. Required if type is endDate.
    :vartype end_date: ~datetime.datetime
    :ivar type_properties_recurrence_pattern_type: The recurrence type : weekly, monthly, etc.
     Known values are: "weekly" and "absoluteMonthly".
    :vartype type_properties_recurrence_pattern_type: str or
     ~azure.mgmt.authorization.models.AccessReviewRecurrencePatternType
    :ivar interval: The interval for recurrence. For a quarterly review, the interval is 3 for type
     : absoluteMonthly.
    :vartype interval: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "mail_notifications_enabled": {"key": "properties.mailNotificationsEnabled", "type": "bool"},
        "reminder_notifications_enabled": {"key": "properties.reminderNotificationsEnabled", "type": "bool"},
        "default_decision_enabled": {"key": "properties.defaultDecisionEnabled", "type": "bool"},
        "justification_required_on_approval": {"key": "properties.justificationRequiredOnApproval", "type": "bool"},
        "default_decision": {"key": "properties.defaultDecision", "type": "str"},
        "auto_apply_decisions_enabled": {"key": "properties.autoApplyDecisionsEnabled", "type": "bool"},
        "recommendations_enabled": {"key": "properties.recommendationsEnabled", "type": "bool"},
        "recommendation_look_back_duration": {"key": "properties.recommendationLookBackDuration", "type": "duration"},
        "instance_duration_in_days": {"key": "properties.instanceDurationInDays", "type": "int"},
        "type_properties_recurrence_range_type": {"key": "properties.recurrence.range.type", "type": "str"},
        "number_of_occurrences": {"key": "properties.recurrence.range.numberOfOccurrences", "type": "int"},
        "start_date": {"key": "properties.recurrence.range.startDate", "type": "iso-8601"},
        "end_date": {"key": "properties.recurrence.range.endDate", "type": "iso-8601"},
        "type_properties_recurrence_pattern_type": {"key": "properties.recurrence.pattern.type", "type": "str"},
        "interval": {"key": "properties.recurrence.pattern.interval", "type": "int"},
    }

    def __init__(
        self,
        *,
        mail_notifications_enabled: Optional[bool] = None,
        reminder_notifications_enabled: Optional[bool] = None,
        default_decision_enabled: Optional[bool] = None,
        justification_required_on_approval: Optional[bool] = None,
        default_decision: Optional[Union[str, "_models.DefaultDecisionType"]] = None,
        auto_apply_decisions_enabled: Optional[bool] = None,
        recommendations_enabled: Optional[bool] = None,
        recommendation_look_back_duration: Optional[datetime.timedelta] = None,
        instance_duration_in_days: Optional[int] = None,
        type_properties_recurrence_range_type: Optional[Union[str, "_models.AccessReviewRecurrenceRangeType"]] = None,
        number_of_occurrences: Optional[int] = None,
        start_date: Optional[datetime.datetime] = None,
        end_date: Optional[datetime.datetime] = None,
        type_properties_recurrence_pattern_type: Optional[
            Union[str, "_models.AccessReviewRecurrencePatternType"]
        ] = None,
        interval: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mail_notifications_enabled: Flag to indicate whether sending mails to reviewers and
         the review creator is enabled.
        :paramtype mail_notifications_enabled: bool
        :keyword reminder_notifications_enabled: Flag to indicate whether sending reminder emails to
         reviewers are enabled.
        :paramtype reminder_notifications_enabled: bool
        :keyword default_decision_enabled: Flag to indicate whether reviewers are required to provide a
         justification when reviewing access.
        :paramtype default_decision_enabled: bool
        :keyword justification_required_on_approval: Flag to indicate whether the reviewer is required
         to pass justification when recording a decision.
        :paramtype justification_required_on_approval: bool
        :keyword default_decision: This specifies the behavior for the autoReview feature when an
         access review completes. Known values are: "Approve", "Deny", and "Recommendation".
        :paramtype default_decision: str or ~azure.mgmt.authorization.models.DefaultDecisionType
        :keyword auto_apply_decisions_enabled: Flag to indicate whether auto-apply capability, to
         automatically change the target object access resource, is enabled. If not enabled, a user
         must, after the review completes, apply the access review.
        :paramtype auto_apply_decisions_enabled: bool
        :keyword recommendations_enabled: Flag to indicate whether showing recommendations to reviewers
         is enabled.
        :paramtype recommendations_enabled: bool
        :keyword recommendation_look_back_duration: Recommendations for access reviews are calculated
         by looking back at 30 days of data(w.r.t the start date of the review) by default. However, in
         some scenarios, customers want to change how far back to look at and want to configure 60 days,
         90 days, etc. instead. This setting allows customers to configure this duration. The value
         should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can
         be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours,
         minutes, seconds)).
        :paramtype recommendation_look_back_duration: ~datetime.timedelta
        :keyword instance_duration_in_days: The duration in days for an instance.
        :paramtype instance_duration_in_days: int
        :keyword type_properties_recurrence_range_type: The recurrence range type. The possible values
         are: endDate, noEnd, numbered. Known values are: "endDate", "noEnd", and "numbered".
        :paramtype type_properties_recurrence_range_type: str or
         ~azure.mgmt.authorization.models.AccessReviewRecurrenceRangeType
        :keyword number_of_occurrences: The number of times to repeat the access review. Required and
         must be positive if type is numbered.
        :paramtype number_of_occurrences: int
        :keyword start_date: The DateTime when the review is scheduled to be start. This could be a
         date in the future. Required on create.
        :paramtype start_date: ~datetime.datetime
        :keyword end_date: The DateTime when the review is scheduled to end. Required if type is
         endDate.
        :paramtype end_date: ~datetime.datetime
        :keyword type_properties_recurrence_pattern_type: The recurrence type : weekly, monthly, etc.
         Known values are: "weekly" and "absoluteMonthly".
        :paramtype type_properties_recurrence_pattern_type: str or
         ~azure.mgmt.authorization.models.AccessReviewRecurrencePatternType
        :keyword interval: The interval for recurrence. For a quarterly review, the interval is 3 for
         type : absoluteMonthly.
        :paramtype interval: int
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.mail_notifications_enabled = mail_notifications_enabled
        self.reminder_notifications_enabled = reminder_notifications_enabled
        self.default_decision_enabled = default_decision_enabled
        self.justification_required_on_approval = justification_required_on_approval
        self.default_decision = default_decision
        self.auto_apply_decisions_enabled = auto_apply_decisions_enabled
        self.recommendations_enabled = recommendations_enabled
        self.recommendation_look_back_duration = recommendation_look_back_duration
        self.instance_duration_in_days = instance_duration_in_days
        self.type_properties_recurrence_range_type = type_properties_recurrence_range_type
        self.number_of_occurrences = number_of_occurrences
        self.start_date = start_date
        self.end_date = end_date
        self.type_properties_recurrence_pattern_type = type_properties_recurrence_pattern_type
        self.interval = interval


class AccessReviewHistoryDefinition(_serialization.Model):
    """Access Review History Definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The access review history definition id.
    :vartype id: str
    :ivar name: The access review history definition unique id.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar display_name: The display name for the history definition.
    :vartype display_name: str
    :ivar review_history_period_start_date_time: Date time used when selecting review data, all
     reviews included in data start on or after this date. For use only with one-time/non-recurring
     reports.
    :vartype review_history_period_start_date_time: ~datetime.datetime
    :ivar review_history_period_end_date_time: Date time used when selecting review data, all
     reviews included in data end on or before this date. For use only with one-time/non-recurring
     reports.
    :vartype review_history_period_end_date_time: ~datetime.datetime
    :ivar decisions: Collection of review decisions which the history data should be filtered on.
     For example if Approve and Deny are supplied the data will only contain review results in which
     the decision maker approved or denied a review request.
    :vartype decisions: list[str or ~azure.mgmt.authorization.models.AccessReviewResult]
    :ivar status: This read-only field specifies the of the requested review history data. This is
     either requested, in-progress, done or error. Known values are: "Requested", "InProgress",
     "Done", and "Error".
    :vartype status: str or ~azure.mgmt.authorization.models.AccessReviewHistoryDefinitionStatus
    :ivar created_date_time: Date time when history definition was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar scopes: A collection of scopes used when selecting review history data.
    :vartype scopes: list[~azure.mgmt.authorization.models.AccessReviewScope]
    :ivar instances: Set of access review history instances for this history definition.
    :vartype instances: list[~azure.mgmt.authorization.models.AccessReviewHistoryInstance]
    :ivar type_properties_settings_range_type: The recurrence range type. The possible values are:
     endDate, noEnd, numbered. Known values are: "endDate", "noEnd", and "numbered".
    :vartype type_properties_settings_range_type: str or
     ~azure.mgmt.authorization.models.AccessReviewRecurrenceRangeType
    :ivar number_of_occurrences: The number of times to repeat the access review. Required and must
     be positive if type is numbered.
    :vartype number_of_occurrences: int
    :ivar start_date: The DateTime when the review is scheduled to be start. This could be a date
     in the future. Required on create.
    :vartype start_date: ~datetime.datetime
    :ivar end_date: The DateTime when the review is scheduled to end. Required if type is endDate.
    :vartype end_date: ~datetime.datetime
    :ivar type_properties_settings_pattern_type: The recurrence type : weekly, monthly, etc. Known
     values are: "weekly" and "absoluteMonthly".
    :vartype type_properties_settings_pattern_type: str or
     ~azure.mgmt.authorization.models.AccessReviewRecurrencePatternType
    :ivar interval: The interval for recurrence. For a quarterly review, the interval is 3 for type
     : absoluteMonthly.
    :vartype interval: int
    :ivar principal_id: The identity id.
    :vartype principal_id: str
    :ivar principal_type: The identity type : user/servicePrincipal. Known values are: "user" and
     "servicePrincipal".
    :vartype principal_type: str or ~azure.mgmt.authorization.models.AccessReviewActorIdentityType
    :ivar principal_name: The identity display name.
    :vartype principal_name: str
    :ivar user_principal_name: The user principal name(if valid).
    :vartype user_principal_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "review_history_period_start_date_time": {"readonly": True},
        "review_history_period_end_date_time": {"readonly": True},
        "status": {"readonly": True},
        "created_date_time": {"readonly": True},
        "principal_id": {"readonly": True},
        "principal_type": {"readonly": True},
        "principal_name": {"readonly": True},
        "user_principal_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "review_history_period_start_date_time": {
            "key": "properties.reviewHistoryPeriodStartDateTime",
            "type": "iso-8601",
        },
        "review_history_period_end_date_time": {"key": "properties.reviewHistoryPeriodEndDateTime", "type": "iso-8601"},
        "decisions": {"key": "properties.decisions", "type": "[str]"},
        "status": {"key": "properties.status", "type": "str"},
        "created_date_time": {"key": "properties.createdDateTime", "type": "iso-8601"},
        "scopes": {"key": "properties.scopes", "type": "[AccessReviewScope]"},
        "instances": {"key": "properties.instances", "type": "[AccessReviewHistoryInstance]"},
        "type_properties_settings_range_type": {"key": "properties.settings.range.type", "type": "str"},
        "number_of_occurrences": {"key": "properties.settings.range.numberOfOccurrences", "type": "int"},
        "start_date": {"key": "properties.settings.range.startDate", "type": "iso-8601"},
        "end_date": {"key": "properties.settings.range.endDate", "type": "iso-8601"},
        "type_properties_settings_pattern_type": {"key": "properties.settings.pattern.type", "type": "str"},
        "interval": {"key": "properties.settings.pattern.interval", "type": "int"},
        "principal_id": {"key": "properties.createdBy.principalId", "type": "str"},
        "principal_type": {"key": "properties.createdBy.principalType", "type": "str"},
        "principal_name": {"key": "properties.createdBy.principalName", "type": "str"},
        "user_principal_name": {"key": "properties.createdBy.userPrincipalName", "type": "str"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        decisions: Optional[List[Union[str, "_models.AccessReviewResult"]]] = None,
        scopes: Optional[List["_models.AccessReviewScope"]] = None,
        instances: Optional[List["_models.AccessReviewHistoryInstance"]] = None,
        type_properties_settings_range_type: Optional[Union[str, "_models.AccessReviewRecurrenceRangeType"]] = None,
        number_of_occurrences: Optional[int] = None,
        start_date: Optional[datetime.datetime] = None,
        end_date: Optional[datetime.datetime] = None,
        type_properties_settings_pattern_type: Optional[Union[str, "_models.AccessReviewRecurrencePatternType"]] = None,
        interval: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: The display name for the history definition.
        :paramtype display_name: str
        :keyword decisions: Collection of review decisions which the history data should be filtered
         on. For example if Approve and Deny are supplied the data will only contain review results in
         which the decision maker approved or denied a review request.
        :paramtype decisions: list[str or ~azure.mgmt.authorization.models.AccessReviewResult]
        :keyword scopes: A collection of scopes used when selecting review history data.
        :paramtype scopes: list[~azure.mgmt.authorization.models.AccessReviewScope]
        :keyword instances: Set of access review history instances for this history definition.
        :paramtype instances: list[~azure.mgmt.authorization.models.AccessReviewHistoryInstance]
        :keyword type_properties_settings_range_type: The recurrence range type. The possible values
         are: endDate, noEnd, numbered. Known values are: "endDate", "noEnd", and "numbered".
        :paramtype type_properties_settings_range_type: str or
         ~azure.mgmt.authorization.models.AccessReviewRecurrenceRangeType
        :keyword number_of_occurrences: The number of times to repeat the access review. Required and
         must be positive if type is numbered.
        :paramtype number_of_occurrences: int
        :keyword start_date: The DateTime when the review is scheduled to be start. This could be a
         date in the future. Required on create.
        :paramtype start_date: ~datetime.datetime
        :keyword end_date: The DateTime when the review is scheduled to end. Required if type is
         endDate.
        :paramtype end_date: ~datetime.datetime
        :keyword type_properties_settings_pattern_type: The recurrence type : weekly, monthly, etc.
         Known values are: "weekly" and "absoluteMonthly".
        :paramtype type_properties_settings_pattern_type: str or
         ~azure.mgmt.authorization.models.AccessReviewRecurrencePatternType
        :keyword interval: The interval for recurrence. For a quarterly review, the interval is 3 for
         type : absoluteMonthly.
        :paramtype interval: int
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.display_name = display_name
        self.review_history_period_start_date_time: Optional[datetime.datetime] = None
        self.review_history_period_end_date_time: Optional[datetime.datetime] = None
        self.decisions = decisions
        self.status: Optional[Union[str, "_models.AccessReviewHistoryDefinitionStatus"]] = None
        self.created_date_time: Optional[datetime.datetime] = None
        self.scopes = scopes
        self.instances = instances
        self.type_properties_settings_range_type = type_properties_settings_range_type
        self.number_of_occurrences = number_of_occurrences
        self.start_date = start_date
        self.end_date = end_date
        self.type_properties_settings_pattern_type = type_properties_settings_pattern_type
        self.interval = interval
        self.principal_id: Optional[str] = None
        self.principal_type: Optional[Union[str, "_models.AccessReviewActorIdentityType"]] = None
        self.principal_name: Optional[str] = None
        self.user_principal_name: Optional[str] = None


class AccessReviewHistoryDefinitionInstanceListResult(_serialization.Model):  # pylint: disable=name-too-long
    """List of Access Review History Instances.

    :ivar value: Access Review History Definition's Instance list.
    :vartype value: list[~azure.mgmt.authorization.models.AccessReviewHistoryInstance]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AccessReviewHistoryInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AccessReviewHistoryInstance"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Access Review History Definition's Instance list.
        :paramtype value: list[~azure.mgmt.authorization.models.AccessReviewHistoryInstance]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AccessReviewHistoryDefinitionListResult(_serialization.Model):
    """List of Access Review History Definitions.

    :ivar value: Access Review History Definition list.
    :vartype value: list[~azure.mgmt.authorization.models.AccessReviewHistoryDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AccessReviewHistoryDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AccessReviewHistoryDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Access Review History Definition list.
        :paramtype value: list[~azure.mgmt.authorization.models.AccessReviewHistoryDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AccessReviewHistoryDefinitionProperties(_serialization.Model):
    """Access Review History Instances.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: The display name for the history definition.
    :vartype display_name: str
    :ivar review_history_period_start_date_time: Date time used when selecting review data, all
     reviews included in data start on or after this date. For use only with one-time/non-recurring
     reports.
    :vartype review_history_period_start_date_time: ~datetime.datetime
    :ivar review_history_period_end_date_time: Date time used when selecting review data, all
     reviews included in data end on or before this date. For use only with one-time/non-recurring
     reports.
    :vartype review_history_period_end_date_time: ~datetime.datetime
    :ivar decisions: Collection of review decisions which the history data should be filtered on.
     For example if Approve and Deny are supplied the data will only contain review results in which
     the decision maker approved or denied a review request.
    :vartype decisions: list[str or ~azure.mgmt.authorization.models.AccessReviewResult]
    :ivar status: This read-only field specifies the of the requested review history data. This is
     either requested, in-progress, done or error. Known values are: "Requested", "InProgress",
     "Done", and "Error".
    :vartype status: str or ~azure.mgmt.authorization.models.AccessReviewHistoryDefinitionStatus
    :ivar created_date_time: Date time when history definition was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar scopes: A collection of scopes used when selecting review history data.
    :vartype scopes: list[~azure.mgmt.authorization.models.AccessReviewScope]
    :ivar instances: Set of access review history instances for this history definition.
    :vartype instances: list[~azure.mgmt.authorization.models.AccessReviewHistoryInstance]
    :ivar type_settings_range_type: The recurrence range type. The possible values are: endDate,
     noEnd, numbered. Known values are: "endDate", "noEnd", and "numbered".
    :vartype type_settings_range_type: str or
     ~azure.mgmt.authorization.models.AccessReviewRecurrenceRangeType
    :ivar number_of_occurrences: The number of times to repeat the access review. Required and must
     be positive if type is numbered.
    :vartype number_of_occurrences: int
    :ivar start_date: The DateTime when the review is scheduled to be start. This could be a date
     in the future. Required on create.
    :vartype start_date: ~datetime.datetime
    :ivar end_date: The DateTime when the review is scheduled to end. Required if type is endDate.
    :vartype end_date: ~datetime.datetime
    :ivar type_settings_pattern_type: The recurrence type : weekly, monthly, etc. Known values are:
     "weekly" and "absoluteMonthly".
    :vartype type_settings_pattern_type: str or
     ~azure.mgmt.authorization.models.AccessReviewRecurrencePatternType
    :ivar interval: The interval for recurrence. For a quarterly review, the interval is 3 for type
     : absoluteMonthly.
    :vartype interval: int
    :ivar principal_id: The identity id.
    :vartype principal_id: str
    :ivar principal_type: The identity type : user/servicePrincipal. Known values are: "user" and
     "servicePrincipal".
    :vartype principal_type: str or ~azure.mgmt.authorization.models.AccessReviewActorIdentityType
    :ivar principal_name: The identity display name.
    :vartype principal_name: str
    :ivar user_principal_name: The user principal name(if valid).
    :vartype user_principal_name: str
    """

    _validation = {
        "review_history_period_start_date_time": {"readonly": True},
        "review_history_period_end_date_time": {"readonly": True},
        "status": {"readonly": True},
        "created_date_time": {"readonly": True},
        "principal_id": {"readonly": True},
        "principal_type": {"readonly": True},
        "principal_name": {"readonly": True},
        "user_principal_name": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "review_history_period_start_date_time": {"key": "reviewHistoryPeriodStartDateTime", "type": "iso-8601"},
        "review_history_period_end_date_time": {"key": "reviewHistoryPeriodEndDateTime", "type": "iso-8601"},
        "decisions": {"key": "decisions", "type": "[str]"},
        "status": {"key": "status", "type": "str"},
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "scopes": {"key": "scopes", "type": "[AccessReviewScope]"},
        "instances": {"key": "instances", "type": "[AccessReviewHistoryInstance]"},
        "type_settings_range_type": {"key": "settings.range.type", "type": "str"},
        "number_of_occurrences": {"key": "settings.range.numberOfOccurrences", "type": "int"},
        "start_date": {"key": "settings.range.startDate", "type": "iso-8601"},
        "end_date": {"key": "settings.range.endDate", "type": "iso-8601"},
        "type_settings_pattern_type": {"key": "settings.pattern.type", "type": "str"},
        "interval": {"key": "settings.pattern.interval", "type": "int"},
        "principal_id": {"key": "createdBy.principalId", "type": "str"},
        "principal_type": {"key": "createdBy.principalType", "type": "str"},
        "principal_name": {"key": "createdBy.principalName", "type": "str"},
        "user_principal_name": {"key": "createdBy.userPrincipalName", "type": "str"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        decisions: Optional[List[Union[str, "_models.AccessReviewResult"]]] = None,
        scopes: Optional[List["_models.AccessReviewScope"]] = None,
        instances: Optional[List["_models.AccessReviewHistoryInstance"]] = None,
        type_settings_range_type: Optional[Union[str, "_models.AccessReviewRecurrenceRangeType"]] = None,
        number_of_occurrences: Optional[int] = None,
        start_date: Optional[datetime.datetime] = None,
        end_date: Optional[datetime.datetime] = None,
        type_settings_pattern_type: Optional[Union[str, "_models.AccessReviewRecurrencePatternType"]] = None,
        interval: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: The display name for the history definition.
        :paramtype display_name: str
        :keyword decisions: Collection of review decisions which the history data should be filtered
         on. For example if Approve and Deny are supplied the data will only contain review results in
         which the decision maker approved or denied a review request.
        :paramtype decisions: list[str or ~azure.mgmt.authorization.models.AccessReviewResult]
        :keyword scopes: A collection of scopes used when selecting review history data.
        :paramtype scopes: list[~azure.mgmt.authorization.models.AccessReviewScope]
        :keyword instances: Set of access review history instances for this history definition.
        :paramtype instances: list[~azure.mgmt.authorization.models.AccessReviewHistoryInstance]
        :keyword type_settings_range_type: The recurrence range type. The possible values are: endDate,
         noEnd, numbered. Known values are: "endDate", "noEnd", and "numbered".
        :paramtype type_settings_range_type: str or
         ~azure.mgmt.authorization.models.AccessReviewRecurrenceRangeType
        :keyword number_of_occurrences: The number of times to repeat the access review. Required and
         must be positive if type is numbered.
        :paramtype number_of_occurrences: int
        :keyword start_date: The DateTime when the review is scheduled to be start. This could be a
         date in the future. Required on create.
        :paramtype start_date: ~datetime.datetime
        :keyword end_date: The DateTime when the review is scheduled to end. Required if type is
         endDate.
        :paramtype end_date: ~datetime.datetime
        :keyword type_settings_pattern_type: The recurrence type : weekly, monthly, etc. Known values
         are: "weekly" and "absoluteMonthly".
        :paramtype type_settings_pattern_type: str or
         ~azure.mgmt.authorization.models.AccessReviewRecurrencePatternType
        :keyword interval: The interval for recurrence. For a quarterly review, the interval is 3 for
         type : absoluteMonthly.
        :paramtype interval: int
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.review_history_period_start_date_time: Optional[datetime.datetime] = None
        self.review_history_period_end_date_time: Optional[datetime.datetime] = None
        self.decisions = decisions
        self.status: Optional[Union[str, "_models.AccessReviewHistoryDefinitionStatus"]] = None
        self.created_date_time: Optional[datetime.datetime] = None
        self.scopes = scopes
        self.instances = instances
        self.type_settings_range_type = type_settings_range_type
        self.number_of_occurrences = number_of_occurrences
        self.start_date = start_date
        self.end_date = end_date
        self.type_settings_pattern_type = type_settings_pattern_type
        self.interval = interval
        self.principal_id: Optional[str] = None
        self.principal_type: Optional[Union[str, "_models.AccessReviewActorIdentityType"]] = None
        self.principal_name: Optional[str] = None
        self.user_principal_name: Optional[str] = None


class AccessReviewHistoryInstance(_serialization.Model):
    """Access Review History Definition Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The access review history definition instance id.
    :vartype id: str
    :ivar name: The access review history definition instance unique id.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar review_history_period_start_date_time: Date time used when selecting review data, all
     reviews included in data start on or after this date. For use only with one-time/non-recurring
     reports.
    :vartype review_history_period_start_date_time: ~datetime.datetime
    :ivar review_history_period_end_date_time: Date time used when selecting review data, all
     reviews included in data end on or before this date. For use only with one-time/non-recurring
     reports.
    :vartype review_history_period_end_date_time: ~datetime.datetime
    :ivar display_name: The display name for the parent history definition.
    :vartype display_name: str
    :ivar status: Status of the requested review history instance data. This is either requested,
     in-progress, done or error. The state transitions are as follows - Requested -> InProgress ->
     Done -> Expired. Known values are: "Requested", "InProgress", "Done", and "Error".
    :vartype status: str or ~azure.mgmt.authorization.models.AccessReviewHistoryDefinitionStatus
    :ivar run_date_time: Date time when the history data report is scheduled to be generated.
    :vartype run_date_time: ~datetime.datetime
    :ivar fulfilled_date_time: Date time when the history data report is scheduled to be generated.
    :vartype fulfilled_date_time: ~datetime.datetime
    :ivar download_uri: Uri which can be used to retrieve review history data. To generate this
     Uri, generateDownloadUri() must be called for a specific accessReviewHistoryDefinitionInstance.
     The link expires after a 24 hour period. Callers can see the expiration date time by looking at
     the 'se' parameter in the generated uri.
    :vartype download_uri: str
    :ivar expiration: Date time when history data report expires and the associated data is
     deleted.
    :vartype expiration: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "status": {"readonly": True},
        "download_uri": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "review_history_period_start_date_time": {
            "key": "properties.reviewHistoryPeriodStartDateTime",
            "type": "iso-8601",
        },
        "review_history_period_end_date_time": {"key": "properties.reviewHistoryPeriodEndDateTime", "type": "iso-8601"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "run_date_time": {"key": "properties.runDateTime", "type": "iso-8601"},
        "fulfilled_date_time": {"key": "properties.fulfilledDateTime", "type": "iso-8601"},
        "download_uri": {"key": "properties.downloadUri", "type": "str"},
        "expiration": {"key": "properties.expiration", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        review_history_period_start_date_time: Optional[datetime.datetime] = None,
        review_history_period_end_date_time: Optional[datetime.datetime] = None,
        display_name: Optional[str] = None,
        run_date_time: Optional[datetime.datetime] = None,
        fulfilled_date_time: Optional[datetime.datetime] = None,
        expiration: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword review_history_period_start_date_time: Date time used when selecting review data, all
         reviews included in data start on or after this date. For use only with one-time/non-recurring
         reports.
        :paramtype review_history_period_start_date_time: ~datetime.datetime
        :keyword review_history_period_end_date_time: Date time used when selecting review data, all
         reviews included in data end on or before this date. For use only with one-time/non-recurring
         reports.
        :paramtype review_history_period_end_date_time: ~datetime.datetime
        :keyword display_name: The display name for the parent history definition.
        :paramtype display_name: str
        :keyword run_date_time: Date time when the history data report is scheduled to be generated.
        :paramtype run_date_time: ~datetime.datetime
        :keyword fulfilled_date_time: Date time when the history data report is scheduled to be
         generated.
        :paramtype fulfilled_date_time: ~datetime.datetime
        :keyword expiration: Date time when history data report expires and the associated data is
         deleted.
        :paramtype expiration: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.review_history_period_start_date_time = review_history_period_start_date_time
        self.review_history_period_end_date_time = review_history_period_end_date_time
        self.display_name = display_name
        self.status: Optional[Union[str, "_models.AccessReviewHistoryDefinitionStatus"]] = None
        self.run_date_time = run_date_time
        self.fulfilled_date_time = fulfilled_date_time
        self.download_uri: Optional[str] = None
        self.expiration = expiration


class AccessReviewInstance(_serialization.Model):
    """Access Review Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The access review instance id.
    :vartype id: str
    :ivar name: The access review instance name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar status: This read-only field specifies the status of an access review instance. Known
     values are: "NotStarted", "InProgress", "Completed", "Applied", "Initializing", "Applying",
     "Completing", "Scheduled", "AutoReviewing", "AutoReviewed", and "Starting".
    :vartype status: str or ~azure.mgmt.authorization.models.AccessReviewInstanceStatus
    :ivar start_date_time: The DateTime when the review instance is scheduled to be start.
    :vartype start_date_time: ~datetime.datetime
    :ivar end_date_time: The DateTime when the review instance is scheduled to end.
    :vartype end_date_time: ~datetime.datetime
    :ivar reviewers: This is the collection of reviewers.
    :vartype reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
    :ivar backup_reviewers: This is the collection of backup reviewers.
    :vartype backup_reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
    :ivar reviewers_type: This field specifies the type of reviewers for a review. Usually for a
     review, reviewers are explicitly assigned. However, in some cases, the reviewers may not be
     assigned and instead be chosen dynamically. For example managers review or self review. Known
     values are: "Assigned", "Self", and "Managers".
    :vartype reviewers_type: str or
     ~azure.mgmt.authorization.models.AccessReviewInstanceReviewersType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "status": {"readonly": True},
        "reviewers_type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "start_date_time": {"key": "properties.startDateTime", "type": "iso-8601"},
        "end_date_time": {"key": "properties.endDateTime", "type": "iso-8601"},
        "reviewers": {"key": "properties.reviewers", "type": "[AccessReviewReviewer]"},
        "backup_reviewers": {"key": "properties.backupReviewers", "type": "[AccessReviewReviewer]"},
        "reviewers_type": {"key": "properties.reviewersType", "type": "str"},
    }

    def __init__(
        self,
        *,
        start_date_time: Optional[datetime.datetime] = None,
        end_date_time: Optional[datetime.datetime] = None,
        reviewers: Optional[List["_models.AccessReviewReviewer"]] = None,
        backup_reviewers: Optional[List["_models.AccessReviewReviewer"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_date_time: The DateTime when the review instance is scheduled to be start.
        :paramtype start_date_time: ~datetime.datetime
        :keyword end_date_time: The DateTime when the review instance is scheduled to end.
        :paramtype end_date_time: ~datetime.datetime
        :keyword reviewers: This is the collection of reviewers.
        :paramtype reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
        :keyword backup_reviewers: This is the collection of backup reviewers.
        :paramtype backup_reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.status: Optional[Union[str, "_models.AccessReviewInstanceStatus"]] = None
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.reviewers = reviewers
        self.backup_reviewers = backup_reviewers
        self.reviewers_type: Optional[Union[str, "_models.AccessReviewInstanceReviewersType"]] = None


class AccessReviewInstanceListResult(_serialization.Model):
    """List of Access Review Instances.

    :ivar value: Access Review Instance list.
    :vartype value: list[~azure.mgmt.authorization.models.AccessReviewInstance]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AccessReviewInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AccessReviewInstance"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Access Review Instance list.
        :paramtype value: list[~azure.mgmt.authorization.models.AccessReviewInstance]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AccessReviewInstanceProperties(_serialization.Model):
    """Access Review Instance properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: This read-only field specifies the status of an access review instance. Known
     values are: "NotStarted", "InProgress", "Completed", "Applied", "Initializing", "Applying",
     "Completing", "Scheduled", "AutoReviewing", "AutoReviewed", and "Starting".
    :vartype status: str or ~azure.mgmt.authorization.models.AccessReviewInstanceStatus
    :ivar start_date_time: The DateTime when the review instance is scheduled to be start.
    :vartype start_date_time: ~datetime.datetime
    :ivar end_date_time: The DateTime when the review instance is scheduled to end.
    :vartype end_date_time: ~datetime.datetime
    :ivar reviewers: This is the collection of reviewers.
    :vartype reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
    :ivar backup_reviewers: This is the collection of backup reviewers.
    :vartype backup_reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
    :ivar reviewers_type: This field specifies the type of reviewers for a review. Usually for a
     review, reviewers are explicitly assigned. However, in some cases, the reviewers may not be
     assigned and instead be chosen dynamically. For example managers review or self review. Known
     values are: "Assigned", "Self", and "Managers".
    :vartype reviewers_type: str or
     ~azure.mgmt.authorization.models.AccessReviewInstanceReviewersType
    """

    _validation = {
        "status": {"readonly": True},
        "reviewers_type": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "start_date_time": {"key": "startDateTime", "type": "iso-8601"},
        "end_date_time": {"key": "endDateTime", "type": "iso-8601"},
        "reviewers": {"key": "reviewers", "type": "[AccessReviewReviewer]"},
        "backup_reviewers": {"key": "backupReviewers", "type": "[AccessReviewReviewer]"},
        "reviewers_type": {"key": "reviewersType", "type": "str"},
    }

    def __init__(
        self,
        *,
        start_date_time: Optional[datetime.datetime] = None,
        end_date_time: Optional[datetime.datetime] = None,
        reviewers: Optional[List["_models.AccessReviewReviewer"]] = None,
        backup_reviewers: Optional[List["_models.AccessReviewReviewer"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_date_time: The DateTime when the review instance is scheduled to be start.
        :paramtype start_date_time: ~datetime.datetime
        :keyword end_date_time: The DateTime when the review instance is scheduled to end.
        :paramtype end_date_time: ~datetime.datetime
        :keyword reviewers: This is the collection of reviewers.
        :paramtype reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
        :keyword backup_reviewers: This is the collection of backup reviewers.
        :paramtype backup_reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
        """
        super().__init__(**kwargs)
        self.status: Optional[Union[str, "_models.AccessReviewInstanceStatus"]] = None
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.reviewers = reviewers
        self.backup_reviewers = backup_reviewers
        self.reviewers_type: Optional[Union[str, "_models.AccessReviewInstanceReviewersType"]] = None


class AccessReviewReviewer(_serialization.Model):
    """Descriptor for what needs to be reviewed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The id of the reviewer(user/servicePrincipal).
    :vartype principal_id: str
    :ivar principal_type: The identity type : user/servicePrincipal. Known values are: "user" and
     "servicePrincipal".
    :vartype principal_type: str or ~azure.mgmt.authorization.models.AccessReviewReviewerType
    """

    _validation = {
        "principal_type": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "principal_type": {"key": "principalType", "type": "str"},
    }

    def __init__(self, *, principal_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword principal_id: The id of the reviewer(user/servicePrincipal).
        :paramtype principal_id: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.principal_type: Optional[Union[str, "_models.AccessReviewReviewerType"]] = None


class AccessReviewScheduleDefinition(_serialization.Model):
    """Access Review Schedule Definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The access review schedule definition id.
    :vartype id: str
    :ivar name: The access review schedule definition unique id.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar display_name: The display name for the schedule definition.
    :vartype display_name: str
    :ivar status: This read-only field specifies the status of an accessReview. Known values are:
     "NotStarted", "InProgress", "Completed", "Applied", "Initializing", "Applying", "Completing",
     "Scheduled", "AutoReviewing", "AutoReviewed", and "Starting".
    :vartype status: str or ~azure.mgmt.authorization.models.AccessReviewScheduleDefinitionStatus
    :ivar description_for_admins: The description provided by the access review creator and visible
     to admins.
    :vartype description_for_admins: str
    :ivar description_for_reviewers: The description provided by the access review creator to be
     shown to reviewers.
    :vartype description_for_reviewers: str
    :ivar reviewers: This is the collection of reviewers.
    :vartype reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
    :ivar backup_reviewers: This is the collection of backup reviewers.
    :vartype backup_reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
    :ivar reviewers_type: This field specifies the type of reviewers for a review. Usually for a
     review, reviewers are explicitly assigned. However, in some cases, the reviewers may not be
     assigned and instead be chosen dynamically. For example managers review or self review. Known
     values are: "Assigned", "Self", and "Managers".
    :vartype reviewers_type: str or
     ~azure.mgmt.authorization.models.AccessReviewScheduleDefinitionReviewersType
    :ivar instances: This is the collection of instances returned when one does an expand on it.
    :vartype instances: list[~azure.mgmt.authorization.models.AccessReviewInstance]
    :ivar resource_id: ResourceId in which this review is getting created.
    :vartype resource_id: str
    :ivar role_definition_id: This is used to indicate the role being reviewed.
    :vartype role_definition_id: str
    :ivar principal_type_properties_scope_principal_type: The identity type user/servicePrincipal
     to review. Known values are: "user", "guestUser", "servicePrincipal", "user,group", and
     "redeemedGuestUser".
    :vartype principal_type_properties_scope_principal_type: str or
     ~azure.mgmt.authorization.models.AccessReviewScopePrincipalType
    :ivar assignment_state: The role assignment state eligible/active to review. Known values are:
     "eligible" and "active".
    :vartype assignment_state: str or
     ~azure.mgmt.authorization.models.AccessReviewScopeAssignmentState
    :ivar inactive_duration: Duration users are inactive for. The value should be in ISO  8601
     format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert
     TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes,
     seconds)).
    :vartype inactive_duration: ~datetime.timedelta
    :ivar expand_nested_memberships: Flag to indicate whether to expand nested memberships or not.
    :vartype expand_nested_memberships: bool
    :ivar include_inherited_access: Flag to indicate whether to expand nested memberships or not.
    :vartype include_inherited_access: bool
    :ivar include_access_below_resource: Flag to indicate whether to expand nested memberships or
     not.
    :vartype include_access_below_resource: bool
    :ivar exclude_resource_id: This is used to indicate the resource id(s) to exclude.
    :vartype exclude_resource_id: str
    :ivar exclude_role_definition_id: This is used to indicate the role definition id(s) to
     exclude.
    :vartype exclude_role_definition_id: str
    :ivar mail_notifications_enabled: Flag to indicate whether sending mails to reviewers and the
     review creator is enabled.
    :vartype mail_notifications_enabled: bool
    :ivar reminder_notifications_enabled: Flag to indicate whether sending reminder emails to
     reviewers are enabled.
    :vartype reminder_notifications_enabled: bool
    :ivar default_decision_enabled: Flag to indicate whether reviewers are required to provide a
     justification when reviewing access.
    :vartype default_decision_enabled: bool
    :ivar justification_required_on_approval: Flag to indicate whether the reviewer is required to
     pass justification when recording a decision.
    :vartype justification_required_on_approval: bool
    :ivar default_decision: This specifies the behavior for the autoReview feature when an access
     review completes. Known values are: "Approve", "Deny", and "Recommendation".
    :vartype default_decision: str or ~azure.mgmt.authorization.models.DefaultDecisionType
    :ivar auto_apply_decisions_enabled: Flag to indicate whether auto-apply capability, to
     automatically change the target object access resource, is enabled. If not enabled, a user
     must, after the review completes, apply the access review.
    :vartype auto_apply_decisions_enabled: bool
    :ivar recommendations_enabled: Flag to indicate whether showing recommendations to reviewers is
     enabled.
    :vartype recommendations_enabled: bool
    :ivar recommendation_look_back_duration: Recommendations for access reviews are calculated by
     looking back at 30 days of data(w.r.t the start date of the review) by default. However, in
     some scenarios, customers want to change how far back to look at and want to configure 60 days,
     90 days, etc. instead. This setting allows customers to configure this duration. The value
     should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can
     be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours,
     minutes, seconds)).
    :vartype recommendation_look_back_duration: ~datetime.timedelta
    :ivar instance_duration_in_days: The duration in days for an instance.
    :vartype instance_duration_in_days: int
    :ivar type_properties_settings_recurrence_range_type: The recurrence range type. The possible
     values are: endDate, noEnd, numbered. Known values are: "endDate", "noEnd", and "numbered".
    :vartype type_properties_settings_recurrence_range_type: str or
     ~azure.mgmt.authorization.models.AccessReviewRecurrenceRangeType
    :ivar number_of_occurrences: The number of times to repeat the access review. Required and must
     be positive if type is numbered.
    :vartype number_of_occurrences: int
    :ivar start_date: The DateTime when the review is scheduled to be start. This could be a date
     in the future. Required on create.
    :vartype start_date: ~datetime.datetime
    :ivar end_date: The DateTime when the review is scheduled to end. Required if type is endDate.
    :vartype end_date: ~datetime.datetime
    :ivar type_properties_settings_recurrence_pattern_type: The recurrence type : weekly, monthly,
     etc. Known values are: "weekly" and "absoluteMonthly".
    :vartype type_properties_settings_recurrence_pattern_type: str or
     ~azure.mgmt.authorization.models.AccessReviewRecurrencePatternType
    :ivar interval: The interval for recurrence. For a quarterly review, the interval is 3 for type
     : absoluteMonthly.
    :vartype interval: int
    :ivar principal_id: The identity id.
    :vartype principal_id: str
    :ivar principal_type_properties_created_by_principal_type: The identity type :
     user/servicePrincipal. Known values are: "user" and "servicePrincipal".
    :vartype principal_type_properties_created_by_principal_type: str or
     ~azure.mgmt.authorization.models.AccessReviewActorIdentityType
    :ivar principal_name: The identity display name.
    :vartype principal_name: str
    :ivar user_principal_name: The user principal name(if valid).
    :vartype user_principal_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "status": {"readonly": True},
        "reviewers_type": {"readonly": True},
        "resource_id": {"readonly": True},
        "role_definition_id": {"readonly": True},
        "principal_type_properties_scope_principal_type": {"readonly": True},
        "assignment_state": {"readonly": True},
        "principal_id": {"readonly": True},
        "principal_type_properties_created_by_principal_type": {"readonly": True},
        "principal_name": {"readonly": True},
        "user_principal_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "description_for_admins": {"key": "properties.descriptionForAdmins", "type": "str"},
        "description_for_reviewers": {"key": "properties.descriptionForReviewers", "type": "str"},
        "reviewers": {"key": "properties.reviewers", "type": "[AccessReviewReviewer]"},
        "backup_reviewers": {"key": "properties.backupReviewers", "type": "[AccessReviewReviewer]"},
        "reviewers_type": {"key": "properties.reviewersType", "type": "str"},
        "instances": {"key": "properties.instances", "type": "[AccessReviewInstance]"},
        "resource_id": {"key": "properties.scope.resourceId", "type": "str"},
        "role_definition_id": {"key": "properties.scope.roleDefinitionId", "type": "str"},
        "principal_type_properties_scope_principal_type": {"key": "properties.scope.principalType", "type": "str"},
        "assignment_state": {"key": "properties.scope.assignmentState", "type": "str"},
        "inactive_duration": {"key": "properties.scope.inactiveDuration", "type": "duration"},
        "expand_nested_memberships": {"key": "properties.scope.expandNestedMemberships", "type": "bool"},
        "include_inherited_access": {"key": "properties.scope.includeInheritedAccess", "type": "bool"},
        "include_access_below_resource": {"key": "properties.scope.includeAccessBelowResource", "type": "bool"},
        "exclude_resource_id": {"key": "properties.scope.excludeResourceId", "type": "str"},
        "exclude_role_definition_id": {"key": "properties.scope.excludeRoleDefinitionId", "type": "str"},
        "mail_notifications_enabled": {"key": "properties.settings.mailNotificationsEnabled", "type": "bool"},
        "reminder_notifications_enabled": {"key": "properties.settings.reminderNotificationsEnabled", "type": "bool"},
        "default_decision_enabled": {"key": "properties.settings.defaultDecisionEnabled", "type": "bool"},
        "justification_required_on_approval": {
            "key": "properties.settings.justificationRequiredOnApproval",
            "type": "bool",
        },
        "default_decision": {"key": "properties.settings.defaultDecision", "type": "str"},
        "auto_apply_decisions_enabled": {"key": "properties.settings.autoApplyDecisionsEnabled", "type": "bool"},
        "recommendations_enabled": {"key": "properties.settings.recommendationsEnabled", "type": "bool"},
        "recommendation_look_back_duration": {
            "key": "properties.settings.recommendationLookBackDuration",
            "type": "duration",
        },
        "instance_duration_in_days": {"key": "properties.settings.instanceDurationInDays", "type": "int"},
        "type_properties_settings_recurrence_range_type": {
            "key": "properties.settings.recurrence.range.type",
            "type": "str",
        },
        "number_of_occurrences": {"key": "properties.settings.recurrence.range.numberOfOccurrences", "type": "int"},
        "start_date": {"key": "properties.settings.recurrence.range.startDate", "type": "iso-8601"},
        "end_date": {"key": "properties.settings.recurrence.range.endDate", "type": "iso-8601"},
        "type_properties_settings_recurrence_pattern_type": {
            "key": "properties.settings.recurrence.pattern.type",
            "type": "str",
        },
        "interval": {"key": "properties.settings.recurrence.pattern.interval", "type": "int"},
        "principal_id": {"key": "properties.createdBy.principalId", "type": "str"},
        "principal_type_properties_created_by_principal_type": {
            "key": "properties.createdBy.principalType",
            "type": "str",
        },
        "principal_name": {"key": "properties.createdBy.principalName", "type": "str"},
        "user_principal_name": {"key": "properties.createdBy.userPrincipalName", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        display_name: Optional[str] = None,
        description_for_admins: Optional[str] = None,
        description_for_reviewers: Optional[str] = None,
        reviewers: Optional[List["_models.AccessReviewReviewer"]] = None,
        backup_reviewers: Optional[List["_models.AccessReviewReviewer"]] = None,
        instances: Optional[List["_models.AccessReviewInstance"]] = None,
        inactive_duration: Optional[datetime.timedelta] = None,
        expand_nested_memberships: Optional[bool] = None,
        include_inherited_access: Optional[bool] = None,
        include_access_below_resource: Optional[bool] = None,
        exclude_resource_id: Optional[str] = None,
        exclude_role_definition_id: Optional[str] = None,
        mail_notifications_enabled: Optional[bool] = None,
        reminder_notifications_enabled: Optional[bool] = None,
        default_decision_enabled: Optional[bool] = None,
        justification_required_on_approval: Optional[bool] = None,
        default_decision: Optional[Union[str, "_models.DefaultDecisionType"]] = None,
        auto_apply_decisions_enabled: Optional[bool] = None,
        recommendations_enabled: Optional[bool] = None,
        recommendation_look_back_duration: Optional[datetime.timedelta] = None,
        instance_duration_in_days: Optional[int] = None,
        type_properties_settings_recurrence_range_type: Optional[
            Union[str, "_models.AccessReviewRecurrenceRangeType"]
        ] = None,
        number_of_occurrences: Optional[int] = None,
        start_date: Optional[datetime.datetime] = None,
        end_date: Optional[datetime.datetime] = None,
        type_properties_settings_recurrence_pattern_type: Optional[
            Union[str, "_models.AccessReviewRecurrencePatternType"]
        ] = None,
        interval: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: The display name for the schedule definition.
        :paramtype display_name: str
        :keyword description_for_admins: The description provided by the access review creator and
         visible to admins.
        :paramtype description_for_admins: str
        :keyword description_for_reviewers: The description provided by the access review creator to be
         shown to reviewers.
        :paramtype description_for_reviewers: str
        :keyword reviewers: This is the collection of reviewers.
        :paramtype reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
        :keyword backup_reviewers: This is the collection of backup reviewers.
        :paramtype backup_reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
        :keyword instances: This is the collection of instances returned when one does an expand on it.
        :paramtype instances: list[~azure.mgmt.authorization.models.AccessReviewInstance]
        :keyword inactive_duration: Duration users are inactive for. The value should be in ISO  8601
         format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert
         TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes,
         seconds)).
        :paramtype inactive_duration: ~datetime.timedelta
        :keyword expand_nested_memberships: Flag to indicate whether to expand nested memberships or
         not.
        :paramtype expand_nested_memberships: bool
        :keyword include_inherited_access: Flag to indicate whether to expand nested memberships or
         not.
        :paramtype include_inherited_access: bool
        :keyword include_access_below_resource: Flag to indicate whether to expand nested memberships
         or not.
        :paramtype include_access_below_resource: bool
        :keyword exclude_resource_id: This is used to indicate the resource id(s) to exclude.
        :paramtype exclude_resource_id: str
        :keyword exclude_role_definition_id: This is used to indicate the role definition id(s) to
         exclude.
        :paramtype exclude_role_definition_id: str
        :keyword mail_notifications_enabled: Flag to indicate whether sending mails to reviewers and
         the review creator is enabled.
        :paramtype mail_notifications_enabled: bool
        :keyword reminder_notifications_enabled: Flag to indicate whether sending reminder emails to
         reviewers are enabled.
        :paramtype reminder_notifications_enabled: bool
        :keyword default_decision_enabled: Flag to indicate whether reviewers are required to provide a
         justification when reviewing access.
        :paramtype default_decision_enabled: bool
        :keyword justification_required_on_approval: Flag to indicate whether the reviewer is required
         to pass justification when recording a decision.
        :paramtype justification_required_on_approval: bool
        :keyword default_decision: This specifies the behavior for the autoReview feature when an
         access review completes. Known values are: "Approve", "Deny", and "Recommendation".
        :paramtype default_decision: str or ~azure.mgmt.authorization.models.DefaultDecisionType
        :keyword auto_apply_decisions_enabled: Flag to indicate whether auto-apply capability, to
         automatically change the target object access resource, is enabled. If not enabled, a user
         must, after the review completes, apply the access review.
        :paramtype auto_apply_decisions_enabled: bool
        :keyword recommendations_enabled: Flag to indicate whether showing recommendations to reviewers
         is enabled.
        :paramtype recommendations_enabled: bool
        :keyword recommendation_look_back_duration: Recommendations for access reviews are calculated
         by looking back at 30 days of data(w.r.t the start date of the review) by default. However, in
         some scenarios, customers want to change how far back to look at and want to configure 60 days,
         90 days, etc. instead. This setting allows customers to configure this duration. The value
         should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can
         be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours,
         minutes, seconds)).
        :paramtype recommendation_look_back_duration: ~datetime.timedelta
        :keyword instance_duration_in_days: The duration in days for an instance.
        :paramtype instance_duration_in_days: int
        :keyword type_properties_settings_recurrence_range_type: The recurrence range type. The
         possible values are: endDate, noEnd, numbered. Known values are: "endDate", "noEnd", and
         "numbered".
        :paramtype type_properties_settings_recurrence_range_type: str or
         ~azure.mgmt.authorization.models.AccessReviewRecurrenceRangeType
        :keyword number_of_occurrences: The number of times to repeat the access review. Required and
         must be positive if type is numbered.
        :paramtype number_of_occurrences: int
        :keyword start_date: The DateTime when the review is scheduled to be start. This could be a
         date in the future. Required on create.
        :paramtype start_date: ~datetime.datetime
        :keyword end_date: The DateTime when the review is scheduled to end. Required if type is
         endDate.
        :paramtype end_date: ~datetime.datetime
        :keyword type_properties_settings_recurrence_pattern_type: The recurrence type : weekly,
         monthly, etc. Known values are: "weekly" and "absoluteMonthly".
        :paramtype type_properties_settings_recurrence_pattern_type: str or
         ~azure.mgmt.authorization.models.AccessReviewRecurrencePatternType
        :keyword interval: The interval for recurrence. For a quarterly review, the interval is 3 for
         type : absoluteMonthly.
        :paramtype interval: int
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.display_name = display_name
        self.status: Optional[Union[str, "_models.AccessReviewScheduleDefinitionStatus"]] = None
        self.description_for_admins = description_for_admins
        self.description_for_reviewers = description_for_reviewers
        self.reviewers = reviewers
        self.backup_reviewers = backup_reviewers
        self.reviewers_type: Optional[Union[str, "_models.AccessReviewScheduleDefinitionReviewersType"]] = None
        self.instances = instances
        self.resource_id: Optional[str] = None
        self.role_definition_id: Optional[str] = None
        self.principal_type_properties_scope_principal_type: Optional[
            Union[str, "_models.AccessReviewScopePrincipalType"]
        ] = None
        self.assignment_state: Optional[Union[str, "_models.AccessReviewScopeAssignmentState"]] = None
        self.inactive_duration = inactive_duration
        self.expand_nested_memberships = expand_nested_memberships
        self.include_inherited_access = include_inherited_access
        self.include_access_below_resource = include_access_below_resource
        self.exclude_resource_id = exclude_resource_id
        self.exclude_role_definition_id = exclude_role_definition_id
        self.mail_notifications_enabled = mail_notifications_enabled
        self.reminder_notifications_enabled = reminder_notifications_enabled
        self.default_decision_enabled = default_decision_enabled
        self.justification_required_on_approval = justification_required_on_approval
        self.default_decision = default_decision
        self.auto_apply_decisions_enabled = auto_apply_decisions_enabled
        self.recommendations_enabled = recommendations_enabled
        self.recommendation_look_back_duration = recommendation_look_back_duration
        self.instance_duration_in_days = instance_duration_in_days
        self.type_properties_settings_recurrence_range_type = type_properties_settings_recurrence_range_type
        self.number_of_occurrences = number_of_occurrences
        self.start_date = start_date
        self.end_date = end_date
        self.type_properties_settings_recurrence_pattern_type = type_properties_settings_recurrence_pattern_type
        self.interval = interval
        self.principal_id: Optional[str] = None
        self.principal_type_properties_created_by_principal_type: Optional[
            Union[str, "_models.AccessReviewActorIdentityType"]
        ] = None
        self.principal_name: Optional[str] = None
        self.user_principal_name: Optional[str] = None


class AccessReviewScheduleDefinitionListResult(_serialization.Model):
    """List of Access Review Schedule Definitions.

    :ivar value: Access Review Schedule Definition list.
    :vartype value: list[~azure.mgmt.authorization.models.AccessReviewScheduleDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AccessReviewScheduleDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AccessReviewScheduleDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Access Review Schedule Definition list.
        :paramtype value: list[~azure.mgmt.authorization.models.AccessReviewScheduleDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AccessReviewScheduleDefinitionProperties(_serialization.Model):
    """Access Review.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: The display name for the schedule definition.
    :vartype display_name: str
    :ivar status: This read-only field specifies the status of an accessReview. Known values are:
     "NotStarted", "InProgress", "Completed", "Applied", "Initializing", "Applying", "Completing",
     "Scheduled", "AutoReviewing", "AutoReviewed", and "Starting".
    :vartype status: str or ~azure.mgmt.authorization.models.AccessReviewScheduleDefinitionStatus
    :ivar description_for_admins: The description provided by the access review creator and visible
     to admins.
    :vartype description_for_admins: str
    :ivar description_for_reviewers: The description provided by the access review creator to be
     shown to reviewers.
    :vartype description_for_reviewers: str
    :ivar reviewers: This is the collection of reviewers.
    :vartype reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
    :ivar backup_reviewers: This is the collection of backup reviewers.
    :vartype backup_reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
    :ivar reviewers_type: This field specifies the type of reviewers for a review. Usually for a
     review, reviewers are explicitly assigned. However, in some cases, the reviewers may not be
     assigned and instead be chosen dynamically. For example managers review or self review. Known
     values are: "Assigned", "Self", and "Managers".
    :vartype reviewers_type: str or
     ~azure.mgmt.authorization.models.AccessReviewScheduleDefinitionReviewersType
    :ivar instances: This is the collection of instances returned when one does an expand on it.
    :vartype instances: list[~azure.mgmt.authorization.models.AccessReviewInstance]
    :ivar resource_id: ResourceId in which this review is getting created.
    :vartype resource_id: str
    :ivar role_definition_id: This is used to indicate the role being reviewed.
    :vartype role_definition_id: str
    :ivar principal_type_scope_principal_type: The identity type user/servicePrincipal to review.
     Known values are: "user", "guestUser", "servicePrincipal", "user,group", and
     "redeemedGuestUser".
    :vartype principal_type_scope_principal_type: str or
     ~azure.mgmt.authorization.models.AccessReviewScopePrincipalType
    :ivar assignment_state: The role assignment state eligible/active to review. Known values are:
     "eligible" and "active".
    :vartype assignment_state: str or
     ~azure.mgmt.authorization.models.AccessReviewScopeAssignmentState
    :ivar inactive_duration: Duration users are inactive for. The value should be in ISO  8601
     format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert
     TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes,
     seconds)).
    :vartype inactive_duration: ~datetime.timedelta
    :ivar expand_nested_memberships: Flag to indicate whether to expand nested memberships or not.
    :vartype expand_nested_memberships: bool
    :ivar include_inherited_access: Flag to indicate whether to expand nested memberships or not.
    :vartype include_inherited_access: bool
    :ivar include_access_below_resource: Flag to indicate whether to expand nested memberships or
     not.
    :vartype include_access_below_resource: bool
    :ivar exclude_resource_id: This is used to indicate the resource id(s) to exclude.
    :vartype exclude_resource_id: str
    :ivar exclude_role_definition_id: This is used to indicate the role definition id(s) to
     exclude.
    :vartype exclude_role_definition_id: str
    :ivar mail_notifications_enabled: Flag to indicate whether sending mails to reviewers and the
     review creator is enabled.
    :vartype mail_notifications_enabled: bool
    :ivar reminder_notifications_enabled: Flag to indicate whether sending reminder emails to
     reviewers are enabled.
    :vartype reminder_notifications_enabled: bool
    :ivar default_decision_enabled: Flag to indicate whether reviewers are required to provide a
     justification when reviewing access.
    :vartype default_decision_enabled: bool
    :ivar justification_required_on_approval: Flag to indicate whether the reviewer is required to
     pass justification when recording a decision.
    :vartype justification_required_on_approval: bool
    :ivar default_decision: This specifies the behavior for the autoReview feature when an access
     review completes. Known values are: "Approve", "Deny", and "Recommendation".
    :vartype default_decision: str or ~azure.mgmt.authorization.models.DefaultDecisionType
    :ivar auto_apply_decisions_enabled: Flag to indicate whether auto-apply capability, to
     automatically change the target object access resource, is enabled. If not enabled, a user
     must, after the review completes, apply the access review.
    :vartype auto_apply_decisions_enabled: bool
    :ivar recommendations_enabled: Flag to indicate whether showing recommendations to reviewers is
     enabled.
    :vartype recommendations_enabled: bool
    :ivar recommendation_look_back_duration: Recommendations for access reviews are calculated by
     looking back at 30 days of data(w.r.t the start date of the review) by default. However, in
     some scenarios, customers want to change how far back to look at and want to configure 60 days,
     90 days, etc. instead. This setting allows customers to configure this duration. The value
     should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can
     be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours,
     minutes, seconds)).
    :vartype recommendation_look_back_duration: ~datetime.timedelta
    :ivar instance_duration_in_days: The duration in days for an instance.
    :vartype instance_duration_in_days: int
    :ivar type_settings_recurrence_range_type: The recurrence range type. The possible values are:
     endDate, noEnd, numbered. Known values are: "endDate", "noEnd", and "numbered".
    :vartype type_settings_recurrence_range_type: str or
     ~azure.mgmt.authorization.models.AccessReviewRecurrenceRangeType
    :ivar number_of_occurrences: The number of times to repeat the access review. Required and must
     be positive if type is numbered.
    :vartype number_of_occurrences: int
    :ivar start_date: The DateTime when the review is scheduled to be start. This could be a date
     in the future. Required on create.
    :vartype start_date: ~datetime.datetime
    :ivar end_date: The DateTime when the review is scheduled to end. Required if type is endDate.
    :vartype end_date: ~datetime.datetime
    :ivar type_settings_recurrence_pattern_type: The recurrence type : weekly, monthly, etc. Known
     values are: "weekly" and "absoluteMonthly".
    :vartype type_settings_recurrence_pattern_type: str or
     ~azure.mgmt.authorization.models.AccessReviewRecurrencePatternType
    :ivar interval: The interval for recurrence. For a quarterly review, the interval is 3 for type
     : absoluteMonthly.
    :vartype interval: int
    :ivar principal_id: The identity id.
    :vartype principal_id: str
    :ivar principal_type_created_by_principal_type: The identity type : user/servicePrincipal.
     Known values are: "user" and "servicePrincipal".
    :vartype principal_type_created_by_principal_type: str or
     ~azure.mgmt.authorization.models.AccessReviewActorIdentityType
    :ivar principal_name: The identity display name.
    :vartype principal_name: str
    :ivar user_principal_name: The user principal name(if valid).
    :vartype user_principal_name: str
    """

    _validation = {
        "status": {"readonly": True},
        "reviewers_type": {"readonly": True},
        "resource_id": {"readonly": True},
        "role_definition_id": {"readonly": True},
        "principal_type_scope_principal_type": {"readonly": True},
        "assignment_state": {"readonly": True},
        "principal_id": {"readonly": True},
        "principal_type_created_by_principal_type": {"readonly": True},
        "principal_name": {"readonly": True},
        "user_principal_name": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "description_for_admins": {"key": "descriptionForAdmins", "type": "str"},
        "description_for_reviewers": {"key": "descriptionForReviewers", "type": "str"},
        "reviewers": {"key": "reviewers", "type": "[AccessReviewReviewer]"},
        "backup_reviewers": {"key": "backupReviewers", "type": "[AccessReviewReviewer]"},
        "reviewers_type": {"key": "reviewersType", "type": "str"},
        "instances": {"key": "instances", "type": "[AccessReviewInstance]"},
        "resource_id": {"key": "scope.resourceId", "type": "str"},
        "role_definition_id": {"key": "scope.roleDefinitionId", "type": "str"},
        "principal_type_scope_principal_type": {"key": "scope.principalType", "type": "str"},
        "assignment_state": {"key": "scope.assignmentState", "type": "str"},
        "inactive_duration": {"key": "scope.inactiveDuration", "type": "duration"},
        "expand_nested_memberships": {"key": "scope.expandNestedMemberships", "type": "bool"},
        "include_inherited_access": {"key": "scope.includeInheritedAccess", "type": "bool"},
        "include_access_below_resource": {"key": "scope.includeAccessBelowResource", "type": "bool"},
        "exclude_resource_id": {"key": "scope.excludeResourceId", "type": "str"},
        "exclude_role_definition_id": {"key": "scope.excludeRoleDefinitionId", "type": "str"},
        "mail_notifications_enabled": {"key": "settings.mailNotificationsEnabled", "type": "bool"},
        "reminder_notifications_enabled": {"key": "settings.reminderNotificationsEnabled", "type": "bool"},
        "default_decision_enabled": {"key": "settings.defaultDecisionEnabled", "type": "bool"},
        "justification_required_on_approval": {"key": "settings.justificationRequiredOnApproval", "type": "bool"},
        "default_decision": {"key": "settings.defaultDecision", "type": "str"},
        "auto_apply_decisions_enabled": {"key": "settings.autoApplyDecisionsEnabled", "type": "bool"},
        "recommendations_enabled": {"key": "settings.recommendationsEnabled", "type": "bool"},
        "recommendation_look_back_duration": {"key": "settings.recommendationLookBackDuration", "type": "duration"},
        "instance_duration_in_days": {"key": "settings.instanceDurationInDays", "type": "int"},
        "type_settings_recurrence_range_type": {"key": "settings.recurrence.range.type", "type": "str"},
        "number_of_occurrences": {"key": "settings.recurrence.range.numberOfOccurrences", "type": "int"},
        "start_date": {"key": "settings.recurrence.range.startDate", "type": "iso-8601"},
        "end_date": {"key": "settings.recurrence.range.endDate", "type": "iso-8601"},
        "type_settings_recurrence_pattern_type": {"key": "settings.recurrence.pattern.type", "type": "str"},
        "interval": {"key": "settings.recurrence.pattern.interval", "type": "int"},
        "principal_id": {"key": "createdBy.principalId", "type": "str"},
        "principal_type_created_by_principal_type": {"key": "createdBy.principalType", "type": "str"},
        "principal_name": {"key": "createdBy.principalName", "type": "str"},
        "user_principal_name": {"key": "createdBy.userPrincipalName", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        display_name: Optional[str] = None,
        description_for_admins: Optional[str] = None,
        description_for_reviewers: Optional[str] = None,
        reviewers: Optional[List["_models.AccessReviewReviewer"]] = None,
        backup_reviewers: Optional[List["_models.AccessReviewReviewer"]] = None,
        instances: Optional[List["_models.AccessReviewInstance"]] = None,
        inactive_duration: Optional[datetime.timedelta] = None,
        expand_nested_memberships: Optional[bool] = None,
        include_inherited_access: Optional[bool] = None,
        include_access_below_resource: Optional[bool] = None,
        exclude_resource_id: Optional[str] = None,
        exclude_role_definition_id: Optional[str] = None,
        mail_notifications_enabled: Optional[bool] = None,
        reminder_notifications_enabled: Optional[bool] = None,
        default_decision_enabled: Optional[bool] = None,
        justification_required_on_approval: Optional[bool] = None,
        default_decision: Optional[Union[str, "_models.DefaultDecisionType"]] = None,
        auto_apply_decisions_enabled: Optional[bool] = None,
        recommendations_enabled: Optional[bool] = None,
        recommendation_look_back_duration: Optional[datetime.timedelta] = None,
        instance_duration_in_days: Optional[int] = None,
        type_settings_recurrence_range_type: Optional[Union[str, "_models.AccessReviewRecurrenceRangeType"]] = None,
        number_of_occurrences: Optional[int] = None,
        start_date: Optional[datetime.datetime] = None,
        end_date: Optional[datetime.datetime] = None,
        type_settings_recurrence_pattern_type: Optional[Union[str, "_models.AccessReviewRecurrencePatternType"]] = None,
        interval: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: The display name for the schedule definition.
        :paramtype display_name: str
        :keyword description_for_admins: The description provided by the access review creator and
         visible to admins.
        :paramtype description_for_admins: str
        :keyword description_for_reviewers: The description provided by the access review creator to be
         shown to reviewers.
        :paramtype description_for_reviewers: str
        :keyword reviewers: This is the collection of reviewers.
        :paramtype reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
        :keyword backup_reviewers: This is the collection of backup reviewers.
        :paramtype backup_reviewers: list[~azure.mgmt.authorization.models.AccessReviewReviewer]
        :keyword instances: This is the collection of instances returned when one does an expand on it.
        :paramtype instances: list[~azure.mgmt.authorization.models.AccessReviewInstance]
        :keyword inactive_duration: Duration users are inactive for. The value should be in ISO  8601
         format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert
         TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes,
         seconds)).
        :paramtype inactive_duration: ~datetime.timedelta
        :keyword expand_nested_memberships: Flag to indicate whether to expand nested memberships or
         not.
        :paramtype expand_nested_memberships: bool
        :keyword include_inherited_access: Flag to indicate whether to expand nested memberships or
         not.
        :paramtype include_inherited_access: bool
        :keyword include_access_below_resource: Flag to indicate whether to expand nested memberships
         or not.
        :paramtype include_access_below_resource: bool
        :keyword exclude_resource_id: This is used to indicate the resource id(s) to exclude.
        :paramtype exclude_resource_id: str
        :keyword exclude_role_definition_id: This is used to indicate the role definition id(s) to
         exclude.
        :paramtype exclude_role_definition_id: str
        :keyword mail_notifications_enabled: Flag to indicate whether sending mails to reviewers and
         the review creator is enabled.
        :paramtype mail_notifications_enabled: bool
        :keyword reminder_notifications_enabled: Flag to indicate whether sending reminder emails to
         reviewers are enabled.
        :paramtype reminder_notifications_enabled: bool
        :keyword default_decision_enabled: Flag to indicate whether reviewers are required to provide a
         justification when reviewing access.
        :paramtype default_decision_enabled: bool
        :keyword justification_required_on_approval: Flag to indicate whether the reviewer is required
         to pass justification when recording a decision.
        :paramtype justification_required_on_approval: bool
        :keyword default_decision: This specifies the behavior for the autoReview feature when an
         access review completes. Known values are: "Approve", "Deny", and "Recommendation".
        :paramtype default_decision: str or ~azure.mgmt.authorization.models.DefaultDecisionType
        :keyword auto_apply_decisions_enabled: Flag to indicate whether auto-apply capability, to
         automatically change the target object access resource, is enabled. If not enabled, a user
         must, after the review completes, apply the access review.
        :paramtype auto_apply_decisions_enabled: bool
        :keyword recommendations_enabled: Flag to indicate whether showing recommendations to reviewers
         is enabled.
        :paramtype recommendations_enabled: bool
        :keyword recommendation_look_back_duration: Recommendations for access reviews are calculated
         by looking back at 30 days of data(w.r.t the start date of the review) by default. However, in
         some scenarios, customers want to change how far back to look at and want to configure 60 days,
         90 days, etc. instead. This setting allows customers to configure this duration. The value
         should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can
         be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours,
         minutes, seconds)).
        :paramtype recommendation_look_back_duration: ~datetime.timedelta
        :keyword instance_duration_in_days: The duration in days for an instance.
        :paramtype instance_duration_in_days: int
        :keyword type_settings_recurrence_range_type: The recurrence range type. The possible values
         are: endDate, noEnd, numbered. Known values are: "endDate", "noEnd", and "numbered".
        :paramtype type_settings_recurrence_range_type: str or
         ~azure.mgmt.authorization.models.AccessReviewRecurrenceRangeType
        :keyword number_of_occurrences: The number of times to repeat the access review. Required and
         must be positive if type is numbered.
        :paramtype number_of_occurrences: int
        :keyword start_date: The DateTime when the review is scheduled to be start. This could be a
         date in the future. Required on create.
        :paramtype start_date: ~datetime.datetime
        :keyword end_date: The DateTime when the review is scheduled to end. Required if type is
         endDate.
        :paramtype end_date: ~datetime.datetime
        :keyword type_settings_recurrence_pattern_type: The recurrence type : weekly, monthly, etc.
         Known values are: "weekly" and "absoluteMonthly".
        :paramtype type_settings_recurrence_pattern_type: str or
         ~azure.mgmt.authorization.models.AccessReviewRecurrencePatternType
        :keyword interval: The interval for recurrence. For a quarterly review, the interval is 3 for
         type : absoluteMonthly.
        :paramtype interval: int
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.status: Optional[Union[str, "_models.AccessReviewScheduleDefinitionStatus"]] = None
        self.description_for_admins = description_for_admins
        self.description_for_reviewers = description_for_reviewers
        self.reviewers = reviewers
        self.backup_reviewers = backup_reviewers
        self.reviewers_type: Optional[Union[str, "_models.AccessReviewScheduleDefinitionReviewersType"]] = None
        self.instances = instances
        self.resource_id: Optional[str] = None
        self.role_definition_id: Optional[str] = None
        self.principal_type_scope_principal_type: Optional[Union[str, "_models.AccessReviewScopePrincipalType"]] = None
        self.assignment_state: Optional[Union[str, "_models.AccessReviewScopeAssignmentState"]] = None
        self.inactive_duration = inactive_duration
        self.expand_nested_memberships = expand_nested_memberships
        self.include_inherited_access = include_inherited_access
        self.include_access_below_resource = include_access_below_resource
        self.exclude_resource_id = exclude_resource_id
        self.exclude_role_definition_id = exclude_role_definition_id
        self.mail_notifications_enabled = mail_notifications_enabled
        self.reminder_notifications_enabled = reminder_notifications_enabled
        self.default_decision_enabled = default_decision_enabled
        self.justification_required_on_approval = justification_required_on_approval
        self.default_decision = default_decision
        self.auto_apply_decisions_enabled = auto_apply_decisions_enabled
        self.recommendations_enabled = recommendations_enabled
        self.recommendation_look_back_duration = recommendation_look_back_duration
        self.instance_duration_in_days = instance_duration_in_days
        self.type_settings_recurrence_range_type = type_settings_recurrence_range_type
        self.number_of_occurrences = number_of_occurrences
        self.start_date = start_date
        self.end_date = end_date
        self.type_settings_recurrence_pattern_type = type_settings_recurrence_pattern_type
        self.interval = interval
        self.principal_id: Optional[str] = None
        self.principal_type_created_by_principal_type: Optional[Union[str, "_models.AccessReviewActorIdentityType"]] = (
            None
        )
        self.principal_name: Optional[str] = None
        self.user_principal_name: Optional[str] = None


class AccessReviewScheduleSettings(_serialization.Model):
    """Settings of an Access Review.

    :ivar mail_notifications_enabled: Flag to indicate whether sending mails to reviewers and the
     review creator is enabled.
    :vartype mail_notifications_enabled: bool
    :ivar reminder_notifications_enabled: Flag to indicate whether sending reminder emails to
     reviewers are enabled.
    :vartype reminder_notifications_enabled: bool
    :ivar default_decision_enabled: Flag to indicate whether reviewers are required to provide a
     justification when reviewing access.
    :vartype default_decision_enabled: bool
    :ivar justification_required_on_approval: Flag to indicate whether the reviewer is required to
     pass justification when recording a decision.
    :vartype justification_required_on_approval: bool
    :ivar default_decision: This specifies the behavior for the autoReview feature when an access
     review completes. Known values are: "Approve", "Deny", and "Recommendation".
    :vartype default_decision: str or ~azure.mgmt.authorization.models.DefaultDecisionType
    :ivar auto_apply_decisions_enabled: Flag to indicate whether auto-apply capability, to
     automatically change the target object access resource, is enabled. If not enabled, a user
     must, after the review completes, apply the access review.
    :vartype auto_apply_decisions_enabled: bool
    :ivar recommendations_enabled: Flag to indicate whether showing recommendations to reviewers is
     enabled.
    :vartype recommendations_enabled: bool
    :ivar recommendation_look_back_duration: Recommendations for access reviews are calculated by
     looking back at 30 days of data(w.r.t the start date of the review) by default. However, in
     some scenarios, customers want to change how far back to look at and want to configure 60 days,
     90 days, etc. instead. This setting allows customers to configure this duration. The value
     should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can
     be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours,
     minutes, seconds)).
    :vartype recommendation_look_back_duration: ~datetime.timedelta
    :ivar instance_duration_in_days: The duration in days for an instance.
    :vartype instance_duration_in_days: int
    :ivar type_recurrence_range_type: The recurrence range type. The possible values are: endDate,
     noEnd, numbered. Known values are: "endDate", "noEnd", and "numbered".
    :vartype type_recurrence_range_type: str or
     ~azure.mgmt.authorization.models.AccessReviewRecurrenceRangeType
    :ivar number_of_occurrences: The number of times to repeat the access review. Required and must
     be positive if type is numbered.
    :vartype number_of_occurrences: int
    :ivar start_date: The DateTime when the review is scheduled to be start. This could be a date
     in the future. Required on create.
    :vartype start_date: ~datetime.datetime
    :ivar end_date: The DateTime when the review is scheduled to end. Required if type is endDate.
    :vartype end_date: ~datetime.datetime
    :ivar type_recurrence_pattern_type: The recurrence type : weekly, monthly, etc. Known values
     are: "weekly" and "absoluteMonthly".
    :vartype type_recurrence_pattern_type: str or
     ~azure.mgmt.authorization.models.AccessReviewRecurrencePatternType
    :ivar interval: The interval for recurrence. For a quarterly review, the interval is 3 for type
     : absoluteMonthly.
    :vartype interval: int
    """

    _attribute_map = {
        "mail_notifications_enabled": {"key": "mailNotificationsEnabled", "type": "bool"},
        "reminder_notifications_enabled": {"key": "reminderNotificationsEnabled", "type": "bool"},
        "default_decision_enabled": {"key": "defaultDecisionEnabled", "type": "bool"},
        "justification_required_on_approval": {"key": "justificationRequiredOnApproval", "type": "bool"},
        "default_decision": {"key": "defaultDecision", "type": "str"},
        "auto_apply_decisions_enabled": {"key": "autoApplyDecisionsEnabled", "type": "bool"},
        "recommendations_enabled": {"key": "recommendationsEnabled", "type": "bool"},
        "recommendation_look_back_duration": {"key": "recommendationLookBackDuration", "type": "duration"},
        "instance_duration_in_days": {"key": "instanceDurationInDays", "type": "int"},
        "type_recurrence_range_type": {"key": "recurrence.range.type", "type": "str"},
        "number_of_occurrences": {"key": "recurrence.range.numberOfOccurrences", "type": "int"},
        "start_date": {"key": "recurrence.range.startDate", "type": "iso-8601"},
        "end_date": {"key": "recurrence.range.endDate", "type": "iso-8601"},
        "type_recurrence_pattern_type": {"key": "recurrence.pattern.type", "type": "str"},
        "interval": {"key": "recurrence.pattern.interval", "type": "int"},
    }

    def __init__(
        self,
        *,
        mail_notifications_enabled: Optional[bool] = None,
        reminder_notifications_enabled: Optional[bool] = None,
        default_decision_enabled: Optional[bool] = None,
        justification_required_on_approval: Optional[bool] = None,
        default_decision: Optional[Union[str, "_models.DefaultDecisionType"]] = None,
        auto_apply_decisions_enabled: Optional[bool] = None,
        recommendations_enabled: Optional[bool] = None,
        recommendation_look_back_duration: Optional[datetime.timedelta] = None,
        instance_duration_in_days: Optional[int] = None,
        type_recurrence_range_type: Optional[Union[str, "_models.AccessReviewRecurrenceRangeType"]] = None,
        number_of_occurrences: Optional[int] = None,
        start_date: Optional[datetime.datetime] = None,
        end_date: Optional[datetime.datetime] = None,
        type_recurrence_pattern_type: Optional[Union[str, "_models.AccessReviewRecurrencePatternType"]] = None,
        interval: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mail_notifications_enabled: Flag to indicate whether sending mails to reviewers and
         the review creator is enabled.
        :paramtype mail_notifications_enabled: bool
        :keyword reminder_notifications_enabled: Flag to indicate whether sending reminder emails to
         reviewers are enabled.
        :paramtype reminder_notifications_enabled: bool
        :keyword default_decision_enabled: Flag to indicate whether reviewers are required to provide a
         justification when reviewing access.
        :paramtype default_decision_enabled: bool
        :keyword justification_required_on_approval: Flag to indicate whether the reviewer is required
         to pass justification when recording a decision.
        :paramtype justification_required_on_approval: bool
        :keyword default_decision: This specifies the behavior for the autoReview feature when an
         access review completes. Known values are: "Approve", "Deny", and "Recommendation".
        :paramtype default_decision: str or ~azure.mgmt.authorization.models.DefaultDecisionType
        :keyword auto_apply_decisions_enabled: Flag to indicate whether auto-apply capability, to
         automatically change the target object access resource, is enabled. If not enabled, a user
         must, after the review completes, apply the access review.
        :paramtype auto_apply_decisions_enabled: bool
        :keyword recommendations_enabled: Flag to indicate whether showing recommendations to reviewers
         is enabled.
        :paramtype recommendations_enabled: bool
        :keyword recommendation_look_back_duration: Recommendations for access reviews are calculated
         by looking back at 30 days of data(w.r.t the start date of the review) by default. However, in
         some scenarios, customers want to change how far back to look at and want to configure 60 days,
         90 days, etc. instead. This setting allows customers to configure this duration. The value
         should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can
         be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours,
         minutes, seconds)).
        :paramtype recommendation_look_back_duration: ~datetime.timedelta
        :keyword instance_duration_in_days: The duration in days for an instance.
        :paramtype instance_duration_in_days: int
        :keyword type_recurrence_range_type: The recurrence range type. The possible values are:
         endDate, noEnd, numbered. Known values are: "endDate", "noEnd", and "numbered".
        :paramtype type_recurrence_range_type: str or
         ~azure.mgmt.authorization.models.AccessReviewRecurrenceRangeType
        :keyword number_of_occurrences: The number of times to repeat the access review. Required and
         must be positive if type is numbered.
        :paramtype number_of_occurrences: int
        :keyword start_date: The DateTime when the review is scheduled to be start. This could be a
         date in the future. Required on create.
        :paramtype start_date: ~datetime.datetime
        :keyword end_date: The DateTime when the review is scheduled to end. Required if type is
         endDate.
        :paramtype end_date: ~datetime.datetime
        :keyword type_recurrence_pattern_type: The recurrence type : weekly, monthly, etc. Known values
         are: "weekly" and "absoluteMonthly".
        :paramtype type_recurrence_pattern_type: str or
         ~azure.mgmt.authorization.models.AccessReviewRecurrencePatternType
        :keyword interval: The interval for recurrence. For a quarterly review, the interval is 3 for
         type : absoluteMonthly.
        :paramtype interval: int
        """
        super().__init__(**kwargs)
        self.mail_notifications_enabled = mail_notifications_enabled
        self.reminder_notifications_enabled = reminder_notifications_enabled
        self.default_decision_enabled = default_decision_enabled
        self.justification_required_on_approval = justification_required_on_approval
        self.default_decision = default_decision
        self.auto_apply_decisions_enabled = auto_apply_decisions_enabled
        self.recommendations_enabled = recommendations_enabled
        self.recommendation_look_back_duration = recommendation_look_back_duration
        self.instance_duration_in_days = instance_duration_in_days
        self.type_recurrence_range_type = type_recurrence_range_type
        self.number_of_occurrences = number_of_occurrences
        self.start_date = start_date
        self.end_date = end_date
        self.type_recurrence_pattern_type = type_recurrence_pattern_type
        self.interval = interval


class AccessReviewScope(_serialization.Model):
    """Descriptor for what needs to be reviewed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_id: ResourceId in which this review is getting created.
    :vartype resource_id: str
    :ivar role_definition_id: This is used to indicate the role being reviewed.
    :vartype role_definition_id: str
    :ivar principal_type: The identity type user/servicePrincipal to review. Known values are:
     "user", "guestUser", "servicePrincipal", "user,group", and "redeemedGuestUser".
    :vartype principal_type: str or ~azure.mgmt.authorization.models.AccessReviewScopePrincipalType
    :ivar assignment_state: The role assignment state eligible/active to review. Known values are:
     "eligible" and "active".
    :vartype assignment_state: str or
     ~azure.mgmt.authorization.models.AccessReviewScopeAssignmentState
    :ivar inactive_duration: Duration users are inactive for. The value should be in ISO  8601
     format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert
     TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes,
     seconds)).
    :vartype inactive_duration: ~datetime.timedelta
    :ivar expand_nested_memberships: Flag to indicate whether to expand nested memberships or not.
    :vartype expand_nested_memberships: bool
    :ivar include_inherited_access: Flag to indicate whether to expand nested memberships or not.
    :vartype include_inherited_access: bool
    :ivar include_access_below_resource: Flag to indicate whether to expand nested memberships or
     not.
    :vartype include_access_below_resource: bool
    :ivar exclude_resource_id: This is used to indicate the resource id(s) to exclude.
    :vartype exclude_resource_id: str
    :ivar exclude_role_definition_id: This is used to indicate the role definition id(s) to
     exclude.
    :vartype exclude_role_definition_id: str
    """

    _validation = {
        "resource_id": {"readonly": True},
        "role_definition_id": {"readonly": True},
        "principal_type": {"readonly": True},
        "assignment_state": {"readonly": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
        "principal_type": {"key": "principalType", "type": "str"},
        "assignment_state": {"key": "assignmentState", "type": "str"},
        "inactive_duration": {"key": "inactiveDuration", "type": "duration"},
        "expand_nested_memberships": {"key": "expandNestedMemberships", "type": "bool"},
        "include_inherited_access": {"key": "includeInheritedAccess", "type": "bool"},
        "include_access_below_resource": {"key": "includeAccessBelowResource", "type": "bool"},
        "exclude_resource_id": {"key": "excludeResourceId", "type": "str"},
        "exclude_role_definition_id": {"key": "excludeRoleDefinitionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        inactive_duration: Optional[datetime.timedelta] = None,
        expand_nested_memberships: Optional[bool] = None,
        include_inherited_access: Optional[bool] = None,
        include_access_below_resource: Optional[bool] = None,
        exclude_resource_id: Optional[str] = None,
        exclude_role_definition_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword inactive_duration: Duration users are inactive for. The value should be in ISO  8601
         format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert
         TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes,
         seconds)).
        :paramtype inactive_duration: ~datetime.timedelta
        :keyword expand_nested_memberships: Flag to indicate whether to expand nested memberships or
         not.
        :paramtype expand_nested_memberships: bool
        :keyword include_inherited_access: Flag to indicate whether to expand nested memberships or
         not.
        :paramtype include_inherited_access: bool
        :keyword include_access_below_resource: Flag to indicate whether to expand nested memberships
         or not.
        :paramtype include_access_below_resource: bool
        :keyword exclude_resource_id: This is used to indicate the resource id(s) to exclude.
        :paramtype exclude_resource_id: str
        :keyword exclude_role_definition_id: This is used to indicate the role definition id(s) to
         exclude.
        :paramtype exclude_role_definition_id: str
        """
        super().__init__(**kwargs)
        self.resource_id: Optional[str] = None
        self.role_definition_id: Optional[str] = None
        self.principal_type: Optional[Union[str, "_models.AccessReviewScopePrincipalType"]] = None
        self.assignment_state: Optional[Union[str, "_models.AccessReviewScopeAssignmentState"]] = None
        self.inactive_duration = inactive_duration
        self.expand_nested_memberships = expand_nested_memberships
        self.include_inherited_access = include_inherited_access
        self.include_access_below_resource = include_access_below_resource
        self.exclude_resource_id = exclude_resource_id
        self.exclude_role_definition_id = exclude_role_definition_id


class Alert(_serialization.Model):
    """The alert.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The alert ID.
    :vartype id: str
    :ivar name: The alert name.
    :vartype name: str
    :ivar type: The alert type.
    :vartype type: str
    :ivar scope: The alert scope.
    :vartype scope: str
    :ivar is_active: False by default; true if the alert is active.
    :vartype is_active: bool
    :ivar incident_count: The number of generated incidents of the alert.
    :vartype incident_count: int
    :ivar last_modified_date_time: The date time when the alert configuration was updated or new
     incidents were generated.
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar last_scanned_date_time: The date time when the alert was last scanned.
    :vartype last_scanned_date_time: ~datetime.datetime
    :ivar alert_definition: The alert definition.
    :vartype alert_definition: ~azure.mgmt.authorization.models.AlertDefinition
    :ivar alert_incidents: The alert incidents.
    :vartype alert_incidents: list[~azure.mgmt.authorization.models.AlertIncident]
    :ivar alert_configuration: The alert configuration.
    :vartype alert_configuration: ~azure.mgmt.authorization.models.AlertConfiguration
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "scope": {"readonly": True},
        "incident_count": {"readonly": True},
        "last_modified_date_time": {"readonly": True},
        "last_scanned_date_time": {"readonly": True},
        "alert_definition": {"readonly": True},
        "alert_incidents": {"readonly": True},
        "alert_configuration": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "is_active": {"key": "properties.isActive", "type": "bool"},
        "incident_count": {"key": "properties.incidentCount", "type": "int"},
        "last_modified_date_time": {"key": "properties.lastModifiedDateTime", "type": "iso-8601"},
        "last_scanned_date_time": {"key": "properties.lastScannedDateTime", "type": "iso-8601"},
        "alert_definition": {"key": "properties.alertDefinition", "type": "AlertDefinition"},
        "alert_incidents": {"key": "properties.alertIncidents", "type": "[AlertIncident]"},
        "alert_configuration": {"key": "properties.alertConfiguration", "type": "AlertConfiguration"},
    }

    def __init__(self, *, is_active: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_active: False by default; true if the alert is active.
        :paramtype is_active: bool
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.scope: Optional[str] = None
        self.is_active = is_active
        self.incident_count: Optional[int] = None
        self.last_modified_date_time: Optional[datetime.datetime] = None
        self.last_scanned_date_time: Optional[datetime.datetime] = None
        self.alert_definition: Optional["_models.AlertDefinition"] = None
        self.alert_incidents: Optional[List["_models.AlertIncident"]] = None
        self.alert_configuration: Optional["_models.AlertConfiguration"] = None


class AlertConfiguration(_serialization.Model):
    """Alert configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The alert configuration ID.
    :vartype id: str
    :ivar name: The alert configuration name.
    :vartype name: str
    :ivar type: The alert configuration type.
    :vartype type: str
    :ivar alert_definition_id: The alert definition ID.
    :vartype alert_definition_id: str
    :ivar scope: The alert scope.
    :vartype scope: str
    :ivar is_enabled: True if the alert is enabled, false will disable the scanning for the
     specific alert.
    :vartype is_enabled: bool
    :ivar alert_configuration_type: The alert configuration type.
    :vartype alert_configuration_type: str
    :ivar alert_definition: The alert definition.
    :vartype alert_definition: ~azure.mgmt.authorization.models.AlertDefinition
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "alert_definition_id": {"readonly": True},
        "scope": {"readonly": True},
        "alert_definition": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "alert_definition_id": {"key": "properties.alertDefinitionId", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
        "alert_configuration_type": {"key": "properties.alertConfigurationType", "type": "str"},
        "alert_definition": {"key": "properties.alertDefinition", "type": "AlertDefinition"},
    }

    def __init__(self, *, is_enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_enabled: True if the alert is enabled, false will disable the scanning for the
         specific alert.
        :paramtype is_enabled: bool
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.alert_definition_id: Optional[str] = None
        self.scope: Optional[str] = None
        self.is_enabled = is_enabled
        self.alert_configuration_type: Optional[str] = None
        self.alert_definition: Optional["_models.AlertDefinition"] = None


class AlertConfigurationListResult(_serialization.Model):
    """Alert configuration list operation result.

    :ivar value: Alert configuration list.
    :vartype value: list[~azure.mgmt.authorization.models.AlertConfiguration]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AlertConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AlertConfiguration"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Alert configuration list.
        :paramtype value: list[~azure.mgmt.authorization.models.AlertConfiguration]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AlertConfigurationProperties(_serialization.Model):
    """Alert configuration properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureRolesAssignedOutsidePimAlertConfigurationProperties,
    DuplicateRoleCreatedAlertConfigurationProperties,
    TooManyOwnersAssignedToResourceAlertConfigurationProperties,
    TooManyPermanentOwnersAssignedToResourceAlertConfigurationProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar alert_definition_id: The alert definition ID.
    :vartype alert_definition_id: str
    :ivar scope: The alert scope.
    :vartype scope: str
    :ivar is_enabled: True if the alert is enabled, false will disable the scanning for the
     specific alert.
    :vartype is_enabled: bool
    :ivar alert_configuration_type: The alert configuration type. Required.
    :vartype alert_configuration_type: str
    :ivar alert_definition: The alert definition.
    :vartype alert_definition: ~azure.mgmt.authorization.models.AlertDefinition
    """

    _validation = {
        "alert_definition_id": {"readonly": True},
        "scope": {"readonly": True},
        "alert_configuration_type": {"required": True},
        "alert_definition": {"readonly": True},
    }

    _attribute_map = {
        "alert_definition_id": {"key": "alertDefinitionId", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "alert_configuration_type": {"key": "alertConfigurationType", "type": "str"},
        "alert_definition": {"key": "alertDefinition", "type": "AlertDefinition"},
    }

    _subtype_map = {
        "alert_configuration_type": {
            "AzureRolesAssignedOutsidePimAlertConfiguration": "AzureRolesAssignedOutsidePimAlertConfigurationProperties",
            "DuplicateRoleCreatedAlertConfiguration": "DuplicateRoleCreatedAlertConfigurationProperties",
            "TooManyOwnersAssignedToResourceAlertConfiguration": "TooManyOwnersAssignedToResourceAlertConfigurationProperties",
            "TooManyPermanentOwnersAssignedToResourceAlertConfiguration": "TooManyPermanentOwnersAssignedToResourceAlertConfigurationProperties",
        }
    }

    def __init__(self, *, is_enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_enabled: True if the alert is enabled, false will disable the scanning for the
         specific alert.
        :paramtype is_enabled: bool
        """
        super().__init__(**kwargs)
        self.alert_definition_id: Optional[str] = None
        self.scope: Optional[str] = None
        self.is_enabled = is_enabled
        self.alert_configuration_type: Optional[str] = None
        self.alert_definition: Optional["_models.AlertDefinition"] = None


class AlertDefinition(_serialization.Model):
    """Alert definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The alert definition ID.
    :vartype id: str
    :ivar name: The alert definition name.
    :vartype name: str
    :ivar type: The alert definition type.
    :vartype type: str
    :ivar display_name: The alert display name.
    :vartype display_name: str
    :ivar scope: The alert scope.
    :vartype scope: str
    :ivar description: The alert description.
    :vartype description: str
    :ivar severity_level: Severity level of the alert. Known values are: "Low", "Medium", and
     "High".
    :vartype severity_level: str or ~azure.mgmt.authorization.models.SeverityLevel
    :ivar security_impact: Security impact of the alert.
    :vartype security_impact: str
    :ivar mitigation_steps: The methods to mitigate the alert.
    :vartype mitigation_steps: str
    :ivar how_to_prevent: The ways to prevent the alert.
    :vartype how_to_prevent: str
    :ivar is_remediatable: True if the alert can be remediated; false, otherwise.
    :vartype is_remediatable: bool
    :ivar is_configurable: True if the alert configuration can be configured; false, otherwise.
    :vartype is_configurable: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "scope": {"readonly": True},
        "description": {"readonly": True},
        "severity_level": {"readonly": True},
        "security_impact": {"readonly": True},
        "mitigation_steps": {"readonly": True},
        "how_to_prevent": {"readonly": True},
        "is_remediatable": {"readonly": True},
        "is_configurable": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "severity_level": {"key": "properties.severityLevel", "type": "str"},
        "security_impact": {"key": "properties.securityImpact", "type": "str"},
        "mitigation_steps": {"key": "properties.mitigationSteps", "type": "str"},
        "how_to_prevent": {"key": "properties.howToPrevent", "type": "str"},
        "is_remediatable": {"key": "properties.isRemediatable", "type": "bool"},
        "is_configurable": {"key": "properties.isConfigurable", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.display_name: Optional[str] = None
        self.scope: Optional[str] = None
        self.description: Optional[str] = None
        self.severity_level: Optional[Union[str, "_models.SeverityLevel"]] = None
        self.security_impact: Optional[str] = None
        self.mitigation_steps: Optional[str] = None
        self.how_to_prevent: Optional[str] = None
        self.is_remediatable: Optional[bool] = None
        self.is_configurable: Optional[bool] = None


class AlertDefinitionListResult(_serialization.Model):
    """Alert definition list operation result.

    :ivar value: Alert definition list.
    :vartype value: list[~azure.mgmt.authorization.models.AlertDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AlertDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AlertDefinition"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Alert definition list.
        :paramtype value: list[~azure.mgmt.authorization.models.AlertDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AlertIncident(_serialization.Model):
    """Alert incident.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The alert incident ID.
    :vartype id: str
    :ivar name: The alert incident name.
    :vartype name: str
    :ivar type: The alert incident type.
    :vartype type: str
    :ivar alert_incident_type: The alert incident type.
    :vartype alert_incident_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "alert_incident_type": {"key": "properties.alertIncidentType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.alert_incident_type: Optional[str] = None


class AlertIncidentListResult(_serialization.Model):
    """Alert incident list operation result.

    :ivar value: Alert incident list.
    :vartype value: list[~azure.mgmt.authorization.models.AlertIncident]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AlertIncident]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AlertIncident"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Alert incident list.
        :paramtype value: list[~azure.mgmt.authorization.models.AlertIncident]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AlertIncidentProperties(_serialization.Model):
    """Alert incident properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureRolesAssignedOutsidePimAlertIncidentProperties,
    DuplicateRoleCreatedAlertIncidentProperties,
    TooManyOwnersAssignedToResourceAlertIncidentProperties,
    TooManyPermanentOwnersAssignedToResourceAlertIncidentProperties

    All required parameters must be populated in order to send to server.

    :ivar alert_incident_type: The alert incident type. Required.
    :vartype alert_incident_type: str
    """

    _validation = {
        "alert_incident_type": {"required": True},
    }

    _attribute_map = {
        "alert_incident_type": {"key": "alertIncidentType", "type": "str"},
    }

    _subtype_map = {
        "alert_incident_type": {
            "AzureRolesAssignedOutsidePimAlertIncident": "AzureRolesAssignedOutsidePimAlertIncidentProperties",
            "DuplicateRoleCreatedAlertIncident": "DuplicateRoleCreatedAlertIncidentProperties",
            "TooManyOwnersAssignedToResourceAlertIncident": "TooManyOwnersAssignedToResourceAlertIncidentProperties",
            "TooManyPermanentOwnersAssignedToResourceAlertIncident": "TooManyPermanentOwnersAssignedToResourceAlertIncidentProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.alert_incident_type: Optional[str] = None


class AlertListResult(_serialization.Model):
    """Alert list operation result.

    :ivar value: Alert list.
    :vartype value: list[~azure.mgmt.authorization.models.Alert]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Alert]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Alert"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Alert list.
        :paramtype value: list[~azure.mgmt.authorization.models.Alert]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AlertOperationResult(_serialization.Model):
    """Alert operation result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The id of the alert operation.
    :vartype id: str
    :ivar status: The status of the alert operation.
    :vartype status: str
    :ivar status_detail: The status detail of the alert operation.
    :vartype status_detail: str
    :ivar created_date_time: The created date of the alert operation.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_action_date_time: The last action date of the alert operation.
    :vartype last_action_date_time: ~datetime.datetime
    :ivar resource_location: The location of the alert associated with the operation.
    :vartype resource_location: str
    """

    _validation = {
        "id": {"readonly": True},
        "status": {"readonly": True},
        "status_detail": {"readonly": True},
        "created_date_time": {"readonly": True},
        "last_action_date_time": {"readonly": True},
        "resource_location": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "status_detail": {"key": "statusDetail", "type": "str"},
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "last_action_date_time": {"key": "lastActionDateTime", "type": "iso-8601"},
        "resource_location": {"key": "resourceLocation", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.status: Optional[str] = None
        self.status_detail: Optional[str] = None
        self.created_date_time: Optional[datetime.datetime] = None
        self.last_action_date_time: Optional[datetime.datetime] = None
        self.resource_location: Optional[str] = None


class ApprovalSettings(_serialization.Model):
    """The approval settings.

    :ivar is_approval_required: Determines whether approval is required or not.
    :vartype is_approval_required: bool
    :ivar is_approval_required_for_extension: Determines whether approval is required for
     assignment extension.
    :vartype is_approval_required_for_extension: bool
    :ivar is_requestor_justification_required: Determine whether requestor justification is
     required.
    :vartype is_requestor_justification_required: bool
    :ivar approval_mode: The type of rule. Known values are: "SingleStage", "Serial", "Parallel",
     and "NoApproval".
    :vartype approval_mode: str or ~azure.mgmt.authorization.models.ApprovalMode
    :ivar approval_stages: The approval stages of the request.
    :vartype approval_stages: list[~azure.mgmt.authorization.models.ApprovalStage]
    """

    _attribute_map = {
        "is_approval_required": {"key": "isApprovalRequired", "type": "bool"},
        "is_approval_required_for_extension": {"key": "isApprovalRequiredForExtension", "type": "bool"},
        "is_requestor_justification_required": {"key": "isRequestorJustificationRequired", "type": "bool"},
        "approval_mode": {"key": "approvalMode", "type": "str"},
        "approval_stages": {"key": "approvalStages", "type": "[ApprovalStage]"},
    }

    def __init__(
        self,
        *,
        is_approval_required: Optional[bool] = None,
        is_approval_required_for_extension: Optional[bool] = None,
        is_requestor_justification_required: Optional[bool] = None,
        approval_mode: Optional[Union[str, "_models.ApprovalMode"]] = None,
        approval_stages: Optional[List["_models.ApprovalStage"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_approval_required: Determines whether approval is required or not.
        :paramtype is_approval_required: bool
        :keyword is_approval_required_for_extension: Determines whether approval is required for
         assignment extension.
        :paramtype is_approval_required_for_extension: bool
        :keyword is_requestor_justification_required: Determine whether requestor justification is
         required.
        :paramtype is_requestor_justification_required: bool
        :keyword approval_mode: The type of rule. Known values are: "SingleStage", "Serial",
         "Parallel", and "NoApproval".
        :paramtype approval_mode: str or ~azure.mgmt.authorization.models.ApprovalMode
        :keyword approval_stages: The approval stages of the request.
        :paramtype approval_stages: list[~azure.mgmt.authorization.models.ApprovalStage]
        """
        super().__init__(**kwargs)
        self.is_approval_required = is_approval_required
        self.is_approval_required_for_extension = is_approval_required_for_extension
        self.is_requestor_justification_required = is_requestor_justification_required
        self.approval_mode = approval_mode
        self.approval_stages = approval_stages


class ApprovalStage(_serialization.Model):
    """The approval stage.

    :ivar approval_stage_time_out_in_days: The time in days when approval request would be timed
     out.
    :vartype approval_stage_time_out_in_days: int
    :ivar is_approver_justification_required: Determines whether approver need to provide
     justification for his decision.
    :vartype is_approver_justification_required: bool
    :ivar escalation_time_in_minutes: The time in minutes when the approval request would be
     escalated if the primary approver does not approve.
    :vartype escalation_time_in_minutes: int
    :ivar primary_approvers: The primary approver of the request.
    :vartype primary_approvers: list[~azure.mgmt.authorization.models.UserSet]
    :ivar is_escalation_enabled: The value determine whether escalation feature is enabled.
    :vartype is_escalation_enabled: bool
    :ivar escalation_approvers: The escalation approver of the request.
    :vartype escalation_approvers: list[~azure.mgmt.authorization.models.UserSet]
    """

    _attribute_map = {
        "approval_stage_time_out_in_days": {"key": "approvalStageTimeOutInDays", "type": "int"},
        "is_approver_justification_required": {"key": "isApproverJustificationRequired", "type": "bool"},
        "escalation_time_in_minutes": {"key": "escalationTimeInMinutes", "type": "int"},
        "primary_approvers": {"key": "primaryApprovers", "type": "[UserSet]"},
        "is_escalation_enabled": {"key": "isEscalationEnabled", "type": "bool"},
        "escalation_approvers": {"key": "escalationApprovers", "type": "[UserSet]"},
    }

    def __init__(
        self,
        *,
        approval_stage_time_out_in_days: Optional[int] = None,
        is_approver_justification_required: Optional[bool] = None,
        escalation_time_in_minutes: Optional[int] = None,
        primary_approvers: Optional[List["_models.UserSet"]] = None,
        is_escalation_enabled: Optional[bool] = None,
        escalation_approvers: Optional[List["_models.UserSet"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword approval_stage_time_out_in_days: The time in days when approval request would be timed
         out.
        :paramtype approval_stage_time_out_in_days: int
        :keyword is_approver_justification_required: Determines whether approver need to provide
         justification for his decision.
        :paramtype is_approver_justification_required: bool
        :keyword escalation_time_in_minutes: The time in minutes when the approval request would be
         escalated if the primary approver does not approve.
        :paramtype escalation_time_in_minutes: int
        :keyword primary_approvers: The primary approver of the request.
        :paramtype primary_approvers: list[~azure.mgmt.authorization.models.UserSet]
        :keyword is_escalation_enabled: The value determine whether escalation feature is enabled.
        :paramtype is_escalation_enabled: bool
        :keyword escalation_approvers: The escalation approver of the request.
        :paramtype escalation_approvers: list[~azure.mgmt.authorization.models.UserSet]
        """
        super().__init__(**kwargs)
        self.approval_stage_time_out_in_days = approval_stage_time_out_in_days
        self.is_approver_justification_required = is_approver_justification_required
        self.escalation_time_in_minutes = escalation_time_in_minutes
        self.primary_approvers = primary_approvers
        self.is_escalation_enabled = is_escalation_enabled
        self.escalation_approvers = escalation_approvers


class AzureRolesAssignedOutsidePimAlertConfigurationProperties(
    AlertConfigurationProperties
):  # pylint: disable=name-too-long
    """The Azure roles assigned outside PIM alert configuration properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar alert_definition_id: The alert definition ID.
    :vartype alert_definition_id: str
    :ivar scope: The alert scope.
    :vartype scope: str
    :ivar is_enabled: True if the alert is enabled, false will disable the scanning for the
     specific alert.
    :vartype is_enabled: bool
    :ivar alert_configuration_type: The alert configuration type. Required.
    :vartype alert_configuration_type: str
    :ivar alert_definition: The alert definition.
    :vartype alert_definition: ~azure.mgmt.authorization.models.AlertDefinition
    """

    _validation = {
        "alert_definition_id": {"readonly": True},
        "scope": {"readonly": True},
        "alert_configuration_type": {"required": True},
        "alert_definition": {"readonly": True},
    }

    _attribute_map = {
        "alert_definition_id": {"key": "alertDefinitionId", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "alert_configuration_type": {"key": "alertConfigurationType", "type": "str"},
        "alert_definition": {"key": "alertDefinition", "type": "AlertDefinition"},
    }

    def __init__(self, *, is_enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_enabled: True if the alert is enabled, false will disable the scanning for the
         specific alert.
        :paramtype is_enabled: bool
        """
        super().__init__(is_enabled=is_enabled, **kwargs)
        self.alert_configuration_type: str = "AzureRolesAssignedOutsidePimAlertConfiguration"


class AzureRolesAssignedOutsidePimAlertIncidentProperties(AlertIncidentProperties):  # pylint: disable=name-too-long
    """Azure roles assigned outside PIM alert incident properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar alert_incident_type: The alert incident type. Required.
    :vartype alert_incident_type: str
    :ivar assignee_display_name: The assignee display name.
    :vartype assignee_display_name: str
    :ivar assignee_user_principal_name: The assignee user principal name.
    :vartype assignee_user_principal_name: str
    :ivar assignee_id: The assignee ID.
    :vartype assignee_id: str
    :ivar role_display_name: The role display name.
    :vartype role_display_name: str
    :ivar role_template_id: The role template ID.
    :vartype role_template_id: str
    :ivar role_definition_id: The role definition ID.
    :vartype role_definition_id: str
    :ivar assignment_activated_date: The date the assignment was activated.
    :vartype assignment_activated_date: ~datetime.datetime
    :ivar requestor_id: The requestor ID.
    :vartype requestor_id: str
    :ivar requestor_display_name: The requestor display name.
    :vartype requestor_display_name: str
    :ivar requestor_user_principal_name: The requestor user principal name.
    :vartype requestor_user_principal_name: str
    """

    _validation = {
        "alert_incident_type": {"required": True},
        "assignee_display_name": {"readonly": True},
        "assignee_user_principal_name": {"readonly": True},
        "assignee_id": {"readonly": True},
        "role_display_name": {"readonly": True},
        "role_template_id": {"readonly": True},
        "role_definition_id": {"readonly": True},
        "assignment_activated_date": {"readonly": True},
        "requestor_id": {"readonly": True},
        "requestor_display_name": {"readonly": True},
        "requestor_user_principal_name": {"readonly": True},
    }

    _attribute_map = {
        "alert_incident_type": {"key": "alertIncidentType", "type": "str"},
        "assignee_display_name": {"key": "assigneeDisplayName", "type": "str"},
        "assignee_user_principal_name": {"key": "assigneeUserPrincipalName", "type": "str"},
        "assignee_id": {"key": "assigneeId", "type": "str"},
        "role_display_name": {"key": "roleDisplayName", "type": "str"},
        "role_template_id": {"key": "roleTemplateId", "type": "str"},
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
        "assignment_activated_date": {"key": "assignmentActivatedDate", "type": "iso-8601"},
        "requestor_id": {"key": "requestorId", "type": "str"},
        "requestor_display_name": {"key": "requestorDisplayName", "type": "str"},
        "requestor_user_principal_name": {"key": "requestorUserPrincipalName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.alert_incident_type: str = "AzureRolesAssignedOutsidePimAlertIncident"
        self.assignee_display_name: Optional[str] = None
        self.assignee_user_principal_name: Optional[str] = None
        self.assignee_id: Optional[str] = None
        self.role_display_name: Optional[str] = None
        self.role_template_id: Optional[str] = None
        self.role_definition_id: Optional[str] = None
        self.assignment_activated_date: Optional[datetime.datetime] = None
        self.requestor_id: Optional[str] = None
        self.requestor_display_name: Optional[str] = None
        self.requestor_user_principal_name: Optional[str] = None


class ClassicAdministrator(_serialization.Model):
    """Classic Administrators.

    :ivar id: The ID of the administrator.
    :vartype id: str
    :ivar name: The name of the administrator.
    :vartype name: str
    :ivar type: The type of the administrator.
    :vartype type: str
    :ivar email_address: The email address of the administrator.
    :vartype email_address: str
    :ivar role: The role of the administrator.
    :vartype role: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "email_address": {"key": "properties.emailAddress", "type": "str"},
        "role": {"key": "properties.role", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        email_address: Optional[str] = None,
        role: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the administrator.
        :paramtype id: str
        :keyword name: The name of the administrator.
        :paramtype name: str
        :keyword type: The type of the administrator.
        :paramtype type: str
        :keyword email_address: The email address of the administrator.
        :paramtype email_address: str
        :keyword role: The role of the administrator.
        :paramtype role: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.email_address = email_address
        self.role = role


class ClassicAdministratorListResult(_serialization.Model):
    """ClassicAdministrator list result information.

    :ivar value: An array of administrators.
    :vartype value: list[~azure.mgmt.authorization.models.ClassicAdministrator]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ClassicAdministrator]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ClassicAdministrator"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of administrators.
        :paramtype value: list[~azure.mgmt.authorization.models.ClassicAdministrator]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CloudErrorBody(_serialization.Model):
    """An error response from the service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class DenyAssignment(_serialization.Model):
    """Deny Assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The deny assignment ID.
    :vartype id: str
    :ivar name: The deny assignment name.
    :vartype name: str
    :ivar type: The deny assignment type.
    :vartype type: str
    :ivar deny_assignment_name: The display name of the deny assignment.
    :vartype deny_assignment_name: str
    :ivar description: The description of the deny assignment.
    :vartype description: str
    :ivar permissions: An array of permissions that are denied by the deny assignment.
    :vartype permissions: list[~azure.mgmt.authorization.models.DenyAssignmentPermission]
    :ivar scope: The deny assignment scope.
    :vartype scope: str
    :ivar do_not_apply_to_child_scopes: Determines if the deny assignment applies to child scopes.
     Default value is false.
    :vartype do_not_apply_to_child_scopes: bool
    :ivar principals: Array of principals to which the deny assignment applies.
    :vartype principals: list[~azure.mgmt.authorization.models.Principal]
    :ivar exclude_principals: Array of principals to which the deny assignment does not apply.
    :vartype exclude_principals: list[~azure.mgmt.authorization.models.Principal]
    :ivar is_system_protected: Specifies whether this deny assignment was created by Azure and
     cannot be edited or deleted.
    :vartype is_system_protected: bool
    :ivar condition: The conditions on the deny assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :vartype condition: str
    :ivar condition_version: Version of the condition.
    :vartype condition_version: str
    :ivar created_on: Time it was created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: Time it was updated.
    :vartype updated_on: ~datetime.datetime
    :ivar created_by: Id of the user who created the assignment.
    :vartype created_by: str
    :ivar updated_by: Id of the user who updated the assignment.
    :vartype updated_by: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "created_on": {"readonly": True},
        "updated_on": {"readonly": True},
        "created_by": {"readonly": True},
        "updated_by": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "deny_assignment_name": {"key": "properties.denyAssignmentName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "permissions": {"key": "properties.permissions", "type": "[DenyAssignmentPermission]"},
        "scope": {"key": "properties.scope", "type": "str"},
        "do_not_apply_to_child_scopes": {"key": "properties.doNotApplyToChildScopes", "type": "bool"},
        "principals": {"key": "properties.principals", "type": "[Principal]"},
        "exclude_principals": {"key": "properties.excludePrincipals", "type": "[Principal]"},
        "is_system_protected": {"key": "properties.isSystemProtected", "type": "bool"},
        "condition": {"key": "properties.condition", "type": "str"},
        "condition_version": {"key": "properties.conditionVersion", "type": "str"},
        "created_on": {"key": "properties.createdOn", "type": "iso-8601"},
        "updated_on": {"key": "properties.updatedOn", "type": "iso-8601"},
        "created_by": {"key": "properties.createdBy", "type": "str"},
        "updated_by": {"key": "properties.updatedBy", "type": "str"},
    }

    def __init__(
        self,
        *,
        deny_assignment_name: Optional[str] = None,
        description: Optional[str] = None,
        permissions: Optional[List["_models.DenyAssignmentPermission"]] = None,
        scope: Optional[str] = None,
        do_not_apply_to_child_scopes: Optional[bool] = None,
        principals: Optional[List["_models.Principal"]] = None,
        exclude_principals: Optional[List["_models.Principal"]] = None,
        is_system_protected: Optional[bool] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword deny_assignment_name: The display name of the deny assignment.
        :paramtype deny_assignment_name: str
        :keyword description: The description of the deny assignment.
        :paramtype description: str
        :keyword permissions: An array of permissions that are denied by the deny assignment.
        :paramtype permissions: list[~azure.mgmt.authorization.models.DenyAssignmentPermission]
        :keyword scope: The deny assignment scope.
        :paramtype scope: str
        :keyword do_not_apply_to_child_scopes: Determines if the deny assignment applies to child
         scopes. Default value is false.
        :paramtype do_not_apply_to_child_scopes: bool
        :keyword principals: Array of principals to which the deny assignment applies.
        :paramtype principals: list[~azure.mgmt.authorization.models.Principal]
        :keyword exclude_principals: Array of principals to which the deny assignment does not apply.
        :paramtype exclude_principals: list[~azure.mgmt.authorization.models.Principal]
        :keyword is_system_protected: Specifies whether this deny assignment was created by Azure and
         cannot be edited or deleted.
        :paramtype is_system_protected: bool
        :keyword condition: The conditions on the deny assignment. This limits the resources it can be
         assigned to. e.g.:
         @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
         StringEqualsIgnoreCase 'foo_storage_container'.
        :paramtype condition: str
        :keyword condition_version: Version of the condition.
        :paramtype condition_version: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.deny_assignment_name = deny_assignment_name
        self.description = description
        self.permissions = permissions
        self.scope = scope
        self.do_not_apply_to_child_scopes = do_not_apply_to_child_scopes
        self.principals = principals
        self.exclude_principals = exclude_principals
        self.is_system_protected = is_system_protected
        self.condition = condition
        self.condition_version = condition_version
        self.created_on: Optional[datetime.datetime] = None
        self.updated_on: Optional[datetime.datetime] = None
        self.created_by: Optional[str] = None
        self.updated_by: Optional[str] = None


class DenyAssignmentFilter(_serialization.Model):
    """Deny Assignments filter.

    :ivar deny_assignment_name: Return deny assignment with specified name.
    :vartype deny_assignment_name: str
    :ivar principal_id: Return all deny assignments where the specified principal is listed in the
     principals list of deny assignments.
    :vartype principal_id: str
    :ivar gdpr_export_principal_id: Return all deny assignments where the specified principal is
     listed either in the principals list or exclude principals list of deny assignments.
    :vartype gdpr_export_principal_id: str
    """

    _attribute_map = {
        "deny_assignment_name": {"key": "denyAssignmentName", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "gdpr_export_principal_id": {"key": "gdprExportPrincipalId", "type": "str"},
    }

    def __init__(
        self,
        *,
        deny_assignment_name: Optional[str] = None,
        principal_id: Optional[str] = None,
        gdpr_export_principal_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword deny_assignment_name: Return deny assignment with specified name.
        :paramtype deny_assignment_name: str
        :keyword principal_id: Return all deny assignments where the specified principal is listed in
         the principals list of deny assignments.
        :paramtype principal_id: str
        :keyword gdpr_export_principal_id: Return all deny assignments where the specified principal is
         listed either in the principals list or exclude principals list of deny assignments.
        :paramtype gdpr_export_principal_id: str
        """
        super().__init__(**kwargs)
        self.deny_assignment_name = deny_assignment_name
        self.principal_id = principal_id
        self.gdpr_export_principal_id = gdpr_export_principal_id


class DenyAssignmentListResult(_serialization.Model):
    """Deny assignment list operation result.

    :ivar value: Deny assignment list.
    :vartype value: list[~azure.mgmt.authorization.models.DenyAssignment]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DenyAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.DenyAssignment"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Deny assignment list.
        :paramtype value: list[~azure.mgmt.authorization.models.DenyAssignment]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DenyAssignmentPermission(_serialization.Model):
    """Deny assignment permissions.

    :ivar actions: Actions to which the deny assignment does not grant access.
    :vartype actions: list[str]
    :ivar not_actions: Actions to exclude from that the deny assignment does not grant access.
    :vartype not_actions: list[str]
    :ivar data_actions: Data actions to which the deny assignment does not grant access.
    :vartype data_actions: list[str]
    :ivar not_data_actions: Data actions to exclude from that the deny assignment does not grant
     access.
    :vartype not_data_actions: list[str]
    :ivar condition: The conditions on the Deny assignment permission. This limits the resources it
     applies to.
    :vartype condition: str
    :ivar condition_version: Version of the condition.
    :vartype condition_version: str
    """

    _attribute_map = {
        "actions": {"key": "actions", "type": "[str]"},
        "not_actions": {"key": "notActions", "type": "[str]"},
        "data_actions": {"key": "dataActions", "type": "[str]"},
        "not_data_actions": {"key": "notDataActions", "type": "[str]"},
        "condition": {"key": "condition", "type": "str"},
        "condition_version": {"key": "conditionVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        actions: Optional[List[str]] = None,
        not_actions: Optional[List[str]] = None,
        data_actions: Optional[List[str]] = None,
        not_data_actions: Optional[List[str]] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword actions: Actions to which the deny assignment does not grant access.
        :paramtype actions: list[str]
        :keyword not_actions: Actions to exclude from that the deny assignment does not grant access.
        :paramtype not_actions: list[str]
        :keyword data_actions: Data actions to which the deny assignment does not grant access.
        :paramtype data_actions: list[str]
        :keyword not_data_actions: Data actions to exclude from that the deny assignment does not grant
         access.
        :paramtype not_data_actions: list[str]
        :keyword condition: The conditions on the Deny assignment permission. This limits the resources
         it applies to.
        :paramtype condition: str
        :keyword condition_version: Version of the condition.
        :paramtype condition_version: str
        """
        super().__init__(**kwargs)
        self.actions = actions
        self.not_actions = not_actions
        self.data_actions = data_actions
        self.not_data_actions = not_data_actions
        self.condition = condition
        self.condition_version = condition_version


class DuplicateRoleCreatedAlertConfigurationProperties(AlertConfigurationProperties):  # pylint: disable=name-too-long
    """The duplicate role created alert configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar alert_definition_id: The alert definition ID.
    :vartype alert_definition_id: str
    :ivar scope: The alert scope.
    :vartype scope: str
    :ivar is_enabled: True if the alert is enabled, false will disable the scanning for the
     specific alert.
    :vartype is_enabled: bool
    :ivar alert_configuration_type: The alert configuration type. Required.
    :vartype alert_configuration_type: str
    :ivar alert_definition: The alert definition.
    :vartype alert_definition: ~azure.mgmt.authorization.models.AlertDefinition
    """

    _validation = {
        "alert_definition_id": {"readonly": True},
        "scope": {"readonly": True},
        "alert_configuration_type": {"required": True},
        "alert_definition": {"readonly": True},
    }

    _attribute_map = {
        "alert_definition_id": {"key": "alertDefinitionId", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "alert_configuration_type": {"key": "alertConfigurationType", "type": "str"},
        "alert_definition": {"key": "alertDefinition", "type": "AlertDefinition"},
    }

    def __init__(self, *, is_enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_enabled: True if the alert is enabled, false will disable the scanning for the
         specific alert.
        :paramtype is_enabled: bool
        """
        super().__init__(is_enabled=is_enabled, **kwargs)
        self.alert_configuration_type: str = "DuplicateRoleCreatedAlertConfiguration"


class DuplicateRoleCreatedAlertIncidentProperties(AlertIncidentProperties):  # pylint: disable=name-too-long
    """Duplicate role created alert incident properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar alert_incident_type: The alert incident type. Required.
    :vartype alert_incident_type: str
    :ivar role_name: The role name.
    :vartype role_name: str
    :ivar duplicate_roles: The duplicate roles.
    :vartype duplicate_roles: str
    :ivar reason: The reason for the incident.
    :vartype reason: str
    """

    _validation = {
        "alert_incident_type": {"required": True},
        "role_name": {"readonly": True},
        "duplicate_roles": {"readonly": True},
        "reason": {"readonly": True},
    }

    _attribute_map = {
        "alert_incident_type": {"key": "alertIncidentType", "type": "str"},
        "role_name": {"key": "roleName", "type": "str"},
        "duplicate_roles": {"key": "duplicateRoles", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.alert_incident_type: str = "DuplicateRoleCreatedAlertIncident"
        self.role_name: Optional[str] = None
        self.duplicate_roles: Optional[str] = None
        self.reason: Optional[str] = None


class EligibleChildResource(_serialization.Model):
    """Eligible child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource scope Id.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class EligibleChildResourcesListResult(_serialization.Model):
    """Eligible child resources list operation result.

    :ivar value: Eligible child resource list.
    :vartype value: list[~azure.mgmt.authorization.models.EligibleChildResource]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EligibleChildResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.EligibleChildResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Eligible child resource list.
        :paramtype value: list[~azure.mgmt.authorization.models.EligibleChildResource]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDefinition(_serialization.Model):
    """Error description and code explaining why an operation failed.

    :ivar error: Error of the list gateway status.
    :vartype error: ~azure.mgmt.authorization.models.ErrorDefinitionProperties
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDefinitionProperties"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDefinitionProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword error: Error of the list gateway status.
        :paramtype error: ~azure.mgmt.authorization.models.ErrorDefinitionProperties
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorDefinitionProperties(_serialization.Model):
    """Error description and code explaining why an operation failed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar message: Description of the error.
    :vartype message: str
    :ivar code: Error code of list gateway.
    :vartype code: str
    """

    _validation = {
        "message": {"readonly": True},
    }

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "code": {"key": "code", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code of list gateway.
        :paramtype code: str
        """
        super().__init__(**kwargs)
        self.message: Optional[str] = None
        self.code = code


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.authorization.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.authorization.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetail"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.authorization.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.authorization.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExpandedProperties(_serialization.Model):
    """ExpandedProperties.

    :ivar scope: Details of the resource scope.
    :vartype scope: ~azure.mgmt.authorization.models.ExpandedPropertiesScope
    :ivar role_definition: Details of role definition.
    :vartype role_definition: ~azure.mgmt.authorization.models.ExpandedPropertiesRoleDefinition
    :ivar principal: Details of the principal.
    :vartype principal: ~azure.mgmt.authorization.models.ExpandedPropertiesPrincipal
    """

    _attribute_map = {
        "scope": {"key": "scope", "type": "ExpandedPropertiesScope"},
        "role_definition": {"key": "roleDefinition", "type": "ExpandedPropertiesRoleDefinition"},
        "principal": {"key": "principal", "type": "ExpandedPropertiesPrincipal"},
    }

    def __init__(
        self,
        *,
        scope: Optional["_models.ExpandedPropertiesScope"] = None,
        role_definition: Optional["_models.ExpandedPropertiesRoleDefinition"] = None,
        principal: Optional["_models.ExpandedPropertiesPrincipal"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: Details of the resource scope.
        :paramtype scope: ~azure.mgmt.authorization.models.ExpandedPropertiesScope
        :keyword role_definition: Details of role definition.
        :paramtype role_definition: ~azure.mgmt.authorization.models.ExpandedPropertiesRoleDefinition
        :keyword principal: Details of the principal.
        :paramtype principal: ~azure.mgmt.authorization.models.ExpandedPropertiesPrincipal
        """
        super().__init__(**kwargs)
        self.scope = scope
        self.role_definition = role_definition
        self.principal = principal


class ExpandedPropertiesPrincipal(_serialization.Model):
    """Details of the principal.

    :ivar id: Id of the principal.
    :vartype id: str
    :ivar display_name: Display name of the principal.
    :vartype display_name: str
    :ivar email: Email id of the principal.
    :vartype email: str
    :ivar type: Type of the principal.
    :vartype type: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        display_name: Optional[str] = None,
        email: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Id of the principal.
        :paramtype id: str
        :keyword display_name: Display name of the principal.
        :paramtype display_name: str
        :keyword email: Email id of the principal.
        :paramtype email: str
        :keyword type: Type of the principal.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.email = email
        self.type = type


class ExpandedPropertiesRoleDefinition(_serialization.Model):
    """Details of role definition.

    :ivar id: Id of the role definition.
    :vartype id: str
    :ivar display_name: Display name of the role definition.
    :vartype display_name: str
    :ivar type: Type of the role definition.
    :vartype type: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        display_name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Id of the role definition.
        :paramtype id: str
        :keyword display_name: Display name of the role definition.
        :paramtype display_name: str
        :keyword type: Type of the role definition.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.type = type


class ExpandedPropertiesScope(_serialization.Model):
    """Details of the resource scope.

    :ivar id: Scope id of the resource.
    :vartype id: str
    :ivar display_name: Display name of the resource.
    :vartype display_name: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        display_name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Scope id of the resource.
        :paramtype id: str
        :keyword display_name: Display name of the resource.
        :paramtype display_name: str
        :keyword type: Type of the resource.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.type = type


class Operation(_serialization.Model):
    """The definition of a Microsoft.Authorization operation.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: Display of the operation.
    :vartype display: ~azure.mgmt.authorization.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: Display of the operation.
        :paramtype display: ~azure.mgmt.authorization.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin


class OperationDisplay(_serialization.Model):
    """The display information for a Microsoft.Authorization operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The resource provider name: Microsoft.Authorization.
    :vartype provider: str
    :ivar resource: The resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: The operation that users can perform.
    :vartype operation: str
    :ivar description: The description for the operation.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider: Optional[str] = None
        self.resource: Optional[str] = None
        self.operation: Optional[str] = None
        self.description: Optional[str] = None


class OperationListResult(_serialization.Model):
    """The result of a request to list Microsoft.Authorization operations.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.authorization.models.Operation]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.authorization.models.Operation]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Permission(_serialization.Model):
    """Role definition permissions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar actions: Allowed actions.
    :vartype actions: list[str]
    :ivar not_actions: Denied actions.
    :vartype not_actions: list[str]
    :ivar data_actions: Allowed Data actions.
    :vartype data_actions: list[str]
    :ivar not_data_actions: Denied Data actions.
    :vartype not_data_actions: list[str]
    :ivar condition: The conditions on the role definition. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :vartype condition: str
    :ivar condition_version: Version of the condition. Currently the only accepted value is '2.0'.
    :vartype condition_version: str
    """

    _validation = {
        "condition": {"readonly": True},
        "condition_version": {"readonly": True},
    }

    _attribute_map = {
        "actions": {"key": "actions", "type": "[str]"},
        "not_actions": {"key": "notActions", "type": "[str]"},
        "data_actions": {"key": "dataActions", "type": "[str]"},
        "not_data_actions": {"key": "notDataActions", "type": "[str]"},
        "condition": {"key": "condition", "type": "str"},
        "condition_version": {"key": "conditionVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        actions: Optional[List[str]] = None,
        not_actions: Optional[List[str]] = None,
        data_actions: Optional[List[str]] = None,
        not_data_actions: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword actions: Allowed actions.
        :paramtype actions: list[str]
        :keyword not_actions: Denied actions.
        :paramtype not_actions: list[str]
        :keyword data_actions: Allowed Data actions.
        :paramtype data_actions: list[str]
        :keyword not_data_actions: Denied Data actions.
        :paramtype not_data_actions: list[str]
        """
        super().__init__(**kwargs)
        self.actions = actions
        self.not_actions = not_actions
        self.data_actions = data_actions
        self.not_data_actions = not_data_actions
        self.condition: Optional[str] = None
        self.condition_version: Optional[str] = None


class PermissionGetResult(_serialization.Model):
    """Permissions information.

    :ivar value: An array of permissions.
    :vartype value: list[~azure.mgmt.authorization.models.Permission]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Permission]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Permission"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of permissions.
        :paramtype value: list[~azure.mgmt.authorization.models.Permission]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PIMOnlyModeSettings(_serialization.Model):
    """The PIM Only Mode settings.

    :ivar mode: Determines whether the setting is enabled, disabled or report only. Known values
     are: "Disabled", "Enabled", and "ReportOnly".
    :vartype mode: str or ~azure.mgmt.authorization.models.PIMOnlyMode
    :ivar excludes: The list of excluded entities that the rule does not apply to.
    :vartype excludes: list[~azure.mgmt.authorization.models.UsersOrServicePrincipalSet]
    :ivar excluded_assignment_types: The list of excluded assignment types allowed.
    :vartype excluded_assignment_types: list[str or
     ~azure.mgmt.authorization.models.ExcludedPrincipalTypes]
    """

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "excludes": {"key": "excludes", "type": "[UsersOrServicePrincipalSet]"},
        "excluded_assignment_types": {"key": "excludedAssignmentTypes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.PIMOnlyMode"]] = None,
        excludes: Optional[List["_models.UsersOrServicePrincipalSet"]] = None,
        excluded_assignment_types: Optional[List[Union[str, "_models.ExcludedPrincipalTypes"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: Determines whether the setting is enabled, disabled or report only. Known values
         are: "Disabled", "Enabled", and "ReportOnly".
        :paramtype mode: str or ~azure.mgmt.authorization.models.PIMOnlyMode
        :keyword excludes: The list of excluded entities that the rule does not apply to.
        :paramtype excludes: list[~azure.mgmt.authorization.models.UsersOrServicePrincipalSet]
        :keyword excluded_assignment_types: The list of excluded assignment types allowed.
        :paramtype excluded_assignment_types: list[str or
         ~azure.mgmt.authorization.models.ExcludedPrincipalTypes]
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.excludes = excludes
        self.excluded_assignment_types = excluded_assignment_types


class PolicyAssignmentProperties(_serialization.Model):
    """Expanded info of resource scope, role definition and policy.

    :ivar scope: Details of the resource scope.
    :vartype scope: ~azure.mgmt.authorization.models.PolicyAssignmentPropertiesScope
    :ivar role_definition: Details of role definition.
    :vartype role_definition:
     ~azure.mgmt.authorization.models.PolicyAssignmentPropertiesRoleDefinition
    :ivar policy: Details of the policy.
    :vartype policy: ~azure.mgmt.authorization.models.PolicyAssignmentPropertiesPolicy
    """

    _attribute_map = {
        "scope": {"key": "scope", "type": "PolicyAssignmentPropertiesScope"},
        "role_definition": {"key": "roleDefinition", "type": "PolicyAssignmentPropertiesRoleDefinition"},
        "policy": {"key": "policy", "type": "PolicyAssignmentPropertiesPolicy"},
    }

    def __init__(
        self,
        *,
        scope: Optional["_models.PolicyAssignmentPropertiesScope"] = None,
        role_definition: Optional["_models.PolicyAssignmentPropertiesRoleDefinition"] = None,
        policy: Optional["_models.PolicyAssignmentPropertiesPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: Details of the resource scope.
        :paramtype scope: ~azure.mgmt.authorization.models.PolicyAssignmentPropertiesScope
        :keyword role_definition: Details of role definition.
        :paramtype role_definition:
         ~azure.mgmt.authorization.models.PolicyAssignmentPropertiesRoleDefinition
        :keyword policy: Details of the policy.
        :paramtype policy: ~azure.mgmt.authorization.models.PolicyAssignmentPropertiesPolicy
        """
        super().__init__(**kwargs)
        self.scope = scope
        self.role_definition = role_definition
        self.policy = policy


class PolicyAssignmentPropertiesPolicy(_serialization.Model):
    """Details of the policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of the policy.
    :vartype id: str
    :ivar last_modified_by: The name of the entity last modified it.
    :vartype last_modified_by: ~azure.mgmt.authorization.models.Principal
    :ivar last_modified_date_time: The last modified date time.
    :vartype last_modified_date_time: ~datetime.datetime
    """

    _validation = {
        "last_modified_by": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "Principal"},
        "last_modified_date_time": {"key": "lastModifiedDateTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        last_modified_date_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Id of the policy.
        :paramtype id: str
        :keyword last_modified_date_time: The last modified date time.
        :paramtype last_modified_date_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.id = id
        self.last_modified_by: Optional["_models.Principal"] = None
        self.last_modified_date_time = last_modified_date_time


class PolicyAssignmentPropertiesRoleDefinition(_serialization.Model):
    """Details of role definition.

    :ivar id: Id of the role definition.
    :vartype id: str
    :ivar display_name: Display name of the role definition.
    :vartype display_name: str
    :ivar type: Type of the role definition.
    :vartype type: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        display_name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Id of the role definition.
        :paramtype id: str
        :keyword display_name: Display name of the role definition.
        :paramtype display_name: str
        :keyword type: Type of the role definition.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.type = type


class PolicyAssignmentPropertiesScope(_serialization.Model):
    """Details of the resource scope.

    :ivar id: Scope id of the resource.
    :vartype id: str
    :ivar display_name: Display name of the resource.
    :vartype display_name: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        display_name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Scope id of the resource.
        :paramtype id: str
        :keyword display_name: Display name of the resource.
        :paramtype display_name: str
        :keyword type: Type of the resource.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.type = type


class PolicyProperties(_serialization.Model):
    """Expanded info of resource scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar scope: Details of the resource scope.
    :vartype scope: ~azure.mgmt.authorization.models.PolicyPropertiesScope
    """

    _validation = {
        "scope": {"readonly": True},
    }

    _attribute_map = {
        "scope": {"key": "scope", "type": "PolicyPropertiesScope"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.scope: Optional["_models.PolicyPropertiesScope"] = None


class PolicyPropertiesScope(_serialization.Model):
    """Details of the resource scope.

    :ivar id: Scope id of the resource.
    :vartype id: str
    :ivar display_name: Display name of the resource.
    :vartype display_name: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        display_name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Scope id of the resource.
        :paramtype id: str
        :keyword display_name: Display name of the resource.
        :paramtype display_name: str
        :keyword type: Type of the resource.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.type = type


class Principal(_serialization.Model):
    """The name of the entity last modified it.

    :ivar id: The id of the principal made changes.
    :vartype id: str
    :ivar display_name: The name of the principal made changes.
    :vartype display_name: str
    :ivar type: Type of principal such as user , group etc.
    :vartype type: str
    :ivar email: Email of principal.
    :vartype email: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "email": {"key": "email", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        display_name: Optional[str] = None,
        type: Optional[str] = None,
        email: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the principal made changes.
        :paramtype id: str
        :keyword display_name: The name of the principal made changes.
        :paramtype display_name: str
        :keyword type: Type of principal such as user , group etc.
        :paramtype type: str
        :keyword email: Email of principal.
        :paramtype email: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.type = type
        self.email = email


class ProviderOperation(_serialization.Model):
    """Operation.

    :ivar name: The operation name.
    :vartype name: str
    :ivar display_name: The operation display name.
    :vartype display_name: str
    :ivar description: The operation description.
    :vartype description: str
    :ivar origin: The operation origin.
    :vartype origin: str
    :ivar properties: The operation properties.
    :vartype properties: JSON
    :ivar is_data_action: The dataAction flag to specify the operation type.
    :vartype is_data_action: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "object"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        origin: Optional[str] = None,
        properties: Optional[JSON] = None,
        is_data_action: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The operation name.
        :paramtype name: str
        :keyword display_name: The operation display name.
        :paramtype display_name: str
        :keyword description: The operation description.
        :paramtype description: str
        :keyword origin: The operation origin.
        :paramtype origin: str
        :keyword properties: The operation properties.
        :paramtype properties: JSON
        :keyword is_data_action: The dataAction flag to specify the operation type.
        :paramtype is_data_action: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.description = description
        self.origin = origin
        self.properties = properties
        self.is_data_action = is_data_action


class ProviderOperationsMetadata(_serialization.Model):
    """Provider Operations metadata.

    :ivar id: The provider id.
    :vartype id: str
    :ivar name: The provider name.
    :vartype name: str
    :ivar type: The provider type.
    :vartype type: str
    :ivar display_name: The provider display name.
    :vartype display_name: str
    :ivar resource_types: The provider resource types.
    :vartype resource_types: list[~azure.mgmt.authorization.models.ResourceType]
    :ivar operations: The provider operations.
    :vartype operations: list[~azure.mgmt.authorization.models.ProviderOperation]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "resource_types": {"key": "resourceTypes", "type": "[ResourceType]"},
        "operations": {"key": "operations", "type": "[ProviderOperation]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        display_name: Optional[str] = None,
        resource_types: Optional[List["_models.ResourceType"]] = None,
        operations: Optional[List["_models.ProviderOperation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The provider id.
        :paramtype id: str
        :keyword name: The provider name.
        :paramtype name: str
        :keyword type: The provider type.
        :paramtype type: str
        :keyword display_name: The provider display name.
        :paramtype display_name: str
        :keyword resource_types: The provider resource types.
        :paramtype resource_types: list[~azure.mgmt.authorization.models.ResourceType]
        :keyword operations: The provider operations.
        :paramtype operations: list[~azure.mgmt.authorization.models.ProviderOperation]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.display_name = display_name
        self.resource_types = resource_types
        self.operations = operations


class ProviderOperationsMetadataListResult(_serialization.Model):
    """Provider operations metadata list.

    :ivar value: The list of providers.
    :vartype value: list[~azure.mgmt.authorization.models.ProviderOperationsMetadata]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ProviderOperationsMetadata]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ProviderOperationsMetadata"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of providers.
        :paramtype value: list[~azure.mgmt.authorization.models.ProviderOperationsMetadata]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RecordAllDecisionsProperties(_serialization.Model):
    """Record All Decisions payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The id of principal which needs to be approved/denied.
    :vartype principal_id: str
    :ivar resource_id: The id of resource which needs to be approved/denied.
    :vartype resource_id: str
    :ivar decision: The decision to make. Approvers can take action of Approve/Deny. Known values
     are: "Approve" and "Deny".
    :vartype decision: str or ~azure.mgmt.authorization.models.RecordAllDecisionsResult
    :ivar justification: Justification provided by approvers for their action.
    :vartype justification: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "resource_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "decision": {"key": "decision", "type": "str"},
        "justification": {"key": "justification", "type": "str"},
    }

    def __init__(
        self,
        *,
        decision: Optional[Union[str, "_models.RecordAllDecisionsResult"]] = None,
        justification: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword decision: The decision to make. Approvers can take action of Approve/Deny. Known
         values are: "Approve" and "Deny".
        :paramtype decision: str or ~azure.mgmt.authorization.models.RecordAllDecisionsResult
        :keyword justification: Justification provided by approvers for their action.
        :paramtype justification: str
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.resource_id: Optional[str] = None
        self.decision = decision
        self.justification = justification


class ResourceType(_serialization.Model):
    """Resource Type.

    :ivar name: The resource type name.
    :vartype name: str
    :ivar display_name: The resource type display name.
    :vartype display_name: str
    :ivar operations: The resource type operations.
    :vartype operations: list[~azure.mgmt.authorization.models.ProviderOperation]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "operations": {"key": "operations", "type": "[ProviderOperation]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        operations: Optional[List["_models.ProviderOperation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The resource type name.
        :paramtype name: str
        :keyword display_name: The resource type display name.
        :paramtype display_name: str
        :keyword operations: The resource type operations.
        :paramtype operations: list[~azure.mgmt.authorization.models.ProviderOperation]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.operations = operations


class RoleAssignment(_serialization.Model):
    """Role Assignments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role assignment ID.
    :vartype id: str
    :ivar name: The role assignment name.
    :vartype name: str
    :ivar type: The role assignment type.
    :vartype type: str
    :ivar scope: The role assignment scope.
    :vartype scope: str
    :ivar role_definition_id: The role definition ID.
    :vartype role_definition_id: str
    :ivar principal_id: The principal ID.
    :vartype principal_id: str
    :ivar principal_type: The principal type of the assigned principal ID. Known values are:
     "User", "Group", "ServicePrincipal", "ForeignGroup", and "Device".
    :vartype principal_type: str or ~azure.mgmt.authorization.models.PrincipalType
    :ivar description: Description of role assignment.
    :vartype description: str
    :ivar condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :vartype condition: str
    :ivar condition_version: Version of the condition. Currently the only accepted value is '2.0'.
    :vartype condition_version: str
    :ivar created_on: Time it was created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: Time it was updated.
    :vartype updated_on: ~datetime.datetime
    :ivar created_by: Id of the user who created the assignment.
    :vartype created_by: str
    :ivar updated_by: Id of the user who updated the assignment.
    :vartype updated_by: str
    :ivar delegated_managed_identity_resource_id: Id of the delegated managed identity resource.
    :vartype delegated_managed_identity_resource_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "scope": {"readonly": True},
        "created_on": {"readonly": True},
        "updated_on": {"readonly": True},
        "created_by": {"readonly": True},
        "updated_by": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "role_definition_id": {"key": "properties.roleDefinitionId", "type": "str"},
        "principal_id": {"key": "properties.principalId", "type": "str"},
        "principal_type": {"key": "properties.principalType", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "condition": {"key": "properties.condition", "type": "str"},
        "condition_version": {"key": "properties.conditionVersion", "type": "str"},
        "created_on": {"key": "properties.createdOn", "type": "iso-8601"},
        "updated_on": {"key": "properties.updatedOn", "type": "iso-8601"},
        "created_by": {"key": "properties.createdBy", "type": "str"},
        "updated_by": {"key": "properties.updatedBy", "type": "str"},
        "delegated_managed_identity_resource_id": {
            "key": "properties.delegatedManagedIdentityResourceId",
            "type": "str",
        },
    }

    def __init__(
        self,
        *,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        principal_type: Optional[Union[str, "_models.PrincipalType"]] = None,
        description: Optional[str] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        delegated_managed_identity_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword role_definition_id: The role definition ID.
        :paramtype role_definition_id: str
        :keyword principal_id: The principal ID.
        :paramtype principal_id: str
        :keyword principal_type: The principal type of the assigned principal ID. Known values are:
         "User", "Group", "ServicePrincipal", "ForeignGroup", and "Device".
        :paramtype principal_type: str or ~azure.mgmt.authorization.models.PrincipalType
        :keyword description: Description of role assignment.
        :paramtype description: str
        :keyword condition: The conditions on the role assignment. This limits the resources it can be
         assigned to. e.g.:
         @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
         StringEqualsIgnoreCase 'foo_storage_container'.
        :paramtype condition: str
        :keyword condition_version: Version of the condition. Currently the only accepted value is
         '2.0'.
        :paramtype condition_version: str
        :keyword delegated_managed_identity_resource_id: Id of the delegated managed identity resource.
        :paramtype delegated_managed_identity_resource_id: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.scope: Optional[str] = None
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type = principal_type
        self.description = description
        self.condition = condition
        self.condition_version = condition_version
        self.created_on: Optional[datetime.datetime] = None
        self.updated_on: Optional[datetime.datetime] = None
        self.created_by: Optional[str] = None
        self.updated_by: Optional[str] = None
        self.delegated_managed_identity_resource_id = delegated_managed_identity_resource_id


class RoleAssignmentCreateParameters(_serialization.Model):
    """Role assignment create parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar scope: The role assignment scope.
    :vartype scope: str
    :ivar role_definition_id: The role definition ID. Required.
    :vartype role_definition_id: str
    :ivar principal_id: The principal ID. Required.
    :vartype principal_id: str
    :ivar principal_type: The principal type of the assigned principal ID. Known values are:
     "User", "Group", "ServicePrincipal", "ForeignGroup", and "Device".
    :vartype principal_type: str or ~azure.mgmt.authorization.models.PrincipalType
    :ivar description: Description of role assignment.
    :vartype description: str
    :ivar condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :vartype condition: str
    :ivar condition_version: Version of the condition. Currently the only accepted value is '2.0'.
    :vartype condition_version: str
    :ivar created_on: Time it was created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: Time it was updated.
    :vartype updated_on: ~datetime.datetime
    :ivar created_by: Id of the user who created the assignment.
    :vartype created_by: str
    :ivar updated_by: Id of the user who updated the assignment.
    :vartype updated_by: str
    :ivar delegated_managed_identity_resource_id: Id of the delegated managed identity resource.
    :vartype delegated_managed_identity_resource_id: str
    """

    _validation = {
        "scope": {"readonly": True},
        "role_definition_id": {"required": True},
        "principal_id": {"required": True},
        "created_on": {"readonly": True},
        "updated_on": {"readonly": True},
        "created_by": {"readonly": True},
        "updated_by": {"readonly": True},
    }

    _attribute_map = {
        "scope": {"key": "properties.scope", "type": "str"},
        "role_definition_id": {"key": "properties.roleDefinitionId", "type": "str"},
        "principal_id": {"key": "properties.principalId", "type": "str"},
        "principal_type": {"key": "properties.principalType", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "condition": {"key": "properties.condition", "type": "str"},
        "condition_version": {"key": "properties.conditionVersion", "type": "str"},
        "created_on": {"key": "properties.createdOn", "type": "iso-8601"},
        "updated_on": {"key": "properties.updatedOn", "type": "iso-8601"},
        "created_by": {"key": "properties.createdBy", "type": "str"},
        "updated_by": {"key": "properties.updatedBy", "type": "str"},
        "delegated_managed_identity_resource_id": {
            "key": "properties.delegatedManagedIdentityResourceId",
            "type": "str",
        },
    }

    def __init__(
        self,
        *,
        role_definition_id: str,
        principal_id: str,
        principal_type: Optional[Union[str, "_models.PrincipalType"]] = None,
        description: Optional[str] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        delegated_managed_identity_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword role_definition_id: The role definition ID. Required.
        :paramtype role_definition_id: str
        :keyword principal_id: The principal ID. Required.
        :paramtype principal_id: str
        :keyword principal_type: The principal type of the assigned principal ID. Known values are:
         "User", "Group", "ServicePrincipal", "ForeignGroup", and "Device".
        :paramtype principal_type: str or ~azure.mgmt.authorization.models.PrincipalType
        :keyword description: Description of role assignment.
        :paramtype description: str
        :keyword condition: The conditions on the role assignment. This limits the resources it can be
         assigned to. e.g.:
         @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
         StringEqualsIgnoreCase 'foo_storage_container'.
        :paramtype condition: str
        :keyword condition_version: Version of the condition. Currently the only accepted value is
         '2.0'.
        :paramtype condition_version: str
        :keyword delegated_managed_identity_resource_id: Id of the delegated managed identity resource.
        :paramtype delegated_managed_identity_resource_id: str
        """
        super().__init__(**kwargs)
        self.scope: Optional[str] = None
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type = principal_type
        self.description = description
        self.condition = condition
        self.condition_version = condition_version
        self.created_on: Optional[datetime.datetime] = None
        self.updated_on: Optional[datetime.datetime] = None
        self.created_by: Optional[str] = None
        self.updated_by: Optional[str] = None
        self.delegated_managed_identity_resource_id = delegated_managed_identity_resource_id


class RoleAssignmentFilter(_serialization.Model):
    """Role Assignments filter.

    :ivar principal_id: Returns role assignment of the specific principal.
    :vartype principal_id: str
    """

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
    }

    def __init__(self, *, principal_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword principal_id: Returns role assignment of the specific principal.
        :paramtype principal_id: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id


class RoleAssignmentListResult(_serialization.Model):
    """Role assignment list operation result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Role assignment list.
    :vartype value: list[~azure.mgmt.authorization.models.RoleAssignment]
    :ivar next_link: The skipToken to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.RoleAssignment"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Role assignment list.
        :paramtype value: list[~azure.mgmt.authorization.models.RoleAssignment]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class RoleAssignmentSchedule(_serialization.Model):
    """Role Assignment schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role assignment schedule Id.
    :vartype id: str
    :ivar name: The role assignment schedule name.
    :vartype name: str
    :ivar type: The role assignment schedule type.
    :vartype type: str
    :ivar scope: The role assignment schedule scope.
    :vartype scope: str
    :ivar role_definition_id: The role definition ID.
    :vartype role_definition_id: str
    :ivar principal_id: The principal ID.
    :vartype principal_id: str
    :ivar principal_type: The principal type of the assigned principal ID. Known values are:
     "User", "Group", "ServicePrincipal", "ForeignGroup", and "Device".
    :vartype principal_type: str or ~azure.mgmt.authorization.models.PrincipalType
    :ivar role_assignment_schedule_request_id: The id of roleAssignmentScheduleRequest used to
     create this roleAssignmentSchedule.
    :vartype role_assignment_schedule_request_id: str
    :ivar linked_role_eligibility_schedule_id: The id of roleEligibilitySchedule used to activated
     this roleAssignmentSchedule.
    :vartype linked_role_eligibility_schedule_id: str
    :ivar assignment_type: Assignment type of the role assignment schedule. Known values are:
     "Activated" and "Assigned".
    :vartype assignment_type: str or ~azure.mgmt.authorization.models.AssignmentType
    :ivar member_type: Membership type of the role assignment schedule. Known values are:
     "Inherited", "Direct", and "Group".
    :vartype member_type: str or ~azure.mgmt.authorization.models.MemberType
    :ivar status: The status of the role assignment schedule. Known values are: "Accepted",
     "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", and "PendingExternalProvisioning".
    :vartype status: str or ~azure.mgmt.authorization.models.Status
    :ivar start_date_time: Start DateTime when role assignment schedule.
    :vartype start_date_time: ~datetime.datetime
    :ivar end_date_time: End DateTime when role assignment schedule.
    :vartype end_date_time: ~datetime.datetime
    :ivar condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :vartype condition: str
    :ivar condition_version: Version of the condition. Currently accepted value is '2.0'.
    :vartype condition_version: str
    :ivar created_on: DateTime when role assignment schedule was created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: DateTime when role assignment schedule was modified.
    :vartype updated_on: ~datetime.datetime
    :ivar expanded_properties: Additional properties of principal, scope and role definition.
    :vartype expanded_properties: ~azure.mgmt.authorization.models.ExpandedProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "role_definition_id": {"key": "properties.roleDefinitionId", "type": "str"},
        "principal_id": {"key": "properties.principalId", "type": "str"},
        "principal_type": {"key": "properties.principalType", "type": "str"},
        "role_assignment_schedule_request_id": {"key": "properties.roleAssignmentScheduleRequestId", "type": "str"},
        "linked_role_eligibility_schedule_id": {"key": "properties.linkedRoleEligibilityScheduleId", "type": "str"},
        "assignment_type": {"key": "properties.assignmentType", "type": "str"},
        "member_type": {"key": "properties.memberType", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "start_date_time": {"key": "properties.startDateTime", "type": "iso-8601"},
        "end_date_time": {"key": "properties.endDateTime", "type": "iso-8601"},
        "condition": {"key": "properties.condition", "type": "str"},
        "condition_version": {"key": "properties.conditionVersion", "type": "str"},
        "created_on": {"key": "properties.createdOn", "type": "iso-8601"},
        "updated_on": {"key": "properties.updatedOn", "type": "iso-8601"},
        "expanded_properties": {"key": "properties.expandedProperties", "type": "ExpandedProperties"},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        principal_type: Optional[Union[str, "_models.PrincipalType"]] = None,
        role_assignment_schedule_request_id: Optional[str] = None,
        linked_role_eligibility_schedule_id: Optional[str] = None,
        assignment_type: Optional[Union[str, "_models.AssignmentType"]] = None,
        member_type: Optional[Union[str, "_models.MemberType"]] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        start_date_time: Optional[datetime.datetime] = None,
        end_date_time: Optional[datetime.datetime] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        created_on: Optional[datetime.datetime] = None,
        updated_on: Optional[datetime.datetime] = None,
        expanded_properties: Optional["_models.ExpandedProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: The role assignment schedule scope.
        :paramtype scope: str
        :keyword role_definition_id: The role definition ID.
        :paramtype role_definition_id: str
        :keyword principal_id: The principal ID.
        :paramtype principal_id: str
        :keyword principal_type: The principal type of the assigned principal ID. Known values are:
         "User", "Group", "ServicePrincipal", "ForeignGroup", and "Device".
        :paramtype principal_type: str or ~azure.mgmt.authorization.models.PrincipalType
        :keyword role_assignment_schedule_request_id: The id of roleAssignmentScheduleRequest used to
         create this roleAssignmentSchedule.
        :paramtype role_assignment_schedule_request_id: str
        :keyword linked_role_eligibility_schedule_id: The id of roleEligibilitySchedule used to
         activated this roleAssignmentSchedule.
        :paramtype linked_role_eligibility_schedule_id: str
        :keyword assignment_type: Assignment type of the role assignment schedule. Known values are:
         "Activated" and "Assigned".
        :paramtype assignment_type: str or ~azure.mgmt.authorization.models.AssignmentType
        :keyword member_type: Membership type of the role assignment schedule. Known values are:
         "Inherited", "Direct", and "Group".
        :paramtype member_type: str or ~azure.mgmt.authorization.models.MemberType
        :keyword status: The status of the role assignment schedule. Known values are: "Accepted",
         "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
         "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
         "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
         "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
         "ScheduleCreated", and "PendingExternalProvisioning".
        :paramtype status: str or ~azure.mgmt.authorization.models.Status
        :keyword start_date_time: Start DateTime when role assignment schedule.
        :paramtype start_date_time: ~datetime.datetime
        :keyword end_date_time: End DateTime when role assignment schedule.
        :paramtype end_date_time: ~datetime.datetime
        :keyword condition: The conditions on the role assignment. This limits the resources it can be
         assigned to. e.g.:
         @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
         StringEqualsIgnoreCase 'foo_storage_container'.
        :paramtype condition: str
        :keyword condition_version: Version of the condition. Currently accepted value is '2.0'.
        :paramtype condition_version: str
        :keyword created_on: DateTime when role assignment schedule was created.
        :paramtype created_on: ~datetime.datetime
        :keyword updated_on: DateTime when role assignment schedule was modified.
        :paramtype updated_on: ~datetime.datetime
        :keyword expanded_properties: Additional properties of principal, scope and role definition.
        :paramtype expanded_properties: ~azure.mgmt.authorization.models.ExpandedProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.scope = scope
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type = principal_type
        self.role_assignment_schedule_request_id = role_assignment_schedule_request_id
        self.linked_role_eligibility_schedule_id = linked_role_eligibility_schedule_id
        self.assignment_type = assignment_type
        self.member_type = member_type
        self.status = status
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.condition = condition
        self.condition_version = condition_version
        self.created_on = created_on
        self.updated_on = updated_on
        self.expanded_properties = expanded_properties


class RoleAssignmentScheduleFilter(_serialization.Model):
    """Role assignment schedule filter.

    :ivar principal_id: Returns role assignment schedule of the specific principal.
    :vartype principal_id: str
    :ivar role_definition_id: Returns role assignment schedule of the specific role definition.
    :vartype role_definition_id: str
    :ivar status: Returns role assignment schedule instances of the specific status.
    :vartype status: str
    """

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword principal_id: Returns role assignment schedule of the specific principal.
        :paramtype principal_id: str
        :keyword role_definition_id: Returns role assignment schedule of the specific role definition.
        :paramtype role_definition_id: str
        :keyword status: Returns role assignment schedule instances of the specific status.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id
        self.status = status


class RoleAssignmentScheduleInstance(_serialization.Model):
    """Information about current or upcoming role assignment schedule instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role assignment schedule instance ID.
    :vartype id: str
    :ivar name: The role assignment schedule instance name.
    :vartype name: str
    :ivar type: The role assignment schedule instance type.
    :vartype type: str
    :ivar scope: The role assignment schedule scope.
    :vartype scope: str
    :ivar role_definition_id: The role definition ID.
    :vartype role_definition_id: str
    :ivar principal_id: The principal ID.
    :vartype principal_id: str
    :ivar principal_type: The principal type of the assigned principal ID. Known values are:
     "User", "Group", "ServicePrincipal", "ForeignGroup", and "Device".
    :vartype principal_type: str or ~azure.mgmt.authorization.models.PrincipalType
    :ivar role_assignment_schedule_id: Id of the master role assignment schedule.
    :vartype role_assignment_schedule_id: str
    :ivar origin_role_assignment_id: Role Assignment Id in external system.
    :vartype origin_role_assignment_id: str
    :ivar status: The status of the role assignment schedule instance. Known values are:
     "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", and "PendingExternalProvisioning".
    :vartype status: str or ~azure.mgmt.authorization.models.Status
    :ivar start_date_time: The startDateTime of the role assignment schedule instance.
    :vartype start_date_time: ~datetime.datetime
    :ivar end_date_time: The endDateTime of the role assignment schedule instance.
    :vartype end_date_time: ~datetime.datetime
    :ivar linked_role_eligibility_schedule_id: roleEligibilityScheduleId used to activate.
    :vartype linked_role_eligibility_schedule_id: str
    :ivar linked_role_eligibility_schedule_instance_id: roleEligibilityScheduleInstanceId linked to
     this roleAssignmentScheduleInstance.
    :vartype linked_role_eligibility_schedule_instance_id: str
    :ivar assignment_type: Assignment type of the role assignment schedule. Known values are:
     "Activated" and "Assigned".
    :vartype assignment_type: str or ~azure.mgmt.authorization.models.AssignmentType
    :ivar member_type: Membership type of the role assignment schedule. Known values are:
     "Inherited", "Direct", and "Group".
    :vartype member_type: str or ~azure.mgmt.authorization.models.MemberType
    :ivar condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :vartype condition: str
    :ivar condition_version: Version of the condition. Currently accepted value is '2.0'.
    :vartype condition_version: str
    :ivar created_on: DateTime when role assignment schedule was created.
    :vartype created_on: ~datetime.datetime
    :ivar expanded_properties: Additional properties of principal, scope and role definition.
    :vartype expanded_properties: ~azure.mgmt.authorization.models.ExpandedProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "role_definition_id": {"key": "properties.roleDefinitionId", "type": "str"},
        "principal_id": {"key": "properties.principalId", "type": "str"},
        "principal_type": {"key": "properties.principalType", "type": "str"},
        "role_assignment_schedule_id": {"key": "properties.roleAssignmentScheduleId", "type": "str"},
        "origin_role_assignment_id": {"key": "properties.originRoleAssignmentId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "start_date_time": {"key": "properties.startDateTime", "type": "iso-8601"},
        "end_date_time": {"key": "properties.endDateTime", "type": "iso-8601"},
        "linked_role_eligibility_schedule_id": {"key": "properties.linkedRoleEligibilityScheduleId", "type": "str"},
        "linked_role_eligibility_schedule_instance_id": {
            "key": "properties.linkedRoleEligibilityScheduleInstanceId",
            "type": "str",
        },
        "assignment_type": {"key": "properties.assignmentType", "type": "str"},
        "member_type": {"key": "properties.memberType", "type": "str"},
        "condition": {"key": "properties.condition", "type": "str"},
        "condition_version": {"key": "properties.conditionVersion", "type": "str"},
        "created_on": {"key": "properties.createdOn", "type": "iso-8601"},
        "expanded_properties": {"key": "properties.expandedProperties", "type": "ExpandedProperties"},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        principal_type: Optional[Union[str, "_models.PrincipalType"]] = None,
        role_assignment_schedule_id: Optional[str] = None,
        origin_role_assignment_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        start_date_time: Optional[datetime.datetime] = None,
        end_date_time: Optional[datetime.datetime] = None,
        linked_role_eligibility_schedule_id: Optional[str] = None,
        linked_role_eligibility_schedule_instance_id: Optional[str] = None,
        assignment_type: Optional[Union[str, "_models.AssignmentType"]] = None,
        member_type: Optional[Union[str, "_models.MemberType"]] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        created_on: Optional[datetime.datetime] = None,
        expanded_properties: Optional["_models.ExpandedProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: The role assignment schedule scope.
        :paramtype scope: str
        :keyword role_definition_id: The role definition ID.
        :paramtype role_definition_id: str
        :keyword principal_id: The principal ID.
        :paramtype principal_id: str
        :keyword principal_type: The principal type of the assigned principal ID. Known values are:
         "User", "Group", "ServicePrincipal", "ForeignGroup", and "Device".
        :paramtype principal_type: str or ~azure.mgmt.authorization.models.PrincipalType
        :keyword role_assignment_schedule_id: Id of the master role assignment schedule.
        :paramtype role_assignment_schedule_id: str
        :keyword origin_role_assignment_id: Role Assignment Id in external system.
        :paramtype origin_role_assignment_id: str
        :keyword status: The status of the role assignment schedule instance. Known values are:
         "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
         "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
         "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
         "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
         "ScheduleCreated", and "PendingExternalProvisioning".
        :paramtype status: str or ~azure.mgmt.authorization.models.Status
        :keyword start_date_time: The startDateTime of the role assignment schedule instance.
        :paramtype start_date_time: ~datetime.datetime
        :keyword end_date_time: The endDateTime of the role assignment schedule instance.
        :paramtype end_date_time: ~datetime.datetime
        :keyword linked_role_eligibility_schedule_id: roleEligibilityScheduleId used to activate.
        :paramtype linked_role_eligibility_schedule_id: str
        :keyword linked_role_eligibility_schedule_instance_id: roleEligibilityScheduleInstanceId linked
         to this roleAssignmentScheduleInstance.
        :paramtype linked_role_eligibility_schedule_instance_id: str
        :keyword assignment_type: Assignment type of the role assignment schedule. Known values are:
         "Activated" and "Assigned".
        :paramtype assignment_type: str or ~azure.mgmt.authorization.models.AssignmentType
        :keyword member_type: Membership type of the role assignment schedule. Known values are:
         "Inherited", "Direct", and "Group".
        :paramtype member_type: str or ~azure.mgmt.authorization.models.MemberType
        :keyword condition: The conditions on the role assignment. This limits the resources it can be
         assigned to. e.g.:
         @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
         StringEqualsIgnoreCase 'foo_storage_container'.
        :paramtype condition: str
        :keyword condition_version: Version of the condition. Currently accepted value is '2.0'.
        :paramtype condition_version: str
        :keyword created_on: DateTime when role assignment schedule was created.
        :paramtype created_on: ~datetime.datetime
        :keyword expanded_properties: Additional properties of principal, scope and role definition.
        :paramtype expanded_properties: ~azure.mgmt.authorization.models.ExpandedProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.scope = scope
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type = principal_type
        self.role_assignment_schedule_id = role_assignment_schedule_id
        self.origin_role_assignment_id = origin_role_assignment_id
        self.status = status
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.linked_role_eligibility_schedule_id = linked_role_eligibility_schedule_id
        self.linked_role_eligibility_schedule_instance_id = linked_role_eligibility_schedule_instance_id
        self.assignment_type = assignment_type
        self.member_type = member_type
        self.condition = condition
        self.condition_version = condition_version
        self.created_on = created_on
        self.expanded_properties = expanded_properties


class RoleAssignmentScheduleInstanceFilter(_serialization.Model):
    """Role assignment schedule instance filter.

    :ivar principal_id: Returns role assignment schedule instances of the specific principal.
    :vartype principal_id: str
    :ivar role_definition_id: Returns role assignment schedule instances of the specific role
     definition.
    :vartype role_definition_id: str
    :ivar status: Returns role assignment schedule instances of the specific status.
    :vartype status: str
    :ivar role_assignment_schedule_id: Returns role assignment schedule instances belonging to a
     specific role assignment schedule.
    :vartype role_assignment_schedule_id: str
    """

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "role_assignment_schedule_id": {"key": "roleAssignmentScheduleId", "type": "str"},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        status: Optional[str] = None,
        role_assignment_schedule_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword principal_id: Returns role assignment schedule instances of the specific principal.
        :paramtype principal_id: str
        :keyword role_definition_id: Returns role assignment schedule instances of the specific role
         definition.
        :paramtype role_definition_id: str
        :keyword status: Returns role assignment schedule instances of the specific status.
        :paramtype status: str
        :keyword role_assignment_schedule_id: Returns role assignment schedule instances belonging to a
         specific role assignment schedule.
        :paramtype role_assignment_schedule_id: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id
        self.status = status
        self.role_assignment_schedule_id = role_assignment_schedule_id


class RoleAssignmentScheduleInstanceListResult(_serialization.Model):
    """Role assignment schedule instance list operation result.

    :ivar value: Role assignment schedule instance list.
    :vartype value: list[~azure.mgmt.authorization.models.RoleAssignmentScheduleInstance]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleAssignmentScheduleInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.RoleAssignmentScheduleInstance"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Role assignment schedule instance list.
        :paramtype value: list[~azure.mgmt.authorization.models.RoleAssignmentScheduleInstance]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleAssignmentScheduleListResult(_serialization.Model):
    """Role assignment schedule list operation result.

    :ivar value: Role assignment schedule list.
    :vartype value: list[~azure.mgmt.authorization.models.RoleAssignmentSchedule]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleAssignmentSchedule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.RoleAssignmentSchedule"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Role assignment schedule list.
        :paramtype value: list[~azure.mgmt.authorization.models.RoleAssignmentSchedule]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleAssignmentScheduleRequest(_serialization.Model):
    """Role Assignment schedule request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role assignment schedule request ID.
    :vartype id: str
    :ivar name: The role assignment schedule request name.
    :vartype name: str
    :ivar type: The role assignment schedule request type.
    :vartype type: str
    :ivar scope: The role assignment schedule request scope.
    :vartype scope: str
    :ivar role_definition_id: The role definition ID.
    :vartype role_definition_id: str
    :ivar principal_id: The principal ID.
    :vartype principal_id: str
    :ivar principal_type: The principal type of the assigned principal ID. Known values are:
     "User", "Group", "ServicePrincipal", "ForeignGroup", and "Device".
    :vartype principal_type: str or ~azure.mgmt.authorization.models.PrincipalType
    :ivar request_type: The type of the role assignment schedule request. Eg: SelfActivate,
     AdminAssign etc. Known values are: "AdminAssign", "AdminRemove", "AdminUpdate", "AdminExtend",
     "AdminRenew", "SelfActivate", "SelfDeactivate", "SelfExtend", and "SelfRenew".
    :vartype request_type: str or ~azure.mgmt.authorization.models.RequestType
    :ivar status: The status of the role assignment schedule request. Known values are: "Accepted",
     "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", and "PendingExternalProvisioning".
    :vartype status: str or ~azure.mgmt.authorization.models.Status
    :ivar approval_id: The approvalId of the role assignment schedule request.
    :vartype approval_id: str
    :ivar target_role_assignment_schedule_id: The resultant role assignment schedule id or the role
     assignment schedule id being updated.
    :vartype target_role_assignment_schedule_id: str
    :ivar target_role_assignment_schedule_instance_id: The role assignment schedule instance id
     being updated.
    :vartype target_role_assignment_schedule_instance_id: str
    :ivar schedule_info: Schedule info of the role assignment schedule.
    :vartype schedule_info:
     ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequestPropertiesScheduleInfo
    :ivar linked_role_eligibility_schedule_id: The linked role eligibility schedule id - to
     activate an eligibility.
    :vartype linked_role_eligibility_schedule_id: str
    :ivar justification: Justification for the role assignment.
    :vartype justification: str
    :ivar ticket_info: Ticket Info of the role assignment.
    :vartype ticket_info:
     ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequestPropertiesTicketInfo
    :ivar condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :vartype condition: str
    :ivar condition_version: Version of the condition. Currently accepted value is '2.0'.
    :vartype condition_version: str
    :ivar created_on: DateTime when role assignment schedule request was created.
    :vartype created_on: ~datetime.datetime
    :ivar requestor_id: Id of the user who created this request.
    :vartype requestor_id: str
    :ivar expanded_properties: Additional properties of principal, scope and role definition.
    :vartype expanded_properties: ~azure.mgmt.authorization.models.ExpandedProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "scope": {"readonly": True},
        "principal_type": {"readonly": True},
        "status": {"readonly": True},
        "approval_id": {"readonly": True},
        "created_on": {"readonly": True},
        "requestor_id": {"readonly": True},
        "expanded_properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "role_definition_id": {"key": "properties.roleDefinitionId", "type": "str"},
        "principal_id": {"key": "properties.principalId", "type": "str"},
        "principal_type": {"key": "properties.principalType", "type": "str"},
        "request_type": {"key": "properties.requestType", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "approval_id": {"key": "properties.approvalId", "type": "str"},
        "target_role_assignment_schedule_id": {"key": "properties.targetRoleAssignmentScheduleId", "type": "str"},
        "target_role_assignment_schedule_instance_id": {
            "key": "properties.targetRoleAssignmentScheduleInstanceId",
            "type": "str",
        },
        "schedule_info": {
            "key": "properties.scheduleInfo",
            "type": "RoleAssignmentScheduleRequestPropertiesScheduleInfo",
        },
        "linked_role_eligibility_schedule_id": {"key": "properties.linkedRoleEligibilityScheduleId", "type": "str"},
        "justification": {"key": "properties.justification", "type": "str"},
        "ticket_info": {"key": "properties.ticketInfo", "type": "RoleAssignmentScheduleRequestPropertiesTicketInfo"},
        "condition": {"key": "properties.condition", "type": "str"},
        "condition_version": {"key": "properties.conditionVersion", "type": "str"},
        "created_on": {"key": "properties.createdOn", "type": "iso-8601"},
        "requestor_id": {"key": "properties.requestorId", "type": "str"},
        "expanded_properties": {"key": "properties.expandedProperties", "type": "ExpandedProperties"},
    }

    def __init__(
        self,
        *,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        request_type: Optional[Union[str, "_models.RequestType"]] = None,
        target_role_assignment_schedule_id: Optional[str] = None,
        target_role_assignment_schedule_instance_id: Optional[str] = None,
        schedule_info: Optional["_models.RoleAssignmentScheduleRequestPropertiesScheduleInfo"] = None,
        linked_role_eligibility_schedule_id: Optional[str] = None,
        justification: Optional[str] = None,
        ticket_info: Optional["_models.RoleAssignmentScheduleRequestPropertiesTicketInfo"] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword role_definition_id: The role definition ID.
        :paramtype role_definition_id: str
        :keyword principal_id: The principal ID.
        :paramtype principal_id: str
        :keyword request_type: The type of the role assignment schedule request. Eg: SelfActivate,
         AdminAssign etc. Known values are: "AdminAssign", "AdminRemove", "AdminUpdate", "AdminExtend",
         "AdminRenew", "SelfActivate", "SelfDeactivate", "SelfExtend", and "SelfRenew".
        :paramtype request_type: str or ~azure.mgmt.authorization.models.RequestType
        :keyword target_role_assignment_schedule_id: The resultant role assignment schedule id or the
         role assignment schedule id being updated.
        :paramtype target_role_assignment_schedule_id: str
        :keyword target_role_assignment_schedule_instance_id: The role assignment schedule instance id
         being updated.
        :paramtype target_role_assignment_schedule_instance_id: str
        :keyword schedule_info: Schedule info of the role assignment schedule.
        :paramtype schedule_info:
         ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequestPropertiesScheduleInfo
        :keyword linked_role_eligibility_schedule_id: The linked role eligibility schedule id - to
         activate an eligibility.
        :paramtype linked_role_eligibility_schedule_id: str
        :keyword justification: Justification for the role assignment.
        :paramtype justification: str
        :keyword ticket_info: Ticket Info of the role assignment.
        :paramtype ticket_info:
         ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequestPropertiesTicketInfo
        :keyword condition: The conditions on the role assignment. This limits the resources it can be
         assigned to. e.g.:
         @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
         StringEqualsIgnoreCase 'foo_storage_container'.
        :paramtype condition: str
        :keyword condition_version: Version of the condition. Currently accepted value is '2.0'.
        :paramtype condition_version: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.scope: Optional[str] = None
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type: Optional[Union[str, "_models.PrincipalType"]] = None
        self.request_type = request_type
        self.status: Optional[Union[str, "_models.Status"]] = None
        self.approval_id: Optional[str] = None
        self.target_role_assignment_schedule_id = target_role_assignment_schedule_id
        self.target_role_assignment_schedule_instance_id = target_role_assignment_schedule_instance_id
        self.schedule_info = schedule_info
        self.linked_role_eligibility_schedule_id = linked_role_eligibility_schedule_id
        self.justification = justification
        self.ticket_info = ticket_info
        self.condition = condition
        self.condition_version = condition_version
        self.created_on: Optional[datetime.datetime] = None
        self.requestor_id: Optional[str] = None
        self.expanded_properties: Optional["_models.ExpandedProperties"] = None


class RoleAssignmentScheduleRequestFilter(_serialization.Model):
    """Role assignment schedule request filter.

    :ivar principal_id: Returns role assignment requests of the specific principal.
    :vartype principal_id: str
    :ivar role_definition_id: Returns role assignment requests of the specific role definition.
    :vartype role_definition_id: str
    :ivar requestor_id: Returns role assignment requests created by specific principal.
    :vartype requestor_id: str
    :ivar status: Returns role assignment requests of specific status.
    :vartype status: str
    """

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
        "requestor_id": {"key": "requestorId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        requestor_id: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword principal_id: Returns role assignment requests of the specific principal.
        :paramtype principal_id: str
        :keyword role_definition_id: Returns role assignment requests of the specific role definition.
        :paramtype role_definition_id: str
        :keyword requestor_id: Returns role assignment requests created by specific principal.
        :paramtype requestor_id: str
        :keyword status: Returns role assignment requests of specific status.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id
        self.requestor_id = requestor_id
        self.status = status


class RoleAssignmentScheduleRequestListResult(_serialization.Model):
    """Role assignment schedule request list operation result.

    :ivar value: Role assignment schedule request list.
    :vartype value: list[~azure.mgmt.authorization.models.RoleAssignmentScheduleRequest]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleAssignmentScheduleRequest]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.RoleAssignmentScheduleRequest"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Role assignment schedule request list.
        :paramtype value: list[~azure.mgmt.authorization.models.RoleAssignmentScheduleRequest]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleAssignmentScheduleRequestPropertiesScheduleInfo(_serialization.Model):  # pylint: disable=name-too-long
    """Schedule info of the role assignment schedule.

    :ivar start_date_time: Start DateTime of the role assignment schedule.
    :vartype start_date_time: ~datetime.datetime
    :ivar expiration: Expiration of the role assignment schedule.
    :vartype expiration:
     ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration
    """

    _attribute_map = {
        "start_date_time": {"key": "startDateTime", "type": "iso-8601"},
        "expiration": {"key": "expiration", "type": "RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration"},
    }

    def __init__(
        self,
        *,
        start_date_time: Optional[datetime.datetime] = None,
        expiration: Optional["_models.RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_date_time: Start DateTime of the role assignment schedule.
        :paramtype start_date_time: ~datetime.datetime
        :keyword expiration: Expiration of the role assignment schedule.
        :paramtype expiration:
         ~azure.mgmt.authorization.models.RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration
        """
        super().__init__(**kwargs)
        self.start_date_time = start_date_time
        self.expiration = expiration


class RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Expiration of the role assignment schedule.

    :ivar type: Type of the role assignment schedule expiration. Known values are: "AfterDuration",
     "AfterDateTime", and "NoExpiration".
    :vartype type: str or ~azure.mgmt.authorization.models.Type
    :ivar end_date_time: End DateTime of the role assignment schedule.
    :vartype end_date_time: ~datetime.datetime
    :ivar duration: Duration of the role assignment schedule in TimeSpan.
    :vartype duration: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "end_date_time": {"key": "endDateTime", "type": "iso-8601"},
        "duration": {"key": "duration", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.Type"]] = None,
        end_date_time: Optional[datetime.datetime] = None,
        duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the role assignment schedule expiration. Known values are:
         "AfterDuration", "AfterDateTime", and "NoExpiration".
        :paramtype type: str or ~azure.mgmt.authorization.models.Type
        :keyword end_date_time: End DateTime of the role assignment schedule.
        :paramtype end_date_time: ~datetime.datetime
        :keyword duration: Duration of the role assignment schedule in TimeSpan.
        :paramtype duration: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.end_date_time = end_date_time
        self.duration = duration


class RoleAssignmentScheduleRequestPropertiesTicketInfo(_serialization.Model):  # pylint: disable=name-too-long
    """Ticket Info of the role assignment.

    :ivar ticket_number: Ticket number for the role assignment.
    :vartype ticket_number: str
    :ivar ticket_system: Ticket system name for the role assignment.
    :vartype ticket_system: str
    """

    _attribute_map = {
        "ticket_number": {"key": "ticketNumber", "type": "str"},
        "ticket_system": {"key": "ticketSystem", "type": "str"},
    }

    def __init__(
        self, *, ticket_number: Optional[str] = None, ticket_system: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword ticket_number: Ticket number for the role assignment.
        :paramtype ticket_number: str
        :keyword ticket_system: Ticket system name for the role assignment.
        :paramtype ticket_system: str
        """
        super().__init__(**kwargs)
        self.ticket_number = ticket_number
        self.ticket_system = ticket_system


class RoleDefinition(_serialization.Model):
    """Role definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role definition ID.
    :vartype id: str
    :ivar name: The role definition name.
    :vartype name: str
    :ivar type: The role definition type.
    :vartype type: str
    :ivar role_name: The role name.
    :vartype role_name: str
    :ivar description: The role definition description.
    :vartype description: str
    :ivar role_type: The role type.
    :vartype role_type: str
    :ivar permissions: Role definition permissions.
    :vartype permissions: list[~azure.mgmt.authorization.models.Permission]
    :ivar assignable_scopes: Role definition assignable scopes.
    :vartype assignable_scopes: list[str]
    :ivar created_on: Time it was created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: Time it was updated.
    :vartype updated_on: ~datetime.datetime
    :ivar created_by: Id of the user who created the assignment.
    :vartype created_by: str
    :ivar updated_by: Id of the user who updated the assignment.
    :vartype updated_by: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "created_on": {"readonly": True},
        "updated_on": {"readonly": True},
        "created_by": {"readonly": True},
        "updated_by": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "role_name": {"key": "properties.roleName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "role_type": {"key": "properties.type", "type": "str"},
        "permissions": {"key": "properties.permissions", "type": "[Permission]"},
        "assignable_scopes": {"key": "properties.assignableScopes", "type": "[str]"},
        "created_on": {"key": "properties.createdOn", "type": "iso-8601"},
        "updated_on": {"key": "properties.updatedOn", "type": "iso-8601"},
        "created_by": {"key": "properties.createdBy", "type": "str"},
        "updated_by": {"key": "properties.updatedBy", "type": "str"},
    }

    def __init__(
        self,
        *,
        role_name: Optional[str] = None,
        description: Optional[str] = None,
        role_type: Optional[str] = None,
        permissions: Optional[List["_models.Permission"]] = None,
        assignable_scopes: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword role_name: The role name.
        :paramtype role_name: str
        :keyword description: The role definition description.
        :paramtype description: str
        :keyword role_type: The role type.
        :paramtype role_type: str
        :keyword permissions: Role definition permissions.
        :paramtype permissions: list[~azure.mgmt.authorization.models.Permission]
        :keyword assignable_scopes: Role definition assignable scopes.
        :paramtype assignable_scopes: list[str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.role_name = role_name
        self.description = description
        self.role_type = role_type
        self.permissions = permissions
        self.assignable_scopes = assignable_scopes
        self.created_on: Optional[datetime.datetime] = None
        self.updated_on: Optional[datetime.datetime] = None
        self.created_by: Optional[str] = None
        self.updated_by: Optional[str] = None


class RoleDefinitionFilter(_serialization.Model):
    """Role Definitions filter.

    :ivar role_name: Returns role definition with the specific name.
    :vartype role_name: str
    :ivar type: Returns role definition with the specific type.
    :vartype type: str
    """

    _attribute_map = {
        "role_name": {"key": "roleName", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, role_name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword role_name: Returns role definition with the specific name.
        :paramtype role_name: str
        :keyword type: Returns role definition with the specific type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.role_name = role_name
        self.type = type


class RoleDefinitionListResult(_serialization.Model):
    """Role definition list operation result.

    :ivar value: Role definition list.
    :vartype value: list[~azure.mgmt.authorization.models.RoleDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RoleDefinition"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Role definition list.
        :paramtype value: list[~azure.mgmt.authorization.models.RoleDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleEligibilitySchedule(_serialization.Model):
    """Role eligibility schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role eligibility schedule Id.
    :vartype id: str
    :ivar name: The role eligibility schedule name.
    :vartype name: str
    :ivar type: The role eligibility schedule type.
    :vartype type: str
    :ivar scope: The role eligibility schedule scope.
    :vartype scope: str
    :ivar role_definition_id: The role definition ID.
    :vartype role_definition_id: str
    :ivar principal_id: The principal ID.
    :vartype principal_id: str
    :ivar principal_type: The principal type of the assigned principal ID. Known values are:
     "User", "Group", "ServicePrincipal", "ForeignGroup", and "Device".
    :vartype principal_type: str or ~azure.mgmt.authorization.models.PrincipalType
    :ivar role_eligibility_schedule_request_id: The id of roleEligibilityScheduleRequest used to
     create this roleAssignmentSchedule.
    :vartype role_eligibility_schedule_request_id: str
    :ivar member_type: Membership type of the role eligibility schedule. Known values are:
     "Inherited", "Direct", and "Group".
    :vartype member_type: str or ~azure.mgmt.authorization.models.MemberType
    :ivar status: The status of the role eligibility schedule. Known values are: "Accepted",
     "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", and "PendingExternalProvisioning".
    :vartype status: str or ~azure.mgmt.authorization.models.Status
    :ivar start_date_time: Start DateTime when role eligibility schedule.
    :vartype start_date_time: ~datetime.datetime
    :ivar end_date_time: End DateTime when role eligibility schedule.
    :vartype end_date_time: ~datetime.datetime
    :ivar condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :vartype condition: str
    :ivar condition_version: Version of the condition. Currently accepted value is '2.0'.
    :vartype condition_version: str
    :ivar created_on: DateTime when role eligibility schedule was created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: DateTime when role eligibility schedule was modified.
    :vartype updated_on: ~datetime.datetime
    :ivar expanded_properties: Additional properties of principal, scope and role definition.
    :vartype expanded_properties: ~azure.mgmt.authorization.models.ExpandedProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "role_definition_id": {"key": "properties.roleDefinitionId", "type": "str"},
        "principal_id": {"key": "properties.principalId", "type": "str"},
        "principal_type": {"key": "properties.principalType", "type": "str"},
        "role_eligibility_schedule_request_id": {"key": "properties.roleEligibilityScheduleRequestId", "type": "str"},
        "member_type": {"key": "properties.memberType", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "start_date_time": {"key": "properties.startDateTime", "type": "iso-8601"},
        "end_date_time": {"key": "properties.endDateTime", "type": "iso-8601"},
        "condition": {"key": "properties.condition", "type": "str"},
        "condition_version": {"key": "properties.conditionVersion", "type": "str"},
        "created_on": {"key": "properties.createdOn", "type": "iso-8601"},
        "updated_on": {"key": "properties.updatedOn", "type": "iso-8601"},
        "expanded_properties": {"key": "properties.expandedProperties", "type": "ExpandedProperties"},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        principal_type: Optional[Union[str, "_models.PrincipalType"]] = None,
        role_eligibility_schedule_request_id: Optional[str] = None,
        member_type: Optional[Union[str, "_models.MemberType"]] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        start_date_time: Optional[datetime.datetime] = None,
        end_date_time: Optional[datetime.datetime] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        created_on: Optional[datetime.datetime] = None,
        updated_on: Optional[datetime.datetime] = None,
        expanded_properties: Optional["_models.ExpandedProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: The role eligibility schedule scope.
        :paramtype scope: str
        :keyword role_definition_id: The role definition ID.
        :paramtype role_definition_id: str
        :keyword principal_id: The principal ID.
        :paramtype principal_id: str
        :keyword principal_type: The principal type of the assigned principal ID. Known values are:
         "User", "Group", "ServicePrincipal", "ForeignGroup", and "Device".
        :paramtype principal_type: str or ~azure.mgmt.authorization.models.PrincipalType
        :keyword role_eligibility_schedule_request_id: The id of roleEligibilityScheduleRequest used to
         create this roleAssignmentSchedule.
        :paramtype role_eligibility_schedule_request_id: str
        :keyword member_type: Membership type of the role eligibility schedule. Known values are:
         "Inherited", "Direct", and "Group".
        :paramtype member_type: str or ~azure.mgmt.authorization.models.MemberType
        :keyword status: The status of the role eligibility schedule. Known values are: "Accepted",
         "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
         "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
         "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
         "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
         "ScheduleCreated", and "PendingExternalProvisioning".
        :paramtype status: str or ~azure.mgmt.authorization.models.Status
        :keyword start_date_time: Start DateTime when role eligibility schedule.
        :paramtype start_date_time: ~datetime.datetime
        :keyword end_date_time: End DateTime when role eligibility schedule.
        :paramtype end_date_time: ~datetime.datetime
        :keyword condition: The conditions on the role assignment. This limits the resources it can be
         assigned to. e.g.:
         @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
         StringEqualsIgnoreCase 'foo_storage_container'.
        :paramtype condition: str
        :keyword condition_version: Version of the condition. Currently accepted value is '2.0'.
        :paramtype condition_version: str
        :keyword created_on: DateTime when role eligibility schedule was created.
        :paramtype created_on: ~datetime.datetime
        :keyword updated_on: DateTime when role eligibility schedule was modified.
        :paramtype updated_on: ~datetime.datetime
        :keyword expanded_properties: Additional properties of principal, scope and role definition.
        :paramtype expanded_properties: ~azure.mgmt.authorization.models.ExpandedProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.scope = scope
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type = principal_type
        self.role_eligibility_schedule_request_id = role_eligibility_schedule_request_id
        self.member_type = member_type
        self.status = status
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.condition = condition
        self.condition_version = condition_version
        self.created_on = created_on
        self.updated_on = updated_on
        self.expanded_properties = expanded_properties


class RoleEligibilityScheduleFilter(_serialization.Model):
    """Role eligibility schedule filter.

    :ivar principal_id: Returns role eligibility schedule of the specific principal.
    :vartype principal_id: str
    :ivar role_definition_id: Returns role eligibility schedule of the specific role definition.
    :vartype role_definition_id: str
    :ivar status: Returns role eligibility schedule of the specific status.
    :vartype status: str
    """

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword principal_id: Returns role eligibility schedule of the specific principal.
        :paramtype principal_id: str
        :keyword role_definition_id: Returns role eligibility schedule of the specific role definition.
        :paramtype role_definition_id: str
        :keyword status: Returns role eligibility schedule of the specific status.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id
        self.status = status


class RoleEligibilityScheduleInstance(_serialization.Model):
    """Information about current or upcoming role eligibility schedule instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role eligibility schedule instance ID.
    :vartype id: str
    :ivar name: The role eligibility schedule instance name.
    :vartype name: str
    :ivar type: The role eligibility schedule instance type.
    :vartype type: str
    :ivar scope: The role eligibility schedule scope.
    :vartype scope: str
    :ivar role_definition_id: The role definition ID.
    :vartype role_definition_id: str
    :ivar principal_id: The principal ID.
    :vartype principal_id: str
    :ivar principal_type: The principal type of the assigned principal ID. Known values are:
     "User", "Group", "ServicePrincipal", "ForeignGroup", and "Device".
    :vartype principal_type: str or ~azure.mgmt.authorization.models.PrincipalType
    :ivar role_eligibility_schedule_id: Id of the master role eligibility schedule.
    :vartype role_eligibility_schedule_id: str
    :ivar status: The status of the role eligibility schedule instance. Known values are:
     "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", and "PendingExternalProvisioning".
    :vartype status: str or ~azure.mgmt.authorization.models.Status
    :ivar start_date_time: The startDateTime of the role eligibility schedule instance.
    :vartype start_date_time: ~datetime.datetime
    :ivar end_date_time: The endDateTime of the role eligibility schedule instance.
    :vartype end_date_time: ~datetime.datetime
    :ivar member_type: Membership type of the role eligibility schedule. Known values are:
     "Inherited", "Direct", and "Group".
    :vartype member_type: str or ~azure.mgmt.authorization.models.MemberType
    :ivar condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :vartype condition: str
    :ivar condition_version: Version of the condition. Currently accepted value is '2.0'.
    :vartype condition_version: str
    :ivar created_on: DateTime when role eligibility schedule was created.
    :vartype created_on: ~datetime.datetime
    :ivar expanded_properties: Additional properties of principal, scope and role definition.
    :vartype expanded_properties: ~azure.mgmt.authorization.models.ExpandedProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "role_definition_id": {"key": "properties.roleDefinitionId", "type": "str"},
        "principal_id": {"key": "properties.principalId", "type": "str"},
        "principal_type": {"key": "properties.principalType", "type": "str"},
        "role_eligibility_schedule_id": {"key": "properties.roleEligibilityScheduleId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "start_date_time": {"key": "properties.startDateTime", "type": "iso-8601"},
        "end_date_time": {"key": "properties.endDateTime", "type": "iso-8601"},
        "member_type": {"key": "properties.memberType", "type": "str"},
        "condition": {"key": "properties.condition", "type": "str"},
        "condition_version": {"key": "properties.conditionVersion", "type": "str"},
        "created_on": {"key": "properties.createdOn", "type": "iso-8601"},
        "expanded_properties": {"key": "properties.expandedProperties", "type": "ExpandedProperties"},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        principal_type: Optional[Union[str, "_models.PrincipalType"]] = None,
        role_eligibility_schedule_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        start_date_time: Optional[datetime.datetime] = None,
        end_date_time: Optional[datetime.datetime] = None,
        member_type: Optional[Union[str, "_models.MemberType"]] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        created_on: Optional[datetime.datetime] = None,
        expanded_properties: Optional["_models.ExpandedProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: The role eligibility schedule scope.
        :paramtype scope: str
        :keyword role_definition_id: The role definition ID.
        :paramtype role_definition_id: str
        :keyword principal_id: The principal ID.
        :paramtype principal_id: str
        :keyword principal_type: The principal type of the assigned principal ID. Known values are:
         "User", "Group", "ServicePrincipal", "ForeignGroup", and "Device".
        :paramtype principal_type: str or ~azure.mgmt.authorization.models.PrincipalType
        :keyword role_eligibility_schedule_id: Id of the master role eligibility schedule.
        :paramtype role_eligibility_schedule_id: str
        :keyword status: The status of the role eligibility schedule instance. Known values are:
         "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
         "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
         "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
         "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
         "ScheduleCreated", and "PendingExternalProvisioning".
        :paramtype status: str or ~azure.mgmt.authorization.models.Status
        :keyword start_date_time: The startDateTime of the role eligibility schedule instance.
        :paramtype start_date_time: ~datetime.datetime
        :keyword end_date_time: The endDateTime of the role eligibility schedule instance.
        :paramtype end_date_time: ~datetime.datetime
        :keyword member_type: Membership type of the role eligibility schedule. Known values are:
         "Inherited", "Direct", and "Group".
        :paramtype member_type: str or ~azure.mgmt.authorization.models.MemberType
        :keyword condition: The conditions on the role assignment. This limits the resources it can be
         assigned to. e.g.:
         @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
         StringEqualsIgnoreCase 'foo_storage_container'.
        :paramtype condition: str
        :keyword condition_version: Version of the condition. Currently accepted value is '2.0'.
        :paramtype condition_version: str
        :keyword created_on: DateTime when role eligibility schedule was created.
        :paramtype created_on: ~datetime.datetime
        :keyword expanded_properties: Additional properties of principal, scope and role definition.
        :paramtype expanded_properties: ~azure.mgmt.authorization.models.ExpandedProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.scope = scope
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type = principal_type
        self.role_eligibility_schedule_id = role_eligibility_schedule_id
        self.status = status
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.member_type = member_type
        self.condition = condition
        self.condition_version = condition_version
        self.created_on = created_on
        self.expanded_properties = expanded_properties


class RoleEligibilityScheduleInstanceFilter(_serialization.Model):
    """Role eligibility schedule instance filter.

    :ivar principal_id: Returns role eligibility schedule instances of the specific principal.
    :vartype principal_id: str
    :ivar role_definition_id: Returns role eligibility schedule instances of the specific role
     definition.
    :vartype role_definition_id: str
    :ivar status: Returns role eligibility schedule instances of the specific status.
    :vartype status: str
    :ivar role_eligibility_schedule_id: Returns role eligibility schedule instances belonging to a
     specific role eligibility schedule.
    :vartype role_eligibility_schedule_id: str
    """

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "role_eligibility_schedule_id": {"key": "roleEligibilityScheduleId", "type": "str"},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        status: Optional[str] = None,
        role_eligibility_schedule_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword principal_id: Returns role eligibility schedule instances of the specific principal.
        :paramtype principal_id: str
        :keyword role_definition_id: Returns role eligibility schedule instances of the specific role
         definition.
        :paramtype role_definition_id: str
        :keyword status: Returns role eligibility schedule instances of the specific status.
        :paramtype status: str
        :keyword role_eligibility_schedule_id: Returns role eligibility schedule instances belonging to
         a specific role eligibility schedule.
        :paramtype role_eligibility_schedule_id: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id
        self.status = status
        self.role_eligibility_schedule_id = role_eligibility_schedule_id


class RoleEligibilityScheduleInstanceListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Role eligibility schedule instance list operation result.

    :ivar value: Role eligibility schedule instance list.
    :vartype value: list[~azure.mgmt.authorization.models.RoleEligibilityScheduleInstance]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleEligibilityScheduleInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.RoleEligibilityScheduleInstance"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Role eligibility schedule instance list.
        :paramtype value: list[~azure.mgmt.authorization.models.RoleEligibilityScheduleInstance]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleEligibilityScheduleListResult(_serialization.Model):
    """role eligibility schedule list operation result.

    :ivar value: role eligibility schedule list.
    :vartype value: list[~azure.mgmt.authorization.models.RoleEligibilitySchedule]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleEligibilitySchedule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.RoleEligibilitySchedule"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: role eligibility schedule list.
        :paramtype value: list[~azure.mgmt.authorization.models.RoleEligibilitySchedule]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleEligibilityScheduleRequest(_serialization.Model):
    """Role Eligibility schedule request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role eligibility schedule request ID.
    :vartype id: str
    :ivar name: The role eligibility schedule request name.
    :vartype name: str
    :ivar type: The role eligibility schedule request type.
    :vartype type: str
    :ivar scope: The role eligibility schedule request scope.
    :vartype scope: str
    :ivar role_definition_id: The role definition ID.
    :vartype role_definition_id: str
    :ivar principal_id: The principal ID.
    :vartype principal_id: str
    :ivar principal_type: The principal type of the assigned principal ID. Known values are:
     "User", "Group", "ServicePrincipal", "ForeignGroup", and "Device".
    :vartype principal_type: str or ~azure.mgmt.authorization.models.PrincipalType
    :ivar request_type: The type of the role assignment schedule request. Eg: SelfActivate,
     AdminAssign etc. Known values are: "AdminAssign", "AdminRemove", "AdminUpdate", "AdminExtend",
     "AdminRenew", "SelfActivate", "SelfDeactivate", "SelfExtend", and "SelfRenew".
    :vartype request_type: str or ~azure.mgmt.authorization.models.RequestType
    :ivar status: The status of the role eligibility schedule request. Known values are:
     "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", and "PendingExternalProvisioning".
    :vartype status: str or ~azure.mgmt.authorization.models.Status
    :ivar approval_id: The approvalId of the role eligibility schedule request.
    :vartype approval_id: str
    :ivar schedule_info: Schedule info of the role eligibility schedule.
    :vartype schedule_info:
     ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequestPropertiesScheduleInfo
    :ivar target_role_eligibility_schedule_id: The resultant role eligibility schedule id or the
     role eligibility schedule id being updated.
    :vartype target_role_eligibility_schedule_id: str
    :ivar target_role_eligibility_schedule_instance_id: The role eligibility schedule instance id
     being updated.
    :vartype target_role_eligibility_schedule_instance_id: str
    :ivar justification: Justification for the role eligibility.
    :vartype justification: str
    :ivar ticket_info: Ticket Info of the role eligibility.
    :vartype ticket_info:
     ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequestPropertiesTicketInfo
    :ivar condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :vartype condition: str
    :ivar condition_version: Version of the condition. Currently accepted value is '2.0'.
    :vartype condition_version: str
    :ivar created_on: DateTime when role eligibility schedule request was created.
    :vartype created_on: ~datetime.datetime
    :ivar requestor_id: Id of the user who created this request.
    :vartype requestor_id: str
    :ivar expanded_properties: Additional properties of principal, scope and role definition.
    :vartype expanded_properties: ~azure.mgmt.authorization.models.ExpandedProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "scope": {"readonly": True},
        "principal_type": {"readonly": True},
        "status": {"readonly": True},
        "approval_id": {"readonly": True},
        "created_on": {"readonly": True},
        "requestor_id": {"readonly": True},
        "expanded_properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "role_definition_id": {"key": "properties.roleDefinitionId", "type": "str"},
        "principal_id": {"key": "properties.principalId", "type": "str"},
        "principal_type": {"key": "properties.principalType", "type": "str"},
        "request_type": {"key": "properties.requestType", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "approval_id": {"key": "properties.approvalId", "type": "str"},
        "schedule_info": {
            "key": "properties.scheduleInfo",
            "type": "RoleEligibilityScheduleRequestPropertiesScheduleInfo",
        },
        "target_role_eligibility_schedule_id": {"key": "properties.targetRoleEligibilityScheduleId", "type": "str"},
        "target_role_eligibility_schedule_instance_id": {
            "key": "properties.targetRoleEligibilityScheduleInstanceId",
            "type": "str",
        },
        "justification": {"key": "properties.justification", "type": "str"},
        "ticket_info": {"key": "properties.ticketInfo", "type": "RoleEligibilityScheduleRequestPropertiesTicketInfo"},
        "condition": {"key": "properties.condition", "type": "str"},
        "condition_version": {"key": "properties.conditionVersion", "type": "str"},
        "created_on": {"key": "properties.createdOn", "type": "iso-8601"},
        "requestor_id": {"key": "properties.requestorId", "type": "str"},
        "expanded_properties": {"key": "properties.expandedProperties", "type": "ExpandedProperties"},
    }

    def __init__(
        self,
        *,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        request_type: Optional[Union[str, "_models.RequestType"]] = None,
        schedule_info: Optional["_models.RoleEligibilityScheduleRequestPropertiesScheduleInfo"] = None,
        target_role_eligibility_schedule_id: Optional[str] = None,
        target_role_eligibility_schedule_instance_id: Optional[str] = None,
        justification: Optional[str] = None,
        ticket_info: Optional["_models.RoleEligibilityScheduleRequestPropertiesTicketInfo"] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword role_definition_id: The role definition ID.
        :paramtype role_definition_id: str
        :keyword principal_id: The principal ID.
        :paramtype principal_id: str
        :keyword request_type: The type of the role assignment schedule request. Eg: SelfActivate,
         AdminAssign etc. Known values are: "AdminAssign", "AdminRemove", "AdminUpdate", "AdminExtend",
         "AdminRenew", "SelfActivate", "SelfDeactivate", "SelfExtend", and "SelfRenew".
        :paramtype request_type: str or ~azure.mgmt.authorization.models.RequestType
        :keyword schedule_info: Schedule info of the role eligibility schedule.
        :paramtype schedule_info:
         ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequestPropertiesScheduleInfo
        :keyword target_role_eligibility_schedule_id: The resultant role eligibility schedule id or the
         role eligibility schedule id being updated.
        :paramtype target_role_eligibility_schedule_id: str
        :keyword target_role_eligibility_schedule_instance_id: The role eligibility schedule instance
         id being updated.
        :paramtype target_role_eligibility_schedule_instance_id: str
        :keyword justification: Justification for the role eligibility.
        :paramtype justification: str
        :keyword ticket_info: Ticket Info of the role eligibility.
        :paramtype ticket_info:
         ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequestPropertiesTicketInfo
        :keyword condition: The conditions on the role assignment. This limits the resources it can be
         assigned to. e.g.:
         @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
         StringEqualsIgnoreCase 'foo_storage_container'.
        :paramtype condition: str
        :keyword condition_version: Version of the condition. Currently accepted value is '2.0'.
        :paramtype condition_version: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.scope: Optional[str] = None
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type: Optional[Union[str, "_models.PrincipalType"]] = None
        self.request_type = request_type
        self.status: Optional[Union[str, "_models.Status"]] = None
        self.approval_id: Optional[str] = None
        self.schedule_info = schedule_info
        self.target_role_eligibility_schedule_id = target_role_eligibility_schedule_id
        self.target_role_eligibility_schedule_instance_id = target_role_eligibility_schedule_instance_id
        self.justification = justification
        self.ticket_info = ticket_info
        self.condition = condition
        self.condition_version = condition_version
        self.created_on: Optional[datetime.datetime] = None
        self.requestor_id: Optional[str] = None
        self.expanded_properties: Optional["_models.ExpandedProperties"] = None


class RoleEligibilityScheduleRequestFilter(_serialization.Model):
    """Role eligibility schedule request filter.

    :ivar principal_id: Returns role eligibility requests of the specific principal.
    :vartype principal_id: str
    :ivar role_definition_id: Returns role eligibility requests of the specific role definition.
    :vartype role_definition_id: str
    :ivar requestor_id: Returns role eligibility requests created by specific principal.
    :vartype requestor_id: str
    :ivar status: Returns role eligibility requests of specific status.
    :vartype status: str
    """

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
        "requestor_id": {"key": "requestorId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        requestor_id: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword principal_id: Returns role eligibility requests of the specific principal.
        :paramtype principal_id: str
        :keyword role_definition_id: Returns role eligibility requests of the specific role definition.
        :paramtype role_definition_id: str
        :keyword requestor_id: Returns role eligibility requests created by specific principal.
        :paramtype requestor_id: str
        :keyword status: Returns role eligibility requests of specific status.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id
        self.requestor_id = requestor_id
        self.status = status


class RoleEligibilityScheduleRequestListResult(_serialization.Model):
    """Role eligibility schedule request list operation result.

    :ivar value: Role eligibility schedule request list.
    :vartype value: list[~azure.mgmt.authorization.models.RoleEligibilityScheduleRequest]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleEligibilityScheduleRequest]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.RoleEligibilityScheduleRequest"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Role eligibility schedule request list.
        :paramtype value: list[~azure.mgmt.authorization.models.RoleEligibilityScheduleRequest]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleEligibilityScheduleRequestPropertiesScheduleInfo(_serialization.Model):  # pylint: disable=name-too-long
    """Schedule info of the role eligibility schedule.

    :ivar start_date_time: Start DateTime of the role eligibility schedule.
    :vartype start_date_time: ~datetime.datetime
    :ivar expiration: Expiration of the role eligibility schedule.
    :vartype expiration:
     ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration
    """

    _attribute_map = {
        "start_date_time": {"key": "startDateTime", "type": "iso-8601"},
        "expiration": {"key": "expiration", "type": "RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration"},
    }

    def __init__(
        self,
        *,
        start_date_time: Optional[datetime.datetime] = None,
        expiration: Optional["_models.RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_date_time: Start DateTime of the role eligibility schedule.
        :paramtype start_date_time: ~datetime.datetime
        :keyword expiration: Expiration of the role eligibility schedule.
        :paramtype expiration:
         ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration
        """
        super().__init__(**kwargs)
        self.start_date_time = start_date_time
        self.expiration = expiration


class RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Expiration of the role eligibility schedule.

    :ivar type: Type of the role eligibility schedule expiration. Known values are:
     "AfterDuration", "AfterDateTime", and "NoExpiration".
    :vartype type: str or ~azure.mgmt.authorization.models.Type
    :ivar end_date_time: End DateTime of the role eligibility schedule.
    :vartype end_date_time: ~datetime.datetime
    :ivar duration: Duration of the role eligibility schedule in TimeSpan.
    :vartype duration: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "end_date_time": {"key": "endDateTime", "type": "iso-8601"},
        "duration": {"key": "duration", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.Type"]] = None,
        end_date_time: Optional[datetime.datetime] = None,
        duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the role eligibility schedule expiration. Known values are:
         "AfterDuration", "AfterDateTime", and "NoExpiration".
        :paramtype type: str or ~azure.mgmt.authorization.models.Type
        :keyword end_date_time: End DateTime of the role eligibility schedule.
        :paramtype end_date_time: ~datetime.datetime
        :keyword duration: Duration of the role eligibility schedule in TimeSpan.
        :paramtype duration: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.end_date_time = end_date_time
        self.duration = duration


class RoleEligibilityScheduleRequestPropertiesTicketInfo(_serialization.Model):  # pylint: disable=name-too-long
    """Ticket Info of the role eligibility.

    :ivar ticket_number: Ticket number for the role eligibility.
    :vartype ticket_number: str
    :ivar ticket_system: Ticket system name for the role eligibility.
    :vartype ticket_system: str
    """

    _attribute_map = {
        "ticket_number": {"key": "ticketNumber", "type": "str"},
        "ticket_system": {"key": "ticketSystem", "type": "str"},
    }

    def __init__(
        self, *, ticket_number: Optional[str] = None, ticket_system: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword ticket_number: Ticket number for the role eligibility.
        :paramtype ticket_number: str
        :keyword ticket_system: Ticket system name for the role eligibility.
        :paramtype ticket_system: str
        """
        super().__init__(**kwargs)
        self.ticket_number = ticket_number
        self.ticket_system = ticket_system


class RoleManagementPolicy(_serialization.Model):
    """Role management policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role management policy Id.
    :vartype id: str
    :ivar name: The role management policy name.
    :vartype name: str
    :ivar type: The role management policy type.
    :vartype type: str
    :ivar scope: The role management policy scope.
    :vartype scope: str
    :ivar display_name: The role management policy display name.
    :vartype display_name: str
    :ivar description: The role management policy description.
    :vartype description: str
    :ivar is_organization_default: The role management policy is default policy.
    :vartype is_organization_default: bool
    :ivar last_modified_by: The name of the entity last modified it.
    :vartype last_modified_by: ~azure.mgmt.authorization.models.Principal
    :ivar last_modified_date_time: The last modified date time.
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar rules: The rule applied to the policy.
    :vartype rules: list[~azure.mgmt.authorization.models.RoleManagementPolicyRule]
    :ivar effective_rules: The readonly computed rule applied to the policy.
    :vartype effective_rules: list[~azure.mgmt.authorization.models.RoleManagementPolicyRule]
    :ivar policy_properties: Additional properties of scope.
    :vartype policy_properties: ~azure.mgmt.authorization.models.PolicyProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "last_modified_by": {"readonly": True},
        "last_modified_date_time": {"readonly": True},
        "effective_rules": {"readonly": True},
        "policy_properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "is_organization_default": {"key": "properties.isOrganizationDefault", "type": "bool"},
        "last_modified_by": {"key": "properties.lastModifiedBy", "type": "Principal"},
        "last_modified_date_time": {"key": "properties.lastModifiedDateTime", "type": "iso-8601"},
        "rules": {"key": "properties.rules", "type": "[RoleManagementPolicyRule]"},
        "effective_rules": {"key": "properties.effectiveRules", "type": "[RoleManagementPolicyRule]"},
        "policy_properties": {"key": "properties.policyProperties", "type": "PolicyProperties"},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        is_organization_default: Optional[bool] = None,
        rules: Optional[List["_models.RoleManagementPolicyRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: The role management policy scope.
        :paramtype scope: str
        :keyword display_name: The role management policy display name.
        :paramtype display_name: str
        :keyword description: The role management policy description.
        :paramtype description: str
        :keyword is_organization_default: The role management policy is default policy.
        :paramtype is_organization_default: bool
        :keyword rules: The rule applied to the policy.
        :paramtype rules: list[~azure.mgmt.authorization.models.RoleManagementPolicyRule]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.scope = scope
        self.display_name = display_name
        self.description = description
        self.is_organization_default = is_organization_default
        self.last_modified_by: Optional["_models.Principal"] = None
        self.last_modified_date_time: Optional[datetime.datetime] = None
        self.rules = rules
        self.effective_rules: Optional[List["_models.RoleManagementPolicyRule"]] = None
        self.policy_properties: Optional["_models.PolicyProperties"] = None


class RoleManagementPolicyRule(_serialization.Model):
    """The role management policy rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    RoleManagementPolicyApprovalRule, RoleManagementPolicyAuthenticationContextRule,
    RoleManagementPolicyEnablementRule, RoleManagementPolicyExpirationRule,
    RoleManagementPolicyNotificationRule, RoleManagementPolicyPimOnlyModeRule

    All required parameters must be populated in order to send to server.

    :ivar id: The id of the rule.
    :vartype id: str
    :ivar rule_type: The type of rule. Required. Known values are:
     "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule", and "RoleManagementPolicyPimOnlyModeRule".
    :vartype rule_type: str or ~azure.mgmt.authorization.models.RoleManagementPolicyRuleType
    :ivar target: The target of the current rule.
    :vartype target: ~azure.mgmt.authorization.models.RoleManagementPolicyRuleTarget
    """

    _validation = {
        "rule_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "target": {"key": "target", "type": "RoleManagementPolicyRuleTarget"},
    }

    _subtype_map = {
        "rule_type": {
            "RoleManagementPolicyApprovalRule": "RoleManagementPolicyApprovalRule",
            "RoleManagementPolicyAuthenticationContextRule": "RoleManagementPolicyAuthenticationContextRule",
            "RoleManagementPolicyEnablementRule": "RoleManagementPolicyEnablementRule",
            "RoleManagementPolicyExpirationRule": "RoleManagementPolicyExpirationRule",
            "RoleManagementPolicyNotificationRule": "RoleManagementPolicyNotificationRule",
            "RoleManagementPolicyPimOnlyModeRule": "RoleManagementPolicyPimOnlyModeRule",
        }
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        target: Optional["_models.RoleManagementPolicyRuleTarget"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the rule.
        :paramtype id: str
        :keyword target: The target of the current rule.
        :paramtype target: ~azure.mgmt.authorization.models.RoleManagementPolicyRuleTarget
        """
        super().__init__(**kwargs)
        self.id = id
        self.rule_type: Optional[str] = None
        self.target = target


class RoleManagementPolicyApprovalRule(RoleManagementPolicyRule):
    """The role management policy approval rule.

    All required parameters must be populated in order to send to server.

    :ivar id: The id of the rule.
    :vartype id: str
    :ivar rule_type: The type of rule. Required. Known values are:
     "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule", and "RoleManagementPolicyPimOnlyModeRule".
    :vartype rule_type: str or ~azure.mgmt.authorization.models.RoleManagementPolicyRuleType
    :ivar target: The target of the current rule.
    :vartype target: ~azure.mgmt.authorization.models.RoleManagementPolicyRuleTarget
    :ivar setting: The approval setting.
    :vartype setting: ~azure.mgmt.authorization.models.ApprovalSettings
    """

    _validation = {
        "rule_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "target": {"key": "target", "type": "RoleManagementPolicyRuleTarget"},
        "setting": {"key": "setting", "type": "ApprovalSettings"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        target: Optional["_models.RoleManagementPolicyRuleTarget"] = None,
        setting: Optional["_models.ApprovalSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the rule.
        :paramtype id: str
        :keyword target: The target of the current rule.
        :paramtype target: ~azure.mgmt.authorization.models.RoleManagementPolicyRuleTarget
        :keyword setting: The approval setting.
        :paramtype setting: ~azure.mgmt.authorization.models.ApprovalSettings
        """
        super().__init__(id=id, target=target, **kwargs)
        self.rule_type: str = "RoleManagementPolicyApprovalRule"
        self.setting = setting


class RoleManagementPolicyAssignment(_serialization.Model):
    """Role management policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role management policy Id.
    :vartype id: str
    :ivar name: The role management policy name.
    :vartype name: str
    :ivar type: The role management policy type.
    :vartype type: str
    :ivar scope: The role management policy scope.
    :vartype scope: str
    :ivar role_definition_id: The role definition of management policy assignment.
    :vartype role_definition_id: str
    :ivar policy_id: The policy id role management policy assignment.
    :vartype policy_id: str
    :ivar effective_rules: The readonly computed rule applied to the policy.
    :vartype effective_rules: list[~azure.mgmt.authorization.models.RoleManagementPolicyRule]
    :ivar policy_assignment_properties: Additional properties of scope, role definition and policy.
    :vartype policy_assignment_properties:
     ~azure.mgmt.authorization.models.PolicyAssignmentProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "effective_rules": {"readonly": True},
        "policy_assignment_properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "role_definition_id": {"key": "properties.roleDefinitionId", "type": "str"},
        "policy_id": {"key": "properties.policyId", "type": "str"},
        "effective_rules": {"key": "properties.effectiveRules", "type": "[RoleManagementPolicyRule]"},
        "policy_assignment_properties": {
            "key": "properties.policyAssignmentProperties",
            "type": "PolicyAssignmentProperties",
        },
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope: The role management policy scope.
        :paramtype scope: str
        :keyword role_definition_id: The role definition of management policy assignment.
        :paramtype role_definition_id: str
        :keyword policy_id: The policy id role management policy assignment.
        :paramtype policy_id: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.scope = scope
        self.role_definition_id = role_definition_id
        self.policy_id = policy_id
        self.effective_rules: Optional[List["_models.RoleManagementPolicyRule"]] = None
        self.policy_assignment_properties: Optional["_models.PolicyAssignmentProperties"] = None


class RoleManagementPolicyAssignmentListResult(_serialization.Model):
    """Role management policy assignment list operation result.

    :ivar value: Role management policy assignment list.
    :vartype value: list[~azure.mgmt.authorization.models.RoleManagementPolicyAssignment]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleManagementPolicyAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.RoleManagementPolicyAssignment"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Role management policy assignment list.
        :paramtype value: list[~azure.mgmt.authorization.models.RoleManagementPolicyAssignment]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleManagementPolicyAuthenticationContextRule(RoleManagementPolicyRule):  # pylint: disable=name-too-long
    """The role management policy authentication context rule.

    All required parameters must be populated in order to send to server.

    :ivar id: The id of the rule.
    :vartype id: str
    :ivar rule_type: The type of rule. Required. Known values are:
     "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule", and "RoleManagementPolicyPimOnlyModeRule".
    :vartype rule_type: str or ~azure.mgmt.authorization.models.RoleManagementPolicyRuleType
    :ivar target: The target of the current rule.
    :vartype target: ~azure.mgmt.authorization.models.RoleManagementPolicyRuleTarget
    :ivar is_enabled: The value indicating if rule is enabled.
    :vartype is_enabled: bool
    :ivar claim_value: The claim value.
    :vartype claim_value: str
    """

    _validation = {
        "rule_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "target": {"key": "target", "type": "RoleManagementPolicyRuleTarget"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "claim_value": {"key": "claimValue", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        target: Optional["_models.RoleManagementPolicyRuleTarget"] = None,
        is_enabled: Optional[bool] = None,
        claim_value: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the rule.
        :paramtype id: str
        :keyword target: The target of the current rule.
        :paramtype target: ~azure.mgmt.authorization.models.RoleManagementPolicyRuleTarget
        :keyword is_enabled: The value indicating if rule is enabled.
        :paramtype is_enabled: bool
        :keyword claim_value: The claim value.
        :paramtype claim_value: str
        """
        super().__init__(id=id, target=target, **kwargs)
        self.rule_type: str = "RoleManagementPolicyAuthenticationContextRule"
        self.is_enabled = is_enabled
        self.claim_value = claim_value


class RoleManagementPolicyEnablementRule(RoleManagementPolicyRule):
    """The role management policy enablement rule.

    All required parameters must be populated in order to send to server.

    :ivar id: The id of the rule.
    :vartype id: str
    :ivar rule_type: The type of rule. Required. Known values are:
     "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule", and "RoleManagementPolicyPimOnlyModeRule".
    :vartype rule_type: str or ~azure.mgmt.authorization.models.RoleManagementPolicyRuleType
    :ivar target: The target of the current rule.
    :vartype target: ~azure.mgmt.authorization.models.RoleManagementPolicyRuleTarget
    :ivar enabled_rules: The list of enabled rules.
    :vartype enabled_rules: list[str or ~azure.mgmt.authorization.models.EnablementRules]
    """

    _validation = {
        "rule_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "target": {"key": "target", "type": "RoleManagementPolicyRuleTarget"},
        "enabled_rules": {"key": "enabledRules", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        target: Optional["_models.RoleManagementPolicyRuleTarget"] = None,
        enabled_rules: Optional[List[Union[str, "_models.EnablementRules"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the rule.
        :paramtype id: str
        :keyword target: The target of the current rule.
        :paramtype target: ~azure.mgmt.authorization.models.RoleManagementPolicyRuleTarget
        :keyword enabled_rules: The list of enabled rules.
        :paramtype enabled_rules: list[str or ~azure.mgmt.authorization.models.EnablementRules]
        """
        super().__init__(id=id, target=target, **kwargs)
        self.rule_type: str = "RoleManagementPolicyEnablementRule"
        self.enabled_rules = enabled_rules


class RoleManagementPolicyExpirationRule(RoleManagementPolicyRule):
    """The role management policy expiration rule.

    All required parameters must be populated in order to send to server.

    :ivar id: The id of the rule.
    :vartype id: str
    :ivar rule_type: The type of rule. Required. Known values are:
     "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule", and "RoleManagementPolicyPimOnlyModeRule".
    :vartype rule_type: str or ~azure.mgmt.authorization.models.RoleManagementPolicyRuleType
    :ivar target: The target of the current rule.
    :vartype target: ~azure.mgmt.authorization.models.RoleManagementPolicyRuleTarget
    :ivar is_expiration_required: The value indicating whether expiration is required.
    :vartype is_expiration_required: bool
    :ivar maximum_duration: The maximum duration of expiration in timespan.
    :vartype maximum_duration: str
    :ivar exception_members: The members not restricted by expiration rule.
    :vartype exception_members: list[~azure.mgmt.authorization.models.UserSet]
    """

    _validation = {
        "rule_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "target": {"key": "target", "type": "RoleManagementPolicyRuleTarget"},
        "is_expiration_required": {"key": "isExpirationRequired", "type": "bool"},
        "maximum_duration": {"key": "maximumDuration", "type": "str"},
        "exception_members": {"key": "exceptionMembers", "type": "[UserSet]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        target: Optional["_models.RoleManagementPolicyRuleTarget"] = None,
        is_expiration_required: Optional[bool] = None,
        maximum_duration: Optional[str] = None,
        exception_members: Optional[List["_models.UserSet"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the rule.
        :paramtype id: str
        :keyword target: The target of the current rule.
        :paramtype target: ~azure.mgmt.authorization.models.RoleManagementPolicyRuleTarget
        :keyword is_expiration_required: The value indicating whether expiration is required.
        :paramtype is_expiration_required: bool
        :keyword maximum_duration: The maximum duration of expiration in timespan.
        :paramtype maximum_duration: str
        :keyword exception_members: The members not restricted by expiration rule.
        :paramtype exception_members: list[~azure.mgmt.authorization.models.UserSet]
        """
        super().__init__(id=id, target=target, **kwargs)
        self.rule_type: str = "RoleManagementPolicyExpirationRule"
        self.is_expiration_required = is_expiration_required
        self.maximum_duration = maximum_duration
        self.exception_members = exception_members


class RoleManagementPolicyListResult(_serialization.Model):
    """Role management policy list operation result.

    :ivar value: Role management policy list.
    :vartype value: list[~azure.mgmt.authorization.models.RoleManagementPolicy]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleManagementPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.RoleManagementPolicy"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Role management policy list.
        :paramtype value: list[~azure.mgmt.authorization.models.RoleManagementPolicy]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleManagementPolicyNotificationRule(RoleManagementPolicyRule):
    """The role management policy notification rule.

    All required parameters must be populated in order to send to server.

    :ivar id: The id of the rule.
    :vartype id: str
    :ivar rule_type: The type of rule. Required. Known values are:
     "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule", and "RoleManagementPolicyPimOnlyModeRule".
    :vartype rule_type: str or ~azure.mgmt.authorization.models.RoleManagementPolicyRuleType
    :ivar target: The target of the current rule.
    :vartype target: ~azure.mgmt.authorization.models.RoleManagementPolicyRuleTarget
    :ivar notification_type: The type of notification. "Email"
    :vartype notification_type: str or
     ~azure.mgmt.authorization.models.NotificationDeliveryMechanism
    :ivar notification_level: The notification level. Known values are: "None", "Critical", and
     "All".
    :vartype notification_level: str or ~azure.mgmt.authorization.models.NotificationLevel
    :ivar recipient_type: The recipient type. Known values are: "Requestor", "Approver", and
     "Admin".
    :vartype recipient_type: str or ~azure.mgmt.authorization.models.RecipientType
    :ivar notification_recipients: The list of notification recipients.
    :vartype notification_recipients: list[str]
    :ivar is_default_recipients_enabled: Determines if the notification will be sent to the
     recipient type specified in the policy rule.
    :vartype is_default_recipients_enabled: bool
    """

    _validation = {
        "rule_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "target": {"key": "target", "type": "RoleManagementPolicyRuleTarget"},
        "notification_type": {"key": "notificationType", "type": "str"},
        "notification_level": {"key": "notificationLevel", "type": "str"},
        "recipient_type": {"key": "recipientType", "type": "str"},
        "notification_recipients": {"key": "notificationRecipients", "type": "[str]"},
        "is_default_recipients_enabled": {"key": "isDefaultRecipientsEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        target: Optional["_models.RoleManagementPolicyRuleTarget"] = None,
        notification_type: Optional[Union[str, "_models.NotificationDeliveryMechanism"]] = None,
        notification_level: Optional[Union[str, "_models.NotificationLevel"]] = None,
        recipient_type: Optional[Union[str, "_models.RecipientType"]] = None,
        notification_recipients: Optional[List[str]] = None,
        is_default_recipients_enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the rule.
        :paramtype id: str
        :keyword target: The target of the current rule.
        :paramtype target: ~azure.mgmt.authorization.models.RoleManagementPolicyRuleTarget
        :keyword notification_type: The type of notification. "Email"
        :paramtype notification_type: str or
         ~azure.mgmt.authorization.models.NotificationDeliveryMechanism
        :keyword notification_level: The notification level. Known values are: "None", "Critical", and
         "All".
        :paramtype notification_level: str or ~azure.mgmt.authorization.models.NotificationLevel
        :keyword recipient_type: The recipient type. Known values are: "Requestor", "Approver", and
         "Admin".
        :paramtype recipient_type: str or ~azure.mgmt.authorization.models.RecipientType
        :keyword notification_recipients: The list of notification recipients.
        :paramtype notification_recipients: list[str]
        :keyword is_default_recipients_enabled: Determines if the notification will be sent to the
         recipient type specified in the policy rule.
        :paramtype is_default_recipients_enabled: bool
        """
        super().__init__(id=id, target=target, **kwargs)
        self.rule_type: str = "RoleManagementPolicyNotificationRule"
        self.notification_type = notification_type
        self.notification_level = notification_level
        self.recipient_type = recipient_type
        self.notification_recipients = notification_recipients
        self.is_default_recipients_enabled = is_default_recipients_enabled


class RoleManagementPolicyPimOnlyModeRule(RoleManagementPolicyRule):
    """The role management policy PIM only mode rule.

    All required parameters must be populated in order to send to server.

    :ivar id: The id of the rule.
    :vartype id: str
    :ivar rule_type: The type of rule. Required. Known values are:
     "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule", and "RoleManagementPolicyPimOnlyModeRule".
    :vartype rule_type: str or ~azure.mgmt.authorization.models.RoleManagementPolicyRuleType
    :ivar target: The target of the current rule.
    :vartype target: ~azure.mgmt.authorization.models.RoleManagementPolicyRuleTarget
    :ivar pim_only_mode_settings: The PIM Only Mode settings.
    :vartype pim_only_mode_settings: ~azure.mgmt.authorization.models.PIMOnlyModeSettings
    """

    _validation = {
        "rule_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "target": {"key": "target", "type": "RoleManagementPolicyRuleTarget"},
        "pim_only_mode_settings": {"key": "pimOnlyModeSettings", "type": "PIMOnlyModeSettings"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        target: Optional["_models.RoleManagementPolicyRuleTarget"] = None,
        pim_only_mode_settings: Optional["_models.PIMOnlyModeSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the rule.
        :paramtype id: str
        :keyword target: The target of the current rule.
        :paramtype target: ~azure.mgmt.authorization.models.RoleManagementPolicyRuleTarget
        :keyword pim_only_mode_settings: The PIM Only Mode settings.
        :paramtype pim_only_mode_settings: ~azure.mgmt.authorization.models.PIMOnlyModeSettings
        """
        super().__init__(id=id, target=target, **kwargs)
        self.rule_type: str = "RoleManagementPolicyPimOnlyModeRule"
        self.pim_only_mode_settings = pim_only_mode_settings


class RoleManagementPolicyRuleTarget(_serialization.Model):
    """The role management policy rule target.

    :ivar caller: The caller of the setting.
    :vartype caller: str
    :ivar operations: The type of operation.
    :vartype operations: list[str]
    :ivar level: The assignment level to which rule is applied.
    :vartype level: str
    :ivar target_objects: The list of target objects.
    :vartype target_objects: list[str]
    :ivar inheritable_settings: The list of inheritable settings.
    :vartype inheritable_settings: list[str]
    :ivar enforced_settings: The list of enforced settings.
    :vartype enforced_settings: list[str]
    """

    _attribute_map = {
        "caller": {"key": "caller", "type": "str"},
        "operations": {"key": "operations", "type": "[str]"},
        "level": {"key": "level", "type": "str"},
        "target_objects": {"key": "targetObjects", "type": "[str]"},
        "inheritable_settings": {"key": "inheritableSettings", "type": "[str]"},
        "enforced_settings": {"key": "enforcedSettings", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        caller: Optional[str] = None,
        operations: Optional[List[str]] = None,
        level: Optional[str] = None,
        target_objects: Optional[List[str]] = None,
        inheritable_settings: Optional[List[str]] = None,
        enforced_settings: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword caller: The caller of the setting.
        :paramtype caller: str
        :keyword operations: The type of operation.
        :paramtype operations: list[str]
        :keyword level: The assignment level to which rule is applied.
        :paramtype level: str
        :keyword target_objects: The list of target objects.
        :paramtype target_objects: list[str]
        :keyword inheritable_settings: The list of inheritable settings.
        :paramtype inheritable_settings: list[str]
        :keyword enforced_settings: The list of enforced settings.
        :paramtype enforced_settings: list[str]
        """
        super().__init__(**kwargs)
        self.caller = caller
        self.operations = operations
        self.level = level
        self.target_objects = target_objects
        self.inheritable_settings = inheritable_settings
        self.enforced_settings = enforced_settings


class TooManyOwnersAssignedToResourceAlertConfigurationProperties(
    AlertConfigurationProperties
):  # pylint: disable=name-too-long
    """Too many owners assigned to resource alert configuration properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar alert_definition_id: The alert definition ID.
    :vartype alert_definition_id: str
    :ivar scope: The alert scope.
    :vartype scope: str
    :ivar is_enabled: True if the alert is enabled, false will disable the scanning for the
     specific alert.
    :vartype is_enabled: bool
    :ivar alert_configuration_type: The alert configuration type. Required.
    :vartype alert_configuration_type: str
    :ivar alert_definition: The alert definition.
    :vartype alert_definition: ~azure.mgmt.authorization.models.AlertDefinition
    :ivar threshold_number_of_owners: The threshold number of owners.
    :vartype threshold_number_of_owners: int
    :ivar threshold_percentage_of_owners_out_of_all_role_members: The threshold percentage of
     owners out of all role members.
    :vartype threshold_percentage_of_owners_out_of_all_role_members: int
    """

    _validation = {
        "alert_definition_id": {"readonly": True},
        "scope": {"readonly": True},
        "alert_configuration_type": {"required": True},
        "alert_definition": {"readonly": True},
    }

    _attribute_map = {
        "alert_definition_id": {"key": "alertDefinitionId", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "alert_configuration_type": {"key": "alertConfigurationType", "type": "str"},
        "alert_definition": {"key": "alertDefinition", "type": "AlertDefinition"},
        "threshold_number_of_owners": {"key": "thresholdNumberOfOwners", "type": "int"},
        "threshold_percentage_of_owners_out_of_all_role_members": {
            "key": "thresholdPercentageOfOwnersOutOfAllRoleMembers",
            "type": "int",
        },
    }

    def __init__(
        self,
        *,
        is_enabled: Optional[bool] = None,
        threshold_number_of_owners: Optional[int] = None,
        threshold_percentage_of_owners_out_of_all_role_members: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: True if the alert is enabled, false will disable the scanning for the
         specific alert.
        :paramtype is_enabled: bool
        :keyword threshold_number_of_owners: The threshold number of owners.
        :paramtype threshold_number_of_owners: int
        :keyword threshold_percentage_of_owners_out_of_all_role_members: The threshold percentage of
         owners out of all role members.
        :paramtype threshold_percentage_of_owners_out_of_all_role_members: int
        """
        super().__init__(is_enabled=is_enabled, **kwargs)
        self.alert_configuration_type: str = "TooManyOwnersAssignedToResourceAlertConfiguration"
        self.threshold_number_of_owners = threshold_number_of_owners
        self.threshold_percentage_of_owners_out_of_all_role_members = (
            threshold_percentage_of_owners_out_of_all_role_members
        )


class TooManyOwnersAssignedToResourceAlertIncidentProperties(AlertIncidentProperties):  # pylint: disable=name-too-long
    """Too many owners assigned to resource alert incident properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar alert_incident_type: The alert incident type. Required.
    :vartype alert_incident_type: str
    :ivar assignee_name: The assignee name.
    :vartype assignee_name: str
    :ivar assignee_type: The assignee type.
    :vartype assignee_type: str
    """

    _validation = {
        "alert_incident_type": {"required": True},
        "assignee_name": {"readonly": True},
        "assignee_type": {"readonly": True},
    }

    _attribute_map = {
        "alert_incident_type": {"key": "alertIncidentType", "type": "str"},
        "assignee_name": {"key": "assigneeName", "type": "str"},
        "assignee_type": {"key": "assigneeType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.alert_incident_type: str = "TooManyOwnersAssignedToResourceAlertIncident"
        self.assignee_name: Optional[str] = None
        self.assignee_type: Optional[str] = None


class TooManyPermanentOwnersAssignedToResourceAlertConfigurationProperties(
    AlertConfigurationProperties
):  # pylint: disable=name-too-long
    """Too many permanent owners assigned to resource alert configuration properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar alert_definition_id: The alert definition ID.
    :vartype alert_definition_id: str
    :ivar scope: The alert scope.
    :vartype scope: str
    :ivar is_enabled: True if the alert is enabled, false will disable the scanning for the
     specific alert.
    :vartype is_enabled: bool
    :ivar alert_configuration_type: The alert configuration type. Required.
    :vartype alert_configuration_type: str
    :ivar alert_definition: The alert definition.
    :vartype alert_definition: ~azure.mgmt.authorization.models.AlertDefinition
    :ivar threshold_number_of_permanent_owners: The threshold number of permanent owners.
    :vartype threshold_number_of_permanent_owners: int
    :ivar threshold_percentage_of_permanent_owners_out_of_all_owners: The threshold percentage of
     permanent owners out of all owners.
    :vartype threshold_percentage_of_permanent_owners_out_of_all_owners: int
    """

    _validation = {
        "alert_definition_id": {"readonly": True},
        "scope": {"readonly": True},
        "alert_configuration_type": {"required": True},
        "alert_definition": {"readonly": True},
    }

    _attribute_map = {
        "alert_definition_id": {"key": "alertDefinitionId", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "alert_configuration_type": {"key": "alertConfigurationType", "type": "str"},
        "alert_definition": {"key": "alertDefinition", "type": "AlertDefinition"},
        "threshold_number_of_permanent_owners": {"key": "thresholdNumberOfPermanentOwners", "type": "int"},
        "threshold_percentage_of_permanent_owners_out_of_all_owners": {
            "key": "thresholdPercentageOfPermanentOwnersOutOfAllOwners",
            "type": "int",
        },
    }

    def __init__(
        self,
        *,
        is_enabled: Optional[bool] = None,
        threshold_number_of_permanent_owners: Optional[int] = None,
        threshold_percentage_of_permanent_owners_out_of_all_owners: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: True if the alert is enabled, false will disable the scanning for the
         specific alert.
        :paramtype is_enabled: bool
        :keyword threshold_number_of_permanent_owners: The threshold number of permanent owners.
        :paramtype threshold_number_of_permanent_owners: int
        :keyword threshold_percentage_of_permanent_owners_out_of_all_owners: The threshold percentage
         of permanent owners out of all owners.
        :paramtype threshold_percentage_of_permanent_owners_out_of_all_owners: int
        """
        super().__init__(is_enabled=is_enabled, **kwargs)
        self.alert_configuration_type: str = "TooManyPermanentOwnersAssignedToResourceAlertConfiguration"
        self.threshold_number_of_permanent_owners = threshold_number_of_permanent_owners
        self.threshold_percentage_of_permanent_owners_out_of_all_owners = (
            threshold_percentage_of_permanent_owners_out_of_all_owners
        )


class TooManyPermanentOwnersAssignedToResourceAlertIncidentProperties(
    AlertIncidentProperties
):  # pylint: disable=name-too-long
    """Too many permanent owners assigned to resource alert incident properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar alert_incident_type: The alert incident type. Required.
    :vartype alert_incident_type: str
    :ivar assignee_name: The assignee name.
    :vartype assignee_name: str
    :ivar assignee_type: The assignee type.
    :vartype assignee_type: str
    """

    _validation = {
        "alert_incident_type": {"required": True},
        "assignee_name": {"readonly": True},
        "assignee_type": {"readonly": True},
    }

    _attribute_map = {
        "alert_incident_type": {"key": "alertIncidentType", "type": "str"},
        "assignee_name": {"key": "assigneeName", "type": "str"},
        "assignee_type": {"key": "assigneeType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.alert_incident_type: str = "TooManyPermanentOwnersAssignedToResourceAlertIncident"
        self.assignee_name: Optional[str] = None
        self.assignee_type: Optional[str] = None


class UserSet(_serialization.Model):
    """The detail of a user.

    :ivar user_type: The type of user. Known values are: "User", "Group", and "ServicePrincipal".
    :vartype user_type: str or ~azure.mgmt.authorization.models.UserType
    :ivar is_backup: The value indicating whether the user is a backup fallback approver.
    :vartype is_backup: bool
    :ivar id: The object id of the user.
    :vartype id: str
    :ivar description: The description of the user.
    :vartype description: str
    """

    _attribute_map = {
        "user_type": {"key": "userType", "type": "str"},
        "is_backup": {"key": "isBackup", "type": "bool"},
        "id": {"key": "id", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        user_type: Optional[Union[str, "_models.UserType"]] = None,
        is_backup: Optional[bool] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_type: The type of user. Known values are: "User", "Group", and
         "ServicePrincipal".
        :paramtype user_type: str or ~azure.mgmt.authorization.models.UserType
        :keyword is_backup: The value indicating whether the user is a backup fallback approver.
        :paramtype is_backup: bool
        :keyword id: The object id of the user.
        :paramtype id: str
        :keyword description: The description of the user.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.user_type = user_type
        self.is_backup = is_backup
        self.id = id
        self.description = description


class UsersOrServicePrincipalSet(_serialization.Model):
    """The detail of a subject.

    :ivar type: The type of user. Known values are: "User", "Group", and "ServicePrincipal".
    :vartype type: str or ~azure.mgmt.authorization.models.UserType
    :ivar id: The object id of the entity.
    :vartype id: str
    :ivar display_name: The display Name of the entity.
    :vartype display_name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.UserType"]] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        display_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of user. Known values are: "User", "Group", and "ServicePrincipal".
        :paramtype type: str or ~azure.mgmt.authorization.models.UserType
        :keyword id: The object id of the entity.
        :paramtype id: str
        :keyword display_name: The display Name of the entity.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.id = id
        self.display_name = display_name


class ValidationResponse(_serialization.Model):
    """Validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_valid: Whether or not validation succeeded.
    :vartype is_valid: bool
    :ivar error_info: Failed validation result details.
    :vartype error_info: ~azure.mgmt.authorization.models.ValidationResponseErrorInfo
    """

    _validation = {
        "is_valid": {"readonly": True},
    }

    _attribute_map = {
        "is_valid": {"key": "isValid", "type": "bool"},
        "error_info": {"key": "errorInfo", "type": "ValidationResponseErrorInfo"},
    }

    def __init__(self, *, error_info: Optional["_models.ValidationResponseErrorInfo"] = None, **kwargs: Any) -> None:
        """
        :keyword error_info: Failed validation result details.
        :paramtype error_info: ~azure.mgmt.authorization.models.ValidationResponseErrorInfo
        """
        super().__init__(**kwargs)
        self.is_valid: Optional[bool] = None
        self.error_info = error_info


class ValidationResponseErrorInfo(_serialization.Model):
    """Failed validation result details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code indicating why validation failed.
    :vartype code: str
    :ivar message: Message indicating why validation failed.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
