﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/route53-recovery-readiness/Route53RecoveryReadiness_EXPORTS.h>
#include <aws/route53-recovery-readiness/model/CellOutput.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Route53RecoveryReadiness {
namespace Model {
class ListCellsResult {
 public:
  AWS_ROUTE53RECOVERYREADINESS_API ListCellsResult() = default;
  AWS_ROUTE53RECOVERYREADINESS_API ListCellsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ROUTE53RECOVERYREADINESS_API ListCellsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of cells.</p>
   */
  inline const Aws::Vector<CellOutput>& GetCells() const { return m_cells; }
  template <typename CellsT = Aws::Vector<CellOutput>>
  void SetCells(CellsT&& value) {
    m_cellsHasBeenSet = true;
    m_cells = std::forward<CellsT>(value);
  }
  template <typename CellsT = Aws::Vector<CellOutput>>
  ListCellsResult& WithCells(CellsT&& value) {
    SetCells(std::forward<CellsT>(value));
    return *this;
  }
  template <typename CellsT = CellOutput>
  ListCellsResult& AddCells(CellsT&& value) {
    m_cellsHasBeenSet = true;
    m_cells.emplace_back(std::forward<CellsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token that identifies which batch of results you want to see.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListCellsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListCellsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<CellOutput> m_cells;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_cellsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53RecoveryReadiness
}  // namespace Aws
