﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/geo-routes/GeoRoutes_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GeoRoutes {
namespace Model {

/**
 * <p>TracePoint indices for which the provided notice code corresponds
 * to.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/geo-routes-2020-11-19/RoadSnapTracePoint">AWS
 * API Reference</a></p>
 */
class RoadSnapTracePoint {
 public:
  AWS_GEOROUTES_API RoadSnapTracePoint() = default;
  AWS_GEOROUTES_API RoadSnapTracePoint(Aws::Utils::Json::JsonView jsonValue);
  AWS_GEOROUTES_API RoadSnapTracePoint& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GEOROUTES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>GPS Heading at the position.</p>
   */
  inline double GetHeading() const { return m_heading; }
  inline bool HeadingHasBeenSet() const { return m_headingHasBeenSet; }
  inline void SetHeading(double value) {
    m_headingHasBeenSet = true;
    m_heading = value;
  }
  inline RoadSnapTracePoint& WithHeading(double value) {
    SetHeading(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Position defined as <code>[longitude, latitude]</code>.</p>
   */
  inline const Aws::Vector<double>& GetPosition() const { return m_position; }
  inline bool PositionHasBeenSet() const { return m_positionHasBeenSet; }
  template <typename PositionT = Aws::Vector<double>>
  void SetPosition(PositionT&& value) {
    m_positionHasBeenSet = true;
    m_position = std::forward<PositionT>(value);
  }
  template <typename PositionT = Aws::Vector<double>>
  RoadSnapTracePoint& WithPosition(PositionT&& value) {
    SetPosition(std::forward<PositionT>(value));
    return *this;
  }
  inline RoadSnapTracePoint& AddPosition(double value) {
    m_positionHasBeenSet = true;
    m_position.push_back(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Speed at the specified trace point .</p> <p> <b>Unit</b>:
   * <code>KilometersPerHour</code> </p>
   */
  inline double GetSpeed() const { return m_speed; }
  inline bool SpeedHasBeenSet() const { return m_speedHasBeenSet; }
  inline void SetSpeed(double value) {
    m_speedHasBeenSet = true;
    m_speed = value;
  }
  inline RoadSnapTracePoint& WithSpeed(double value) {
    SetSpeed(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Timestamp of the event.</p>
   */
  inline const Aws::String& GetTimestamp() const { return m_timestamp; }
  inline bool TimestampHasBeenSet() const { return m_timestampHasBeenSet; }
  template <typename TimestampT = Aws::String>
  void SetTimestamp(TimestampT&& value) {
    m_timestampHasBeenSet = true;
    m_timestamp = std::forward<TimestampT>(value);
  }
  template <typename TimestampT = Aws::String>
  RoadSnapTracePoint& WithTimestamp(TimestampT&& value) {
    SetTimestamp(std::forward<TimestampT>(value));
    return *this;
  }
  ///@}
 private:
  double m_heading{0.0};

  Aws::Vector<double> m_position;

  double m_speed{0.0};

  Aws::String m_timestamp;
  bool m_headingHasBeenSet = false;
  bool m_positionHasBeenSet = false;
  bool m_speedHasBeenSet = false;
  bool m_timestampHasBeenSet = false;
};

}  // namespace Model
}  // namespace GeoRoutes
}  // namespace Aws
