﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-runtime/BedrockRuntime_EXPORTS.h>
#include <aws/bedrock-runtime/model/ConverseStreamMetrics.h>
#include <aws/bedrock-runtime/model/ConverseStreamTrace.h>
#include <aws/bedrock-runtime/model/PerformanceConfiguration.h>
#include <aws/bedrock-runtime/model/ServiceTier.h>
#include <aws/bedrock-runtime/model/TokenUsage.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BedrockRuntime {
namespace Model {

/**
 * <p>A conversation stream metadata event.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/ConverseStreamMetadataEvent">AWS
 * API Reference</a></p>
 */
class ConverseStreamMetadataEvent {
 public:
  AWS_BEDROCKRUNTIME_API ConverseStreamMetadataEvent() = default;
  AWS_BEDROCKRUNTIME_API ConverseStreamMetadataEvent(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKRUNTIME_API ConverseStreamMetadataEvent& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKRUNTIME_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Usage information for the conversation stream event.</p>
   */
  inline const TokenUsage& GetUsage() const { return m_usage; }
  inline bool UsageHasBeenSet() const { return m_usageHasBeenSet; }
  template <typename UsageT = TokenUsage>
  void SetUsage(UsageT&& value) {
    m_usageHasBeenSet = true;
    m_usage = std::forward<UsageT>(value);
  }
  template <typename UsageT = TokenUsage>
  ConverseStreamMetadataEvent& WithUsage(UsageT&& value) {
    SetUsage(std::forward<UsageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metrics for the conversation stream metadata event.</p>
   */
  inline const ConverseStreamMetrics& GetMetrics() const { return m_metrics; }
  inline bool MetricsHasBeenSet() const { return m_metricsHasBeenSet; }
  template <typename MetricsT = ConverseStreamMetrics>
  void SetMetrics(MetricsT&& value) {
    m_metricsHasBeenSet = true;
    m_metrics = std::forward<MetricsT>(value);
  }
  template <typename MetricsT = ConverseStreamMetrics>
  ConverseStreamMetadataEvent& WithMetrics(MetricsT&& value) {
    SetMetrics(std::forward<MetricsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The trace object in the response from <a
   * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>
   * that contains information about the guardrail behavior.</p>
   */
  inline const ConverseStreamTrace& GetTrace() const { return m_trace; }
  inline bool TraceHasBeenSet() const { return m_traceHasBeenSet; }
  template <typename TraceT = ConverseStreamTrace>
  void SetTrace(TraceT&& value) {
    m_traceHasBeenSet = true;
    m_trace = std::forward<TraceT>(value);
  }
  template <typename TraceT = ConverseStreamTrace>
  ConverseStreamMetadataEvent& WithTrace(TraceT&& value) {
    SetTrace(std::forward<TraceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Model performance configuration metadata for the conversation stream
   * event.</p>
   */
  inline const PerformanceConfiguration& GetPerformanceConfig() const { return m_performanceConfig; }
  inline bool PerformanceConfigHasBeenSet() const { return m_performanceConfigHasBeenSet; }
  template <typename PerformanceConfigT = PerformanceConfiguration>
  void SetPerformanceConfig(PerformanceConfigT&& value) {
    m_performanceConfigHasBeenSet = true;
    m_performanceConfig = std::forward<PerformanceConfigT>(value);
  }
  template <typename PerformanceConfigT = PerformanceConfiguration>
  ConverseStreamMetadataEvent& WithPerformanceConfig(PerformanceConfigT&& value) {
    SetPerformanceConfig(std::forward<PerformanceConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the processing tier configuration used for serving the request.</p>
   */
  inline const ServiceTier& GetServiceTier() const { return m_serviceTier; }
  inline bool ServiceTierHasBeenSet() const { return m_serviceTierHasBeenSet; }
  template <typename ServiceTierT = ServiceTier>
  void SetServiceTier(ServiceTierT&& value) {
    m_serviceTierHasBeenSet = true;
    m_serviceTier = std::forward<ServiceTierT>(value);
  }
  template <typename ServiceTierT = ServiceTier>
  ConverseStreamMetadataEvent& WithServiceTier(ServiceTierT&& value) {
    SetServiceTier(std::forward<ServiceTierT>(value));
    return *this;
  }
  ///@}
 private:
  TokenUsage m_usage;

  ConverseStreamMetrics m_metrics;

  ConverseStreamTrace m_trace;

  PerformanceConfiguration m_performanceConfig;

  ServiceTier m_serviceTier;
  bool m_usageHasBeenSet = false;
  bool m_metricsHasBeenSet = false;
  bool m_traceHasBeenSet = false;
  bool m_performanceConfigHasBeenSet = false;
  bool m_serviceTierHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockRuntime
}  // namespace Aws
