/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.regex;

import java.util.concurrent.atomic.AtomicLong;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexComposed;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.text.StringLocated;

public final class RegexConcat
extends RegexComposed
implements IRegex {
    private final AtomicLong foxRegex = new AtomicLong(-1L);
    private int limitSize;

    public static void printCacheInfo() {
    }

    public RegexConcat(IRegex ... partials) {
        super(partials);
    }

    private long foxRegex() {
        long result = this.foxRegex.get();
        if (result == -1L) {
            long tmp = 0L;
            for (int i = 1; i < this.partials().size() - 1; ++i) {
                IRegex part = this.partials().get(i);
                if (!(part instanceof RegexLeaf)) continue;
                RegexLeaf leaf = (RegexLeaf)part;
                tmp |= leaf.getFoxSignature();
            }
            this.foxRegex.set(tmp);
            return tmp;
        }
        return result;
    }

    public static RegexConcat build(String key, IRegex ... partials) {
        return RegexConcat.buildInternal(partials);
    }

    private static RegexConcat buildInternal(IRegex ... partials) {
        RegexConcat result = new RegexConcat(partials);
        assert (partials[0] == RegexLeaf.start());
        assert (partials[partials.length - 1] == RegexLeaf.end());
        return result;
    }

    private boolean invoked() {
        return this.foxRegex.get() != -1L;
    }

    @Override
    public boolean match(StringLocated s) {
        long foxLine;
        long check;
        if (this.limitSize != 0 && s.getString().length() > this.limitSize) {
            return false;
        }
        long foxRegex = this.foxRegex();
        if (foxRegex != 0L && (check = foxRegex & (foxLine = s.getFoxSignature())) != foxRegex) {
            return false;
        }
        return super.match(s);
    }

    @Override
    public String getPatternAsString() {
        StringBuilder sb = new StringBuilder();
        for (IRegex p : this.partials()) {
            sb.append(p.getPatternAsString());
        }
        return sb.toString();
    }

    public RegexConcat protectSize(int size) {
        this.limitSize = size;
        return this;
    }
}

