/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.rest.handler;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.ExecuteResultResponseRecorder;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.function.ExecutorFunction;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.DateRange;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.Job;
import org.opensearch.timeseries.model.TaskState;
import org.opensearch.timeseries.model.TaskType;
import org.opensearch.timeseries.model.TimeSeriesTask;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.task.TaskManager;
import org.opensearch.timeseries.transport.JobResponse;
import org.opensearch.timeseries.transport.ProfileResponse;
import org.opensearch.timeseries.transport.ResultRequest;
import org.opensearch.timeseries.transport.ResultResponse;
import org.opensearch.timeseries.transport.StopConfigRequest;
import org.opensearch.timeseries.transport.StopConfigResponse;
import org.opensearch.timeseries.util.ExceptionUtil;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public abstract class IndexJobActionHandler<IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, TaskCacheManagerType extends TaskCacheManager, TaskTypeEnum extends TaskType, TaskClass extends TimeSeriesTask, TaskManagerType extends TaskManager<TaskCacheManagerType, TaskTypeEnum, TaskClass, IndexType, IndexManagementType>, IndexableResultType extends IndexableResult, ProfileActionType extends ActionType<ProfileResponse>, ExecuteResultResponseRecorderType extends ExecuteResultResponseRecorder<IndexType, IndexManagementType, TaskCacheManagerType, TaskTypeEnum, TaskClass, TaskManagerType, IndexableResultType, ProfileActionType>> {
    private final IndexManagementType indexManagement;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    protected final TaskManagerType taskManager;
    private final Logger logger = LogManager.getLogger(IndexJobActionHandler.class);
    private final TimeValue requestTimeout;
    private final ExecuteResultResponseRecorderType recorder;
    private final ActionType<? extends ResultResponse<IndexableResultType>> resultAction;
    private final AnalysisType analysisType;
    private final String stateIndex;
    private final ActionType<StopConfigResponse> stopConfigAction;
    protected final NodeStateManager nodeStateManager;

    public IndexJobActionHandler(Client client, IndexManagementType indexManagement, NamedXContentRegistry xContentRegistry, TaskManagerType taskManager, ExecuteResultResponseRecorderType recorder, ActionType<? extends ResultResponse<IndexableResultType>> resultAction, AnalysisType analysisType, String stateIndex, ActionType<StopConfigResponse> stopConfigAction, NodeStateManager nodeStateManager, Settings settings, Setting<TimeValue> timeoutSetting) {
        this.client = client;
        this.indexManagement = indexManagement;
        this.xContentRegistry = xContentRegistry;
        this.taskManager = taskManager;
        this.recorder = recorder;
        this.resultAction = resultAction;
        this.analysisType = analysisType;
        this.stateIndex = stateIndex;
        this.stopConfigAction = stopConfigAction;
        this.nodeStateManager = nodeStateManager;
        this.requestTimeout = (TimeValue)timeoutSetting.get(settings);
    }

    public void startJob(Config config, TransportService transportService, Clock clock, ActionListener<JobResponse> listener) {
        ActionListener startListener = ActionListener.wrap(r -> {
            try {
                Instant executionEndTime = Instant.now();
                IntervalTimeConfiguration schedule = (IntervalTimeConfiguration)config.getInterval();
                Instant executionStartTime = executionEndTime.minus(schedule.getInterval(), schedule.getUnit());
                ResultRequest getRequest = this.createResultRequest(config.getId(), executionStartTime.toEpochMilli(), executionEndTime.toEpochMilli());
                this.client.execute(this.resultAction, (ActionRequest)getRequest, ActionListener.wrap(response -> ((ExecuteResultResponseRecorder)this.recorder).indexResult(executionStartTime, executionEndTime, response, config), exception -> ((ExecuteResultResponseRecorder)this.recorder).indexResultException(executionStartTime, executionEndTime, Throwables.getStackTraceAsString((Throwable)exception), null, config, clock)));
            }
            catch (Exception ex) {
                listener.onFailure(ex);
                return;
            }
            listener.onResponse((Object)r);
        }, arg_0 -> listener.onFailure(arg_0));
        if (!((IndexManagement)this.indexManagement).doesJobIndexExist()) {
            ((IndexManagement)this.indexManagement).initJobIndex((ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> {
                if (response.isAcknowledged()) {
                    this.logger.info("Created {} with mappings.", (Object)".opendistro-anomaly-detector-jobs");
                    this.createJob(config, transportService, (ActionListener<JobResponse>)startListener);
                } else {
                    this.logger.warn("Created {} with mappings call not acknowledged.", (Object)".opendistro-anomaly-detector-jobs");
                    startListener.onFailure((Exception)new OpenSearchStatusException("Created .opendistro-anomaly-detector-jobs with mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }
            }, exception -> startListener.onFailure(exception)));
        } else {
            this.createJob(config, transportService, (ActionListener<JobResponse>)startListener);
        }
    }

    private void createJob(Config config, TransportService transportService, ActionListener<JobResponse> listener) {
        try {
            IntervalTimeConfiguration frequency = (IntervalTimeConfiguration)config.getInferredFrequency();
            IntervalSchedule schedule = new IntervalSchedule(Instant.now(), (int)frequency.getInterval(), frequency.getUnit());
            Duration duration = Duration.of(frequency.getInterval(), frequency.getUnit());
            Job job = new Job(config.getId(), (Schedule)schedule, config.getWindowDelay(), true, Instant.now(), null, Instant.now(), duration.getSeconds(), config.getUser(), config.getCustomResultIndexOrAlias(), this.analysisType);
            this.getJobForWrite(config, job, transportService, listener);
        }
        catch (Exception e) {
            String message = "Failed to parse job " + config.getId();
            this.logger.error(message, (Throwable)e);
            listener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    private void getJobForWrite(Config config, Job job, TransportService transportService, ActionListener<JobResponse> listener) {
        GetRequest getRequest = new GetRequest(".opendistro-anomaly-detector-jobs").id(config.getId());
        this.client.get(getRequest, ActionListener.wrap(response -> this.onGetJobForWrite((GetResponse)response, config, job, transportService, listener), exception -> listener.onFailure(exception)));
    }

    private void onGetJobForWrite(GetResponse response, Config config, Job job, TransportService transportService, ActionListener<JobResponse> listener) throws IOException {
        if (response.isExists()) {
            try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(this.xContentRegistry, response.getSourceAsBytesRef());){
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                Job currentAdJob = Job.parse(parser);
                if (currentAdJob.isEnabled()) {
                    listener.onFailure((Exception)new OpenSearchStatusException("Anomaly detector job is already running: " + config.getId(), RestStatus.OK, new Object[0]));
                    return;
                }
                Job newJob = new Job(job.getName(), job.getSchedule(), job.getWindowDelay(), job.isEnabled(), Instant.now(), currentAdJob.getDisabledTime(), Instant.now(), job.getLockDurationSeconds(), job.getUser(), job.getCustomResultIndexOrAlias(), job.getAnalysisType());
                this.startConfig(config, null, job.getUser(), transportService, (ActionListener<JobResponse>)ActionListener.wrap(r -> this.indexJob(newJob, null, listener), e -> listener.onFailure(e)));
            }
            catch (IOException e2) {
                String message = "Failed to parse job " + job.getName();
                this.logger.error(message, (Throwable)e2);
                listener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        } else {
            this.startConfig(config, null, job.getUser(), transportService, (ActionListener<JobResponse>)ActionListener.wrap(r -> this.indexJob(job, null, listener), e -> listener.onFailure(e)));
        }
    }

    public void startConfig(Config config, DateRange dateRange, User user, TransportService transportService, ActionListener<JobResponse> listener) {
        try {
            if (((IndexManagement)this.indexManagement).doesStateIndexExist()) {
                ((TaskManager)this.taskManager).getAndExecuteOnLatestConfigLevelTask(config, dateRange, false, user, transportService, listener);
            } else {
                ((IndexManagement)this.indexManagement).initStateIndex((ActionListener<CreateIndexResponse>)ActionListener.wrap(r -> {
                    if (r.isAcknowledged()) {
                        this.logger.info("Created {} with mappings.", (Object)this.stateIndex);
                        ((TaskManager)this.taskManager).updateLatestFlagOfOldTasksAndCreateNewTask(config, dateRange, false, user, TaskState.CREATED, listener);
                    } else {
                        String error = String.format(Locale.ROOT, "Create index %S not acknowledged by OpenSearch core", this.stateIndex);
                        this.logger.warn(error);
                        listener.onFailure((Exception)new OpenSearchStatusException(error, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                    }
                }, e -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                        ((TaskManager)this.taskManager).updateLatestFlagOfOldTasksAndCreateNewTask(config, dateRange, false, user, TaskState.CREATED, listener);
                    } else {
                        this.logger.error("Failed to init state index", (Throwable)e);
                        listener.onFailure(e);
                    }
                }));
            }
        }
        catch (Exception e2) {
            this.logger.error("Failed to start config " + config.getId(), (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private void indexJob(Job job, ExecutorFunction function, ActionListener<JobResponse> listener) throws IOException {
        IndexRequest indexRequest = ((IndexRequest)((IndexRequest)new IndexRequest(".opendistro-anomaly-detector-jobs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(job.toXContent(XContentFactory.jsonBuilder(), (ToXContent.Params)RestHandlerUtils.XCONTENT_WITH_TYPE)).timeout(this.requestTimeout)).id(job.getName());
        this.client.index(indexRequest, ActionListener.wrap(response -> this.onIndexAnomalyDetectorJobResponse((IndexResponse)response, function, listener), exception -> listener.onFailure(exception)));
    }

    private void onIndexAnomalyDetectorJobResponse(IndexResponse response, ExecutorFunction function, ActionListener<JobResponse> listener) {
        if (response == null || response.getResult() != DocWriteResponse.Result.CREATED && response.getResult() != DocWriteResponse.Result.UPDATED) {
            String errorMsg = ExceptionUtil.getShardsFailure(response);
            listener.onFailure((Exception)new OpenSearchStatusException(errorMsg, response == null ? RestStatus.INTERNAL_SERVER_ERROR : response.status(), new Object[0]));
            return;
        }
        if (function != null) {
            function.execute();
        } else {
            JobResponse anomalyDetectorJobResponse = new JobResponse(response.getId());
            listener.onResponse((Object)anomalyDetectorJobResponse);
        }
    }

    public void stopJob(String configId, TransportService transportService, ActionListener<JobResponse> listener) {
        GetRequest getRequest = new GetRequest(".opendistro-anomaly-detector-jobs").id(configId);
        this.client.get(getRequest, ActionListener.wrap(response -> {
            if (response.isExists()) {
                try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(this.xContentRegistry, response.getSourceAsBytesRef());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    Job job = Job.parse(parser);
                    if (!job.isEnabled()) {
                        ((TaskManager)this.taskManager).stopLatestRealtimeTask(configId, TaskState.STOPPED, null, transportService, listener);
                    } else {
                        Job newJob = new Job(job.getName(), job.getSchedule(), job.getWindowDelay(), false, job.getEnabledTime(), Instant.now(), Instant.now(), job.getLockDurationSeconds(), job.getUser(), job.getCustomResultIndexOrAlias(), job.getAnalysisType());
                        this.indexJob(newJob, () -> this.client.execute(this.stopConfigAction, (ActionRequest)new StopConfigRequest(configId), this.stopConfigListener(configId, transportService, listener)), listener);
                    }
                }
                catch (IOException e) {
                    String message = "Failed to parse job " + configId;
                    this.logger.error(message, (Throwable)e);
                    listener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }
            } else {
                this.logger.info((Message)new ParameterizedMessage("Job {} was not found", (Object)configId));
                listener.onResponse((Object)new JobResponse(configId));
            }
        }, exception -> {
            this.logger.error("JobRunner failed to get job " + configId, (Throwable)exception);
            if (exception instanceof IndexNotFoundException) {
                listener.onResponse((Object)new JobResponse(configId));
            } else {
                listener.onFailure(exception);
            }
        }));
    }

    public ActionListener<StopConfigResponse> stopConfigListener(final String configId, final TransportService transportService, final ActionListener<JobResponse> listener) {
        return new ActionListener<StopConfigResponse>(){

            public void onResponse(StopConfigResponse stopDetectorResponse) {
                if (stopDetectorResponse.success()) {
                    IndexJobActionHandler.this.logger.info("model deleted successfully for config {}", (Object)configId);
                    ((TaskManager)IndexJobActionHandler.this.taskManager).stopLatestRealtimeTask(configId, TaskState.STOPPED, null, null, (ActionListener<JobResponse>)listener);
                } else {
                    IndexJobActionHandler.this.logger.error("Failed to delete model for config {}", (Object)configId);
                    ((TaskManager)IndexJobActionHandler.this.taskManager).stopLatestRealtimeTask(configId, TaskState.FAILED, (Exception)new OpenSearchStatusException("Failed to delete model", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]), transportService, (ActionListener<JobResponse>)listener);
                }
            }

            public void onFailure(Exception e) {
                IndexJobActionHandler.this.logger.error("Failed to delete model for config " + configId, (Throwable)e);
                ((TaskManager)IndexJobActionHandler.this.taskManager).stopLatestRealtimeTask(configId, TaskState.FAILED, (Exception)new OpenSearchStatusException("Failed to execute stop config action", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]), transportService, (ActionListener<JobResponse>)listener);
            }
        };
    }

    public void startConfig(String configId, DateRange dateRange, User user, TransportService transportService, ThreadContext.StoredContext context, Clock clock, ActionListener<JobResponse> listener) {
        ((IndexManagement)this.indexManagement).update();
        this.nodeStateManager.getConfig(configId, this.analysisType, config -> {
            if (!config.isPresent()) {
                listener.onFailure((Exception)new OpenSearchStatusException(CommonMessages.FAIL_TO_FIND_CONFIG_MSG + configId, RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            String errorMessage = this.validateConfig((Config)config.get());
            if (errorMessage != null) {
                listener.onFailure((Exception)new OpenSearchStatusException(errorMessage, RestStatus.BAD_REQUEST, new Object[0]));
                return;
            }
            String resultIndex = ((Config)config.get()).getCustomResultIndexOrAlias();
            if (resultIndex == null) {
                this.startRealtimeOrHistoricalAnalysis(dateRange, user, transportService, listener, (Optional<? extends Config>)config, clock);
                return;
            }
            context.restore();
            ((IndexManagement)this.indexManagement).initCustomResultIndexAndExecute(resultIndex, () -> this.startRealtimeOrHistoricalAnalysis(dateRange, user, transportService, listener, (Optional<? extends Config>)config, clock), listener);
        }, listener);
    }

    private String validateConfig(Config detector) {
        String error = null;
        if (detector.getFeatureAttributes().size() == 0) {
            error = "Can't start job as no features configured";
        } else if (detector.getEnabledFeatureIds().size() == 0) {
            error = "Can't start job as no enabled features configured";
        }
        return error;
    }

    private void startRealtimeOrHistoricalAnalysis(DateRange dateRange, User user, TransportService transportService, ActionListener<JobResponse> listener, Optional<? extends Config> config, Clock clock) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            if (dateRange == null) {
                this.startJob(config.get(), transportService, clock, listener);
            } else {
                ((TaskManager)this.taskManager).startHistorical(config.get(), dateRange, user, transportService, listener);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to stash context", (Throwable)e);
            listener.onFailure(e);
        }
    }

    protected abstract ResultRequest createResultRequest(String var1, long var2, long var4);

    protected abstract List<TaskTypeEnum> getBatchConfigTaskTypes();

    public abstract void stopConfig(String var1, boolean var2, User var3, TransportService var4, ActionListener<JobResponse> var5);
}

