/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query.rewriters;

import java.util.ArrayList;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.GeoBoundingBoxQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.query.WithFieldName;
import org.opensearch.search.query.QueryRewriter;

public class MustToFilterRewriter
implements QueryRewriter {
    public static final MustToFilterRewriter INSTANCE = new MustToFilterRewriter();

    private MustToFilterRewriter() {
    }

    @Override
    public QueryBuilder rewrite(QueryBuilder query, QueryShardContext context) {
        if (!(query instanceof BoolQueryBuilder)) {
            return query;
        }
        BoolQueryBuilder boolQuery = (BoolQueryBuilder)query;
        if (boolQuery.must().isEmpty()) {
            return query;
        }
        ArrayList<QueryBuilder> rewrittenMustClauses = new ArrayList<QueryBuilder>();
        ArrayList<QueryBuilder> mustClausesToMove = new ArrayList<QueryBuilder>();
        for (QueryBuilder clause : boolQuery.must()) {
            QueryBuilder rewrittenClause = this.rewriteIfNeeded(clause, context);
            rewrittenMustClauses.add(rewrittenClause);
            if (!this.isClauseIrrelevantToScoring(rewrittenClause, context)) continue;
            mustClausesToMove.add(rewrittenClause);
        }
        boolean hasChanges = !mustClausesToMove.isEmpty();
        for (int i = 0; i < boolQuery.must().size(); ++i) {
            if (boolQuery.must().get(i) == rewrittenMustClauses.get(i)) continue;
            hasChanges = true;
            break;
        }
        if (!hasChanges) {
            return query;
        }
        BoolQueryBuilder rewritten = new BoolQueryBuilder();
        rewritten.boost(boolQuery.boost());
        rewritten.queryName(boolQuery.queryName());
        rewritten.minimumShouldMatch(boolQuery.minimumShouldMatch());
        rewritten.adjustPureNegative(boolQuery.adjustPureNegative());
        for (QueryBuilder rewrittenClause : rewrittenMustClauses) {
            if (mustClausesToMove.contains(rewrittenClause)) continue;
            rewritten.must(rewrittenClause);
        }
        for (QueryBuilder movedClause : mustClausesToMove) {
            rewritten.filter(movedClause);
        }
        for (QueryBuilder filterClause : boolQuery.filter()) {
            rewritten.filter(this.rewriteIfNeeded(filterClause, context));
        }
        for (QueryBuilder shouldClause : boolQuery.should()) {
            rewritten.should(this.rewriteIfNeeded(shouldClause, context));
        }
        for (QueryBuilder mustNotClause : boolQuery.mustNot()) {
            rewritten.mustNot(this.rewriteIfNeeded(mustNotClause, context));
        }
        return rewritten;
    }

    private QueryBuilder rewriteIfNeeded(QueryBuilder query, QueryShardContext context) {
        if (query instanceof BoolQueryBuilder) {
            BoolQueryBuilder boolQueryBuilder = (BoolQueryBuilder)query;
            return this.rewrite(boolQueryBuilder, context);
        }
        return query;
    }

    private boolean isClauseIrrelevantToScoring(QueryBuilder clause, QueryShardContext context) {
        if (clause instanceof RangeQueryBuilder) {
            return true;
        }
        if (clause instanceof GeoBoundingBoxQueryBuilder) {
            return true;
        }
        if (context == null) {
            return false;
        }
        if (!(clause instanceof WithFieldName)) {
            return false;
        }
        WithFieldName wfn = (WithFieldName)((Object)clause);
        MappedFieldType fieldType = context.fieldMapper(wfn.fieldName());
        if (!(fieldType instanceof NumberFieldMapper.NumberFieldType)) {
            return false;
        }
        if (clause instanceof MatchQueryBuilder) {
            return true;
        }
        if (clause instanceof TermQueryBuilder) {
            return true;
        }
        return clause instanceof TermsQueryBuilder;
    }

    @Override
    public int priority() {
        return 150;
    }

    @Override
    public String name() {
        return "must_to_filter";
    }
}

