/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.spi.PropertyAccessSerializationException;

public abstract class AbstractSetterMethodSerialForm
implements Serializable {
    private final Class<?> containerClass;
    private final String propertyName;
    private final Class<?> declaringClass;
    private final String methodName;
    private final Class<?> argumentType;

    public AbstractSetterMethodSerialForm(Class<?> containerClass, String propertyName, Method method) {
        this.containerClass = containerClass;
        this.propertyName = propertyName;
        this.declaringClass = method.getDeclaringClass();
        this.methodName = method.getName();
        this.argumentType = method.getParameterTypes()[0];
    }

    public Class<?> getContainerClass() {
        return this.containerClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?> getArgumentType() {
        return this.argumentType;
    }

    protected Method resolveMethod() {
        try {
            Method method = this.declaringClass.getDeclaredMethod(this.methodName, this.argumentType);
            ReflectHelper.ensureAccessibility(method);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new PropertyAccessSerializationException("Unable to resolve setter method on deserialization : " + this.declaringClass.getName() + "#" + this.methodName + "(" + this.argumentType.getName() + ")");
        }
    }
}

