/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime;

import io.quarkus.arc.Arc;
import jakarta.enterprise.inject.literal.NamedLiteral;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Optional;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class QuarkusDataSource
implements DataSource {
    private final Optional<String> dsName;
    private volatile DataSource datasource;

    public QuarkusDataSource(Optional<String> dsName) {
        this.dsName = dsName;
    }

    private DataSource getDataSource() {
        if (this.datasource == null) {
            this.datasource = this.dsName.isEmpty() ? (DataSource)Arc.container().instance(DataSource.class, new Annotation[0]).get() : (DataSource)Arc.container().instance(DataSource.class, new Annotation[]{NamedLiteral.of((String)this.dsName.get())}).get();
        }
        return this.datasource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String user, String passwd) throws SQLException {
        return this.getDataSource().getConnection(user, passwd);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter writer) throws SQLException {
        this.getDataSource().setLogWriter(writer);
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        this.getDataSource().setLoginTimeout(timeout);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getDataSource().getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.getDataSource().getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        return this.getDataSource().unwrap(aClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return this.getDataSource().isWrapperFor(aClass);
    }
}

