/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import com.sun.media.sound.MidiUtils;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Patch;
import javax.sound.midi.Track;

public class Sequence {
    public static final float PPQ = 0.0f;
    public static final float SMPTE_24 = 24.0f;
    public static final float SMPTE_25 = 25.0f;
    public static final float SMPTE_30DROP = 29.97f;
    public static final float SMPTE_30 = 30.0f;
    protected float divisionType;
    protected int resolution;
    protected Vector<Track> tracks = new Vector();

    public Sequence(float f, int n) throws InvalidMidiDataException {
        if (f == 0.0f) {
            this.divisionType = 0.0f;
        } else if (f == 24.0f) {
            this.divisionType = 24.0f;
        } else if (f == 25.0f) {
            this.divisionType = 25.0f;
        } else if (f == 29.97f) {
            this.divisionType = 29.97f;
        } else if (f == 30.0f) {
            this.divisionType = 30.0f;
        } else {
            throw new InvalidMidiDataException("Unsupported division type: " + f);
        }
        this.resolution = n;
    }

    public Sequence(float f, int n, int n2) throws InvalidMidiDataException {
        if (f == 0.0f) {
            this.divisionType = 0.0f;
        } else if (f == 24.0f) {
            this.divisionType = 24.0f;
        } else if (f == 25.0f) {
            this.divisionType = 25.0f;
        } else if (f == 29.97f) {
            this.divisionType = 29.97f;
        } else if (f == 30.0f) {
            this.divisionType = 30.0f;
        } else {
            throw new InvalidMidiDataException("Unsupported division type: " + f);
        }
        this.resolution = n;
        for (int i = 0; i < n2; ++i) {
            this.tracks.addElement(new Track());
        }
    }

    public float getDivisionType() {
        return this.divisionType;
    }

    public int getResolution() {
        return this.resolution;
    }

    public Track createTrack() {
        Track track = new Track();
        this.tracks.addElement(track);
        return track;
    }

    public boolean deleteTrack(Track track) {
        return this.tracks.removeElement(track);
    }

    public Track[] getTracks() {
        return this.tracks.toArray(new Track[0]);
    }

    public long getMicrosecondLength() {
        return MidiUtils.tick2microsecond(this, this.getTickLength(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTickLength() {
        long l = 0L;
        Vector<Track> vector = this.tracks;
        synchronized (vector) {
            for (int i = 0; i < this.tracks.size(); ++i) {
                long l2 = this.tracks.elementAt(i).ticks();
                if (l2 <= l) continue;
                l = l2;
            }
            return l;
        }
    }

    public Patch[] getPatchList() {
        return new Patch[0];
    }
}

