/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.StyleTranslatedObject;
import org.freeplane.features.styles.mindmapmode.NewNodeStyle;

@SelectableAction(checkOnPopup=true)
public class SetNewNodeStyleAction
extends AFreeplaneAction {
    private final IStyle style;
    private static final long serialVersionUID = 1L;

    public SetNewNodeStyleAction(IStyle style) {
        super(SetNewNodeStyleAction.actionName(style), SetNewNodeStyleAction.actionText(style), null);
        this.style = style;
    }

    private static String actionText(IStyle style) {
        return style.toString();
    }

    private static String actionName(IStyle style) {
        return "SetNewNodeStyleAction." + StyleTranslatedObject.toKeyString((IStyle)style);
    }

    public void actionPerformed(ActionEvent e) {
        Controller controller = Controller.getCurrentController();
        NodeModel node = controller.getSelection().getSelected();
        ModeController modeController = controller.getModeController();
        MapStyle mapStyleController = MapStyle.getController((ModeController)modeController);
        MapModel map = node.getMap();
        String propertyValue = NewNodeStyle.propertyValue(this.style);
        mapStyleController.setProperty(map, "newNodeStyle", propertyValue);
    }

    public void setSelected() {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null) {
            Controller controller = Controller.getCurrentController();
            NodeModel node = controller.getSelection().getSelected();
            ModeController modeController = controller.getModeController();
            MapStyle mapStyleController = MapStyle.getController((ModeController)modeController);
            MapModel map = node.getMap();
            String propertyValue = mapStyleController.getPropertySetDefault(map, "newNodeStyle");
            String ownValue = NewNodeStyle.propertyValue(this.style);
            this.setSelected(ownValue.equals(propertyValue));
        } else {
            this.setSelected(false);
        }
    }
}

