/*
 * Decompiled with CFR 0.152.
 */
package app.f3d.F3D;

import java.util.Arrays;

public class Types {
    static {
        System.loadLibrary("f3d-java");
    }

    public static class Mesh {
        public float[] points = new float[0];
        public float[] normals = new float[0];
        public float[] textureCoordinates = new float[0];
        public int[] faceSides = new int[0];
        public int[] faceIndices = new int[0];

        public Mesh() {
        }

        public Mesh(float[] fArray, float[] fArray2, float[] fArray3, int[] nArray, int[] nArray2) {
            this.points = fArray != null ? fArray : new float[]{};
            this.normals = fArray2 != null ? fArray2 : new float[]{};
            this.textureCoordinates = fArray3 != null ? fArray3 : new float[]{};
            this.faceSides = nArray != null ? nArray : new int[]{};
            this.faceIndices = nArray2 != null ? nArray2 : new int[]{};
        }

        public native ValidationResult isValid();

        public static class ValidationResult {
            public boolean valid;
            public String errorMessage;

            public ValidationResult(boolean bl, String string) {
                this.valid = bl;
                this.errorMessage = string;
            }
        }
    }

    public static class LightState {
        public LightType type = LightType.SCENE_LIGHT;
        public double[] position = new double[]{0.0, 0.0, 0.0};
        public double[] color = new double[]{1.0, 1.0, 1.0};
        public double[] direction = new double[]{1.0, 0.0, 0.0};
        public boolean positionalLight = false;
        public double intensity = 1.0;
        public boolean switchState = true;

        public LightState() {
        }

        public LightState(LightType lightType, double[] dArray, double[] dArray2, double[] dArray3, boolean bl, double d, boolean bl2) {
            this.type = lightType;
            this.position = dArray;
            this.color = dArray2;
            this.direction = dArray3;
            this.positionalLight = bl;
            this.intensity = d;
            this.switchState = bl2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LightState lightState = (LightState)object;
            return this.type == lightState.type && Arrays.equals(this.position, lightState.position) && Arrays.equals(this.color, lightState.color) && Arrays.equals(this.direction, lightState.direction) && this.positionalLight == lightState.positionalLight && this.intensity == lightState.intensity && this.switchState == lightState.switchState;
        }
    }

    public static enum LightType {
        HEADLIGHT(1),
        CAMERA_LIGHT(2),
        SCENE_LIGHT(3);

        private final int value;

        private LightType(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        public static LightType fromValue(int n) {
            for (LightType lightType : LightType.values()) {
                if (lightType.value != n) continue;
                return lightType;
            }
            throw new IllegalArgumentException("Unknown light type: " + n);
        }
    }

    public static class Colormap {
        public double[] data;

        public Colormap() {
            this.data = new double[0];
        }

        public Colormap(double[] dArray) {
            this.data = dArray;
        }
    }
}

