/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sh.ShBundle;
import com.intellij.sh.psi.ShCommand;
import com.intellij.sh.psi.ShCommandsList;
import com.intellij.sh.psi.ShCompositeElement;
import com.intellij.sh.psi.ShFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class ShExplainShellIntention
extends BaseIntentionAction {
    ShExplainShellIntention() {
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ShExplainShellIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = ShBundle.message("sh.explain.inspection.text", new Object[0]);
        if (string == null) {
            ShExplainShellIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        Caret caret;
        int offset;
        PsiElement at;
        if (project == null) {
            ShExplainShellIntention.$$$reportNull$$$0(2);
        }
        if (!(psiFile instanceof ShFile)) {
            return false;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            String selectedText = selectionModel.getSelectedText();
            if (StringUtil.isEmptyOrSpaces((String)selectedText)) {
                return false;
            }
            if (selectedText.trim().contains("\n")) {
                return false;
            }
        }
        if ((at = psiFile.findElementAt(offset = (caret = editor.getCaretModel().getPrimaryCaret()).getOffset())) == null) {
            return false;
        }
        return !(at instanceof LeafPsiElement) || !(at.getParent() instanceof ShFile);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        String selectedText;
        if (project == null) {
            ShExplainShellIntention.$$$reportNull$$$0(3);
        }
        if ((selectedText = editor.getSelectionModel().getSelectedText()) != null) {
            ShExplainShellIntention.explain(selectedText.trim());
        } else {
            HashSet strings;
            Caret caret = editor.getCaretModel().getPrimaryCaret();
            int offset = caret.getOffset();
            PsiElement at = psiFile.findElementAt(offset);
            List parents = at == null ? Collections.emptyList() : PsiTreeUtil.collectParents((PsiElement)at, ShCompositeElement.class, (boolean)true, psiElement -> psiElement.getText().contains("\n"));
            List commands = ContainerUtil.filter((Collection)parents, arg_0 -> ShExplainShellIntention.lambda$invoke$1(strings = new HashSet(), arg_0));
            if (commands.isEmpty()) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)ShBundle.message("sh.explain.message.nothing.to.explain", new Object[0]), (String)ShBundle.message("sh.explain.title.nothing.to.explain", new Object[0]), (String)"");
            } else {
                IntroduceTargetChooser.showChooser((Editor)editor, (List)commands, (Pass)new Pass<PsiElement>(){

                    public void pass(@NotNull PsiElement psiElement) {
                        if (psiElement == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ShExplainShellIntention.explain(psiElement.getText());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/sh/ShExplainShellIntention$1", "pass"));
                    }
                }, PsiElement::getText, (String)ShBundle.message("sh.explain.command.to.explain", new Object[0]));
            }
        }
    }

    private static void explain(@NotNull String text) {
        if (text == null) {
            ShExplainShellIntention.$$$reportNull$$$0(4);
        }
        String encodedText = URLEncoder.encode(text, StandardCharsets.UTF_8);
        BrowserUtil.browse((String)("https://explainshell.com/explain?cmd=" + encodedText));
    }

    private static /* synthetic */ boolean lambda$invoke$1(Set strings, ShCompositeElement e) {
        return (e instanceof ShCommand || e instanceof ShCommandsList) && strings.add(e.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/ShExplainShellIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/ShExplainShellIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "explain";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

