/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.tracker;

import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.completion.ml.personalization.UserFactorDescriptions;
import com.intellij.completion.ml.personalization.UserFactorStorage;
import com.intellij.completion.ml.personalization.impl.CompletionUsageUpdater;
import com.intellij.completion.ml.personalization.session.SessionFactorsUtils;
import com.intellij.completion.ml.personalization.session.SessionPrefixTracker;
import com.intellij.completion.ml.storage.MutableLookupStorage;
import com.intellij.completion.ml.tracker.LookupCompletedTracker;
import com.intellij.completion.ml.tracker.LookupSelectionTracker;
import com.intellij.completion.ml.tracker.LookupStartedTracker;
import com.intellij.completion.ml.tracker.LookupTracker;
import com.intellij.completion.ml.tracker.TimeBetweenTypingTracker;
import com.intellij.completion.ml.util.LookupExtensionsKt;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/completion/ml/tracker/CompletionFactorsInitializer;", "Lcom/intellij/completion/ml/tracker/LookupTracker;", "<init>", "()V", "lookupCreated", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "storage", "Lcom/intellij/completion/ml/storage/MutableLookupStorage;", "shouldUseUserFactors", "", "language", "Lcom/intellij/lang/Language;", "shouldUseSessionFactors", "processUserFactors", "processSessionFactors", "lookupStorage", "Companion", "intellij.completionMlRanking"})
public final class CompletionFactorsInitializer
extends LookupTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static boolean isEnabledInTests;

    @Override
    protected void lookupCreated(@NotNull LookupImpl lookup, @NotNull MutableLookupStorage storage) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (ApplicationManager.getApplication().isUnitTestMode() && !isEnabledInTests) {
            return;
        }
        this.processUserFactors(lookup);
        this.processSessionFactors(lookup, storage);
    }

    private final boolean shouldUseUserFactors(Language language) {
        return ApplicationManager.getApplication().isEAP() || Intrinsics.areEqual((Object)ApplicationInfo.getInstance().getVersionName(), (Object)"PyCharm") && (language == null || language.isKindOf("Python")) && PluginManager.isPluginInstalled((PluginId)PluginId.Companion.getId("org.jetbrains.completion.full.line"));
    }

    private final boolean shouldUseSessionFactors() {
        return SessionFactorsUtils.INSTANCE.shouldUseSessionFactors();
    }

    private final void processUserFactors(LookupImpl lookup) {
        if (!this.shouldUseUserFactors(LookupExtensionsKt.language(lookup))) {
            return;
        }
        Project project = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        UserFactorStorage.Companion.applyOnBoth(project, UserFactorDescriptions.INSTANCE.getCOMPLETION_USAGE(), CompletionFactorsInitializer::processUserFactors$lambda$0);
        Project project2 = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        lookup.setPrefixChangeListener((PrefixChangeListener)new TimeBetweenTypingTracker(project2));
        lookup.addLookupListener((LookupListener)new LookupCompletedTracker());
        lookup.addLookupListener((LookupListener)new LookupStartedTracker());
    }

    private final void processSessionFactors(LookupImpl lookup, MutableLookupStorage lookupStorage) {
        if (!this.shouldUseSessionFactors()) {
            return;
        }
        lookup.setPrefixChangeListener((PrefixChangeListener)new SessionPrefixTracker(lookupStorage.getSessionFactors()));
        lookup.addLookupListener((LookupListener)new LookupSelectionTracker(lookupStorage));
    }

    private static final Unit processUserFactors$lambda$0(CompletionUsageUpdater it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.fireCompletionUsed();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/completion/ml/tracker/CompletionFactorsInitializer$Companion;", "", "<init>", "()V", "isEnabledInTests", "", "()Z", "setEnabledInTests", "(Z)V", "intellij.completionMlRanking"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEnabledInTests() {
            return isEnabledInTests;
        }

        public final void setEnabledInTests(boolean bl) {
            isEnabledInTests = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

