/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing.signatory.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.gradle.internal.UncheckedException;
import org.gradle.plugins.signing.signatory.SignatorySupport;
import org.gradle.plugins.signing.signatory.pgp.PgpKeyId;

public class PgpSignatory
extends SignatorySupport {
    private final String name;
    private final PGPSecretKey secretKey;
    private final PGPPrivateKey privateKey;

    public PgpSignatory(String name, PGPSecretKey secretKey, String password) {
        this.name = name;
        this.secretKey = secretKey;
        this.privateKey = this.createPrivateKey(secretKey, password);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void sign(InputStream toSign, OutputStream signatureDestination) {
        PGPSignatureGenerator generator = this.createSignatureGenerator();
        try {
            this.feedGeneratorWith(toSign, generator);
            PGPSignature signature = generator.generate();
            this.writeSignatureTo(signatureDestination, signature);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (PGPException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public String getKeyId() {
        PgpKeyId id = new PgpKeyId(this.secretKey.getKeyID());
        return id.getAsHex();
    }

    private void feedGeneratorWith(InputStream toSign, PGPSignatureGenerator generator) throws IOException {
        byte[] buffer = new byte[1024];
        int read = toSign.read(buffer);
        while (read > 0) {
            generator.update(buffer, 0, read);
            read = toSign.read(buffer);
        }
    }

    private void writeSignatureTo(OutputStream signatureDestination, PGPSignature pgpSignature) throws IOException {
        BCPGOutputStream bufferedOutput = new BCPGOutputStream(signatureDestination);
        pgpSignature.encode((OutputStream)bufferedOutput);
        bufferedOutput.flush();
    }

    public PGPSignatureGenerator createSignatureGenerator() {
        try {
            BcPGPContentSignerBuilder builder = new BcPGPContentSignerBuilder(this.secretKey.getPublicKey().getAlgorithm(), 10);
            PGPSignatureGenerator generator = new PGPSignatureGenerator((PGPContentSignerBuilder)builder, this.secretKey.getPublicKey());
            generator.init(0, this.privateKey);
            return generator;
        }
        catch (PGPException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private PGPPrivateKey createPrivateKey(PGPSecretKey secretKey, String password) {
        try {
            PBESecretKeyDecryptor decryptor = new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(password.toCharArray());
            return secretKey.extractPrivateKey(decryptor);
        }
        catch (PGPException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

